/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.documentation.docstrings.DocStringParameterReference;
import com.jetbrains.python.documentation.docstrings.DocStringTagCompletionContributor;
import com.jetbrains.python.documentation.docstrings.DocStringTypeReference;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.refactoring.PyRefactoringUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PyDocstringCompletionContributor
extends CompletionContributor {
    public PyDocstringCompletionContributor() {
        this.extend(CompletionType.BASIC, StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement().withParent(DocStringTagCompletionContributor.DOCSTRING_PATTERN), PlatformPatterns.psiComment()}), new IdentifierCompletionProvider());
    }

    private static String getPrefix(int offset, PsiFile file2) {
        if (offset > 0) {
            --offset;
        }
        String text = file2.getText();
        StringBuilder prefixBuilder = new StringBuilder();
        while (offset > 0 && Character.isLetterOrDigit(text.charAt(offset))) {
            prefixBuilder.insert(0, text.charAt(offset));
            --offset;
        }
        return prefixBuilder.toString();
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        PsiReference ref;
        if (context == null) {
            PyDocstringCompletionContributor.$$$reportNull$$$0(0);
        }
        if ((ref = context.getFile().findReferenceAt(context.getCaret().getOffset())) instanceof DocStringParameterReference || ref instanceof DocStringTypeReference) {
            context.setDummyIdentifier("IntellijIdeaRulezzz");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/codeInsight/completion/PyDocstringCompletionContributor", "beforeCompletion"));
    }

    private static class IdentifierCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private IdentifierCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result2) {
            PsiElement element;
            if (parameters == null) {
                IdentifierCompletionProvider.$$$reportNull$$$0(0);
            }
            if (result2 == null) {
                IdentifierCompletionProvider.$$$reportNull$$$0(1);
            }
            if ((element = parameters.getOriginalPosition()) == null) {
                return;
            }
            PsiFile file2 = element.getContainingFile();
            PsiReference reference = file2.findReferenceAt(parameters.getOffset());
            if (reference == null) {
                if (parameters.isAutoPopup()) {
                    return;
                }
                PyDocStringOwner docStringOwner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PyDocStringOwner.class);
                Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
                if (module2 != null) {
                    result2 = result2.withPrefixMatcher(PyDocstringCompletionContributor.getPrefix(parameters.getOffset(), file2));
                    Collection<String> identifiers = PyRefactoringUtil.collectUsedNames((PsiElement)docStringOwner);
                    for (String identifier : identifiers) {
                        result2.addElement(LookupElementBuilder.create((String)identifier).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE));
                    }
                    Collection<String> fileIdentifiers = PyRefactoringUtil.collectUsedNames((PsiElement)parameters.getOriginalFile());
                    for (String identifier : fileIdentifiers) {
                        result2.addElement(LookupElementBuilder.create((String)identifier).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE));
                    }
                }
            } else if (reference instanceof PsiMultiReference) {
                for (PsiReference innerReference : ((PsiMultiReference)reference).getReferences()) {
                    IdentifierCompletionProvider.addVariantsFromDocstringReference(innerReference, result2);
                }
            } else {
                IdentifierCompletionProvider.addVariantsFromDocstringReference(reference, result2);
            }
        }

        private static void addVariantsFromDocstringReference(@NotNull PsiReference reference, @NotNull CompletionResultSet result2) {
            block6: {
                block5: {
                    if (reference == null) {
                        IdentifierCompletionProvider.$$$reportNull$$$0(2);
                    }
                    if (result2 == null) {
                        IdentifierCompletionProvider.$$$reportNull$$$0(3);
                    }
                    if (!(reference instanceof DocStringParameterReference)) break block5;
                    for (PyNamedParameter param : ((DocStringParameterReference)reference).collectParameterVariants()) {
                        result2.addElement((LookupElement)LookupElementBuilder.createWithIcon((PsiNamedElement)param));
                    }
                    break block6;
                }
                if (!(reference instanceof DocStringTypeReference)) break block6;
                for (Object variant : ((DocStringTypeReference)reference).collectTypeVariants()) {
                    if (variant instanceof PsiNamedElement) {
                        result2.addElement((LookupElement)LookupElementBuilder.createWithIcon((PsiNamedElement)((PsiNamedElement)variant)));
                        continue;
                    }
                    result2.addElement((LookupElement)LookupElementBuilder.create((Object)variant));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/codeInsight/completion/PyDocstringCompletionContributor$IdentifierCompletionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCompletions";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addVariantsFromDocstringReference";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

