/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaTreeNode;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.SchemaResolveState;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaVariantsTreeBuilder {
    private static final Logger LOG = Logger.getInstance(JsonSchemaVariantsTreeBuilder.class);

    public static JsonSchemaTreeNode buildTree(@NotNull JsonSchemaObject schema, @Nullable List<Step> position, boolean skipLastExpand, boolean literalResolve, boolean acceptAdditional) {
        if (schema == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(0);
        }
        JsonSchemaTreeNode root = new JsonSchemaTreeNode(null, schema);
        JsonSchemaVariantsTreeBuilder.expandChildSchema(root, schema);
        root.getChildren().forEach(node -> node.setSteps(ContainerUtil.notNullize((List)position)));
        ArrayDeque<JsonSchemaTreeNode> queue2 = new ArrayDeque<JsonSchemaTreeNode>(root.getChildren());
        while (!queue2.isEmpty()) {
            Pair<ThreeState, JsonSchemaObject> pair;
            JsonSchemaTreeNode node2 = queue2.removeFirst();
            if (node2.isAny() || node2.isNothing() || node2.getSteps().isEmpty() || node2.getSchema() == null) continue;
            Step step = node2.getSteps().get(0);
            if (!JsonSchemaVariantsTreeBuilder.typeMatches(step.isFromObject(), node2.getSchema())) {
                node2.nothingChild();
                continue;
            }
            if (literalResolve) {
                step.myLiteralResolve = true;
            }
            if (ThreeState.NO.equals((pair = step.step(node2.getSchema(), acceptAdditional)).getFirst())) {
                node2.nothingChild();
            } else if (ThreeState.YES.equals(pair.getFirst())) {
                node2.anyChild();
            } else {
                assert (pair.getSecond() != null);
                if (node2.getSteps().size() > 1 || !skipLastExpand) {
                    JsonSchemaVariantsTreeBuilder.expandChildSchema(node2, (JsonSchemaObject)pair.getSecond());
                } else {
                    node2.setChild((JsonSchemaObject)pair.getSecond());
                }
            }
            queue2.addAll(node2.getChildren());
        }
        return root;
    }

    private static boolean typeMatches(boolean isObject, @NotNull JsonSchemaObject schema) {
        JsonSchemaType requiredType;
        if (schema == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(1);
        }
        JsonSchemaType jsonSchemaType = requiredType = isObject ? JsonSchemaType._object : JsonSchemaType._array;
        if (schema.getType() != null) {
            return requiredType.equals((Object)schema.getType());
        }
        if (schema.getTypeVariants() != null) {
            for (JsonSchemaType schemaType : schema.getTypeVariants()) {
                if (!requiredType.equals((Object)schemaType)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static void expandChildSchema(@NotNull JsonSchemaTreeNode node, @NotNull JsonSchemaObject childSchema) {
        if (node == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(2);
        }
        if (childSchema == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(3);
        }
        JsonObject element = childSchema.getJsonObject();
        if (JsonSchemaVariantsTreeBuilder.interestingSchema(childSchema)) {
            Project project = childSchema.getJsonObject().getProject();
            Operation operation = (Operation)CachedValuesManager.getManager((Project)element.getProject()).createParameterizedCachedValue(param -> {
                ProcessDefinitionsOperation expand = new ProcessDefinitionsOperation((JsonSchemaObject)param);
                expand.doMap(new HashSet<JsonObject>());
                expand.doReduce();
                return CachedValueProvider.Result.create((Object)expand, (Object[])new Object[]{element.getContainingFile(), JsonSchemaService.Impl.get(project).getAnySchemaChangeTracker()});
            }, false).getValue((Object)childSchema);
            node.createChildrenFromOperation(operation);
        } else {
            node.setChild(childSchema);
        }
    }

    public static List<Step> buildSteps(@NotNull String nameInSchema) {
        if (nameInSchema == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(4);
        }
        List chain = StringUtil.split((String)JsonSchemaService.normalizeId(nameInSchema).replace("\\", "/"), (String)"/");
        return chain.stream().filter(s -> !s.isEmpty()).map(item -> Step.createPropertyStep(item)).collect(Collectors.toList());
    }

    private static List<JsonSchemaObject> andGroups(@NotNull List<JsonSchemaObject> g1, @NotNull List<JsonSchemaObject> g2) {
        if (g1 == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(5);
        }
        if (g2 == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(6);
        }
        return g1.stream().map(s -> {
            if (g2 == null) {
                JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(17);
            }
            return JsonSchemaVariantsTreeBuilder.andGroup(s, g2);
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static List<JsonSchemaObject> andGroup(@NotNull JsonSchemaObject object, @NotNull List<JsonSchemaObject> group) {
        if (object == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(7);
        }
        if (group == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(8);
        }
        return group.stream().map(s -> {
            if (object == null) {
                JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(16);
            }
            return JsonSchemaVariantsTreeBuilder.merge(object, s, s);
        }).collect(Collectors.toList());
    }

    @Nullable
    private static JsonSchemaObject getSchemaFromDefinition(@NotNull JsonSchemaObject schema) {
        if (schema == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(9);
        }
        String ref = schema.getRef();
        assert (!StringUtil.isEmptyOrSpaces((String)ref));
        VirtualFile schemaFile = schema.getSchemaFile();
        JsonSchemaService service = JsonSchemaService.Impl.get(schema.getJsonObject().getProject());
        SchemaUrlSplitter splitter = new SchemaUrlSplitter(ref);
        if (splitter.getSchemaId() != null) {
            VirtualFile refFile = service.findSchemaFileByReference(splitter.getSchemaId(), schemaFile);
            if (refFile == null) {
                LOG.debug(String.format("Schema file not found by reference: '%s' from %s", splitter.getSchemaId(), schemaFile.getPath()));
                return null;
            }
            JsonSchemaObject refSchema = service.getSchemaObjectForSchemaFile(refFile);
            if (refSchema == null) {
                LOG.debug(String.format("Schema object not found by reference: '%s' from %s", splitter.getSchemaId(), schemaFile.getPath()));
                return null;
            }
            return JsonSchemaVariantsTreeBuilder.findRelativeDefinition(refSchema, splitter);
        }
        JsonSchemaObject rootSchema = service.getSchemaObjectForSchemaFile(schemaFile);
        if (rootSchema == null) {
            LOG.debug(String.format("Schema object not found for %s", schemaFile.getPath()));
            return null;
        }
        return JsonSchemaVariantsTreeBuilder.findRelativeDefinition(rootSchema, splitter);
    }

    private static JsonSchemaObject findRelativeDefinition(@NotNull JsonSchemaObject schema, @NotNull SchemaUrlSplitter splitter) {
        String path;
        if (schema == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(10);
        }
        if (splitter == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(11);
        }
        if (StringUtil.isEmptyOrSpaces((String)(path = splitter.getRelativePath()))) {
            return schema;
        }
        JsonSchemaObject definition = schema.findRelativeDefinition(path);
        if (definition == null) {
            LOG.debug(String.format("Definition not found by reference: '%s' in file %s", path, schema.getSchemaFile().getPath()));
        }
        return definition;
    }

    public static JsonSchemaObject merge(@NotNull JsonSchemaObject base, @NotNull JsonSchemaObject other, @NotNull JsonSchemaObject pointTo) {
        if (base == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(12);
        }
        if (other == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(13);
        }
        if (pointTo == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(14);
        }
        JsonSchemaObject object = new JsonSchemaObject(pointTo.getJsonObject());
        object.mergeValues(other);
        object.mergeValues(base);
        object.setRef(other.getRef());
        return object;
    }

    private static boolean conflictingSchema(JsonSchemaObject schema) {
        int cnt = 0;
        if (schema.getAllOf() != null) {
            ++cnt;
        }
        if (schema.getAnyOf() != null) {
            ++cnt;
        }
        if (schema.getOneOf() != null) {
            ++cnt;
        }
        return cnt > 1;
    }

    private static boolean interestingSchema(@NotNull JsonSchemaObject schema) {
        if (schema == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(15);
        }
        return schema.getAnyOf() != null || schema.getOneOf() != null || schema.getAllOf() != null || schema.getRef() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childSchema";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameInSchema";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g1";
                break;
            }
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g2";
                break;
            }
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "splitter";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointTo";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaVariantsTreeBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildTree";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "typeMatches";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "expandChildSchema";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "buildSteps";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "andGroups";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "andGroup";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getSchemaFromDefinition";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "findRelativeDefinition";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "merge";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "interestingSchema";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$andGroup$5";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$andGroups$4";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class SchemaUrlSplitter {
        @Nullable
        private final String mySchemaId;
        @NotNull
        private final String myRelativePath;

        public SchemaUrlSplitter(@NotNull String ref) {
            if (ref == null) {
                SchemaUrlSplitter.$$$reportNull$$$0(0);
            }
            if ("#".equals(ref)) {
                this.mySchemaId = null;
                this.myRelativePath = "";
                return;
            }
            if (!ref.startsWith("#/")) {
                int idx = ref.indexOf("#/");
                if (idx == -1) {
                    this.mySchemaId = ref.endsWith("#") ? ref.substring(0, ref.length() - 1) : ref;
                    this.myRelativePath = "";
                } else {
                    this.mySchemaId = ref.substring(0, idx);
                    this.myRelativePath = ref.substring(idx);
                }
            } else {
                this.mySchemaId = null;
                this.myRelativePath = ref;
            }
        }

        public boolean isAbsolute() {
            return this.mySchemaId != null;
        }

        @Nullable
        public String getSchemaId() {
            return this.mySchemaId;
        }

        @NotNull
        public String getRelativePath() {
            String string = this.myRelativePath;
            if (string == null) {
                SchemaUrlSplitter.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaVariantsTreeBuilder$SchemaUrlSplitter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaVariantsTreeBuilder$SchemaUrlSplitter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRelativePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Step {
        @Nullable
        private final String myName;
        private final int myIdx;
        private boolean myLiteralResolve;

        private Step(@Nullable String name, int idx) {
            this.myName = name;
            this.myIdx = idx;
        }

        public static Step createPropertyStep(@NotNull String name) {
            if (name == null) {
                Step.$$$reportNull$$$0(0);
            }
            return new Step(name, -1);
        }

        public static Step createArrayElementStep(int idx) {
            assert (idx >= 0);
            return new Step(null, idx);
        }

        public boolean isFromObject() {
            return this.myName != null;
        }

        public boolean isFromArray() {
            return this.myName == null;
        }

        @Nullable
        public String getName() {
            return this.myName;
        }

        @NotNull
        public Pair<ThreeState, JsonSchemaObject> step(@NotNull JsonSchemaObject parent, boolean acceptAdditionalPropertiesSchemas) {
            if (parent == null) {
                Step.$$$reportNull$$$0(1);
            }
            if (this.myName != null) {
                Pair<ThreeState, JsonSchemaObject> pair = this.propertyStep(parent, acceptAdditionalPropertiesSchemas);
                if (pair == null) {
                    Step.$$$reportNull$$$0(2);
                }
                return pair;
            }
            assert (this.myIdx >= 0);
            Pair<ThreeState, JsonSchemaObject> pair = this.arrayElementStep(parent, acceptAdditionalPropertiesSchemas);
            if (pair == null) {
                Step.$$$reportNull$$$0(3);
            }
            return pair;
        }

        public String toString() {
            String format = "?%s";
            if (this.myName != null) {
                format = "{%s}";
            }
            if (this.myIdx >= 0) {
                format = "[%s]";
            }
            return String.format(format, this.myName != null ? this.myName : (this.myIdx >= 0 ? String.valueOf(this.myIdx) : "null"));
        }

        @NotNull
        private Pair<ThreeState, JsonSchemaObject> propertyStep(@NotNull JsonSchemaObject parent, boolean acceptAdditionalPropertiesSchemas) {
            if (parent == null) {
                Step.$$$reportNull$$$0(4);
            }
            assert (this.myName != null);
            if ("definitions".equals(this.myName) && parent.getDefinitionsMap() != null && (!Step.isInMainSchema(parent) || this.myLiteralResolve)) {
                Map<String, JsonSchemaObject> definitionsMap = parent.getDefinitionsMap();
                JsonObject anyDefinitions = definitionsMap.values().stream().filter(def -> {
                    JsonProperty parentObj = (JsonProperty)ObjectUtils.tryCast((Object)def.getJsonObject().getParent(), JsonProperty.class);
                    return parentObj != null && parentObj.isValid() && parentObj.getValue() instanceof JsonObject;
                }).map(def -> (JsonObject)((JsonProperty)def.getJsonObject().getParent()).getValue()).findFirst().orElse(null);
                if (anyDefinitions == null) {
                    Pair pair = Pair.create((Object)ThreeState.NO, null);
                    if (pair == null) {
                        Step.$$$reportNull$$$0(5);
                    }
                    return pair;
                }
                JsonSchemaObject object = new JsonSchemaObject(anyDefinitions);
                object.setProperties(definitionsMap);
                Pair pair = Pair.create((Object)ThreeState.UNSURE, (Object)object);
                if (pair == null) {
                    Step.$$$reportNull$$$0(6);
                }
                return pair;
            }
            JsonSchemaObject child = parent.getProperties().get(this.myName);
            if (child != null) {
                Pair pair = Pair.create((Object)ThreeState.UNSURE, (Object)child);
                if (pair == null) {
                    Step.$$$reportNull$$$0(7);
                }
                return pair;
            }
            JsonSchemaObject schema = parent.getMatchingPatternPropertySchema(this.myName);
            if (schema != null) {
                Pair pair = Pair.create((Object)ThreeState.UNSURE, (Object)schema);
                if (pair == null) {
                    Step.$$$reportNull$$$0(8);
                }
                return pair;
            }
            if (parent.getAdditionalPropertiesSchema() != null && acceptAdditionalPropertiesSchemas) {
                Pair pair = Pair.create((Object)ThreeState.UNSURE, (Object)parent.getAdditionalPropertiesSchema());
                if (pair == null) {
                    Step.$$$reportNull$$$0(9);
                }
                return pair;
            }
            if (Boolean.FALSE.equals(parent.getAdditionalPropertiesAllowed())) {
                Pair pair = Pair.create((Object)ThreeState.NO, null);
                if (pair == null) {
                    Step.$$$reportNull$$$0(10);
                }
                return pair;
            }
            Pair pair = Pair.create((Object)ThreeState.YES, null);
            if (pair == null) {
                Step.$$$reportNull$$$0(11);
            }
            return pair;
        }

        private static boolean isInMainSchema(@NotNull JsonSchemaObject parent) {
            if (parent == null) {
                Step.$$$reportNull$$$0(12);
            }
            VirtualFile schemaFile = parent.getSchemaFile();
            JsonSchemaService service = JsonSchemaService.Impl.get(parent.getJsonObject().getProject());
            if (!service.isSchemaFile(schemaFile)) {
                return false;
            }
            JsonSchemaObject rootSchema = service.getSchemaObjectForSchemaFile(schemaFile);
            return rootSchema != null && "http://json-schema.org/draft-04/schema#".equals(rootSchema.getId());
        }

        @NotNull
        private Pair<ThreeState, JsonSchemaObject> arrayElementStep(@NotNull JsonSchemaObject parent, boolean acceptAdditionalPropertiesSchemas) {
            if (parent == null) {
                Step.$$$reportNull$$$0(13);
            }
            if (parent.getItemsSchema() != null) {
                Pair pair = Pair.create((Object)ThreeState.UNSURE, (Object)parent.getItemsSchema());
                if (pair == null) {
                    Step.$$$reportNull$$$0(14);
                }
                return pair;
            }
            if (parent.getItemsSchemaList() != null) {
                List<JsonSchemaObject> list2 = parent.getItemsSchemaList();
                if (this.myIdx >= 0 && this.myIdx < list2.size()) {
                    Pair pair = Pair.create((Object)ThreeState.UNSURE, (Object)list2.get(this.myIdx));
                    if (pair == null) {
                        Step.$$$reportNull$$$0(15);
                    }
                    return pair;
                }
            }
            if (parent.getAdditionalItemsSchema() != null && acceptAdditionalPropertiesSchemas) {
                Pair pair = Pair.create((Object)ThreeState.UNSURE, (Object)parent.getAdditionalItemsSchema());
                if (pair == null) {
                    Step.$$$reportNull$$$0(16);
                }
                return pair;
            }
            if (Boolean.FALSE.equals(parent.getAdditionalItemsAllowed())) {
                Pair pair = Pair.create((Object)ThreeState.NO, null);
                if (pair == null) {
                    Step.$$$reportNull$$$0(17);
                }
                return pair;
            }
            Pair pair = Pair.create((Object)ThreeState.YES, null);
            if (pair == null) {
                Step.$$$reportNull$$$0(18);
            }
            return pair;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 4: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaVariantsTreeBuilder$Step";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaVariantsTreeBuilder$Step";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "step";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "propertyStep";
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "arrayElementStep";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createPropertyStep";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "step";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "propertyStep";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "isInMainSchema";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "arrayElementStep";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AnyOfOperation
    extends Operation {
        protected AnyOfOperation(@NotNull JsonSchemaObject sourceNode) {
            if (sourceNode == null) {
                AnyOfOperation.$$$reportNull$$$0(0);
            }
            super(sourceNode);
        }

        @Override
        public void map(@NotNull Set<JsonObject> visited) {
            if (visited == null) {
                AnyOfOperation.$$$reportNull$$$0(1);
            }
            assert (this.mySourceNode.getAnyOf() != null);
            this.myChildOperations.addAll(this.mySourceNode.getAnyOf().stream().map(ProcessDefinitionsOperation::new).collect(Collectors.toList()));
        }

        @Override
        public void reduce() {
            this.myChildOperations.forEach(op -> {
                if (!op.myState.equals((Object)SchemaResolveState.normal)) {
                    return;
                }
                this.myAnyOfGroup.addAll(JsonSchemaVariantsTreeBuilder.andGroup(this.mySourceNode, op.myAnyOfGroup));
                op.myOneOfGroup.forEach(group -> this.myOneOfGroup.add(JsonSchemaVariantsTreeBuilder.andGroup(this.mySourceNode, group)));
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceNode";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visited";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaVariantsTreeBuilder$AnyOfOperation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "map";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class OneOfOperation
    extends Operation {
        protected OneOfOperation(@NotNull JsonSchemaObject sourceNode) {
            if (sourceNode == null) {
                OneOfOperation.$$$reportNull$$$0(0);
            }
            super(sourceNode);
        }

        @Override
        public void map(@NotNull Set<JsonObject> visited) {
            if (visited == null) {
                OneOfOperation.$$$reportNull$$$0(1);
            }
            assert (this.mySourceNode.getOneOf() != null);
            this.myChildOperations.addAll(this.mySourceNode.getOneOf().stream().map(ProcessDefinitionsOperation::new).collect(Collectors.toList()));
        }

        @Override
        public void reduce() {
            SmartList oneOf = new SmartList();
            this.myChildOperations.forEach(arg_0 -> this.lambda$reduce$0((List)oneOf, arg_0));
            this.myOneOfGroup.add(oneOf);
        }

        private /* synthetic */ void lambda$reduce$0(List oneOf, Operation op) {
            if (!op.myState.equals((Object)SchemaResolveState.normal)) {
                return;
            }
            oneOf.addAll(JsonSchemaVariantsTreeBuilder.andGroup(this.mySourceNode, op.myAnyOfGroup));
            oneOf.addAll(JsonSchemaVariantsTreeBuilder.andGroup(this.mySourceNode, OneOfOperation.mergeOneOf(op)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceNode";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visited";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaVariantsTreeBuilder$OneOfOperation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "map";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AllOfOperation
    extends Operation {
        protected AllOfOperation(@NotNull JsonSchemaObject sourceNode) {
            if (sourceNode == null) {
                AllOfOperation.$$$reportNull$$$0(0);
            }
            super(sourceNode);
        }

        @Override
        public void map(@NotNull Set<JsonObject> visited) {
            if (visited == null) {
                AllOfOperation.$$$reportNull$$$0(1);
            }
            assert (this.mySourceNode.getAllOf() != null);
            this.myChildOperations.addAll(this.mySourceNode.getAllOf().stream().map(ProcessDefinitionsOperation::new).collect(Collectors.toList()));
        }

        @Override
        public void reduce() {
            this.myAnyOfGroup.add(this.mySourceNode);
            this.myChildOperations.forEach(op -> {
                if (!op.myState.equals((Object)SchemaResolveState.normal)) {
                    return;
                }
                List mergedAny = JsonSchemaVariantsTreeBuilder.andGroups(op.myAnyOfGroup, this.myAnyOfGroup);
                SmartList mergedExclusive = new SmartList();
                this.myOneOfGroup.forEach(arg_0 -> AllOfOperation.lambda$null$0((List)mergedExclusive, op, arg_0));
                op.myOneOfGroup.forEach(arg_0 -> this.lambda$null$1((List)mergedExclusive, arg_0));
                op.myOneOfGroup.forEach(arg_0 -> this.lambda$null$3((List)mergedExclusive, arg_0));
                this.myAnyOfGroup.clear();
                this.myOneOfGroup.clear();
                this.myAnyOfGroup.addAll(mergedAny);
                this.myOneOfGroup.addAll(mergedExclusive);
            });
        }

        private /* synthetic */ void lambda$null$3(List mergedExclusive, List group) {
            this.myOneOfGroup.forEach(otherGroup -> mergedExclusive.add(JsonSchemaVariantsTreeBuilder.andGroups(group, otherGroup)));
        }

        private /* synthetic */ void lambda$null$1(List mergedExclusive, List group) {
            mergedExclusive.add(JsonSchemaVariantsTreeBuilder.andGroups(group, this.myAnyOfGroup));
        }

        private static /* synthetic */ void lambda$null$0(List mergedExclusive, Operation op, List group) {
            mergedExclusive.add(JsonSchemaVariantsTreeBuilder.andGroups(op.myAnyOfGroup, group));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceNode";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visited";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaVariantsTreeBuilder$AllOfOperation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "map";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ProcessDefinitionsOperation
    extends Operation {
        protected ProcessDefinitionsOperation(@NotNull JsonSchemaObject sourceNode) {
            if (sourceNode == null) {
                ProcessDefinitionsOperation.$$$reportNull$$$0(0);
            }
            super(sourceNode);
        }

        @Override
        public void map(@NotNull Set<JsonObject> visited) {
            Operation expandOperation;
            if (visited == null) {
                ProcessDefinitionsOperation.$$$reportNull$$$0(1);
            }
            JsonSchemaObject current = this.mySourceNode;
            while (!StringUtil.isEmptyOrSpaces((String)current.getRef())) {
                JsonSchemaObject definition = JsonSchemaVariantsTreeBuilder.getSchemaFromDefinition(current);
                if (definition == null) {
                    this.myState = SchemaResolveState.brokenDefinition;
                    return;
                }
                if (!visited.add(definition.getJsonObject())) break;
                current = JsonSchemaVariantsTreeBuilder.merge(current, definition, current);
            }
            if ((expandOperation = this.createExpandOperation(current)) != null) {
                this.myChildOperations.add(expandOperation);
            } else {
                this.myAnyOfGroup.add(current);
            }
        }

        @Override
        public void reduce() {
            if (!this.myChildOperations.isEmpty()) {
                assert (this.myChildOperations.size() == 1);
                Operation operation = (Operation)this.myChildOperations.get(0);
                this.myAnyOfGroup.addAll(operation.myAnyOfGroup);
                this.myOneOfGroup.addAll(operation.myOneOfGroup);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceNode";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visited";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaVariantsTreeBuilder$ProcessDefinitionsOperation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "map";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static abstract class Operation {
        @NotNull
        final List<JsonSchemaObject> myAnyOfGroup;
        @NotNull
        final List<List<JsonSchemaObject>> myOneOfGroup;
        @NotNull
        protected final List<Operation> myChildOperations;
        @NotNull
        protected final JsonSchemaObject mySourceNode;
        protected SchemaResolveState myState;

        protected Operation(@NotNull JsonSchemaObject sourceNode) {
            if (sourceNode == null) {
                Operation.$$$reportNull$$$0(0);
            }
            this.myAnyOfGroup = new SmartList();
            this.myOneOfGroup = new SmartList();
            this.myState = SchemaResolveState.normal;
            this.mySourceNode = sourceNode;
            this.myChildOperations = new ArrayList<Operation>();
        }

        protected abstract void map(@NotNull Set<JsonObject> var1);

        protected abstract void reduce();

        public void doMap(@NotNull Set<JsonObject> visited) {
            if (visited == null) {
                Operation.$$$reportNull$$$0(1);
            }
            this.map(visited);
            this.myChildOperations.forEach(operation -> {
                if (visited == null) {
                    Operation.$$$reportNull$$$0(4);
                }
                operation.doMap(visited);
            });
        }

        public void doReduce() {
            if (!SchemaResolveState.normal.equals((Object)this.myState)) {
                this.myChildOperations.clear();
                this.myAnyOfGroup.clear();
                this.myOneOfGroup.clear();
                return;
            }
            this.myAnyOfGroup.forEach(Operation::clearVariants);
            this.myOneOfGroup.forEach(list2 -> list2.forEach(Operation::clearVariants));
            this.myChildOperations.forEach(Operation::doReduce);
            this.reduce();
            this.myChildOperations.clear();
        }

        private static void clearVariants(@NotNull JsonSchemaObject object) {
            if (object == null) {
                Operation.$$$reportNull$$$0(2);
            }
            object.setAllOf(null);
            object.setAnyOf(null);
            object.setOneOf(null);
        }

        @Nullable
        protected Operation createExpandOperation(@NotNull JsonSchemaObject schema) {
            if (schema == null) {
                Operation.$$$reportNull$$$0(3);
            }
            if (JsonSchemaVariantsTreeBuilder.conflictingSchema(schema)) {
                AnyOfOperation operation = new AnyOfOperation(schema);
                operation.myState = SchemaResolveState.conflict;
                return operation;
            }
            if (schema.getAnyOf() != null) {
                return new AnyOfOperation(schema);
            }
            if (schema.getOneOf() != null) {
                return new OneOfOperation(schema);
            }
            if (schema.getAllOf() != null) {
                return new AllOfOperation(schema);
            }
            return null;
        }

        protected static List<JsonSchemaObject> mergeOneOf(Operation op) {
            return op.myOneOfGroup.stream().flatMap(Collection::stream).collect(Collectors.toList());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceNode";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visited";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "schema";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaVariantsTreeBuilder$Operation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doMap";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clearVariants";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createExpandOperation";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$doMap$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

