/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.packaging;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.JBUI;
import com.intellij.webcore.packaging.PackageManagementService;
import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ManageRepoDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private JBList myList;
    private boolean myEnabled;

    public ManageRepoDialog(Project project, final PackageManagementService controller) {
        super(project, false);
        this.$$$setupUI$$$();
        this.init();
        this.setTitle("Manage Repositories");
        final DefaultListModel<String> repoModel = new DefaultListModel<String>();
        for (String repoUrl : controller.getAllRepositories()) {
            repoModel.addElement(repoUrl);
        }
        this.myList = new JBList();
        this.myList.setModel(repoModel);
        this.myList.setSelectionMode(0);
        this.myList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                Object selected = ManageRepoDialog.this.myList.getSelectedValue();
                ManageRepoDialog.this.myEnabled = controller.canModifyRepository((String)selected);
            }
        });
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JList)this.myList).disableUpDownActions();
        decorator.setAddActionName("Add repository");
        decorator.setRemoveActionName("Remove repository from list");
        decorator.setEditActionName("Edit repository URL");
        decorator.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                String url = Messages.showInputDialog((String)"Please input repository URL", (String)"Repository URL", null);
                if (!repoModel.contains(url) && !StringUtil.isEmptyOrSpaces((String)url)) {
                    repoModel.addElement(url);
                    controller.addRepository(url);
                }
            }
        });
        decorator.setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                String oldValue = (String)ManageRepoDialog.this.myList.getSelectedValue();
                String url = Messages.showInputDialog((String)"Please edit repository URL", (String)"Repository URL", null, (String)oldValue, (InputValidator)new InputValidator(){

                    public boolean checkInput(String inputString) {
                        return !repoModel.contains(inputString);
                    }

                    public boolean canClose(String inputString) {
                        return true;
                    }
                });
                if (!StringUtil.isEmptyOrSpaces((String)url) && !oldValue.equals(url)) {
                    repoModel.addElement(url);
                    repoModel.removeElement(oldValue);
                    controller.removeRepository(oldValue);
                    controller.addRepository(url);
                }
            }
        });
        decorator.setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                String selected = (String)ManageRepoDialog.this.myList.getSelectedValue();
                controller.removeRepository(selected);
                repoModel.removeElement(selected);
                button.setEnabled(false);
            }
        });
        decorator.setRemoveActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                return ManageRepoDialog.this.myEnabled;
            }
        });
        decorator.setEditActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                return ManageRepoDialog.this.myEnabled;
            }
        });
        JPanel panel2 = decorator.createPanel();
        panel2.setPreferredSize((Dimension)JBUI.size((int)800, (int)600));
        this.myMainPanel.add(panel2);
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

