/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EmptyConsumer;
import com.intellij.util.Processor;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.EmptyIntHashSet;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.IntInlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.Page;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentMap;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.data.SingleTaskController;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.VcsUserRegistryImpl;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.IntListDataExternalizer;
import com.intellij.vcs.log.data.index.VcsLogBigRepositoriesList;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.data.index.VcsLogMessagesTrigramIndex;
import com.intellij.vcs.log.data.index.VcsLogPathsIndex;
import com.intellij.vcs.log.data.index.VcsLogUserIndex;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.impl.HeavyAwareExecutor;
import com.intellij.vcs.log.impl.VcsIndexableDetails;
import com.intellij.vcs.log.ui.filter.VcsLogTextFilterImpl;
import com.intellij.vcs.log.util.PersistentSet;
import com.intellij.vcs.log.util.PersistentSetImpl;
import com.intellij.vcs.log.util.PersistentUtil;
import com.intellij.vcs.log.util.StopWatch;
import com.intellij.vcs.log.util.TroveUtil;
import gnu.trove.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogPersistentIndex
implements VcsLogIndex,
Disposable {
    private static final Logger LOG = Logger.getInstance(VcsLogPersistentIndex.class);
    private static final int VERSION = 3;
    @NotNull
    private final Project myProject;
    @NotNull
    private final FatalErrorHandler myFatalErrorsConsumer;
    @NotNull
    private final VcsLogProgress myProgress;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> myProviders;
    @NotNull
    private final VcsLogStorage myStorage;
    @NotNull
    private final VcsUserRegistryImpl myUserRegistry;
    @NotNull
    private final Set<VirtualFile> myRoots;
    @NotNull
    private final VcsLogBigRepositoriesList myBigRepositoriesList;
    @Nullable
    private final IndexStorage myIndexStorage;
    @Nullable
    private final IndexDataGetter myDataGetter;
    @NotNull
    private final SingleTaskController<IndexingRequest, Void> mySingleTaskController;
    @NotNull
    private final Map<VirtualFile, AtomicInteger> myNumberOfTasks;
    @NotNull
    private final Map<VirtualFile, AtomicLong> myIndexingTime;
    @NotNull
    private final Map<VirtualFile, AtomicInteger> myIndexingLimit;
    @NotNull
    private final List<VcsLogIndex.IndexingFinishedListener> myListeners;
    @NotNull
    private Map<VirtualFile, TIntHashSet> myCommitsToIndex;
    @NotNull
    private Map<VirtualFile, TIntHashSet> myCommitsToReIndex;

    public VcsLogPersistentIndex(@NotNull Project project, @NotNull VcsLogStorage storage2, @NotNull VcsLogProgress progress, @NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull FatalErrorHandler fatalErrorsConsumer, @NotNull Disposable disposableParent) {
        if (project == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(0);
        }
        if (storage2 == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(1);
        }
        if (progress == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(2);
        }
        if (providers == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(3);
        }
        if (fatalErrorsConsumer == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(4);
        }
        if (disposableParent == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(5);
        }
        this.myNumberOfTasks = ContainerUtil.newHashMap();
        this.myIndexingTime = ContainerUtil.newHashMap();
        this.myIndexingLimit = ContainerUtil.newHashMap();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myCommitsToIndex = ContainerUtil.newHashMap();
        this.myCommitsToReIndex = ContainerUtil.newHashMap();
        this.myStorage = storage2;
        this.myProject = project;
        this.myProgress = progress;
        this.myProviders = providers;
        this.myFatalErrorsConsumer = fatalErrorsConsumer;
        this.myRoots = ContainerUtil.newLinkedHashSet();
        this.myBigRepositoriesList = VcsLogBigRepositoriesList.getInstance();
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : providers.entrySet()) {
            if (!((Boolean)VcsLogProperties.get((VcsLogProvider)entry.getValue(), (VcsLogProperties.VcsLogProperty)VcsLogProperties.SUPPORTS_INDEXING)).booleanValue()) continue;
            this.myRoots.add(entry.getKey());
        }
        this.myUserRegistry = (VcsUserRegistryImpl)ServiceManager.getService((Project)this.myProject, VcsUserRegistry.class);
        this.myIndexStorage = this.createIndexStorage(fatalErrorsConsumer, PersistentUtil.calcLogId(this.myProject, providers));
        this.myDataGetter = this.myIndexStorage != null ? new IndexDataGetter(this.myProject, this.myRoots, this.myIndexStorage, this.myStorage, this.myFatalErrorsConsumer) : null;
        for (VirtualFile root : this.myRoots) {
            this.myNumberOfTasks.put(root, new AtomicInteger());
            this.myIndexingTime.put(root, new AtomicLong());
            this.myIndexingLimit.put(root, new AtomicInteger(VcsLogPersistentIndex.getIndexingLimit()));
        }
        this.mySingleTaskController = new MySingleTaskController(project, (Disposable)(this.myIndexStorage != null ? this.myIndexStorage : this));
        Disposer.register((Disposable)disposableParent, (Disposable)this);
    }

    private static int getIndexingLimit() {
        return Registry.intValue((String)"vcs.log.index.limit.minutes");
    }

    protected IndexStorage createIndexStorage(@NotNull FatalErrorHandler fatalErrorHandler, @NotNull String logId) {
        if (fatalErrorHandler == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(6);
        }
        if (logId == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(7);
        }
        try {
            return (IndexStorage)IOUtil.openCleanOrResetBroken(() -> {
                if (logId == null) {
                    VcsLogPersistentIndex.$$$reportNull$$$0(38);
                }
                if (fatalErrorHandler == null) {
                    VcsLogPersistentIndex.$$$reportNull$$$0(39);
                }
                return new IndexStorage(logId, this.myUserRegistry, this.myRoots, fatalErrorHandler, this);
            }, () -> {
                if (logId == null) {
                    VcsLogPersistentIndex.$$$reportNull$$$0(37);
                }
                IndexStorage.cleanup(logId);
            });
        }
        catch (IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
            return null;
        }
    }

    public static int getVersion() {
        return 8;
    }

    @Override
    public synchronized void scheduleIndex(boolean full) {
        boolean isFull;
        if (Disposer.isDisposed((Disposable)this)) {
            return;
        }
        if (this.myCommitsToIndex.isEmpty() || this.myIndexStorage == null) {
            return;
        }
        if (this.myIndexStorage.isFresh() && !full) {
            return;
        }
        Map<VirtualFile, TIntHashSet> commitsToIndex = this.myCommitsToIndex;
        for (VirtualFile root : commitsToIndex.keySet()) {
            this.myNumberOfTasks.get(root).incrementAndGet();
        }
        this.myCommitsToIndex = ContainerUtil.newHashMap();
        boolean bl = isFull = full && this.myIndexStorage.isFresh();
        if (isFull) {
            LOG.debug("Index storage for project " + this.myProject.getName() + " is fresh, scheduling full reindex");
        }
        for (VirtualFile root : commitsToIndex.keySet()) {
            TIntHashSet commits = commitsToIndex.get(root);
            if (commits.isEmpty()) continue;
            if (this.myBigRepositoriesList.isBig(root)) {
                this.myCommitsToIndex.put(root, commits);
                LOG.info("Indexing repository " + root.getName() + " is skipped since it is too big");
                continue;
            }
            this.mySingleTaskController.request(new IndexingRequest(root, commits, isFull, false));
        }
        if (isFull) {
            this.myIndexStorage.unmarkFresh();
        }
    }

    private void storeDetail(@NotNull VcsFullCommitDetails detail) {
        if (detail == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(8);
        }
        if (this.myIndexStorage == null) {
            return;
        }
        try {
            int index = this.myStorage.getCommitIndex((Hash)detail.getId(), detail.getRoot());
            this.myIndexStorage.messages.put((Object)index, (Object)detail.getFullMessage());
            this.myIndexStorage.trigrams.update(index, detail);
            this.myIndexStorage.users.update(index, detail);
            this.myIndexStorage.paths.update(index, detail);
            this.myIndexStorage.parents.put((Object)index, (Object)ContainerUtil.map((Collection)detail.getParents(), p -> {
                if (detail == null) {
                    VcsLogPersistentIndex.$$$reportNull$$$0(36);
                }
                return this.myStorage.getCommitIndex((Hash)p, detail.getRoot());
            }));
            if (!(detail instanceof VcsIndexableDetails) || ((VcsIndexableDetails)detail).hasRenames()) {
                this.myIndexStorage.renames.put(index);
            }
            this.myIndexStorage.commits.put(index);
        }
        catch (IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
        }
    }

    private void flush() {
        try {
            if (this.myIndexStorage != null) {
                this.myIndexStorage.messages.force();
                this.myIndexStorage.trigrams.flush();
                this.myIndexStorage.users.flush();
                this.myIndexStorage.paths.flush();
                this.myIndexStorage.parents.force();
                this.myIndexStorage.renames.flush();
                this.myIndexStorage.commits.flush();
            }
        }
        catch (StorageException e) {
            this.myFatalErrorsConsumer.consume(this, e);
        }
    }

    @Override
    public void markCorrupted() {
        if (this.myIndexStorage != null) {
            this.myIndexStorage.commits.markCorrupted();
        }
    }

    @Override
    public boolean isIndexed(int commit) {
        try {
            return this.myIndexStorage == null || this.myIndexStorage.commits.contains(commit);
        }
        catch (IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
            return false;
        }
    }

    private boolean hasRenames(int commit) {
        try {
            return this.myIndexStorage == null || this.myIndexStorage.renames.contains(commit);
        }
        catch (IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
            return false;
        }
    }

    @Override
    public synchronized boolean isIndexed(@NotNull VirtualFile root) {
        if (root == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(9);
        }
        return this.myRoots.contains(root) && !this.myBigRepositoriesList.isBig(root) && !this.myCommitsToIndex.containsKey(root) && this.myNumberOfTasks.get(root).get() == 0;
    }

    @Override
    public synchronized void markForIndexing(int index, @NotNull VirtualFile root) {
        if (root == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(10);
        }
        if (this.isIndexed(index) || !this.myRoots.contains(root)) {
            return;
        }
        TroveUtil.add(this.myCommitsToIndex, root, index);
    }

    @Override
    public synchronized void reindexWithRenames(int commit, @NotNull VirtualFile root) {
        if (root == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(11);
        }
        LOG.assertTrue(this.myRoots.contains(root));
        if (this.hasRenames(commit)) {
            return;
        }
        this.mySingleTaskController.request(new IndexingRequest(root, TroveUtil.singleton(commit), false, true));
    }

    @NotNull
    private <T> TIntHashSet filter(@NotNull PersistentMap<Integer, T> map2, @NotNull Condition<T> condition) {
        if (map2 == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(12);
        }
        if (condition == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(13);
        }
        TIntHashSet result2 = new TIntHashSet();
        if (this.myIndexStorage == null) {
            TIntHashSet tIntHashSet = result2;
            if (tIntHashSet == null) {
                VcsLogPersistentIndex.$$$reportNull$$$0(14);
            }
            return tIntHashSet;
        }
        try {
            Processor processor2 = integer -> {
                if (map2 == null) {
                    VcsLogPersistentIndex.$$$reportNull$$$0(34);
                }
                if (condition == null) {
                    VcsLogPersistentIndex.$$$reportNull$$$0(35);
                }
                try {
                    Object value = map2.get(integer);
                    if (value != null && condition.value(value)) {
                        result2.add(integer.intValue());
                    }
                }
                catch (IOException e) {
                    this.myFatalErrorsConsumer.consume(this, e);
                    return false;
                }
                return true;
            };
            if (this.myIndexStorage.messages instanceof PersistentHashMap) {
                ((PersistentHashMap)this.myIndexStorage.messages).processKeysWithExistingMapping(processor2);
            } else {
                this.myIndexStorage.messages.processKeys(processor2);
            }
        }
        catch (IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
        }
        TIntHashSet tIntHashSet = result2;
        if (tIntHashSet == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(15);
        }
        return tIntHashSet;
    }

    @NotNull
    private TIntHashSet filterUsers(@NotNull Set<VcsUser> users) {
        if (users == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(16);
        }
        if (this.myIndexStorage != null) {
            TIntHashSet tIntHashSet;
            try {
                tIntHashSet = this.myIndexStorage.users.getCommitsForUsers(users);
            }
            catch (StorageException | IOException e) {
                this.myFatalErrorsConsumer.consume(this, e);
            }
            catch (RuntimeException e) {
                this.processRuntimeException(e);
            }
            if (tIntHashSet == null) {
                VcsLogPersistentIndex.$$$reportNull$$$0(17);
            }
            return tIntHashSet;
        }
        TIntHashSet tIntHashSet = new TIntHashSet();
        if (tIntHashSet == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(18);
        }
        return tIntHashSet;
    }

    @NotNull
    private TIntHashSet filterPaths(@NotNull Collection<FilePath> paths) {
        if (paths == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(19);
        }
        if (this.myIndexStorage != null) {
            TIntHashSet tIntHashSet;
            try {
                tIntHashSet = this.myIndexStorage.paths.getCommitsForPaths(paths);
            }
            catch (StorageException | IOException e) {
                this.myFatalErrorsConsumer.consume(this, e);
            }
            catch (RuntimeException e) {
                this.processRuntimeException(e);
            }
            if (tIntHashSet == null) {
                VcsLogPersistentIndex.$$$reportNull$$$0(20);
            }
            return tIntHashSet;
        }
        TIntHashSet tIntHashSet = new TIntHashSet();
        if (tIntHashSet == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(21);
        }
        return tIntHashSet;
    }

    @NotNull
    public TIntHashSet filterMessages(@NotNull VcsLogTextFilter filter2) {
        if (filter2 == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(22);
        }
        if (this.myIndexStorage != null) {
            block8: {
                TIntHashSet tIntHashSet;
                try {
                    TIntHashSet commitsForSearch;
                    if (filter2.isRegex() || (commitsForSearch = this.myIndexStorage.trigrams.getCommitsForSubstring(filter2.getText())) == null) break block8;
                    TIntHashSet result2 = new TIntHashSet();
                    commitsForSearch.forEach(commit -> {
                        if (filter2 == null) {
                            VcsLogPersistentIndex.$$$reportNull$$$0(33);
                        }
                        try {
                            String value = (String)this.myIndexStorage.messages.get((Object)commit);
                            if (value != null && VcsLogTextFilterImpl.matches(filter2, value)) {
                                result2.add(commit);
                            }
                        }
                        catch (IOException e) {
                            this.myFatalErrorsConsumer.consume(this, e);
                            return false;
                        }
                        return true;
                    });
                    tIntHashSet = result2;
                }
                catch (StorageException e) {
                    this.myFatalErrorsConsumer.consume(this, e);
                }
                catch (RuntimeException e) {
                    this.processRuntimeException(e);
                }
                if (tIntHashSet == null) {
                    VcsLogPersistentIndex.$$$reportNull$$$0(23);
                }
                return tIntHashSet;
            }
            TIntHashSet tIntHashSet = this.filter(this.myIndexStorage.messages, message -> {
                if (filter2 == null) {
                    VcsLogPersistentIndex.$$$reportNull$$$0(32);
                }
                return VcsLogTextFilterImpl.matches(filter2, message);
            });
            if (tIntHashSet == null) {
                VcsLogPersistentIndex.$$$reportNull$$$0(24);
            }
            return tIntHashSet;
        }
        TIntHashSet tIntHashSet = EmptyIntHashSet.INSTANCE;
        if (tIntHashSet == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(25);
        }
        return tIntHashSet;
    }

    private void processRuntimeException(@NotNull RuntimeException e) {
        if (e == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(26);
        }
        if (e instanceof ProcessCanceledException) {
            throw e;
        }
        if (this.myIndexStorage != null) {
            this.myIndexStorage.markCorrupted();
        }
        if (!(e.getCause() instanceof IOException) && !(e.getCause() instanceof StorageException)) {
            throw new RuntimeException(e);
        }
        this.myFatalErrorsConsumer.consume(this, e);
    }

    @Override
    public boolean canFilter(@NotNull List<VcsLogDetailsFilter> filters) {
        if (filters == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(27);
        }
        if (filters.isEmpty() || this.myIndexStorage == null) {
            return false;
        }
        for (VcsLogDetailsFilter filter2 : filters) {
            if (filter2 instanceof VcsLogTextFilter || filter2 instanceof VcsLogUserFilter || filter2 instanceof VcsLogStructureFilter) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Set<Integer> filter(@NotNull List<VcsLogDetailsFilter> detailsFilters) {
        if (detailsFilters == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(28);
        }
        VcsLogTextFilter textFilter = (VcsLogTextFilter)ContainerUtil.findInstance(detailsFilters, VcsLogTextFilter.class);
        VcsLogUserFilter userFilter = (VcsLogUserFilter)ContainerUtil.findInstance(detailsFilters, VcsLogUserFilter.class);
        VcsLogStructureFilter pathFilter = (VcsLogStructureFilter)ContainerUtil.findInstance(detailsFilters, VcsLogStructureFilter.class);
        TIntHashSet filteredByMessage = null;
        if (textFilter != null) {
            filteredByMessage = this.filterMessages(textFilter);
        }
        TIntHashSet filteredByUser = null;
        if (userFilter != null) {
            HashSet users = ContainerUtil.newHashSet();
            for (VirtualFile root : this.myRoots) {
                users.addAll(userFilter.getUsers(root));
            }
            filteredByUser = this.filterUsers(users);
        }
        TIntHashSet filteredByPath = null;
        if (pathFilter != null) {
            filteredByPath = this.filterPaths(pathFilter.getFiles());
        }
        Set<Integer> set2 = TroveUtil.intersect(filteredByMessage, filteredByPath, filteredByUser);
        if (set2 == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(29);
        }
        return set2;
    }

    @Override
    @Nullable
    public IndexDataGetter getDataGetter() {
        if (this.myIndexStorage == null) {
            return null;
        }
        return this.myDataGetter;
    }

    @Override
    public void addListener(@NotNull VcsLogIndex.IndexingFinishedListener l) {
        if (l == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(30);
        }
        this.myListeners.add(l);
    }

    @Override
    public void removeListener(@NotNull VcsLogIndex.IndexingFinishedListener l) {
        if (l == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(31);
        }
        this.myListeners.remove(l);
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fatalErrorsConsumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposableParent";
                break;
            }
            case 6: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fatalErrorHandler";
                break;
            }
            case 7: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logId";
                break;
            }
            case 8: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detail";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 12: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 13: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/index/VcsLogPersistentIndex";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "users";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 22: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailsFilters";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPersistentIndex";
                break;
            }
            case 14: 
            case 15: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "filterUsers";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "filterPaths";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "filterMessages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createIndexStorage";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "storeDetail";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isIndexed";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "markForIndexing";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "reindexWithRenames";
                break;
            }
            case 12: 
            case 13: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 29: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "filterUsers";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "filterPaths";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "filterMessages";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processRuntimeException";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "canFilter";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$filterMessages$5";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$filterMessages$4";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$filter$3";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$storeDetail$2";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createIndexStorage$1";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createIndexStorage$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class IndexingRequest {
        private static final int BATCH_SIZE = 20000;
        private static final int FLUSHED_COMMITS_NUMBER = 15000;
        @NotNull
        private final VirtualFile myRoot;
        @NotNull
        private final TIntHashSet myCommits;
        private final boolean myFull;
        private final boolean myReindex;
        @NotNull
        private final AtomicInteger myNewIndexedCommits;
        @NotNull
        private final AtomicInteger myOldCommits;
        private volatile long myStartTime;

        public IndexingRequest(@NotNull VirtualFile root, TIntHashSet commits, boolean full, boolean reindex) {
            if (root == null) {
                IndexingRequest.$$$reportNull$$$0(0);
            }
            if (commits == null) {
                IndexingRequest.$$$reportNull$$$0(1);
            }
            this.myNewIndexedCommits = new AtomicInteger();
            this.myOldCommits = new AtomicInteger();
            this.myRoot = root;
            this.myCommits = commits;
            this.myFull = full;
            this.myReindex = reindex;
            LOG.assertTrue(!this.myFull || !this.myReindex);
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                IndexingRequest.$$$reportNull$$$0(2);
            }
            if (VcsLogPersistentIndex.this.myBigRepositoriesList.isBig(this.myRoot)) {
                LOG.info("Indexing repository " + this.myRoot.getName() + " is skipped since it is too big");
                return;
            }
            indicator.setIndeterminate(false);
            indicator.setFraction(0.0);
            this.myStartTime = this.getCurrentTimeMillis();
            LOG.debug("Indexing " + (this.myFull ? "full repository" : this.myCommits.size() + " commits") + " in " + this.myRoot.getName());
            try {
                try {
                    if (this.myFull) {
                        this.indexAll(indicator);
                    } else {
                        IntStream commits = TroveUtil.stream(this.myCommits).filter(c -> {
                            if (this.myReindex ? VcsLogPersistentIndex.this.hasRenames(c) : VcsLogPersistentIndex.this.isIndexed(c)) {
                                this.myOldCommits.incrementAndGet();
                                return false;
                            }
                            return true;
                        });
                        this.indexOneByOne(commits, indicator);
                    }
                }
                catch (ProcessCanceledException e) {
                    this.scheduleReindex();
                    throw e;
                }
                catch (VcsException e) {
                    LOG.error((Throwable)e);
                    this.scheduleReindex();
                }
            }
            finally {
                if (!this.myReindex) {
                    ((AtomicInteger)VcsLogPersistentIndex.this.myNumberOfTasks.get(this.myRoot)).decrementAndGet();
                }
                if (VcsLogPersistentIndex.this.isIndexed(this.myRoot)) {
                    ((AtomicLong)VcsLogPersistentIndex.this.myIndexingTime.get(this.myRoot)).set(0L);
                    VcsLogPersistentIndex.this.myListeners.forEach(listener2 -> listener2.indexingFinished(this.myRoot));
                } else {
                    ((AtomicLong)VcsLogPersistentIndex.this.myIndexingTime.get(this.myRoot)).updateAndGet(t -> t + (this.getCurrentTimeMillis() - this.myStartTime));
                }
                this.report();
                VcsLogPersistentIndex.this.flush();
            }
        }

        private long getCurrentTimeMillis() {
            return TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
        }

        private void report() {
            String formattedTime = StopWatch.formatTime(this.getCurrentTimeMillis() - this.myStartTime);
            if (this.myFull) {
                LOG.debug(formattedTime + " for indexing " + this.myNewIndexedCommits + " commits in " + this.myRoot.getName());
            } else {
                int leftCommits = this.myCommits.size() - this.myNewIndexedCommits.get() - this.myOldCommits.get();
                String leftCommitsMessage = leftCommits > 0 ? ". " + leftCommits + " commits left" : "";
                LOG.debug(formattedTime + " for indexing " + this.myNewIndexedCommits + " new commits out of " + this.myCommits.size() + " in " + this.myRoot.getName() + leftCommitsMessage);
            }
        }

        private void scheduleReindex() {
            LOG.debug("Schedule reindexing of " + (this.myCommits.size() - this.myNewIndexedCommits.get() - this.myOldCommits.get()) + " commits in " + this.myRoot.getName());
            if (this.myReindex) {
                this.myCommits.forEach(value -> {
                    VcsLogPersistentIndex.this.reindexWithRenames(value, this.myRoot);
                    return true;
                });
            } else {
                this.myCommits.forEach(value -> {
                    VcsLogPersistentIndex.this.markForIndexing(value, this.myRoot);
                    return true;
                });
                VcsLogPersistentIndex.this.scheduleIndex(false);
            }
        }

        private void indexOneByOne(@NotNull IntStream commits, @NotNull ProgressIndicator indicator) throws VcsException {
            if (commits == null) {
                IndexingRequest.$$$reportNull$$$0(3);
            }
            if (indicator == null) {
                IndexingRequest.$$$reportNull$$$0(4);
            }
            TroveUtil.processBatches(commits, 20000, (ThrowableConsumer<TIntHashSet, VcsException>)((ThrowableConsumer)batch -> {
                if (indicator == null) {
                    IndexingRequest.$$$reportNull$$$0(9);
                }
                indicator.checkCanceled();
                List<String> hashes = TroveUtil.map(batch, value -> VcsLogPersistentIndex.this.myStorage.getCommitId(value).getHash().asString());
                ((VcsLogProvider)VcsLogPersistentIndex.this.myProviders.get(this.myRoot)).readFullDetails(this.myRoot, hashes, detail -> {
                    if (indicator == null) {
                        IndexingRequest.$$$reportNull$$$0(10);
                    }
                    VcsLogPersistentIndex.this.storeDetail(detail);
                    this.myNewIndexedCommits.incrementAndGet();
                    this.checkRunningTooLong(indicator);
                }, !this.myReindex);
                this.displayProgress(indicator);
            }));
        }

        public void indexAll(@NotNull ProgressIndicator indicator) throws VcsException {
            if (indicator == null) {
                IndexingRequest.$$$reportNull$$$0(5);
            }
            this.displayProgress(indicator);
            ((VcsLogProvider)VcsLogPersistentIndex.this.myProviders.get(this.myRoot)).readAllFullDetails(this.myRoot, details -> {
                if (indicator == null) {
                    IndexingRequest.$$$reportNull$$$0(8);
                }
                VcsLogPersistentIndex.this.storeDetail(details);
                if (this.myNewIndexedCommits.incrementAndGet() % 15000 == 0) {
                    VcsLogPersistentIndex.this.flush();
                }
                this.checkRunningTooLong(indicator);
                indicator.checkCanceled();
                this.displayProgress(indicator);
            });
        }

        private void checkRunningTooLong(@NotNull ProgressIndicator indicator) {
            int limit;
            long time;
            if (indicator == null) {
                IndexingRequest.$$$reportNull$$$0(6);
            }
            if ((time = ((AtomicLong)VcsLogPersistentIndex.this.myIndexingTime.get(this.myRoot)).get() + (this.getCurrentTimeMillis() - this.myStartTime)) >= (long)(Math.max(limit = ((AtomicInteger)VcsLogPersistentIndex.this.myIndexingLimit.get(this.myRoot)).get(), 1) * 60 * 1000) && !VcsLogPersistentIndex.this.myBigRepositoriesList.isBig(this.myRoot)) {
                LOG.warn("Indexing " + this.myRoot.getName() + " was cancelled after " + StopWatch.formatTime(time));
                VcsLogPersistentIndex.this.myBigRepositoriesList.addRepository(this.myRoot);
                indicator.cancel();
                this.showIndexingNotification(time);
            }
        }

        public void displayProgress(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                IndexingRequest.$$$reportNull$$$0(7);
            }
            indicator.setFraction(((double)this.myNewIndexedCommits.get() + (double)this.myOldCommits.get()) / (double)this.myCommits.size());
        }

        public String toString() {
            return "IndexingRequest of " + this.myCommits.size() + " commits in " + this.myRoot.getName() + (this.myFull ? " (full)" : "");
        }

        private void showIndexingNotification(long time) {
            Runnable notificationRunner = () -> {
                Notification notification = VcsNotifier.createNotification(VcsNotifier.IMPORTANT_ERROR_NOTIFICATION, "Log Indexing for \"" + this.myRoot.getName() + "\" Stopped", "Indexing was taking too long (" + StopWatch.formatTime(time - time % 1000L) + ")", NotificationType.WARNING, null);
                notification.addAction((AnAction)new NotificationAction("Resume"){

                    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (notification == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (VcsLogPersistentIndex.this.myBigRepositoriesList.isBig(IndexingRequest.this.myRoot)) {
                            LOG.info("Resuming indexing " + IndexingRequest.this.myRoot.getName());
                            ((AtomicInteger)VcsLogPersistentIndex.this.myIndexingLimit.get(IndexingRequest.this.myRoot)).updateAndGet(l -> l + VcsLogPersistentIndex.getIndexingLimit());
                            VcsLogPersistentIndex.this.myBigRepositoriesList.removeRepository(IndexingRequest.this.myRoot);
                            VcsLogPersistentIndex.this.scheduleIndex(false);
                        }
                        notification.expire();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "e";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "notification";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest$1";
                        objectArray[2] = "actionPerformed";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                VcsNotifier.getInstance(VcsLogPersistentIndex.this.myProject).notify(notification);
            };
            ApplicationManager.getApplication().invokeLater(notificationRunner);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commits";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "indexOneByOne";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "indexAll";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkRunningTooLong";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "displayProgress";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$indexAll$8";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$indexOneByOne$7";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$null$6";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MySingleTaskController
    extends SingleTaskController<IndexingRequest, Void> {
        private static final int LOW_PRIORITY = 1;
        @NotNull
        private final HeavyAwareExecutor myHeavyAwareExecutor;

        public MySingleTaskController(@NotNull Project project, Disposable parent) {
            if (project == null) {
                MySingleTaskController.$$$reportNull$$$0(0);
            }
            if (parent == null) {
                MySingleTaskController.$$$reportNull$$$0(1);
            }
            super(project, EmptyConsumer.getInstance(), false, parent);
            this.myHeavyAwareExecutor = new HeavyAwareExecutor(project, 50, 100, VcsLogPersistentIndex.this);
        }

        @Override
        @NotNull
        protected ProgressIndicator startNewBackgroundTask() {
            ProgressIndicator indicator = VcsLogPersistentIndex.this.myProgress.createProgressIndicator(false);
            ApplicationManager.getApplication().invokeLater(() -> {
                Task.Backgroundable task2 = new Task.Backgroundable(VcsLogPersistentIndex.this.myProject, "Indexing Commit Data", true, PerformInBackgroundOption.ALWAYS_BACKGROUND){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        int previousPriority = MySingleTaskController.this.setMinimumPriority();
                        try {
                            IndexingRequest request;
                            while ((request = (IndexingRequest)MySingleTaskController.this.popRequest()) != null) {
                                try {
                                    request.run(indicator);
                                    indicator.checkCanceled();
                                }
                                catch (ProcessCanceledException reThrown) {
                                    throw reThrown;
                                }
                                catch (Throwable t) {
                                    LOG.error("Error while indexing", t);
                                }
                            }
                        }
                        finally {
                            MySingleTaskController.this.taskCompleted(null);
                            MySingleTaskController.this.resetPriority(previousPriority);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$MySingleTaskController$1", "run"));
                    }
                };
                this.myHeavyAwareExecutor.executeOutOfHeavyOrPowerSave(task2, indicator);
            });
            ProgressIndicator progressIndicator = indicator;
            if (progressIndicator == null) {
                MySingleTaskController.$$$reportNull$$$0(2);
            }
            return progressIndicator;
        }

        public void resetPriority(int previousPriority) {
            if (Thread.currentThread().getPriority() == 1) {
                Thread.currentThread().setPriority(previousPriority);
            }
        }

        public int setMinimumPriority() {
            int previousPriority = Thread.currentThread().getPriority();
            try {
                Thread.currentThread().setPriority(1);
            }
            catch (SecurityException ignored) {
                LOG.debug("Could not set indexing thread priority", (Throwable)ignored);
            }
            return previousPriority;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$MySingleTaskController";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$MySingleTaskController";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "startNewBackgroundTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class IndexStorage
    implements Disposable {
        private static final String COMMITS = "commits";
        private static final String MESSAGES = "messages";
        private static final String PARENTS = "parents";
        private static final String RENAMES = "renames";
        private static final int MESSAGES_VERSION = 0;
        @NotNull
        public final PersistentSet<Integer> commits;
        @NotNull
        public final PersistentMap<Integer, String> messages;
        @NotNull
        public final PersistentMap<Integer, List<Integer>> parents;
        @NotNull
        public final PersistentSet<Integer> renames;
        @NotNull
        public final VcsLogMessagesTrigramIndex trigrams;
        @NotNull
        public final VcsLogUserIndex users;
        @NotNull
        public final VcsLogPathsIndex paths;
        private volatile boolean myIsFresh;

        public IndexStorage(@NotNull String logId, @NotNull VcsUserRegistryImpl userRegistry, @NotNull Set<VirtualFile> roots, @NotNull FatalErrorHandler fatalErrorHandler, @NotNull Disposable parentDisposable) throws IOException {
            if (logId == null) {
                IndexStorage.$$$reportNull$$$0(0);
            }
            if (userRegistry == null) {
                IndexStorage.$$$reportNull$$$0(1);
            }
            if (roots == null) {
                IndexStorage.$$$reportNull$$$0(2);
            }
            if (fatalErrorHandler == null) {
                IndexStorage.$$$reportNull$$$0(3);
            }
            if (parentDisposable == null) {
                IndexStorage.$$$reportNull$$$0(4);
            }
            Disposer.register((Disposable)parentDisposable, (Disposable)this);
            try {
                int version = VcsLogPersistentIndex.getVersion();
                File commitsStorage = PersistentUtil.getStorageFile("index", COMMITS, logId, version);
                this.myIsFresh = !commitsStorage.exists();
                this.commits = new PersistentSetImpl<Integer>(commitsStorage, (KeyDescriptor<Integer>)EnumeratorIntegerDescriptor.INSTANCE, Page.PAGE_SIZE, null, version);
                Disposer.register((Disposable)this, () -> IndexStorage.catchAndWarn((ThrowableRunnable<IOException>)((ThrowableRunnable)this.commits::close)));
                File messagesStorage = PersistentUtil.getStorageFile("index", MESSAGES, logId, 5);
                this.messages = new PersistentHashMap(messagesStorage, (KeyDescriptor)new IntInlineKeyDescriptor(), (DataExternalizer)EnumeratorStringDescriptor.INSTANCE, Page.PAGE_SIZE);
                Disposer.register((Disposable)this, () -> IndexStorage.catchAndWarn((ThrowableRunnable<IOException>)((ThrowableRunnable)() -> this.messages.close())));
                this.trigrams = new VcsLogMessagesTrigramIndex(logId, fatalErrorHandler, this);
                this.users = new VcsLogUserIndex(logId, userRegistry, fatalErrorHandler, this);
                this.paths = new VcsLogPathsIndex(logId, roots, fatalErrorHandler, this);
                File parentsStorage = PersistentUtil.getStorageFile("index", PARENTS, logId, version);
                this.parents = new PersistentHashMap(parentsStorage, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new IntListDataExternalizer(), Page.PAGE_SIZE, version);
                Disposer.register((Disposable)this, () -> IndexStorage.catchAndWarn((ThrowableRunnable<IOException>)((ThrowableRunnable)() -> this.parents.close())));
                File renamesStorage = PersistentUtil.getStorageFile("index", RENAMES, logId, version);
                this.renames = new PersistentSetImpl<Integer>(renamesStorage, (KeyDescriptor<Integer>)EnumeratorIntegerDescriptor.INSTANCE, Page.PAGE_SIZE, null, version);
                Disposer.register((Disposable)this, () -> IndexStorage.catchAndWarn((ThrowableRunnable<IOException>)((ThrowableRunnable)this.renames::close)));
            }
            catch (Throwable t) {
                Disposer.dispose((Disposable)this);
                throw t;
            }
        }

        void markCorrupted() {
            IndexStorage.catchAndWarn((ThrowableRunnable<IOException>)((ThrowableRunnable)this.commits::markCorrupted));
        }

        private static void catchAndWarn(@NotNull ThrowableRunnable<IOException> runnable2) {
            if (runnable2 == null) {
                IndexStorage.$$$reportNull$$$0(5);
            }
            try {
                runnable2.run();
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }

        private static void cleanup(@NotNull String logId) {
            if (logId == null) {
                IndexStorage.$$$reportNull$$$0(6);
            }
            if (!PersistentUtil.cleanupStorageFiles("index", logId)) {
                LOG.error("Could not clean up storage files in " + new File(PersistentUtil.LOG_CACHE, "index") + " starting with " + logId);
            }
        }

        public void unmarkFresh() {
            this.myIsFresh = false;
        }

        public boolean isFresh() {
            return this.myIsFresh;
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "userRegistry";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fatalErrorHandler";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDisposable";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexStorage";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "catchAndWarn";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "cleanup";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

