/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.ValidateableNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.tree.ChildrenProvider;
import com.intellij.ui.tree.Reference;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.ui.tree.AbstractTreeModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class StructureTreeModel
extends AbstractTreeModel
implements Disposable,
InvokerSupplier,
ChildrenProvider<TreeNode> {
    private static final Logger LOG = Logger.getInstance(StructureTreeModel.class);
    private final Reference<Node> root = new Reference();
    private final Invoker invoker;
    private volatile AbstractTreeStructure structure;
    private volatile Comparator<Node> comparator;

    public StructureTreeModel(boolean background) {
        this.invoker = background ? new Invoker.BackgroundThread(this) : new Invoker.EDT(this);
    }

    public final void setComparator(Comparator<NodeDescriptor> comparator2) {
        if (this.disposed) {
            return;
        }
        if (comparator2 != null) {
            this.comparator = (node1, node2) -> comparator2.compare(((Node)node1).getDescriptor(), ((Node)node2).getDescriptor());
            this.invalidate(null);
        } else if (this.comparator != null) {
            this.comparator = null;
            this.invalidate(null);
        }
    }

    public void setStructure(AbstractTreeStructure structure) {
        if (this.disposed) {
            return;
        }
        this.structure = structure;
        this.invalidate(null);
    }

    public void dispose() {
        super.dispose();
        this.comparator = null;
        this.structure = null;
        Node node = this.root.set(null);
        if (node != null) {
            node.dispose();
        }
    }

    @Override
    @NotNull
    public final Invoker getInvoker() {
        Invoker invoker = this.invoker;
        if (invoker == null) {
            StructureTreeModel.$$$reportNull$$$0(0);
        }
        return invoker;
    }

    private boolean isValidThread() {
        if (this.invoker.isValidThread()) {
            return true;
        }
        LOG.warn("StructureTreeModel is used from unexpected thread");
        return false;
    }

    public final void invalidate(Runnable onDone) {
        this.invoker.invokeLaterIfNeeded(() -> {
            if (this.disposed) {
                return;
            }
            this.root.invalidate();
            Node node = this.root.get();
            LOG.debug("root invalidated: ", new Object[]{node});
            if (node != null) {
                node.invalidate();
            }
            this.treeStructureChanged(null, null, null);
            if (onDone != null) {
                onDone.run();
            }
        });
    }

    public final void invalidate(@NotNull TreePath path, boolean structure) {
        Object component;
        if (path == null) {
            StructureTreeModel.$$$reportNull$$$0(1);
        }
        if ((component = path.getLastPathComponent()) instanceof Node) {
            this.invoker.invokeLaterIfNeeded(() -> {
                if (path == null) {
                    StructureTreeModel.$$$reportNull$$$0(3);
                }
                Node node = (Node)component;
                if (this.disposed) {
                    return;
                }
                if (this.isNodeRemoved(node)) {
                    return;
                }
                if (this.isValid(node.getElement())) {
                    boolean updated = node.update();
                    if (structure) {
                        node.invalidate();
                        this.treeStructureChanged(path, null, null);
                    } else if (updated) {
                        this.treeNodesChanged(path, null, null);
                    }
                } else {
                    LOG.debug("invalid element cannot be updated: ", new Object[]{path});
                    TreePath parent = path.getParentPath();
                    if (parent != null) {
                        this.invalidate(parent, true);
                    } else {
                        this.invalidate(null);
                    }
                }
            });
        }
    }

    public final Object getRoot() {
        if (this.disposed || !this.isValidThread()) {
            return null;
        }
        if (!this.root.isValid()) {
            Node newRoot = this.getValidRoot();
            this.root.set(newRoot);
            LOG.debug("root updated: ", new Object[]{newRoot});
        }
        return this.root.get();
    }

    private Node getNode(Object object) {
        if (this.disposed || !(object instanceof Node) || !this.isValidThread()) {
            return null;
        }
        Node node = (Node)object;
        if (this.isNodeRemoved(node)) {
            return null;
        }
        if (!node.children.isValid()) {
            List<Node> newChildren = this.getValidChildren(node);
            List<Node> oldChildren = node.children.set(newChildren);
            if (oldChildren != null) {
                oldChildren.forEach(child -> child.setParent(null));
            }
            if (newChildren != null) {
                newChildren.forEach(child -> child.setParent(node));
            }
            LOG.debug("children updated: ", new Object[]{node});
        }
        return node;
    }

    private boolean isNodeRemoved(Node node) {
        return !node.isNodeAncestor(this.root.get());
    }

    @Override
    public final List<TreeNode> getChildren(Object object) {
        List list2;
        Node node = this.getNode(object);
        List list3 = list2 = node == null ? null : (List)node.children.get();
        if (list2 == null || list2.isEmpty()) {
            return Collections.emptyList();
        }
        list2.forEach(rec$ -> ((Node)rec$).update());
        return Collections.unmodifiableList(list2);
    }

    public final int getChildCount(Object object) {
        Node node = this.getNode(object);
        return node == null ? 0 : node.getChildCount();
    }

    public final Object getChild(Object object, int index) {
        Node node = this.getNode(object);
        return node == null ? null : node.getChildAt(index);
    }

    public final boolean isLeaf(Object object) {
        Node node = this.getNode(object);
        return node == null || node.isLeaf();
    }

    public final int getIndexOfChild(Object object, Object child) {
        return object instanceof Node ? ((Node)object).getIndexOfChild(child) : -1;
    }

    public void valueForPathChanged(TreePath path, Object value) {
    }

    private boolean isValid(Object element) {
        AbstractTreeNode node;
        AbstractTreeStructure structure = this.structure;
        if (structure == null) {
            return false;
        }
        if (element == null) {
            return false;
        }
        if (element instanceof AbstractTreeNode && null == (node = (AbstractTreeNode)element).getValue()) {
            return false;
        }
        if (element instanceof ValidateableNode && !(node = (ValidateableNode)element).isValid()) {
            return false;
        }
        return structure.isValid(element);
    }

    private Node getValidRoot() {
        AbstractTreeStructure structure = this.structure;
        if (structure == null) {
            return null;
        }
        Object element = structure.getRootElement();
        if (!this.isValid(element)) {
            return null;
        }
        Node newNode = new Node(structure, element, null);
        Node oldNode = this.root.get();
        if (oldNode != null && oldNode.canReuse(newNode, element)) {
            return oldNode;
        }
        return newNode;
    }

    private List<Node> getValidChildren(@NotNull Node node) {
        AbstractTreeStructure structure;
        if (node == null) {
            StructureTreeModel.$$$reportNull$$$0(2);
        }
        if ((structure = this.structure) == null) {
            return null;
        }
        NodeDescriptor descriptor2 = node.getDescriptor();
        if (descriptor2 == null) {
            return null;
        }
        Object parent = descriptor2.getElement();
        if (parent == null) {
            return null;
        }
        Object[] elements = structure.getChildElements(parent);
        if (elements == null || elements.length == 0) {
            return null;
        }
        ArrayList<Node> list2 = new ArrayList<Node>(elements.length);
        for (Object element : elements) {
            if (!this.isValid(element)) continue;
            list2.add(new Node(structure, element, descriptor2));
        }
        Comparator<Node> comparator2 = this.comparator;
        if (comparator2 != null) {
            list2.sort(comparator2);
        }
        HashMap map2 = new HashMap();
        node.getChildren().forEach(child -> {
            Object element = ((Node)child).getElement();
            if (element != null) {
                map2.put(element, child);
            }
        });
        for (int i = 0; i < list2.size(); ++i) {
            Node newNode = (Node)list2.get(i);
            Node oldNode = (Node)map2.get(newNode.getElement());
            if (oldNode == null || !oldNode.canReuse(newNode, null)) continue;
            list2.set(i, oldNode);
        }
        return list2;
    }

    @Deprecated
    public final Object getRootImmediately() {
        if (!this.root.isValid()) {
            this.root.set(this.getValidRoot());
        }
        return this.root.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tree/StructureTreeModel";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvoker";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tree/StructureTreeModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "invalidate";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getValidChildren";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invalidate$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Node
    extends DefaultMutableTreeNode {
        private final Reference<List<Node>> children;

        private Node(@NotNull AbstractTreeStructure structure, Object element, NodeDescriptor parent) {
            if (structure == null) {
                Node.$$$reportNull$$$0(0);
            }
            super(structure.createDescriptor(element, parent), !structure.isAlwaysLeaf(element));
            this.children = new Reference();
            if (!this.getAllowsChildren()) {
                this.children.set(null);
            }
            this.update();
        }

        private void dispose() {
            this.setParent(null);
            List list2 = this.children.set(null);
            if (list2 != null) {
                list2.forEach(Node::dispose);
            }
        }

        private boolean canReuse(@NotNull Node node, Object element) {
            if (node == null) {
                Node.$$$reportNull$$$0(1);
            }
            if (this.allowsChildren != node.allowsChildren) {
                return false;
            }
            if (element != null && !element.equals(this.getElement())) {
                return false;
            }
            this.userObject = node.userObject;
            return true;
        }

        private boolean update() {
            NodeDescriptor descriptor2 = this.getDescriptor();
            return descriptor2 != null && descriptor2.update();
        }

        private void invalidate() {
            if (this.getAllowsChildren()) {
                this.children.invalidate();
                LOG.debug("node invalidated: ", new Object[]{this});
                this.getChildren().forEach(Node::invalidate);
            }
        }

        @NotNull
        private List<Node> getChildren() {
            List<Node> list2 = this.children.get();
            List<Node> list3 = list2 != null ? list2 : Collections.emptyList();
            if (list3 == null) {
                Node.$$$reportNull$$$0(2);
            }
            return list3;
        }

        private NodeDescriptor getDescriptor() {
            Object object = this.getUserObject();
            return object instanceof NodeDescriptor ? (NodeDescriptor)object : null;
        }

        private Object getElement() {
            NodeDescriptor descriptor2 = this.getDescriptor();
            return descriptor2 == null ? null : descriptor2.getElement();
        }

        @Override
        public void setUserObject(Object object) {
            throw new UnsupportedOperationException("cannot modify node");
        }

        @Override
        public void setAllowsChildren(boolean value) {
            throw new UnsupportedOperationException("cannot modify node");
        }

        @Override
        public Object clone() {
            throw new UnsupportedOperationException("cannot clone node");
        }

        @Override
        public void insert(MutableTreeNode child, int index) {
            throw new UnsupportedOperationException("cannot insert node");
        }

        @Override
        public void remove(int index) {
            throw new UnsupportedOperationException("cannot remove node");
        }

        public Enumeration children() {
            return Collections.enumeration(this.getChildren());
        }

        @Override
        public TreeNode getChildAt(int index) {
            List<Node> list2 = this.getChildren();
            return 0 <= index && index < list2.size() ? (TreeNode)list2.get(index) : null;
        }

        @Override
        public int getChildCount() {
            return this.getChildren().size();
        }

        @Override
        public boolean isLeaf() {
            return this.getParent() != null && this.children.isValid() && super.isLeaf();
        }

        @Override
        public int getIndex(TreeNode child) {
            return this.getIndexOfChild(child);
        }

        private int getIndexOfChild(Object child) {
            return child instanceof Node && this.isNodeChild((Node)child) ? this.getChildren().indexOf(child) : -1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "structure";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tree/StructureTreeModel$Node";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tree/StructureTreeModel$Node";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "canReuse";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

