/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.deployment;

import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.impl.runtime.ServerConnectionImpl;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeploymentImpl<D extends DeploymentConfiguration>
implements Deployment {
    private final ServerConnectionImpl<D> myConnection;
    private final String myName;
    private final DeploymentTask<D> myDeploymentTask;
    private volatile DeploymentState myState;
    private String myPresentableName;

    public DeploymentImpl(@NotNull ServerConnectionImpl<D> connection, @NotNull String name, @NotNull DeploymentStatus status, @Nullable String statusText, @Nullable DeploymentRuntime runtime, @Nullable DeploymentTask<D> deploymentTask) {
        if (connection == null) {
            DeploymentImpl.$$$reportNull$$$0(0);
        }
        if (name == null) {
            DeploymentImpl.$$$reportNull$$$0(1);
        }
        if (status == null) {
            DeploymentImpl.$$$reportNull$$$0(2);
        }
        this.myConnection = connection;
        this.myName = name;
        this.myDeploymentTask = deploymentTask;
        this.myState = new DeploymentState(status, statusText, runtime);
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            DeploymentImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public DeploymentStatus getStatus() {
        DeploymentStatus deploymentStatus = this.myState.getStatus();
        if (deploymentStatus == null) {
            DeploymentImpl.$$$reportNull$$$0(4);
        }
        return deploymentStatus;
    }

    @NotNull
    public String getStatusText() {
        String statusText = this.myState.getStatusText();
        String string = statusText != null ? statusText : this.myState.getStatus().getPresentableText();
        if (string == null) {
            DeploymentImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    public DeploymentRuntime getRuntime() {
        return this.myState.getRuntime();
    }

    @Nullable
    public DeploymentTask<D> getDeploymentTask() {
        return this.myDeploymentTask;
    }

    @NotNull
    public DeploymentLogManager getOrCreateLogManager(@NotNull Project project) {
        if (project == null) {
            DeploymentImpl.$$$reportNull$$$0(6);
        }
        DeploymentLogManager deploymentLogManager = this.myConnection.getOrCreateLogManager(project, this);
        if (deploymentLogManager == null) {
            DeploymentImpl.$$$reportNull$$$0(7);
        }
        return deploymentLogManager;
    }

    public void setStatus(@NotNull DeploymentStatus status, @Nullable String statusText) {
        if (status == null) {
            DeploymentImpl.$$$reportNull$$$0(8);
        }
        this.myConnection.changeDeploymentState(this, this.getRuntime(), this.myState.getStatus(), status, statusText);
    }

    @NotNull
    public ServerConnection<?> getConnection() {
        ServerConnectionImpl<D> serverConnectionImpl = this.myConnection;
        if (serverConnectionImpl == null) {
            DeploymentImpl.$$$reportNull$$$0(9);
        }
        return serverConnectionImpl;
    }

    @Nullable
    public DeploymentRuntime getParentRuntime() {
        DeploymentRuntime runtime = this.getRuntime();
        return runtime == null ? null : runtime.getParent();
    }

    public boolean changeState(@NotNull DeploymentStatus oldStatus, @NotNull DeploymentStatus newStatus, @Nullable String statusText, @Nullable DeploymentRuntime runtime) {
        if (oldStatus == null) {
            DeploymentImpl.$$$reportNull$$$0(10);
        }
        if (newStatus == null) {
            DeploymentImpl.$$$reportNull$$$0(11);
        }
        if (this.myState.getStatus() == oldStatus) {
            this.myState = new DeploymentState(newStatus, statusText, runtime);
            return true;
        }
        return false;
    }

    @NotNull
    public String getPresentableName() {
        String string = this.myPresentableName == null ? this.getName() : this.myPresentableName;
        if (string == null) {
            DeploymentImpl.$$$reportNull$$$0(12);
        }
        return string;
    }

    public void setPresentableName(String presentableName) {
        this.myPresentableName = presentableName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldStatus";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateLogManager";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnection";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateLogManager";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setStatus";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "changeState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class DeploymentState {
        private final DeploymentStatus myStatus;
        private final String myStatusText;
        private final DeploymentRuntime myRuntime;

        private DeploymentState(@NotNull DeploymentStatus status, @Nullable String statusText, @Nullable DeploymentRuntime runtime) {
            if (status == null) {
                DeploymentState.$$$reportNull$$$0(0);
            }
            this.myStatus = status;
            this.myStatusText = statusText;
            this.myRuntime = runtime;
        }

        @NotNull
        public DeploymentStatus getStatus() {
            DeploymentStatus deploymentStatus = this.myStatus;
            if (deploymentStatus == null) {
                DeploymentState.$$$reportNull$$$0(1);
            }
            return deploymentStatus;
        }

        @Nullable
        public String getStatusText() {
            return this.myStatusText;
        }

        @Nullable
        public DeploymentRuntime getRuntime() {
            return this.myRuntime;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "status";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl$DeploymentState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl$DeploymentState";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatus";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

