/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduce.inplace;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class OccurrencesChooser<T> {
    public static final String DEFAULT_CHOOSER_TITLE = "Multiple occurrences found";
    private final Set<RangeHighlighter> myRangeHighlighters = new HashSet<RangeHighlighter>();
    private final Editor myEditor;
    private final TextAttributes myAttributes;

    public static <T extends PsiElement> OccurrencesChooser<T> simpleChooser(Editor editor) {
        return new OccurrencesChooser<T>(editor){

            @Override
            protected TextRange getOccurrenceRange(T occurrence) {
                return occurrence.getTextRange();
            }
        };
    }

    public OccurrencesChooser(Editor editor) {
        this.myEditor = editor;
        this.myAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
    }

    public void showChooser(T selectedOccurrence, List<T> allOccurrences, Pass<ReplaceChoice> callback) {
        if (allOccurrences.size() == 1) {
            callback.pass((Object)ReplaceChoice.ALL);
        } else {
            LinkedHashMap occurrencesMap = ContainerUtil.newLinkedHashMap();
            occurrencesMap.put(ReplaceChoice.NO, Collections.singletonList(selectedOccurrence));
            occurrencesMap.put(ReplaceChoice.ALL, allOccurrences);
            this.showChooser(callback, occurrencesMap);
        }
    }

    public void showChooser(Pass<ReplaceChoice> callback, Map<ReplaceChoice, List<T>> occurrencesMap) {
        this.showChooser(callback, occurrencesMap, DEFAULT_CHOOSER_TITLE);
    }

    public <C extends BaseReplaceChoice> void showChooser(Pass<C> callback, final Map<C, List<T>> occurrencesMap, String title) {
        if (occurrencesMap.size() == 1) {
            callback.pass(occurrencesMap.keySet().iterator().next());
            return;
        }
        DefaultListModel<BaseReplaceChoice> model = new DefaultListModel<BaseReplaceChoice>();
        for (BaseReplaceChoice choice : occurrencesMap.keySet()) {
            model.addElement(choice);
        }
        JBList list2 = new JBList(model);
        list2.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component rendererComponent = super.getListCellRendererComponent((JList<?>)list2, value, index, isSelected, cellHasFocus);
                BaseReplaceChoice choices = (BaseReplaceChoice)value;
                if (choices != null) {
                    this.setText(choices.formatDescription(((List)occurrencesMap.get(choices)).size()));
                }
                return rendererComponent;
            }
        });
        list2.addListSelectionListener(new ListSelectionListener((JList)list2, occurrencesMap){
            final /* synthetic */ JList val$list;
            final /* synthetic */ Map val$occurrencesMap;
            {
                this.val$list = jList;
                this.val$occurrencesMap = map2;
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                BaseReplaceChoice value = (BaseReplaceChoice)this.val$list.getSelectedValue();
                if (value == null) {
                    return;
                }
                OccurrencesChooser.this.dropHighlighters();
                MarkupModel markupModel = OccurrencesChooser.this.myEditor.getMarkupModel();
                List occurrenceList = (List)this.val$occurrencesMap.get(value);
                for (Object occurrence : occurrenceList) {
                    TextRange textRange = OccurrencesChooser.this.getOccurrenceRange(occurrence);
                    RangeHighlighter rangeHighlighter = markupModel.addRangeHighlighter(textRange.getStartOffset(), textRange.getEndOffset(), 5999, OccurrencesChooser.this.myAttributes, HighlighterTargetArea.EXACT_RANGE);
                    OccurrencesChooser.this.myRangeHighlighters.add(rangeHighlighter);
                }
            }
        });
        JBPopupFactory.getInstance().createListPopupBuilder((JList)list2).setTitle(title).setMovable(true).setResizable(false).setRequestFocus(true).setItemChoosenCallback(() -> OccurrencesChooser.lambda$showChooser$0(callback, (JList)list2)).addListener((JBPopupListener)new JBPopupAdapter(){

            public void onClosed(LightweightWindowEvent event) {
                OccurrencesChooser.this.dropHighlighters();
            }
        }).createPopup().showInBestPositionFor(this.myEditor);
    }

    protected abstract TextRange getOccurrenceRange(T var1);

    private void dropHighlighters() {
        for (RangeHighlighter highlight : this.myRangeHighlighters) {
            highlight.dispose();
        }
        this.myRangeHighlighters.clear();
    }

    private static /* synthetic */ void lambda$showChooser$0(Pass callback, JList list2) {
        callback.pass(list2.getSelectedValue());
    }

    public static enum ReplaceChoice implements BaseReplaceChoice
    {
        NO("Replace this occurrence only"),
        NO_WRITE("Replace all occurrences but write"),
        ALL("Replace all {0} occurrences");

        private final String myDescription;

        private ReplaceChoice(String description) {
            this.myDescription = description;
        }

        public String getDescription() {
            return this.myDescription;
        }

        @Override
        public boolean isMultiple() {
            return this == NO_WRITE || this == ALL;
        }

        @Override
        public boolean isAll() {
            return this == ALL;
        }

        @Override
        public String formatDescription(int occurrencesCount) {
            return MessageFormat.format(this.getDescription(), occurrencesCount);
        }
    }

    public static interface BaseReplaceChoice {
        public boolean isMultiple();

        public boolean isAll();

        public String formatDescription(int var1);
    }
}

