/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.CommitLegendPanel;
import com.intellij.util.Processor;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ChangeInfoCalculator
implements CommitLegendPanel.InfoCalculator {
    @NotNull
    private List<Change> myDisplayedChanges = Collections.emptyList();
    @NotNull
    private List<Change> myIncludedChanges = Collections.emptyList();
    private int myUnversionedFilesCount = 0;
    private int myIncludedUnversionedFilesCount = 0;
    private static final Processor<Change> MODIFIED_FILTER = item -> item.getType() == Change.Type.MODIFICATION || item.getType() == Change.Type.MOVED;
    private static final Processor<Change> NEW_FILTER = item -> item.getType() == Change.Type.NEW;
    private static final Processor<Change> DELETED_FILTER = item -> item.getType() == Change.Type.DELETED;

    public void update(@NotNull List<Change> displayedChanges, @NotNull List<Change> includedChanges) {
        if (displayedChanges == null) {
            ChangeInfoCalculator.$$$reportNull$$$0(0);
        }
        if (includedChanges == null) {
            ChangeInfoCalculator.$$$reportNull$$$0(1);
        }
        this.update(displayedChanges, includedChanges, 0, 0);
    }

    public void update(@NotNull List<Change> displayedChanges, @NotNull List<Change> includedChanges, int unversionedFilesCount, int includedUnversionedFilesCount) {
        if (displayedChanges == null) {
            ChangeInfoCalculator.$$$reportNull$$$0(2);
        }
        if (includedChanges == null) {
            ChangeInfoCalculator.$$$reportNull$$$0(3);
        }
        this.myDisplayedChanges = displayedChanges;
        this.myIncludedChanges = includedChanges;
        this.myUnversionedFilesCount = unversionedFilesCount;
        this.myIncludedUnversionedFilesCount = includedUnversionedFilesCount;
    }

    @Override
    public int getNew() {
        return ChangeInfoCalculator.countMatchingItems(this.myDisplayedChanges, NEW_FILTER);
    }

    @Override
    public int getModified() {
        return ChangeInfoCalculator.countMatchingItems(this.myDisplayedChanges, MODIFIED_FILTER);
    }

    @Override
    public int getDeleted() {
        return ChangeInfoCalculator.countMatchingItems(this.myDisplayedChanges, DELETED_FILTER);
    }

    @Override
    public int getUnversioned() {
        return this.myUnversionedFilesCount;
    }

    @Override
    public int getIncludedNew() {
        return ChangeInfoCalculator.countMatchingItems(this.myIncludedChanges, NEW_FILTER);
    }

    @Override
    public int getIncludedModified() {
        return ChangeInfoCalculator.countMatchingItems(this.myIncludedChanges, MODIFIED_FILTER);
    }

    @Override
    public int getIncludedDeleted() {
        return ChangeInfoCalculator.countMatchingItems(this.myIncludedChanges, DELETED_FILTER);
    }

    @Override
    public int getIncludedUnversioned() {
        return this.myIncludedUnversionedFilesCount;
    }

    private static <T> int countMatchingItems(@NotNull List<T> items, @NotNull Processor<T> filter2) {
        if (items == null) {
            ChangeInfoCalculator.$$$reportNull$$$0(4);
        }
        if (filter2 == null) {
            ChangeInfoCalculator.$$$reportNull$$$0(5);
        }
        int count = 0;
        for (T item : items) {
            if (!filter2.process(item)) continue;
            ++count;
        }
        return count;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayedChanges";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includedChanges";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangeInfoCalculator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "countMatchingItems";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

