/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.diff.util.DiffUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.ChangesViewI;
import com.intellij.openapi.vcs.changes.DnDActivateOnHoldTargetContent;
import com.intellij.openapi.vcs.changes.PreviewDiffSplitterComponent;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.actions.IgnoredSettingsAction;
import com.intellij.openapi.vcs.changes.actions.ShowDiffPreviewAction;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesDnDSupport;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.ShelvedChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="ChangesViewManager", storages={@Storage(file="$WORKSPACE_FILE$")})
public class ChangesViewManager
implements ChangesViewI,
ProjectComponent,
PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.ChangesViewManager");
    private static final String CHANGES_VIEW_PREVIEW_SPLITTER_PROPORTION = "ChangesViewManager.DETAILS_SPLITTER_PROPORTION";
    @NotNull
    private final ChangesListView myView;
    private JPanel myProgressLabel;
    private final Alarm myRepaintAlarm;
    private boolean myDisposed;
    @NotNull
    private final ChangeListListener myListener;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ChangesViewContentManager myContentManager;
    @NotNull
    private State myState;
    private PreviewDiffSplitterComponent mySplitterComponent;
    @NotNull
    private final TreeSelectionListener myTsl;
    private MyChangeViewContent myContent;

    @NotNull
    public static ChangesViewI getInstance(@NotNull Project project) {
        if (project == null) {
            ChangesViewManager.$$$reportNull$$$0(0);
        }
        ChangesViewI changesViewI = (ChangesViewI)PeriodicalTasksCloser.getInstance().safeGetComponent(project, ChangesViewI.class);
        if (changesViewI == null) {
            ChangesViewManager.$$$reportNull$$$0(1);
        }
        return changesViewI;
    }

    public ChangesViewManager(@NotNull Project project, @NotNull ChangesViewContentManager contentManager) {
        if (project == null) {
            ChangesViewManager.$$$reportNull$$$0(2);
        }
        if (contentManager == null) {
            ChangesViewManager.$$$reportNull$$$0(3);
        }
        this.myDisposed = false;
        this.myListener = new MyChangeListListener();
        this.myState = new State();
        this.myProject = project;
        this.myContentManager = contentManager;
        this.myView = new ChangesListView(project);
        this.myRepaintAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)project);
        this.myTsl = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (LOG.isDebugEnabled()) {
                    Object[] paths = ChangesViewManager.this.myView.getSelectionPaths();
                    String joinedPaths = paths != null ? StringUtil.join((Object[])paths, (Function)FunctionUtil.string(), (String)", ") : null;
                    String message = "selection changed. selected:  " + joinedPaths;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace(message + " from: " + DebugUtil.currentStackTrace());
                    } else {
                        LOG.debug(message);
                    }
                }
                ApplicationManager.getApplication().invokeLater(() -> ChangesViewManager.this.updatePreview());
            }
        };
    }

    public void projectOpened() {
        final ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        changeListManager.addChangeListListener(this.myListener);
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

            public void dispose() {
                changeListManager.removeChangeListListener(ChangesViewManager.this.myListener);
            }
        });
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        this.myContent = new MyChangeViewContent(this.createChangeViewComponent(), "Local Changes", false);
        this.myContent.setCloseable(false);
        this.myContentManager.addContent(this.myContent);
        this.scheduleRefresh();
        this.myProject.getMessageBus().connect().subscribe(RemoteRevisionsCache.REMOTE_VERSION_CHANGED, () -> ApplicationManager.getApplication().invokeLater(() -> this.refreshView(), ModalityState.NON_MODAL, this.myProject.getDisposed()));
        this.updatePreview();
    }

    public void projectClosed() {
        this.myView.removeTreeSelectionListener(this.myTsl);
        this.myDisposed = true;
        this.myRepaintAlarm.cancelAllRequests();
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("ChangesViewManager" == null) {
            ChangesViewManager.$$$reportNull$$$0(4);
        }
        return "ChangesViewManager";
    }

    private JComponent createChangeViewComponent() {
        SimpleToolWindowPanel panel2 = new SimpleToolWindowPanel(false, true);
        EmptyAction.registerWithShortcutSet((String)"ChangesView.Refresh", (ShortcutSet)CommonShortcuts.getRerun(), (JComponent)panel2);
        EmptyAction.registerWithShortcutSet((String)"ChangesView.NewChangeList", (ShortcutSet)CommonShortcuts.getNew(), (JComponent)panel2);
        EmptyAction.registerWithShortcutSet((String)"ChangesView.RemoveChangeList", (ShortcutSet)CommonShortcuts.getDelete(), (JComponent)panel2);
        EmptyAction.registerWithShortcutSet((String)"ChangesView.Move", (ShortcutSet)CommonShortcuts.getMove(), (JComponent)panel2);
        EmptyAction.registerWithShortcutSet((String)"ChangesView.Rename", (ShortcutSet)CommonShortcuts.getRename(), (JComponent)panel2);
        EmptyAction.registerWithShortcutSet((String)"ChangesView.SetDefault", (ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(85, 0x200 | ChangesViewManager.ctrlMask())), (JComponent)panel2);
        EmptyAction.registerWithShortcutSet((String)"Diff.ShowDiff", (ShortcutSet)CommonShortcuts.getDiff(), (JComponent)panel2);
        DefaultActionGroup group = (DefaultActionGroup)ActionManager.getInstance().getAction("ChangesViewToolbar");
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ChangesViewToolbar", (ActionGroup)group, false);
        toolbar.setTargetComponent((JComponent)((Object)this.myView));
        JComponent toolbarComponent = toolbar.getComponent();
        JPanel toolbarPanel = new JPanel(new BorderLayout());
        toolbarPanel.add((Component)toolbarComponent, "West");
        DefaultActionGroup visualActionsGroup = new DefaultActionGroup();
        Expander expander = new Expander();
        visualActionsGroup.add(CommonActionsManager.getInstance().createExpandAllAction((TreeExpander)expander, (JComponent)panel2));
        visualActionsGroup.add(CommonActionsManager.getInstance().createCollapseAllAction((TreeExpander)expander, (JComponent)panel2));
        ToggleShowFlattenAction showFlattenAction = new ToggleShowFlattenAction();
        showFlattenAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(80, ChangesViewManager.ctrlMask())), (JComponent)panel2);
        visualActionsGroup.add((AnAction)showFlattenAction);
        visualActionsGroup.add(ActionManager.getInstance().getAction("$Copy"));
        visualActionsGroup.add((AnAction)new ToggleShowIgnoredAction());
        visualActionsGroup.add((AnAction)new IgnoredSettingsAction());
        visualActionsGroup.add((AnAction)new ToggleDetailsAction());
        visualActionsGroup.add((AnAction)new ContextHelpAction("ideaInterface.changes"));
        toolbarPanel.add((Component)ActionManager.getInstance().createActionToolbar("ChangesViewToolbar", (ActionGroup)visualActionsGroup, false).getComponent(), "Center");
        this.myView.setMenuActions((ActionGroup)((DefaultActionGroup)ActionManager.getInstance().getAction("ChangesViewPopupMenu")));
        this.myView.setShowFlatten(this.myState.myShowFlatten);
        this.myProgressLabel = new JPanel(new BorderLayout());
        panel2.setToolbar((JComponent)toolbarPanel);
        JPanel content = new JPanel(new BorderLayout());
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myView));
        JPanel wrapper2 = new JPanel(new BorderLayout());
        wrapper2.add((Component)scrollPane, "Center");
        MyChangeProcessor changeProcessor = new MyChangeProcessor(this.myProject);
        this.mySplitterComponent = new PreviewDiffSplitterComponent(wrapper2, changeProcessor, CHANGES_VIEW_PREVIEW_SPLITTER_PROPORTION, VcsConfiguration.getInstance((Project)this.myProject).LOCAL_CHANGES_DETAILS_PREVIEW_SHOWN);
        content.add((Component)((Object)this.mySplitterComponent), "Center");
        content.add((Component)this.myProgressLabel, "South");
        panel2.setContent((JComponent)content);
        ChangesDnDSupport.install(this.myProject, this.myView);
        this.myView.addTreeSelectionListener(this.myTsl);
        return panel2;
    }

    @JdkConstants.InputEventMask
    private static int ctrlMask() {
        return SystemInfo.isMac ? 256 : 128;
    }

    private void updateProgressComponent(@NotNull Factory<JComponent> progress) {
        if (progress == null) {
            ChangesViewManager.$$$reportNull$$$0(5);
        }
        SwingUtilities.invokeLater(() -> {
            if (progress == null) {
                ChangesViewManager.$$$reportNull$$$0(14);
            }
            if (this.myProgressLabel != null) {
                this.myProgressLabel.removeAll();
                this.myProgressLabel.add((Component)progress.create());
                this.myProgressLabel.setMinimumSize((Dimension)JBUI.emptySize());
            }
        });
    }

    @Override
    public void updateProgressText(String text, boolean isError) {
        this.updateProgressComponent(ChangesViewManager.createTextStatusFactory(text, isError));
    }

    @Override
    public void setBusy(boolean b) {
        UIUtil.invokeLaterIfNeeded(() -> this.myView.setPaintBusy(b));
    }

    @NotNull
    public static Factory<JComponent> createTextStatusFactory(String text, boolean isError) {
        Factory factory = () -> {
            JLabel label = new JLabel(text);
            label.setForeground((Color)(isError ? JBColor.RED : UIUtil.getLabelForeground()));
            return label;
        };
        if (factory == null) {
            ChangesViewManager.$$$reportNull$$$0(6);
        }
        return factory;
    }

    @Override
    public void scheduleRefresh() {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        int was = this.myRepaintAlarm.cancelAllRequests();
        if (LOG.isDebugEnabled()) {
            LOG.debug("schedule refresh, was " + was);
        }
        if (!this.myRepaintAlarm.isDisposed()) {
            this.myRepaintAlarm.addRequest(() -> this.refreshView(), 100, ModalityState.NON_MODAL);
        }
    }

    private void refreshView() {
        if (this.myDisposed || !this.myProject.isInitialized() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (!ProjectLevelVcsManager.getInstance((Project)this.myProject).hasActiveVcss()) {
            return;
        }
        ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(this.myProject);
        TreeModelBuilder treeModelBuilder = new TreeModelBuilder(this.myProject, this.myView.isShowFlatten()).setChangeLists(changeListManager.getChangeListsCopy()).setLocallyDeletedPaths(changeListManager.getDeletedFiles()).setModifiedWithoutEditing(changeListManager.getModifiedWithoutEditing()).setSwitchedFiles(changeListManager.getSwitchedFilesMap()).setSwitchedRoots(changeListManager.getSwitchedRoots()).setLockedFolders(changeListManager.getLockedFolders()).setLogicallyLockedFiles(changeListManager.getLogicallyLockedFolders()).setUnversioned(changeListManager.getUnversionedFiles());
        if (this.myState.myShowIgnored) {
            treeModelBuilder.setIgnored(changeListManager.getIgnoredFiles(), changeListManager.isIgnoredInUpdateMode());
        }
        this.myView.updateModel(treeModelBuilder.build());
        this.updatePreview();
    }

    private void updatePreview() {
        if (this.mySplitterComponent != null) {
            this.mySplitterComponent.updatePreview();
        }
    }

    @NotNull
    public State getState() {
        State state2 = this.myState;
        if (state2 == null) {
            ChangesViewManager.$$$reportNull$$$0(7);
        }
        return state2;
    }

    public void loadState(@NotNull State state2) {
        if (state2 == null) {
            ChangesViewManager.$$$reportNull$$$0(8);
        }
        this.myState = state2;
    }

    @Override
    public void setShowFlattenMode(boolean state2) {
        this.myState.myShowFlatten = state2;
        this.myView.setShowFlatten(state2);
        this.refreshView();
    }

    @Override
    public void selectFile(@Nullable VirtualFile vFile) {
        if (vFile == null) {
            return;
        }
        Change change = ChangeListManager.getInstance((Project)this.myProject).getChange(vFile);
        Change objectToFind = change != null ? change : vFile;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myView.getModel().getRoot();
        DefaultMutableTreeNode node = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)root, (Object)objectToFind);
        if (node != null) {
            TreeUtil.selectNode((JTree)((Object)this.myView), (TreeNode)node);
        }
    }

    @Override
    public void refreshChangesViewNodeAsync(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ChangesViewManager.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (file2 == null) {
                ChangesViewManager.$$$reportNull$$$0(13);
            }
            this.refreshChangesViewNode(file2);
        }, this.myProject.getDisposed());
    }

    private void refreshChangesViewNode(@NotNull VirtualFile file2) {
        DefaultMutableTreeNode root;
        DefaultMutableTreeNode node;
        ChangeListManager changeListManager;
        VirtualFile userObject;
        if (file2 == null) {
            ChangesViewManager.$$$reportNull$$$0(10);
        }
        Object object = userObject = (changeListManager = ChangeListManager.getInstance((Project)this.myProject)).isUnversioned(file2) ? file2 : changeListManager.getChange(file2);
        if (userObject != null && (node = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)(root = (DefaultMutableTreeNode)this.myView.getModel().getRoot()), (Object)userObject)) != null) {
            this.myView.getModel().nodeChanged(node);
        }
    }

    @Nullable
    public static ChangesBrowserNode getDropRootNode(@NotNull Tree tree, @NotNull DnDEvent event) {
        if (tree == null) {
            ChangesViewManager.$$$reportNull$$$0(11);
        }
        if (event == null) {
            ChangesViewManager.$$$reportNull$$$0(12);
        }
        RelativePoint dropPoint = event.getRelativePoint();
        Point onTree = dropPoint.getPoint((Component)tree);
        TreePath dropPath = tree.getPathForLocation(onTree.x, onTree.y);
        if (dropPath == null) {
            return null;
        }
        ChangesBrowserNode dropNode = (ChangesBrowserNode)dropPath.getLastPathComponent();
        while (!((ChangesBrowserNode)dropNode.getParent()).isRoot()) {
            dropNode = (ChangesBrowserNode)dropNode.getParent();
        }
        return dropNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangesViewManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentManager";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextStatusFactory";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateProgressComponent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "refreshChangesViewNodeAsync";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "refreshChangesViewNode";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDropRootNode";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$refreshChangesViewNodeAsync$6";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateProgressComponent$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyChangeViewContent
    extends DnDActivateOnHoldTargetContent {
        private MyChangeViewContent(JComponent component, String displayName, boolean isLockable) {
            super(ChangesViewManager.this.myProject, component, displayName, isLockable);
        }

        @Override
        public void drop(DnDEvent event) {
            super.drop(event);
            Object attachedObject = event.getAttachedObject();
            if (attachedObject instanceof ShelvedChangeListDragBean) {
                ShelveChangesManager.unshelveSilentlyWithDnd(ChangesViewManager.this.myProject, (ShelvedChangeListDragBean)attachedObject, ChangesViewManager.getDropRootNode(ChangesViewManager.this.myView, event));
            }
        }

        @Override
        public boolean isDropPossible(@NotNull DnDEvent event) {
            Object attachedObject;
            if (event == null) {
                MyChangeViewContent.$$$reportNull$$$0(0);
            }
            if ((attachedObject = event.getAttachedObject()) instanceof ShelvedChangeListDragBean) {
                return !((ShelvedChangeListDragBean)attachedObject).getShelvedChangelists().isEmpty();
            }
            return attachedObject instanceof ChangeListDragBean;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/changes/ChangesViewManager$MyChangeViewContent", "isDropPossible"));
        }
    }

    private class MyChangeProcessor
    extends ChangeViewDiffRequestProcessor {
        public MyChangeProcessor(Project project) {
            if (project == null) {
                MyChangeProcessor.$$$reportNull$$$0(0);
            }
            super(project, "ChangesView");
            Disposer.register((Disposable)project, (Disposable)this);
        }

        @Override
        public boolean isWindowFocused() {
            return DiffUtil.isFocusedComponent(ChangesViewManager.this.myProject, ChangesViewManager.this.myContent.getComponent());
        }

        @Override
        @NotNull
        protected List<ChangeViewDiffRequestProcessor.Wrapper> getSelectedChanges() {
            List<ChangeViewDiffRequestProcessor.Wrapper> result2 = this.wrap(ChangesViewManager.this.myView.getSelectedChanges(), ChangesViewManager.this.myView.getSelectedUnversionedFiles());
            if (result2.isEmpty()) {
                result2 = this.getAllChanges();
            }
            List<ChangeViewDiffRequestProcessor.Wrapper> list2 = result2;
            if (list2 == null) {
                MyChangeProcessor.$$$reportNull$$$0(1);
            }
            return list2;
        }

        @Override
        @NotNull
        protected List<ChangeViewDiffRequestProcessor.Wrapper> getAllChanges() {
            List<ChangeViewDiffRequestProcessor.Wrapper> list2 = this.wrap(ChangesViewManager.this.myView.getChanges(), ChangesViewManager.this.myView.getUnversionedFiles());
            if (list2 == null) {
                MyChangeProcessor.$$$reportNull$$$0(2);
            }
            return list2;
        }

        @Override
        protected void selectChange(@NotNull ChangeViewDiffRequestProcessor.Wrapper change) {
            DefaultMutableTreeNode root;
            DefaultMutableTreeNode node;
            if (change == null) {
                MyChangeProcessor.$$$reportNull$$$0(3);
            }
            if ((node = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)(root = (DefaultMutableTreeNode)ChangesViewManager.this.myView.getModel().getRoot()), (Object)change.getUserObject())) != null) {
                TreePath path = TreeUtil.getPathFromRoot((TreeNode)node);
                TreeUtil.selectPath((JTree)((Object)ChangesViewManager.this.myView), (TreePath)path, (boolean)false);
            }
        }

        @NotNull
        private List<ChangeViewDiffRequestProcessor.Wrapper> wrap(@NotNull Stream<Change> changes, @NotNull Stream<VirtualFile> unversioned) {
            if (changes == null) {
                MyChangeProcessor.$$$reportNull$$$0(4);
            }
            if (unversioned == null) {
                MyChangeProcessor.$$$reportNull$$$0(5);
            }
            List<ChangeViewDiffRequestProcessor.Wrapper> list2 = Stream.concat(changes.map(ChangeViewDiffRequestProcessor.ChangeWrapper::new), unversioned.map(ChangeViewDiffRequestProcessor.UnversionedFileWrapper::new)).collect(Collectors.toList());
            if (list2 == null) {
                MyChangeProcessor.$$$reportNull$$$0(6);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangesViewManager$MyChangeProcessor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unversioned";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager$MyChangeProcessor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelectedChanges";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllChanges";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "wrap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "selectChange";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "wrap";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class ToggleDetailsAction
    extends ShowDiffPreviewAction {
        private ToggleDetailsAction() {
        }

        public void setSelected(AnActionEvent e, boolean state2) {
            ChangesViewManager.this.mySplitterComponent.setDetailsOn(state2);
            VcsConfiguration.getInstance((Project)((ChangesViewManager)ChangesViewManager.this).myProject).LOCAL_CHANGES_DETAILS_PREVIEW_SHOWN = state2;
        }

        public boolean isSelected(AnActionEvent e) {
            return VcsConfiguration.getInstance((Project)((ChangesViewManager)ChangesViewManager.this).myProject).LOCAL_CHANGES_DETAILS_PREVIEW_SHOWN;
        }
    }

    private class ToggleShowIgnoredAction
    extends ToggleAction
    implements DumbAware {
        public ToggleShowIgnoredAction() {
            super(VcsBundle.message((String)"changes.action.show.ignored.text", (Object[])new Object[0]), VcsBundle.message((String)"changes.action.show.ignored.description", (Object[])new Object[0]), AllIcons.Actions.ShowHiddens);
        }

        public boolean isSelected(AnActionEvent e) {
            return ((ChangesViewManager)ChangesViewManager.this).myState.myShowIgnored;
        }

        public void setSelected(AnActionEvent e, boolean state2) {
            ((ChangesViewManager)ChangesViewManager.this).myState.myShowIgnored = state2;
            ChangesViewManager.this.refreshView();
        }
    }

    private class ToggleShowFlattenAction
    extends ToggleAction
    implements DumbAware {
        public ToggleShowFlattenAction() {
            super(VcsBundle.message((String)"changes.action.show.directories.text", (Object[])new Object[0]), VcsBundle.message((String)"changes.action.show.directories.description", (Object[])new Object[0]), AllIcons.Actions.GroupByPackage);
        }

        public boolean isSelected(AnActionEvent e) {
            return !((ChangesViewManager)ChangesViewManager.this).myState.myShowFlatten;
        }

        public void setSelected(AnActionEvent e, boolean state2) {
            ChangesViewManager.this.setShowFlattenMode(!state2);
        }
    }

    private class Expander
    implements TreeExpander {
        private Expander() {
        }

        public void expandAll() {
            TreeUtil.expandAll((JTree)((Object)ChangesViewManager.this.myView));
        }

        public boolean canExpand() {
            return true;
        }

        public void collapseAll() {
            TreeUtil.collapseAll((JTree)((Object)ChangesViewManager.this.myView), (int)2);
            TreeUtil.expand((JTree)((Object)ChangesViewManager.this.myView), (int)1);
        }

        public boolean canCollapse() {
            return true;
        }
    }

    private class MyChangeListListener
    extends ChangeListAdapter {
        private MyChangeListListener() {
        }

        public void changeListAdded(ChangeList list2) {
            ChangesViewManager.this.scheduleRefresh();
        }

        public void changeListRemoved(ChangeList list2) {
            ChangesViewManager.this.scheduleRefresh();
        }

        public void changeListRenamed(ChangeList list2, String oldName) {
            ChangesViewManager.this.scheduleRefresh();
        }

        public void changesMoved(Collection<Change> changes, ChangeList fromList, ChangeList toList) {
            ChangesViewManager.this.scheduleRefresh();
        }

        public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList) {
            ChangesViewManager.this.scheduleRefresh();
        }

        public void changeListUpdateDone() {
            ChangesViewManager.this.scheduleRefresh();
            ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(ChangesViewManager.this.myProject);
            VcsException updateException = changeListManager.getUpdateException();
            ChangesViewManager.this.setBusy(false);
            if (updateException == null) {
                Factory<JComponent> additionalUpdateInfo = changeListManager.getAdditionalUpdateInfo();
                if (additionalUpdateInfo != null) {
                    ChangesViewManager.this.updateProgressComponent((Factory<JComponent>)additionalUpdateInfo);
                } else {
                    ChangesViewManager.this.updateProgressText("", false);
                }
            } else {
                ChangesViewManager.this.updateProgressText(VcsBundle.message((String)"error.updating.changes", (Object[])new Object[]{updateException.getMessage()}), true);
            }
        }
    }

    public static class State {
        @Attribute(value="flattened_view")
        public boolean myShowFlatten = true;
        @Attribute(value="show_ignored")
        public boolean myShowIgnored;
    }
}

