/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.fileTypes.FileNameMatcherFactory;

public class IgnoredPatternSet {
    private final Set<String> myMasks = new LinkedHashSet<String>();
    private final FileTypeAssocTable<Boolean> myIgnorePatterns = new FileTypeAssocTable().copy();

    @NotNull
    Set<String> getIgnoreMasks() {
        Set<String> set2 = Collections.unmodifiableSet(this.myMasks);
        if (set2 == null) {
            IgnoredPatternSet.$$$reportNull$$$0(0);
        }
        return set2;
    }

    public void setIgnoreMasks(@NotNull String list2) {
        if (list2 == null) {
            IgnoredPatternSet.$$$reportNull$$$0(1);
        }
        this.clearPatterns();
        StringTokenizer tokenizer = new StringTokenizer(list2, ";");
        while (tokenizer.hasMoreTokens()) {
            String ignoredFile = tokenizer.nextToken();
            this.addIgnoreMask(ignoredFile);
        }
    }

    void addIgnoreMask(@NotNull String ignoredFile) {
        if (ignoredFile == null) {
            IgnoredPatternSet.$$$reportNull$$$0(2);
        }
        if (this.myIgnorePatterns.findAssociatedFileType(ignoredFile) == null) {
            this.myMasks.add(ignoredFile);
            this.myIgnorePatterns.addAssociation(FileNameMatcherFactory.getInstance().createMatcher(ignoredFile), Boolean.TRUE);
        }
    }

    public boolean isIgnored(@NotNull CharSequence fileName) {
        if (fileName == null) {
            IgnoredPatternSet.$$$reportNull$$$0(3);
        }
        if (this.myIgnorePatterns.findAssociatedFileType(fileName) == Boolean.TRUE) {
            return true;
        }
        return StringUtil.endsWith((CharSequence)fileName, (CharSequence)".__del__");
    }

    void clearPatterns() {
        this.myMasks.clear();
        this.myIgnorePatterns.removeAllAssociations(Boolean.TRUE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/impl/IgnoredPatternSet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoreMasks";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/IgnoredPatternSet";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setIgnoreMasks";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addIgnoreMask";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

