/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PreloadingActivity;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.io.storage.HeavyProcessLatch;
import java.util.concurrent.Executor;

public class Preloader
implements Disposable,
ApplicationComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.application.Preloader");
    private final Executor myExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"com.intellij.openapi.application.Preloader pool");
    private final ProgressIndicator myIndicator = new ProgressIndicatorBase();
    private final ProgressIndicator myWrappingIndicator = new AbstractProgressIndicatorBase(){

        @Override
        public void checkCanceled() {
            Preloader.checkHeavyProcessRunning();
            Preloader.this.myIndicator.checkCanceled();
        }

        @Override
        public boolean isCanceled() {
            return Preloader.this.myIndicator.isCanceled();
        }
    };

    private static void checkHeavyProcessRunning() {
        if (HeavyProcessLatch.INSTANCE.isRunning()) {
            TimeoutUtil.sleep((long)1L);
        }
    }

    public void initComponent() {
        if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        ProgressManager progressManager = ProgressManager.getInstance();
        for (PreloadingActivity activity : (PreloadingActivity[])PreloadingActivity.EP_NAME.getExtensions()) {
            this.myExecutor.execute(() -> {
                if (this.myIndicator.isCanceled()) {
                    return;
                }
                Preloader.checkHeavyProcessRunning();
                if (this.myIndicator.isCanceled()) {
                    return;
                }
                progressManager.runProcess(() -> {
                    try {
                        activity.preload(this.myWrappingIndicator);
                    }
                    catch (ProcessCanceledException processCanceledException) {
                        // empty catch block
                    }
                    LOG.info("Finished preloading " + activity);
                }, this.myIndicator);
            });
        }
    }

    public void dispose() {
        this.myIndicator.cancel();
    }
}

