/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics.ui;

import com.intellij.CommonBundle;
import com.intellij.featureStatistics.FeatureDescriptor;
import com.intellij.featureStatistics.FeatureStatisticsBundle;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.featureStatistics.ProductivityFeaturesRegistry;
import com.intellij.ide.util.TipUIUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class AdaptiveTipDialog
extends DialogWrapper {
    private static final int DEFAULT_WIDTH = 400;
    private static final int DEFAULT_HEIGHT = 200;
    private JEditorPane myBrowser;
    private final String[] myFeatures;
    private int myCurrentFeature;

    public AdaptiveTipDialog(Project project, String[] features) {
        super(project, false);
        this.myFeatures = features;
        this.myCurrentFeature = 0;
        this.setCancelButtonText(CommonBundle.getCloseButtonText());
        this.setTitle(FeatureStatisticsBundle.message((String)"feature.statistics.dialog.title", (Object[])new Object[0]));
        this.setModal(false);
        this.init();
        this.selectCurrentFeature();
    }

    private void selectCurrentFeature() {
        String id = this.myFeatures[this.myCurrentFeature];
        FeatureUsageTracker.getInstance().triggerFeatureShown(id);
        FeatureDescriptor feature = ProductivityFeaturesRegistry.getInstance().getFeatureDescriptor(id);
        TipUIUtil.openTipInBrowser(feature.getTipFileName(), this.myBrowser, feature.getProvider());
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        this.myBrowser = new JEditorPane("text/html", "");
        panel2.add(ScrollPaneFactory.createScrollPane((Component)this.myBrowser));
        panel2.setPreferredSize(new Dimension(400, 200));
        return panel2;
    }

    @NotNull
    protected Action[] createActions() {
        if (this.myFeatures.length == 1) {
            Action[] actionArray = new Action[]{this.getCancelAction()};
            if (actionArray == null) {
                AdaptiveTipDialog.$$$reportNull$$$0(0);
            }
            return actionArray;
        }
        Action[] actionArray = new Action[]{new PrevAction(), new NextAction(), this.getCancelAction()};
        if (actionArray == null) {
            AdaptiveTipDialog.$$$reportNull$$$0(1);
        }
        return actionArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/featureStatistics/ui/AdaptiveTipDialog", "createActions"));
    }

    private class PrevAction
    extends AbstractAction {
        public PrevAction() {
            super(FeatureStatisticsBundle.message((String)"feature.statistics.action.prev.tip", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AdaptiveTipDialog.this.myCurrentFeature--;
            if (AdaptiveTipDialog.this.myCurrentFeature < 0) {
                AdaptiveTipDialog.this.myCurrentFeature = AdaptiveTipDialog.this.myFeatures.length - 1;
            }
            AdaptiveTipDialog.this.selectCurrentFeature();
        }
    }

    private class NextAction
    extends AbstractAction {
        public NextAction() {
            super(FeatureStatisticsBundle.message((String)"feature.statistics.action.next.tip", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AdaptiveTipDialog.this.myCurrentFeature++;
            if (AdaptiveTipDialog.this.myCurrentFeature >= AdaptiveTipDialog.this.myFeatures.length) {
                AdaptiveTipDialog.this.myCurrentFeature = 0;
            }
            AdaptiveTipDialog.this.selectCurrentFeature();
        }
    }
}

