/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ByLine;
import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.ComparisonUtil;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ChunkOptimizer<T> {
    @NotNull
    protected final List<T> myData1;
    @NotNull
    protected final List<T> myData2;
    @NotNull
    private final FairDiffIterable myIterable;
    @NotNull
    protected final ProgressIndicator myIndicator;
    @NotNull
    private final List<Range> myRanges;

    public ChunkOptimizer(@NotNull List<T> data1, @NotNull List<T> data2, @NotNull FairDiffIterable iterable, @NotNull ProgressIndicator indicator) {
        if (data1 == null) {
            ChunkOptimizer.$$$reportNull$$$0(0);
        }
        if (data2 == null) {
            ChunkOptimizer.$$$reportNull$$$0(1);
        }
        if (iterable == null) {
            ChunkOptimizer.$$$reportNull$$$0(2);
        }
        if (indicator == null) {
            ChunkOptimizer.$$$reportNull$$$0(3);
        }
        this.myData1 = data1;
        this.myData2 = data2;
        this.myIterable = iterable;
        this.myIndicator = indicator;
        this.myRanges = new ArrayList<Range>();
    }

    @NotNull
    public FairDiffIterable build() {
        for (Range range : this.myIterable.iterateUnchanged()) {
            this.myRanges.add(range);
            this.processLastRanges();
        }
        FairDiffIterable fairDiffIterable = DiffIterableUtil.fair(DiffIterableUtil.createUnchanged(this.myRanges, this.myData1.size(), this.myData2.size()));
        if (fairDiffIterable == null) {
            ChunkOptimizer.$$$reportNull$$$0(4);
        }
        return fairDiffIterable;
    }

    private void processLastRanges() {
        if (this.myRanges.size() < 2) {
            return;
        }
        Range range1 = this.myRanges.get(this.myRanges.size() - 2);
        Range range2 = this.myRanges.get(this.myRanges.size() - 1);
        if (range1.end1 != range2.start1 && range1.end2 != range2.start2) {
            return;
        }
        int count1 = range1.end1 - range1.start1;
        int count2 = range2.end1 - range2.start1;
        int equalForward = TrimUtil.expandForward(this.myData1, this.myData2, range1.end1, range1.end2, range1.end1 + count2, range1.end2 + count2);
        int equalBackward = TrimUtil.expandBackward(this.myData1, this.myData2, range2.start1 - count1, range2.start2 - count1, range2.start1, range2.start2);
        if (equalForward == 0 && equalBackward == 0) {
            return;
        }
        if (equalForward == count2) {
            this.myRanges.remove(this.myRanges.size() - 1);
            this.myRanges.remove(this.myRanges.size() - 1);
            this.myRanges.add(new Range(range1.start1, range1.end1 + count2, range1.start2, range1.end2 + count2));
            this.processLastRanges();
            return;
        }
        if (equalBackward == count1) {
            this.myRanges.remove(this.myRanges.size() - 1);
            this.myRanges.remove(this.myRanges.size() - 1);
            this.myRanges.add(new Range(range2.start1 - count1, range2.end1, range2.start2 - count1, range2.end2));
            this.processLastRanges();
            return;
        }
        Side touchSide = Side.fromLeft((range1.end1 == range2.start1 ? 1 : 0) != 0);
        int shift = this.getShift(touchSide, equalForward, equalBackward, range1, range2);
        if (shift != 0) {
            this.myRanges.remove(this.myRanges.size() - 1);
            this.myRanges.remove(this.myRanges.size() - 1);
            this.myRanges.add(new Range(range1.start1, range1.end1 + shift, range1.start2, range1.end2 + shift));
            this.myRanges.add(new Range(range2.start1 + shift, range2.end1, range2.start2 + shift, range2.end2));
        }
    }

    protected abstract int getShift(@NotNull Side var1, int var2, int var3, @NotNull Range var4, @NotNull Range var5);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data2";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/comparison/ChunkOptimizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/comparison/ChunkOptimizer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class LineChunkOptimizer
    extends ChunkOptimizer<ByLine.Line> {
        public LineChunkOptimizer(@NotNull List<ByLine.Line> lines1, @NotNull List<ByLine.Line> lines2, @NotNull FairDiffIterable changes, @NotNull ProgressIndicator indicator) {
            if (lines1 == null) {
                LineChunkOptimizer.$$$reportNull$$$0(0);
            }
            if (lines2 == null) {
                LineChunkOptimizer.$$$reportNull$$$0(1);
            }
            if (changes == null) {
                LineChunkOptimizer.$$$reportNull$$$0(2);
            }
            if (indicator == null) {
                LineChunkOptimizer.$$$reportNull$$$0(3);
            }
            super(lines1, lines2, changes, indicator);
        }

        @Override
        protected int getShift(@NotNull Side touchSide, int equalForward, int equalBackward, @NotNull Range range1, @NotNull Range range2) {
            if (touchSide == null) {
                LineChunkOptimizer.$$$reportNull$$$0(4);
            }
            if (range1 == null) {
                LineChunkOptimizer.$$$reportNull$$$0(5);
            }
            if (range2 == null) {
                LineChunkOptimizer.$$$reportNull$$$0(6);
            }
            int threshold = ComparisonUtil.getUnimportantLineCharCount();
            Integer shift = this.getUnchangedBoundaryShift(touchSide, equalForward, equalBackward, range1, range2, 0);
            if (shift != null) {
                return shift;
            }
            shift = this.getChangedBoundaryShift(touchSide, equalForward, equalBackward, range1, range2, 0);
            if (shift != null) {
                return shift;
            }
            shift = this.getUnchangedBoundaryShift(touchSide, equalForward, equalBackward, range1, range2, threshold);
            if (shift != null) {
                return shift;
            }
            shift = this.getChangedBoundaryShift(touchSide, equalForward, equalBackward, range1, range2, threshold);
            if (shift != null) {
                return shift;
            }
            return 0;
        }

        @Nullable
        private Integer getUnchangedBoundaryShift(@NotNull Side touchSide, int equalForward, int equalBackward, @NotNull Range range1, @NotNull Range range2, int threshold) {
            if (touchSide == null) {
                LineChunkOptimizer.$$$reportNull$$$0(7);
            }
            if (range1 == null) {
                LineChunkOptimizer.$$$reportNull$$$0(8);
            }
            if (range2 == null) {
                LineChunkOptimizer.$$$reportNull$$$0(9);
            }
            List touchLines = (List)touchSide.select((Object)this.myData1, (Object)this.myData2);
            int touchStart = touchSide.select(range2.start1, range2.start2);
            int shiftForward = LineChunkOptimizer.findNextUnimportantLine(touchLines, touchStart, equalForward + 1, threshold);
            int shiftBackward = LineChunkOptimizer.findPrevUnimportantLine(touchLines, touchStart - 1, equalBackward + 1, threshold);
            return LineChunkOptimizer.getShift(shiftForward, shiftBackward);
        }

        @Nullable
        private Integer getChangedBoundaryShift(@NotNull Side touchSide, int equalForward, int equalBackward, @NotNull Range range1, @NotNull Range range2, int threshold) {
            if (touchSide == null) {
                LineChunkOptimizer.$$$reportNull$$$0(10);
            }
            if (range1 == null) {
                LineChunkOptimizer.$$$reportNull$$$0(11);
            }
            if (range2 == null) {
                LineChunkOptimizer.$$$reportNull$$$0(12);
            }
            Side nonTouchSide = touchSide.other();
            List nonTouchLines = (List)nonTouchSide.select((Object)this.myData1, (Object)this.myData2);
            int changeStart = nonTouchSide.select(range1.end1, range1.end2);
            int changeEnd = nonTouchSide.select(range2.start1, range2.start2);
            int shiftForward = LineChunkOptimizer.findNextUnimportantLine(nonTouchLines, changeStart, equalForward + 1, threshold);
            int shiftBackward = LineChunkOptimizer.findPrevUnimportantLine(nonTouchLines, changeEnd - 1, equalBackward + 1, threshold);
            return LineChunkOptimizer.getShift(shiftForward, shiftBackward);
        }

        private static int findNextUnimportantLine(@NotNull List<ByLine.Line> lines2, int offset, int count, int threshold) {
            if (lines2 == null) {
                LineChunkOptimizer.$$$reportNull$$$0(13);
            }
            for (int i = 0; i < count; ++i) {
                if (lines2.get(offset + i).getNonSpaceChars() > threshold) continue;
                return i;
            }
            return -1;
        }

        private static int findPrevUnimportantLine(@NotNull List<ByLine.Line> lines2, int offset, int count, int threshold) {
            if (lines2 == null) {
                LineChunkOptimizer.$$$reportNull$$$0(14);
            }
            for (int i = 0; i < count; ++i) {
                if (lines2.get(offset - i).getNonSpaceChars() > threshold) continue;
                return i;
            }
            return -1;
        }

        @Nullable
        private static Integer getShift(int shiftForward, int shiftBackward) {
            if (shiftForward == -1 && shiftBackward == -1) {
                return null;
            }
            if (shiftForward == 0 || shiftBackward == 0) {
                return 0;
            }
            return shiftForward != -1 ? shiftForward : -shiftBackward;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lines1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lines2";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 4: 
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "touchSide";
                    break;
                }
                case 5: 
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range1";
                    break;
                }
                case 6: 
                case 9: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range2";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lines";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/comparison/ChunkOptimizer$LineChunkOptimizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getShift";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getUnchangedBoundaryShift";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getChangedBoundaryShift";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findNextUnimportantLine";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findPrevUnimportantLine";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class WordChunkOptimizer
    extends ChunkOptimizer<ByWord.InlineChunk> {
        @NotNull
        private final CharSequence myText1;
        @NotNull
        private final CharSequence myText2;

        public WordChunkOptimizer(@NotNull List<ByWord.InlineChunk> words1, @NotNull List<ByWord.InlineChunk> words2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull FairDiffIterable changes, @NotNull ProgressIndicator indicator) {
            if (words1 == null) {
                WordChunkOptimizer.$$$reportNull$$$0(0);
            }
            if (words2 == null) {
                WordChunkOptimizer.$$$reportNull$$$0(1);
            }
            if (text1 == null) {
                WordChunkOptimizer.$$$reportNull$$$0(2);
            }
            if (text2 == null) {
                WordChunkOptimizer.$$$reportNull$$$0(3);
            }
            if (changes == null) {
                WordChunkOptimizer.$$$reportNull$$$0(4);
            }
            if (indicator == null) {
                WordChunkOptimizer.$$$reportNull$$$0(5);
            }
            super(words1, words2, changes, indicator);
            this.myText1 = text1;
            this.myText2 = text2;
        }

        @Override
        protected int getShift(@NotNull Side touchSide, int equalForward, int equalBackward, @NotNull Range range1, @NotNull Range range2) {
            int touchStart;
            if (touchSide == null) {
                WordChunkOptimizer.$$$reportNull$$$0(6);
            }
            if (range1 == null) {
                WordChunkOptimizer.$$$reportNull$$$0(7);
            }
            if (range2 == null) {
                WordChunkOptimizer.$$$reportNull$$$0(8);
            }
            List touchWords = (List)touchSide.select((Object)this.myData1, (Object)this.myData2);
            CharSequence touchText = (CharSequence)touchSide.select((Object)this.myText1, (Object)this.myText2);
            if (WordChunkOptimizer.isSeparatedWithWhitespace(touchText, (ByWord.InlineChunk)touchWords.get((touchStart = touchSide.select(range2.start1, range2.start2)) - 1), (ByWord.InlineChunk)touchWords.get(touchStart))) {
                return 0;
            }
            int leftShift = WordChunkOptimizer.findSequenceEdgeShift(touchText, touchWords, touchStart, equalForward, true);
            if (leftShift > 0) {
                return leftShift;
            }
            int rightShift = WordChunkOptimizer.findSequenceEdgeShift(touchText, touchWords, touchStart - 1, equalBackward, false);
            if (rightShift > 0) {
                return -rightShift;
            }
            return 0;
        }

        private static int findSequenceEdgeShift(@NotNull CharSequence text, @NotNull List<ByWord.InlineChunk> words, int offset, int count, boolean leftToRight) {
            if (text == null) {
                WordChunkOptimizer.$$$reportNull$$$0(9);
            }
            if (words == null) {
                WordChunkOptimizer.$$$reportNull$$$0(10);
            }
            for (int i = 0; i < count; ++i) {
                ByWord.InlineChunk word2;
                ByWord.InlineChunk word1;
                if (leftToRight) {
                    word1 = words.get(offset + i);
                    word2 = words.get(offset + i + 1);
                } else {
                    word1 = words.get(offset - i - 1);
                    word2 = words.get(offset - i);
                }
                if (!WordChunkOptimizer.isSeparatedWithWhitespace(text, word1, word2)) continue;
                return i + 1;
            }
            return -1;
        }

        private static boolean isSeparatedWithWhitespace(@NotNull CharSequence text, @NotNull ByWord.InlineChunk word1, @NotNull ByWord.InlineChunk word2) {
            if (text == null) {
                WordChunkOptimizer.$$$reportNull$$$0(11);
            }
            if (word1 == null) {
                WordChunkOptimizer.$$$reportNull$$$0(12);
            }
            if (word2 == null) {
                WordChunkOptimizer.$$$reportNull$$$0(13);
            }
            if (word1 instanceof ByWord.NewlineChunk || word2 instanceof ByWord.NewlineChunk) {
                return true;
            }
            int offset1 = word1.getOffset2();
            int offset2 = word2.getOffset1();
            for (int i = offset1; i < offset2; ++i) {
                if (!StringUtil.isWhiteSpace((char)text.charAt(i))) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "words1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "words2";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text1";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text2";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "touchSide";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range1";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range2";
                    break;
                }
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "words";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "word1";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "word2";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/comparison/ChunkOptimizer$WordChunkOptimizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getShift";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findSequenceEdgeShift";
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSeparatedWithWhitespace";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

