/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.reference.RefDirectory;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.ui.InspectionModuleNode;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionPackageNode;
import com.intellij.codeInspection.ui.InspectionResultsViewComparator;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.codeInspection.ui.util.SynchronizedBidiMultiMap;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionRVContentProvider {
    private static final Logger LOG = Logger.getInstance(InspectionRVContentProvider.class);
    private final Project myProject;

    public InspectionRVContentProvider(@NotNull Project project) {
        if (project == null) {
            InspectionRVContentProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public abstract boolean checkReportedProblems(@NotNull GlobalInspectionContextImpl var1, @NotNull InspectionToolWrapper var2);

    public Iterable<? extends ScopeToolState> getTools(Tools tools) {
        return tools.getTools();
    }

    public boolean hasQuickFixes(InspectionTree tree) {
        TreePath[] treePaths = tree.getSelectionPaths();
        if (treePaths == null) {
            return false;
        }
        for (TreePath selectionPath : treePaths) {
            if (TreeUtil.traverseDepth((TreeNode)((TreeNode)selectionPath.getLastPathComponent()), node -> {
                ProblemDescriptionNode problemDescriptionNode;
                if (!((InspectionTreeNode)node).isValid()) {
                    return true;
                }
                if (node instanceof ProblemDescriptionNode && !(problemDescriptionNode = (ProblemDescriptionNode)node).isQuickFixAppliedFromView()) {
                    CommonProblemDescriptor descriptor2 = problemDescriptionNode.getDescriptor();
                    QuickFix[] fixes = descriptor2 != null ? descriptor2.getFixes() : null;
                    return fixes == null || fixes.length == 0;
                }
                return true;
            })) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public abstract QuickFixAction[] getQuickFixes(@NotNull InspectionToolWrapper var1, @NotNull InspectionTree var2);

    public InspectionNode appendToolNodeContent(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionNode toolNode, @NotNull InspectionTreeNode parentNode, boolean showStructure, boolean groupBySeverity) {
        if (context == null) {
            InspectionRVContentProvider.$$$reportNull$$$0(1);
        }
        if (toolNode == null) {
            InspectionRVContentProvider.$$$reportNull$$$0(2);
        }
        if (parentNode == null) {
            InspectionRVContentProvider.$$$reportNull$$$0(3);
        }
        InspectionToolWrapper wrapper2 = toolNode.getToolWrapper();
        InspectionToolPresentation presentation = context.getPresentation(wrapper2);
        Map<String, Set<RefEntity>> content = presentation.getContent();
        SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> problems = presentation.getProblemElements();
        return this.appendToolNodeContent(context, toolNode, parentNode, showStructure, groupBySeverity, content, problems::get);
    }

    public abstract InspectionNode appendToolNodeContent(@NotNull GlobalInspectionContextImpl var1, @NotNull InspectionNode var2, @NotNull InspectionTreeNode var3, boolean var4, boolean var5, @NotNull Map<String, Set<RefEntity>> var6, @NotNull Function<RefEntity, CommonProblemDescriptor[]> var7);

    protected abstract void appendDescriptor(@NotNull GlobalInspectionContextImpl var1, @NotNull InspectionToolWrapper var2, @NotNull RefEntityContainer var3, @NotNull InspectionTreeNode var4, boolean var5);

    public boolean isContentLoaded() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected <T> void buildTree(@NotNull GlobalInspectionContextImpl context, @NotNull Map<String, Set<T>> packageContents, boolean canPackageRepeat, @NotNull InspectionToolWrapper toolWrapper, @NotNull Function<T, RefEntityContainer<?>> computeContainer, boolean showStructure, UnaryOperator<InspectionTreeNode> createdNodesConsumer) {
        Iterator<String> iterator;
        MultiMap packageDescriptors;
        block34: {
            Iterator iterator2;
            HashMap<String, InspectionModuleNode> moduleNodes;
            if (context == null) {
                InspectionRVContentProvider.$$$reportNull$$$0(4);
            }
            if (packageContents == null) {
                InspectionRVContentProvider.$$$reportNull$$$0(5);
            }
            if (toolWrapper == null) {
                InspectionRVContentProvider.$$$reportNull$$$0(6);
            }
            if (computeContainer == null) {
                InspectionRVContentProvider.$$$reportNull$$$0(7);
            }
            HashMap module2PackageMap = new HashMap();
            boolean supportStructure = showStructure;
            packageDescriptors = new MultiMap();
            iterator = packageContents.keySet().iterator();
            block0: while (true) {
                if (!iterator.hasNext()) {
                    if (supportStructure) {
                        moduleNodes = new HashMap<String, InspectionModuleNode>();
                        iterator2 = module2PackageMap.keySet().iterator();
                        break;
                    }
                    iterator = module2PackageMap.values().iterator();
                    break block34;
                }
                String string = iterator.next();
                Set<T> elements = packageContents.get(string);
                Iterator<T> iterator3 = elements.iterator();
                while (true) {
                    InspectionPackageNode pNode;
                    if (!iterator3.hasNext()) continue block0;
                    T userObject = iterator3.next();
                    RefEntityContainer container = computeContainer.apply(userObject);
                    supportStructure &= container.supportStructure();
                    String moduleName = showStructure ? container.getModule() : null;
                    HashMap packageNodes = (HashMap)module2PackageMap.get(moduleName);
                    if (packageNodes == null) {
                        packageNodes = new HashMap();
                        module2PackageMap.put(moduleName, packageNodes);
                    }
                    if ((pNode = (InspectionPackageNode)packageNodes.get(string)) == null) {
                        pNode = new InspectionPackageNode(string);
                        packageNodes.put(string, pNode);
                    }
                    packageDescriptors.putValue((Object)pNode, (Object)container);
                }
                break;
            }
            while (iterator2.hasNext()) {
                InspectionModuleNode moduleNode;
                Map packageNodes;
                block36: {
                    block35: {
                        String moduleName = (String)iterator2.next();
                        packageNodes = (Map)module2PackageMap.get(moduleName);
                        moduleNode = (InspectionModuleNode)moduleNodes.get(moduleName);
                        if (moduleNode != null) break block35;
                        if (moduleName != null) {
                            Module module2 = (Module)ReadAction.compute(() -> ModuleManager.getInstance((Project)this.myProject).findModuleByName(moduleName));
                            if (module2 == null) continue;
                            moduleNode = new InspectionModuleNode(module2);
                            moduleNodes.put(moduleName, moduleNode);
                            moduleNode = (InspectionModuleNode)createdNodesConsumer.apply(moduleNode);
                            break block36;
                        } else {
                            for (InspectionPackageNode packageNode : packageNodes.values()) {
                                createdNodesConsumer.apply(packageNode);
                                for (Object container : packageDescriptors.get((Object)packageNode)) {
                                    this.appendDescriptor(context, toolWrapper, (RefEntityContainer)container, packageNode, canPackageRepeat);
                                }
                            }
                            continue;
                        }
                    }
                    moduleNode = (InspectionModuleNode)createdNodesConsumer.apply(moduleNode);
                }
                for (InspectionPackageNode packageNode : packageNodes.values()) {
                    if (packageNode.getPackageName() != null) {
                        Object container;
                        Collection objectContainers = packageDescriptors.get((Object)packageNode);
                        packageNode = (InspectionPackageNode)InspectionRVContentProvider.merge(packageNode, moduleNode, true);
                        container = objectContainers.iterator();
                        while (container.hasNext()) {
                            RefEntityContainer container2 = (RefEntityContainer)container.next();
                            this.appendDescriptor(context, toolWrapper, container2, packageNode, canPackageRepeat);
                        }
                        continue;
                    }
                    for (Object container : packageDescriptors.get((Object)packageNode)) {
                        this.appendDescriptor(context, toolWrapper, (RefEntityContainer)container, moduleNode, canPackageRepeat);
                    }
                }
            }
            return;
        }
        while (iterator.hasNext()) {
            Map map2 = (Map)((Object)iterator.next());
            block9: for (InspectionPackageNode pNode : map2.values()) {
                for (RefEntityContainer container : packageDescriptors.get((Object)pNode)) {
                    this.appendDescriptor(context, toolWrapper, container, pNode, canPackageRepeat);
                }
                int count = pNode.getChildCount();
                ArrayList<TreeNode> childNodes = new ArrayList<TreeNode>(count);
                for (int i = 0; i < count; ++i) {
                    childNodes.add(pNode.getChildAt(i));
                }
                for (TreeNode childNode : childNodes) {
                    if (childNode instanceof ProblemDescriptionNode) {
                        createdNodesConsumer.apply(pNode);
                        continue block9;
                    }
                    LOG.assertTrue(childNode instanceof RefElementNode, (Object)childNode.getClass().getName());
                    RefElementNode elementNode = (RefElementNode)childNode;
                    LinkedHashSet<RefElementNode> parentNodes = new LinkedHashSet<RefElementNode>();
                    if (pNode.getPackageName() != null) {
                        parentNodes.add(elementNode);
                    } else {
                        boolean hasElementNodeUnder = true;
                        for (int e = 0; e < elementNode.getChildCount(); ++e) {
                            TreeNode grandChildNode = elementNode.getChildAt(e);
                            if (grandChildNode instanceof ProblemDescriptionNode) {
                                hasElementNodeUnder = false;
                                break;
                            }
                            LOG.assertTrue(grandChildNode instanceof RefElementNode);
                            parentNodes.add((RefElementNode)grandChildNode);
                        }
                        if (!hasElementNodeUnder) {
                            createdNodesConsumer.apply(elementNode);
                            continue;
                        }
                    }
                    if (!"unused".equals(toolWrapper.getShortName())) {
                        for (RefElementNode parentNode : parentNodes) {
                            ArrayList nodes = new ArrayList();
                            TreeUtil.traverse((TreeNode)parentNode, node -> {
                                if (node instanceof ProblemDescriptionNode) {
                                    nodes.add((ProblemDescriptionNode)node);
                                }
                                return true;
                            });
                            if (nodes.isEmpty()) continue;
                            parentNode.removeAllChildren();
                            for (ProblemDescriptionNode node2 : nodes) {
                                parentNode.add(node2);
                            }
                        }
                    }
                    for (RefElementNode node3 : parentNodes) {
                        createdNodesConsumer.apply(node3);
                    }
                }
            }
        }
    }

    @NotNull
    protected static RefElementNode addNodeToParent(@NotNull RefEntityContainer container, @NotNull InspectionToolPresentation presentation, InspectionTreeNode parentNode) {
        if (container == null) {
            InspectionRVContentProvider.$$$reportNull$$$0(8);
        }
        if (presentation == null) {
            InspectionRVContentProvider.$$$reportNull$$$0(9);
        }
        RefElementNode nodeToBeAdded = container.createNode(presentation);
        Ref firstLevel = new Ref((Object)true);
        RefElementNode prevNode = null;
        Ref result2 = new Ref();
        while (true) {
            RefEntityContainer owner;
            RefElementNode currentNode = (Boolean)firstLevel.get() != false ? nodeToBeAdded : container.createNode(presentation);
            RefEntityContainer finalContainer = container;
            RefElementNode finalPrevNode = prevNode;
            TreeUtil.traverseDepth((TreeNode)parentNode, node -> {
                if (node instanceof RefElementNode) {
                    RefElementNode refElementNode = (RefElementNode)node;
                    RefEntity userObject = finalContainer.getRefEntity();
                    RefEntity object = refElementNode.getElement();
                    if (userObject != null && object != null && userObject.getClass().equals(object.getClass()) && finalContainer.areEqual(object, userObject)) {
                        if (((Boolean)firstLevel.get()).booleanValue()) {
                            result2.set((Object)refElementNode);
                            return false;
                        }
                        refElementNode.insertByOrder(finalPrevNode, false);
                        result2.set((Object)nodeToBeAdded);
                        return false;
                    }
                }
                return true;
            });
            if (!result2.isNull()) {
                RefElementNode refElementNode = (RefElementNode)result2.get();
                if (refElementNode == null) {
                    InspectionRVContentProvider.$$$reportNull$$$0(10);
                }
                return refElementNode;
            }
            if (!((Boolean)firstLevel.get()).booleanValue()) {
                currentNode.insertByOrder(prevNode, false);
            }
            if ((owner = container.getOwner()) == null) {
                parentNode.insertByOrder(currentNode, false);
                RefElementNode refElementNode = nodeToBeAdded;
                if (refElementNode == null) {
                    InspectionRVContentProvider.$$$reportNull$$$0(11);
                }
                return refElementNode;
            }
            container = owner;
            prevNode = currentNode;
            firstLevel.set((Object)false);
        }
    }

    public static InspectionTreeNode merge(InspectionTreeNode child, InspectionTreeNode parent, boolean merge) {
        return (InspectionTreeNode)ReadAction.compute(() -> {
            if (merge) {
                for (int i = 0; i < parent.getChildCount(); ++i) {
                    InspectionTreeNode current = (InspectionTreeNode)parent.getChildAt(i);
                    if (child.getClass() != current.getClass()) continue;
                    if (current instanceof InspectionPackageNode) {
                        if (((InspectionPackageNode)current).getPackageName().compareTo(((InspectionPackageNode)child).getPackageName()) != 0) continue;
                        InspectionRVContentProvider.processDepth(child, current);
                        return current;
                    }
                    if (current instanceof RefElementNode) {
                        if (InspectionResultsViewComparator.getInstance().compare(current, child) != 0) continue;
                        InspectionRVContentProvider.processDepth(child, current);
                        return current;
                    }
                    if (current instanceof InspectionNode) {
                        if (((InspectionNode)current).getToolWrapper().getShortName().compareTo(((InspectionNode)child).getToolWrapper().getShortName()) != 0) continue;
                        InspectionRVContentProvider.processDepth(child, current);
                        return current;
                    }
                    if (!(current instanceof InspectionModuleNode) || ((InspectionModuleNode)current).getName().compareTo(((InspectionModuleNode)child).getName()) != 0) continue;
                    InspectionRVContentProvider.processDepth(child, current);
                    return current;
                }
            }
            return parent.insertByOrder(child, false);
        });
    }

    private static void processDepth(InspectionTreeNode child, InspectionTreeNode current) {
        InspectionTreeNode[] children2 = new InspectionTreeNode[child.getChildCount()];
        for (int i = 0; i < children2.length; ++i) {
            children2[i] = (InspectionTreeNode)child.getChildAt(i);
        }
        for (InspectionTreeNode node : children2) {
            InspectionRVContentProvider.merge(node, current, true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageContents";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computeContainer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/InspectionRVContentProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/InspectionRVContentProvider";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "addNodeToParent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "appendToolNodeContent";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildTree";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addNodeToParent";
                break;
            }
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class RefEntityContainer<Descriptor> {
        private final Descriptor[] myDescriptors;
        @Nullable
        private final RefEntity myEntity;

        public RefEntityContainer(@Nullable RefEntity entity, Descriptor[] descriptors) {
            this.myEntity = entity;
            this.myDescriptors = descriptors;
        }

        @Nullable
        public RefEntityContainer<Descriptor> getOwner() {
            if (this.myEntity == null) {
                return null;
            }
            RefEntity entity = this.myEntity.getOwner();
            return entity instanceof RefElement && !(entity instanceof RefDirectory) ? new RefEntityContainer<Descriptor>(entity, this.myDescriptors) : null;
        }

        @NotNull
        public RefElementNode createNode(@NotNull InspectionToolPresentation presentation) {
            if (presentation == null) {
                RefEntityContainer.$$$reportNull$$$0(0);
            }
            RefElementNode refElementNode = (RefElementNode)ReadAction.compute(() -> {
                if (presentation == null) {
                    RefEntityContainer.$$$reportNull$$$0(4);
                }
                return presentation.createRefNode(this.myEntity);
            });
            if (refElementNode == null) {
                RefEntityContainer.$$$reportNull$$$0(1);
            }
            return refElementNode;
        }

        @Nullable
        public RefEntity getRefEntity() {
            return this.myEntity;
        }

        @Nullable
        public String getModule() {
            RefModule refModule = this.myEntity instanceof RefElement ? ((RefElement)this.myEntity).getModule() : (this.myEntity instanceof RefModule ? (RefModule)this.myEntity : null);
            return refModule != null ? refModule.getName() : null;
        }

        boolean areEqual(@NotNull RefEntity o1, @NotNull RefEntity o2) {
            if (o1 == null) {
                RefEntityContainer.$$$reportNull$$$0(2);
            }
            if (o2 == null) {
                RefEntityContainer.$$$reportNull$$$0(3);
            }
            return Comparing.equal((Object)o1, (Object)o2);
        }

        boolean supportStructure() {
            return this.myEntity == null || this.myEntity instanceof RefElement && !(this.myEntity instanceof RefDirectory);
        }

        public Descriptor[] getDescriptors() {
            return this.myDescriptors;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ex/InspectionRVContentProvider$RefEntityContainer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o1";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ex/InspectionRVContentProvider$RefEntityContainer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createNode";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "areEqual";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$createNode$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

