/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.CleanupOnScopeIntention;
import com.intellij.codeInsight.daemon.impl.EditCleanupProfileIntentionAction;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionBean;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInsight.intention.impl.config.IntentionActionMetaData;
import com.intellij.codeInsight.intention.impl.config.IntentionActionWrapper;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings;
import com.intellij.codeInsight.intention.impl.config.LazyEditor;
import com.intellij.codeInsight.intention.impl.config.PlainTextDescriptor;
import com.intellij.codeInsight.intention.impl.config.TextDescriptor;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.actions.CleanupAllIntention;
import com.intellij.codeInspection.actions.CleanupInspectionIntention;
import com.intellij.codeInspection.actions.RunInspectionIntention;
import com.intellij.codeInspection.ex.DisableInspectionToolAction;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsInSuppressedPlaceIntention;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntentionManagerImpl
extends IntentionManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.config.IntentionManagerImpl");
    private final List<IntentionAction> myActions = ContainerUtil.createLockFreeCopyOnWriteList();
    private final IntentionManagerSettings mySettings;
    private final Alarm myInitActionsAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);

    public IntentionManagerImpl(IntentionManagerSettings intentionManagerSettings) {
        this.mySettings = intentionManagerSettings;
        this.addAction(new EditInspectionToolsSettingsInSuppressedPlaceIntention());
        ExtensionPoint point = Extensions.getArea(null).getExtensionPoint(EP_INTENTION_ACTIONS);
        point.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<IntentionActionBean>(){

            public void extensionAdded(@NotNull IntentionActionBean extension, @Nullable PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                IntentionManagerImpl.this.registerIntentionFromBean(extension);
            }

            public void extensionRemoved(@NotNull IntentionActionBean extension, @Nullable PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "extension";
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void registerIntentionFromBean(@NotNull IntentionActionBean extension) {
        if (extension == null) {
            IntentionManagerImpl.$$$reportNull$$$0(0);
        }
        Runnable runnable2 = () -> {
            if (extension == null) {
                IntentionManagerImpl.$$$reportNull$$$0(27);
            }
            String descriptionDirectoryName = extension.getDescriptionDirectoryName();
            String[] categories = extension.getCategories();
            IntentionAction instance = IntentionManagerImpl.createIntentionActionWrapper(extension, categories);
            if (categories == null) {
                this.addAction(instance);
            } else if (descriptionDirectoryName != null) {
                this.addAction(instance);
                this.mySettings.registerIntentionMetaData(instance, categories, descriptionDirectoryName, extension.getMetadataClassLoader());
            } else {
                this.registerIntentionAndMetaData(instance, categories);
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable2.run();
        } else {
            this.myInitActionsAlarm.addRequest(runnable2, 300);
        }
    }

    public void dispose() {
    }

    private static IntentionAction createIntentionActionWrapper(@NotNull IntentionActionBean intentionActionBean, String[] categories) {
        if (intentionActionBean == null) {
            IntentionManagerImpl.$$$reportNull$$$0(1);
        }
        return new IntentionActionWrapper(intentionActionBean, categories);
    }

    public void registerIntentionAndMetaData(@NotNull IntentionAction action, String ... category) {
        if (action == null) {
            IntentionManagerImpl.$$$reportNull$$$0(2);
        }
        if (category == null) {
            IntentionManagerImpl.$$$reportNull$$$0(3);
        }
        this.registerIntentionAndMetaData(action, category, IntentionManagerImpl.getDescriptionDirectoryName(action));
    }

    @NotNull
    private static String getDescriptionDirectoryName(IntentionAction action) {
        if (action instanceof IntentionActionWrapper) {
            IntentionActionWrapper wrapper2 = (IntentionActionWrapper)action;
            String string = IntentionManagerImpl.getDescriptionDirectoryName(wrapper2.getImplementationClassName());
            if (string == null) {
                IntentionManagerImpl.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = IntentionManagerImpl.getDescriptionDirectoryName(action.getClass().getName());
        if (string == null) {
            IntentionManagerImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static String getDescriptionDirectoryName(String fqn) {
        return fqn.substring(fqn.lastIndexOf(46) + 1).replaceAll("\\$", "");
    }

    public void registerIntentionAndMetaData(@NotNull IntentionAction action, @NotNull String[] category, @NotNull @NonNls String descriptionDirectoryName) {
        if (action == null) {
            IntentionManagerImpl.$$$reportNull$$$0(6);
        }
        if (category == null) {
            IntentionManagerImpl.$$$reportNull$$$0(7);
        }
        if (descriptionDirectoryName == null) {
            IntentionManagerImpl.$$$reportNull$$$0(8);
        }
        this.addAction(action);
        this.mySettings.registerIntentionMetaData(action, category, descriptionDirectoryName);
    }

    public void registerIntentionAndMetaData(@NotNull IntentionAction action, @NotNull String[] category, @NotNull String description, @NotNull String exampleFileExtension, @NotNull String[] exampleTextBefore, @NotNull String[] exampleTextAfter) {
        if (action == null) {
            IntentionManagerImpl.$$$reportNull$$$0(9);
        }
        if (category == null) {
            IntentionManagerImpl.$$$reportNull$$$0(10);
        }
        if (description == null) {
            IntentionManagerImpl.$$$reportNull$$$0(11);
        }
        if (exampleFileExtension == null) {
            IntentionManagerImpl.$$$reportNull$$$0(12);
        }
        if (exampleTextBefore == null) {
            IntentionManagerImpl.$$$reportNull$$$0(13);
        }
        if (exampleTextAfter == null) {
            IntentionManagerImpl.$$$reportNull$$$0(14);
        }
        this.addAction(action);
        IntentionActionMetaData metaData = new IntentionActionMetaData(action, category, new PlainTextDescriptor(description, "description.html"), IntentionManagerImpl.mapToDescriptors(exampleTextBefore, "before." + exampleFileExtension), IntentionManagerImpl.mapToDescriptors(exampleTextAfter, "after." + exampleFileExtension));
        this.mySettings.registerMetaData(metaData);
    }

    public void unregisterIntention(@NotNull IntentionAction intentionAction) {
        if (intentionAction == null) {
            IntentionManagerImpl.$$$reportNull$$$0(15);
        }
        this.myActions.remove(intentionAction);
        this.mySettings.unregisterMetaData(intentionAction);
    }

    private static TextDescriptor[] mapToDescriptors(String[] texts, @NonNls String fileName) {
        TextDescriptor[] result2 = new TextDescriptor[texts.length];
        for (int i = 0; i < texts.length; ++i) {
            result2[i] = new PlainTextDescriptor(texts[i], fileName);
        }
        return result2;
    }

    @NotNull
    public List<IntentionAction> getStandardIntentionOptions(@NotNull HighlightDisplayKey displayKey, @NotNull PsiElement context) {
        if (displayKey == null) {
            IntentionManagerImpl.$$$reportNull$$$0(16);
        }
        if (context == null) {
            IntentionManagerImpl.$$$reportNull$$$0(17);
        }
        ArrayList<IntentionAction> options = new ArrayList<IntentionAction>(9);
        options.add(new EditInspectionToolsSettingsAction(displayKey));
        options.add(new RunInspectionIntention(displayKey));
        options.add((IntentionAction)new DisableInspectionToolAction(displayKey));
        ArrayList<IntentionAction> arrayList = options;
        if (arrayList == null) {
            IntentionManagerImpl.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @Nullable
    public IntentionAction createFixAllIntention(InspectionToolWrapper toolWrapper, IntentionAction action) {
        LocalInspectionToolWrapper localWrapper;
        if (toolWrapper instanceof GlobalInspectionToolWrapper && (localWrapper = ((GlobalInspectionToolWrapper)toolWrapper).getSharedLocalInspectionToolWrapper()) != null) {
            return this.createFixAllIntention(localWrapper, action);
        }
        if (toolWrapper instanceof LocalInspectionToolWrapper) {
            IntentionAction fix = action;
            if (action instanceof QuickFixWrapper) {
                fix = ((QuickFixWrapper)action).getFix();
            }
            return new CleanupInspectionIntention(toolWrapper, (FileModifier)fix, action.getText());
        }
        if (toolWrapper instanceof GlobalInspectionToolWrapper) {
            GlobalInspectionTool wrappedTool = (GlobalInspectionTool)((GlobalInspectionToolWrapper)toolWrapper).getTool();
            if (wrappedTool instanceof GlobalSimpleInspectionTool && (action instanceof LocalQuickFix || action instanceof QuickFixWrapper)) {
                IntentionAction fix = action;
                if (action instanceof QuickFixWrapper) {
                    fix = ((QuickFixWrapper)action).getFix();
                }
                return new CleanupInspectionIntention(toolWrapper, (FileModifier)fix, action.getText());
            }
        } else {
            throw new AssertionError((Object)("unknown tool: " + toolWrapper));
        }
        return null;
    }

    @NotNull
    public IntentionAction createCleanupAllIntention() {
        CleanupAllIntention cleanupAllIntention = CleanupAllIntention.INSTANCE;
        if (cleanupAllIntention == null) {
            IntentionManagerImpl.$$$reportNull$$$0(19);
        }
        return cleanupAllIntention;
    }

    @NotNull
    public List<IntentionAction> getCleanupIntentionOptions() {
        ArrayList<IntentionAction> options = new ArrayList<IntentionAction>();
        options.add(EditCleanupProfileIntentionAction.INSTANCE);
        options.add(CleanupOnScopeIntention.INSTANCE);
        ArrayList<IntentionAction> arrayList = options;
        if (arrayList == null) {
            IntentionManagerImpl.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    @NotNull
    public LocalQuickFix convertToFix(final @NotNull IntentionAction action) {
        if (action == null) {
            IntentionManagerImpl.$$$reportNull$$$0(21);
        }
        if (action instanceof LocalQuickFix) {
            LocalQuickFix localQuickFix = (LocalQuickFix)action;
            if (localQuickFix == null) {
                IntentionManagerImpl.$$$reportNull$$$0(22);
            }
            return localQuickFix;
        }
        LocalQuickFix localQuickFix = new LocalQuickFix(){

            @NotNull
            public String getName() {
                String string = action.getText();
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = action.getFamilyName();
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
                if (project == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (descriptor2 == null) {
                    2.$$$reportNull$$$0(3);
                }
                PsiFile psiFile = descriptor2.getPsiElement().getContainingFile();
                try {
                    action.invoke(project, (Editor)new LazyEditor(psiFile), psiFile);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl$2";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (localQuickFix == null) {
            IntentionManagerImpl.$$$reportNull$$$0(23);
        }
        return localQuickFix;
    }

    public void addAction(@NotNull IntentionAction action) {
        if (action == null) {
            IntentionManagerImpl.$$$reportNull$$$0(24);
        }
        this.myActions.add(action);
    }

    @NotNull
    public IntentionAction[] getIntentionActions() {
        IntentionAction[] intentionActionArray = (IntentionAction[])ArrayUtil.stripTrailingNulls((Object[])this.myActions.toArray(new IntentionAction[this.myActions.size()]));
        if (intentionActionArray == null) {
            IntentionManagerImpl.$$$reportNull$$$0(25);
        }
        return intentionActionArray;
    }

    @NotNull
    public IntentionAction[] getAvailableIntentionActions() {
        ArrayList<IntentionAction> list2 = new ArrayList<IntentionAction>(this.myActions.size());
        for (IntentionAction action : this.myActions) {
            if (!this.mySettings.isEnabled(action)) continue;
            list2.add(action);
        }
        IntentionAction[] intentionActionArray = list2.toArray(new IntentionAction[list2.size()]);
        if (intentionActionArray == null) {
            IntentionManagerImpl.$$$reportNull$$$0(26);
        }
        return intentionActionArray;
    }

    public boolean hasActiveRequests() {
        return !this.myInitActionsAlarm.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentionActionBean";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 4: 
            case 5: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionDirectoryName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exampleFileExtension";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exampleTextBefore";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exampleTextAfter";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentionAction";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayKey";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionDirectoryName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getStandardIntentionOptions";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createCleanupAllIntention";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getCleanupIntentionOptions";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToFix";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntentionActions";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableIntentionActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerIntentionFromBean";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createIntentionActionWrapper";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerIntentionAndMetaData";
                break;
            }
            case 4: 
            case 5: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "unregisterIntention";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getStandardIntentionOptions";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "convertToFix";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addAction";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$registerIntentionFromBean$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

