/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.editorActions.XmlEditUtil;
import com.intellij.codeInsight.editorActions.XmlGtTypedHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlEqTypedHandler
extends TypedHandlerDelegate {
    private boolean needToInsertQuotes = false;

    public TypedHandlerDelegate.Result beforeCharTyped(char c, Project project, Editor editor, PsiFile file2, FileType fileType) {
        if (c == '=' && WebEditorOptions.getInstance().isInsertQuotesForAttributeValue() && XmlGtTypedHandler.fileContainsXmlLanguage(file2)) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            PsiElement atParent = XmlEqTypedHandler.getAttributeCandidate(editor, file2, false);
            if (atParent instanceof XmlAttribute && ((XmlAttribute)atParent).getValueElement() == null) {
                this.needToInsertQuotes = ((XmlAttribute)atParent).getValueElement() == null;
            }
        }
        return super.beforeCharTyped(c, project, editor, file2, fileType);
    }

    @Nullable
    private static PsiElement getAttributeCandidate(@NotNull Editor editor, @NotNull PsiFile file2, boolean typed) {
        int newOffset;
        if (editor == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(1);
        }
        if ((newOffset = editor.getCaretModel().getOffset() - (typed ? 2 : 1)) < 0) {
            return null;
        }
        PsiElement at = file2.findElementAt(newOffset);
        return at != null ? at.getParent() : null;
    }

    public TypedHandlerDelegate.Result charTyped(char c, Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(3);
        }
        if (this.needToInsertQuotes) {
            int offset = editor.getCaretModel().getOffset();
            PsiElement fileContext = file2.getContext();
            String toInsert = XmlEqTypedHandler.tryCompleteQuotes(fileContext);
            boolean showPopup = true;
            if (toInsert == null) {
                String quote = XmlEqTypedHandler.getDefaultQuote(file2);
                XmlExtension.AttributeValuePresentation presentation = XmlEqTypedHandler.getValuePresentation(editor, file2, quote);
                toInsert = presentation.getPrefix() + presentation.getPostfix();
                showPopup = presentation.showAutoPopup();
            }
            editor.getDocument().insertString(offset, (CharSequence)toInsert);
            editor.getCaretModel().moveToOffset(offset + toInsert.length() / 2);
            if (showPopup) {
                AutoPopupController.getInstance(project).scheduleAutoPopup(editor);
            }
            this.needToInsertQuotes = false;
        }
        return super.charTyped(c, project, editor, file2);
    }

    @Nullable
    private static String tryCompleteQuotes(@Nullable PsiElement fileContext) {
        if (fileContext != null) {
            if (fileContext.getText().startsWith("\"")) {
                return "''";
            }
            if (fileContext.getText().startsWith("'")) {
                return "\"\"";
            }
        }
        return null;
    }

    @NotNull
    private static String getDefaultQuote(@NotNull PsiFile file2) {
        if (file2 == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(4);
        }
        String string = XmlEditUtil.getAttributeQuote(file2);
        if (string == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private static XmlExtension.AttributeValuePresentation getValuePresentation(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull String quote) {
        PsiElement atParent;
        if (editor == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(7);
        }
        if (quote == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(8);
        }
        XmlAttributeDescriptor descriptor2 = (atParent = XmlEqTypedHandler.getAttributeCandidate(editor, file2, true)) instanceof XmlAttribute ? ((XmlAttribute)atParent).getDescriptor() : null;
        XmlExtension.AttributeValuePresentation attributeValuePresentation = XmlExtension.getExtension(file2).getAttributeValuePresentation(descriptor2, quote);
        if (attributeValuePresentation == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(9);
        }
        return attributeValuePresentation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/XmlEqTypedHandler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quote";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/XmlEqTypedHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultQuote";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getValuePresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeCandidate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultQuote";
                break;
            }
            case 5: 
            case 9: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getValuePresentation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

