/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.vcs.log.VcsCommitMetadata;
import git4idea.DialogManager;
import git4idea.GitLocalBranch;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.history.GitHistoryUtils;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitCompareBranchesDialog;
import git4idea.update.GitFetchResult;
import git4idea.update.GitFetcher;
import git4idea.util.GitCommitCompareInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiUtil;
import org.jetbrains.plugins.github.api.GithubFullPath;
import org.jetbrains.plugins.github.api.data.GithubBranch;
import org.jetbrains.plugins.github.api.data.GithubPullRequest;
import org.jetbrains.plugins.github.api.data.GithubRepo;
import org.jetbrains.plugins.github.api.data.GithubRepoDetailed;
import org.jetbrains.plugins.github.exceptions.GithubOperationCanceledException;
import org.jetbrains.plugins.github.ui.GithubSelectForkDialog;
import org.jetbrains.plugins.github.util.AuthLevel;
import org.jetbrains.plugins.github.util.GithubAuthDataHolder;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubProjectSettings;
import org.jetbrains.plugins.github.util.GithubUrlUtil;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubCreatePullRequestWorker {
    private static final Logger LOG = GithubUtil.LOG;
    private static final String CANNOT_CREATE_PULL_REQUEST = "Can't Create Pull Request";
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final GitRepository myGitRepository;
    @NotNull
    private final GithubAuthDataHolder myAuthHolder;
    @NotNull
    private final GithubFullPath myPath;
    @NotNull
    private final String myRemoteName;
    @NotNull
    private final String myRemoteUrl;
    @NotNull
    private final String myCurrentBranch;
    @NotNull
    private GithubFullPath mySource;
    @NotNull
    private final List<ForkInfo> myForks;
    @Nullable
    private List<GithubFullPath> myAvailableForks;

    private GithubCreatePullRequestWorker(@NotNull Project project, @NotNull Git git, @NotNull GitRepository gitRepository, @NotNull GithubAuthDataHolder authHolder, @NotNull GithubFullPath path, @NotNull String remoteName, @NotNull String remoteUrl, @NotNull String currentBranch) {
        if (project == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(1);
        }
        if (gitRepository == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(2);
        }
        if (authHolder == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(3);
        }
        if (path == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(4);
        }
        if (remoteName == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(5);
        }
        if (remoteUrl == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(6);
        }
        if (currentBranch == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(7);
        }
        this.myProject = project;
        this.myGit = git;
        this.myGitRepository = gitRepository;
        this.myAuthHolder = authHolder;
        this.myPath = path;
        this.myRemoteName = remoteName;
        this.myRemoteUrl = remoteUrl;
        this.myCurrentBranch = currentBranch;
        this.myForks = new ArrayList<ForkInfo>();
    }

    @NotNull
    public String getCurrentBranch() {
        String string = this.myCurrentBranch;
        if (string == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public List<ForkInfo> getForks() {
        List<ForkInfo> list = this.myForks;
        if (list == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    public static GithubCreatePullRequestWorker create(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(10);
        }
        return (GithubCreatePullRequestWorker)GithubUtil.computeValueInModal(project, "Loading data...", indicator -> {
            GithubAuthDataHolder authHolder;
            if (project == null) {
                GithubCreatePullRequestWorker.$$$reportNull$$$0(57);
            }
            Git git = (Git)ServiceManager.getService(Git.class);
            GitRepository gitRepository = GithubUtil.getGitRepository(project, file);
            if (gitRepository == null) {
                GithubNotifications.showError(project, CANNOT_CREATE_PULL_REQUEST, "Can't find git repository");
                return null;
            }
            gitRepository.update();
            Pair<GitRemote, String> remote = GithubUtil.findGithubRemote(gitRepository);
            if (remote == null) {
                GithubNotifications.showError(project, CANNOT_CREATE_PULL_REQUEST, "Can't find GitHub remote");
                return null;
            }
            String remoteName = ((GitRemote)remote.getFirst()).getName();
            String remoteUrl = (String)remote.getSecond();
            GithubFullPath path = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(remoteUrl);
            if (path == null) {
                GithubNotifications.showError(project, CANNOT_CREATE_PULL_REQUEST, "Can't process remote: " + remoteUrl);
                return null;
            }
            GitLocalBranch currentBranch = gitRepository.getCurrentBranch();
            if (currentBranch == null) {
                GithubNotifications.showError(project, CANNOT_CREATE_PULL_REQUEST, "No current branch");
                return null;
            }
            try {
                authHolder = GithubUtil.getValidAuthDataHolderFromConfig(project, AuthLevel.LOGGED, indicator);
            }
            catch (IOException e) {
                GithubNotifications.showError(project, CANNOT_CREATE_PULL_REQUEST, e);
                return null;
            }
            GithubCreatePullRequestWorker worker = new GithubCreatePullRequestWorker(project, git, gitRepository, authHolder, path, remoteName, remoteUrl, currentBranch.getName());
            try {
                worker.initForks((ProgressIndicator)indicator);
            }
            catch (IOException e) {
                GithubNotifications.showError(project, CANNOT_CREATE_PULL_REQUEST, e);
                return null;
            }
            return worker;
        });
    }

    private void initForks(@NotNull ProgressIndicator indicator) throws IOException {
        if (indicator == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(11);
        }
        this.doLoadForksFromGithub(indicator);
        this.doLoadForksFromGit(indicator);
        this.doLoadForksFromSettings(indicator);
    }

    @Nullable
    private ForkInfo doAddFork(@NotNull GithubFullPath path, @Nullable String remoteName, @NotNull ProgressIndicator indicator) {
        if (path == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(12);
        }
        if (indicator == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(13);
        }
        for (ForkInfo fork : this.myForks) {
            if (!fork.getPath().equals(path)) continue;
            if (fork.getRemoteName() == null && remoteName != null) {
                fork.setRemoteName(remoteName);
            }
            return fork;
        }
        try {
            List<String> branches = this.loadBranches(path, indicator);
            String defaultBranch = this.doLoadDefaultBranch(path, indicator);
            ForkInfo fork = new ForkInfo(path, branches, defaultBranch);
            this.myForks.add(fork);
            if (remoteName != null) {
                fork.setRemoteName(remoteName);
            }
            return fork;
        }
        catch (IOException e) {
            GithubNotifications.showWarning(this.myProject, "Can't load branches for " + path.getFullName(), e);
            return null;
        }
    }

    @Nullable
    private ForkInfo doAddFork(@NotNull GithubRepo repo, @NotNull ProgressIndicator indicator) {
        if (repo == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(14);
        }
        if (indicator == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(15);
        }
        GithubFullPath path = repo.getFullPath();
        for (ForkInfo fork : this.myForks) {
            if (!fork.getPath().equals(path)) continue;
            return fork;
        }
        try {
            List<String> branches = this.loadBranches(path, indicator);
            String defaultBranch = repo.getDefaultBranch();
            ForkInfo fork = new ForkInfo(path, branches, defaultBranch);
            this.myForks.add(fork);
            return fork;
        }
        catch (IOException e) {
            GithubNotifications.showWarning(this.myProject, "Can't load branches for " + path.getFullName(), e);
            return null;
        }
    }

    private void doLoadForksFromSettings(@NotNull ProgressIndicator indicator) {
        GithubFullPath savedRepo;
        if (indicator == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(16);
        }
        if ((savedRepo = GithubProjectSettings.getInstance(this.myProject).getCreatePullRequestDefaultRepo()) != null) {
            this.doAddFork(savedRepo, null, indicator);
        }
    }

    private void doLoadForksFromGit(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(17);
        }
        block0: for (GitRemote remote : this.myGitRepository.getRemotes()) {
            for (String url : remote.getUrls()) {
                GithubFullPath path;
                if (!GithubUrlUtil.isGithubUrl(url) || (path = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(url)) == null) continue;
                this.doAddFork(path, remote.getName(), indicator);
                continue block0;
            }
        }
    }

    private void doLoadForksFromGithub(@NotNull ProgressIndicator indicator) throws IOException {
        if (indicator == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(18);
        }
        GithubRepoDetailed repo = (GithubRepoDetailed)GithubUtil.runTask(this.myProject, this.myAuthHolder, indicator, connection -> GithubApiUtil.getDetailedRepoInfo(connection, this.myPath.getUser(), this.myPath.getRepository()));
        this.doAddFork(repo, indicator);
        if (repo.getParent() != null) {
            this.doAddFork(repo.getParent(), indicator);
        }
        if (repo.getSource() != null) {
            this.doAddFork(repo.getSource(), indicator);
        }
        this.mySource = repo.getSource() == null ? repo.getFullPath() : repo.getSource().getFullPath();
    }

    @NotNull
    private List<String> loadBranches(@NotNull GithubFullPath fork, @NotNull ProgressIndicator indicator) throws IOException {
        if (fork == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(19);
        }
        if (indicator == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(20);
        }
        List branches = (List)GithubUtil.runTask(this.myProject, this.myAuthHolder, indicator, connection -> {
            if (fork == null) {
                GithubCreatePullRequestWorker.$$$reportNull$$$0(56);
            }
            return GithubApiUtil.getRepoBranches(connection, fork.getUser(), fork.getRepository());
        });
        List list = ContainerUtil.map((Collection)branches, GithubBranch::getName);
        if (list == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(21);
        }
        return list;
    }

    @Nullable
    private String doLoadDefaultBranch(@NotNull GithubFullPath fork, @NotNull ProgressIndicator indicator) throws IOException {
        if (fork == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(22);
        }
        if (indicator == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(23);
        }
        GithubRepo repo = (GithubRepo)GithubUtil.runTask(this.myProject, this.myAuthHolder, indicator, connection -> {
            if (fork == null) {
                GithubCreatePullRequestWorker.$$$reportNull$$$0(55);
            }
            return GithubApiUtil.getDetailedRepoInfo(connection, fork.getUser(), fork.getRepository());
        });
        return repo.getDefaultBranch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchFetchRemote(@NotNull ForkInfo fork) {
        if (fork == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(24);
        }
        if (fork.getRemoteName() == null) {
            return;
        }
        if (fork.getFetchTask() != null) {
            return;
        }
        Object object = fork.LOCK;
        synchronized (object) {
            if (fork.getFetchTask() != null) {
                return;
            }
            MasterFutureTask<Void> task = new MasterFutureTask<Void>(() -> {
                if (fork == null) {
                    GithubCreatePullRequestWorker.$$$reportNull$$$0(54);
                }
                this.doFetchRemote(fork);
                return null;
            });
            fork.setFetchTask(task);
            ApplicationManager.getApplication().executeOnPooledThread(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchLoadDiffInfo(@NotNull BranchInfo branch) {
        if (branch == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(25);
        }
        if (branch.getForkInfo().getRemoteName() == null) {
            return;
        }
        if (branch.getDiffInfoTask() != null) {
            return;
        }
        Object object = branch.LOCK;
        synchronized (object) {
            if (branch.getDiffInfoTask() != null) {
                return;
            }
            this.launchFetchRemote(branch.getForkInfo());
            MasterFutureTask<Void> masterTask = branch.getForkInfo().getFetchTask();
            assert (masterTask != null);
            SlaveFutureTask<DiffInfo> task = new SlaveFutureTask<DiffInfo>(masterTask, () -> {
                if (branch == null) {
                    GithubCreatePullRequestWorker.$$$reportNull$$$0(53);
                }
                return this.doLoadDiffInfo(branch);
            });
            branch.setDiffInfoTask(task);
            ApplicationManager.getApplication().executeOnPooledThread(task);
        }
    }

    @Nullable
    public DiffInfo getDiffInfo(@NotNull BranchInfo branch) throws IOException {
        if (branch == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(26);
        }
        if (branch.getForkInfo().getRemoteName() == null) {
            return null;
        }
        this.launchLoadDiffInfo(branch);
        assert (branch.getDiffInfoTask() != null);
        try {
            return (DiffInfo)branch.getDiffInfoTask().get();
        }
        catch (InterruptedException e) {
            throw new GithubOperationCanceledException(e);
        }
        catch (ExecutionException e) {
            Throwable ex = e.getCause();
            if (ex instanceof VcsException) {
                throw new IOException(ex);
            }
            LOG.error(ex);
            return null;
        }
    }

    private boolean doFetchRemote(@NotNull ForkInfo fork) {
        if (fork == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(27);
        }
        if (fork.getRemoteName() == null) {
            return false;
        }
        GitFetchResult result = new GitFetcher(this.myProject, (ProgressIndicator)new EmptyProgressIndicator(), false).fetch(this.myGitRepository.getRoot(), fork.getRemoteName(), null);
        if (!result.isSuccess()) {
            GitFetcher.displayFetchResult((Project)this.myProject, (GitFetchResult)result, null, (Collection)result.getErrors());
            return false;
        }
        return true;
    }

    @NotNull
    private DiffInfo doLoadDiffInfo(@NotNull BranchInfo branch) throws VcsException {
        if (branch == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(28);
        }
        String currentBranch = this.myCurrentBranch;
        String targetBranch = branch.getForkInfo().getRemoteName() + "/" + branch.getRemoteName();
        List commits1 = GitHistoryUtils.history((Project)this.myProject, (VirtualFile)this.myGitRepository.getRoot(), (String[])new String[]{".." + targetBranch});
        List commits2 = GitHistoryUtils.history((Project)this.myProject, (VirtualFile)this.myGitRepository.getRoot(), (String[])new String[]{targetBranch + ".."});
        Collection diff = GitChangeUtils.getDiff((Project)this.myProject, (VirtualFile)this.myGitRepository.getRoot(), (String)targetBranch, (String)this.myCurrentBranch, null);
        GitCommitCompareInfo info = new GitCommitCompareInfo(GitCommitCompareInfo.InfoType.BRANCH_TO_HEAD);
        info.put(this.myGitRepository, diff);
        info.put(this.myGitRepository, (Pair)Couple.of((Object)commits1, (Object)commits2));
        DiffInfo diffInfo = new DiffInfo(info, currentBranch, targetBranch);
        if (diffInfo == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(29);
        }
        return diffInfo;
    }

    private void doConfigureRemote(@NotNull ForkInfo fork) {
        if (fork == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(30);
        }
        if (fork.getRemoteName() != null) {
            return;
        }
        GithubFullPath path = fork.getPath();
        String url = GithubUrlUtil.getCloneUrl(path);
        if (GithubUtil.addGithubRemote(this.myProject, this.myGitRepository, path.getUser(), url)) {
            fork.setRemoteName(path.getUser());
        }
    }

    public void configureRemote(@NotNull ForkInfo fork) {
        if (fork == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(31);
        }
        GithubUtil.computeValueInModal(this.myProject, "Creating remote..", false, (Consumer<ProgressIndicator>)((Consumer)indicator -> {
            if (fork == null) {
                GithubCreatePullRequestWorker.$$$reportNull$$$0(52);
            }
            this.doConfigureRemote(fork);
        }));
    }

    @NotNull
    public Couple<String> getDefaultDescriptionMessage(@NotNull BranchInfo branch) {
        Couple<String> message;
        if (branch == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(32);
        }
        if ((message = branch.getDefaultMessage()) != null) {
            Couple<String> couple = message;
            if (couple == null) {
                GithubCreatePullRequestWorker.$$$reportNull$$$0(33);
            }
            return couple;
        }
        if (branch.getForkInfo().getRemoteName() == null) {
            Couple<String> couple = this.getSimpleDefaultDescriptionMessage(branch);
            if (couple == null) {
                GithubCreatePullRequestWorker.$$$reportNull$$$0(34);
            }
            return couple;
        }
        Couple couple = (Couple)GithubUtil.computeValueInModal(this.myProject, "Collecting last commits...", true, indicator -> {
            if (branch == null) {
                GithubCreatePullRequestWorker.$$$reportNull$$$0(51);
            }
            String localBranch = this.myCurrentBranch;
            String targetBranch = branch.getForkInfo().getRemoteName() + "/" + branch.getRemoteName();
            try {
                List commits = GitHistoryUtils.readLastCommits((Project)this.myProject, (VirtualFile)this.myGitRepository.getRoot(), (String[])new String[]{localBranch, targetBranch});
                if (commits == null) {
                    return this.getSimpleDefaultDescriptionMessage(branch);
                }
                VcsCommitMetadata localCommit = (VcsCommitMetadata)commits.get(0);
                VcsCommitMetadata targetCommit = (VcsCommitMetadata)commits.get(1);
                if (localCommit.getParents().contains(targetCommit.getId())) {
                    return GithubUtil.getGithubLikeFormattedDescriptionMessage(localCommit.getFullMessage());
                }
                return this.getSimpleDefaultDescriptionMessage(branch);
            }
            catch (ProcessCanceledException e) {
                return this.getSimpleDefaultDescriptionMessage(branch);
            }
            catch (VcsException e) {
                GithubNotifications.showWarning(this.myProject, "Can't collect additional data", (Exception)((Object)e));
                return this.getSimpleDefaultDescriptionMessage(branch);
            }
        });
        if (couple == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(35);
        }
        return couple;
    }

    @NotNull
    public Couple<String> getSimpleDefaultDescriptionMessage(@NotNull BranchInfo branch) {
        if (branch == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(36);
        }
        Couple message = Couple.of((Object)this.myCurrentBranch, (Object)"");
        branch.setDefaultMessage((Couple<String>)message);
        Couple couple = message;
        if (couple == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(37);
        }
        return couple;
    }

    public boolean checkAction(@Nullable BranchInfo branch) {
        DiffInfo info;
        if (branch == null) {
            GithubNotifications.showWarningDialog(this.myProject, CANNOT_CREATE_PULL_REQUEST, "Target branch is not selected");
            return false;
        }
        try {
            info = (DiffInfo)GithubUtil.computeValueInModalIO(this.myProject, "Collecting diff data...", indicator -> (DiffInfo)GithubUtil.runInterruptable(indicator, () -> this.getDiffInfo(branch)));
        }
        catch (IOException e) {
            GithubNotifications.showError(this.myProject, "Can't collect diff data", e);
            return true;
        }
        if (info == null) {
            return true;
        }
        ForkInfo fork = branch.getForkInfo();
        String localBranchName = "'" + this.myCurrentBranch + "'";
        String targetBranchName = "'" + fork.getRemoteName() + "/" + branch.getRemoteName() + "'";
        if (info.getInfo().getBranchToHeadCommits(this.myGitRepository).isEmpty()) {
            return GithubNotifications.showYesNoDialog(this.myProject, "Empty Pull Request", "The branch " + localBranchName + " is fully merged to the branch " + targetBranchName + '\n' + "Do you want to proceed anyway?");
        }
        if (!info.getInfo().getHeadToBranchCommits(this.myGitRepository).isEmpty()) {
            return GithubNotifications.showYesNoDialog(this.myProject, "Target Branch Is Not Fully Merged", "The branch " + targetBranchName + " is not fully merged to the branch " + localBranchName + '\n' + "Do you want to proceed anyway?");
        }
        return true;
    }

    public void createPullRequest(final @NotNull BranchInfo branch, final @NotNull String title, final @NotNull String description) {
        if (branch == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(38);
        }
        if (title == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(39);
        }
        if (description == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(40);
        }
        new Task.Backgroundable(this.myProject, "Creating Pull Request..."){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                LOG.info("Pushing current branch");
                indicator.setText("Pushing current branch...");
                GitCommandResult result = GithubCreatePullRequestWorker.this.myGit.push(GithubCreatePullRequestWorker.this.myGitRepository, GithubCreatePullRequestWorker.this.myRemoteName, GithubCreatePullRequestWorker.this.myRemoteUrl, GithubCreatePullRequestWorker.this.myCurrentBranch, true, new GitLineHandlerListener[0]);
                if (!result.success()) {
                    GithubNotifications.showError(this.myProject, GithubCreatePullRequestWorker.CANNOT_CREATE_PULL_REQUEST, "Push failed:<br/>" + result.getErrorOutputAsHtmlString());
                    return;
                }
                LOG.info("Creating pull request");
                indicator.setText("Creating pull request...");
                GithubPullRequest request = GithubCreatePullRequestWorker.this.doCreatePullRequest(indicator, branch, title, description);
                if (request == null) {
                    return;
                }
                GithubNotifications.showInfoURL(this.myProject, "Successfully created pull request", "Pull request #" + request.getNumber(), request.getHtmlUrl());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$1", "run"));
            }
        }.queue();
    }

    @Nullable
    private GithubPullRequest doCreatePullRequest(@NotNull ProgressIndicator indicator, @NotNull BranchInfo branch, @NotNull String title, @NotNull String description) {
        if (indicator == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(41);
        }
        if (branch == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(42);
        }
        if (title == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(43);
        }
        if (description == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(44);
        }
        GithubFullPath forkPath = branch.getForkInfo().getPath();
        String head = this.myPath.getUser() + ":" + this.myCurrentBranch;
        String base = branch.getRemoteName();
        try {
            return (GithubPullRequest)GithubUtil.runTask(this.myProject, this.myAuthHolder, indicator, connection -> {
                if (title == null) {
                    GithubCreatePullRequestWorker.$$$reportNull$$$0(49);
                }
                if (description == null) {
                    GithubCreatePullRequestWorker.$$$reportNull$$$0(50);
                }
                return GithubApiUtil.createPullRequest(connection, forkPath.getUser(), forkPath.getRepository(), title, description, head, base);
            });
        }
        catch (IOException e) {
            GithubNotifications.showError(this.myProject, CANNOT_CREATE_PULL_REQUEST, e);
            return null;
        }
    }

    public void showDiffDialog(@Nullable BranchInfo branch) {
        DiffInfo info;
        if (branch == null) {
            GithubNotifications.showWarningDialog(this.myProject, "Can't Show Diff", "Target branch is not selected");
            return;
        }
        try {
            info = (DiffInfo)GithubUtil.computeValueInModalIO(this.myProject, "Collecting diff data...", indicator -> (DiffInfo)GithubUtil.runInterruptable(indicator, () -> this.getDiffInfo(branch)));
        }
        catch (IOException e) {
            GithubNotifications.showError(this.myProject, "Can't collect diff data", e);
            return;
        }
        if (info == null) {
            GithubNotifications.showErrorDialog(this.myProject, "Can't Show Diff", "Can't collect diff data");
            return;
        }
        GitCompareBranchesDialog dialog = new GitCompareBranchesDialog(this.myProject, info.getTo(), info.getFrom(), info.getInfo(), this.myGitRepository, true);
        dialog.show();
    }

    @Nullable
    public ForkInfo showTargetDialog() {
        if (this.myAvailableForks == null) {
            try {
                this.myAvailableForks = (List)GithubUtil.computeValueInModal(this.myProject, this.myCurrentBranch, indicator -> this.getAvailableForks((ProgressIndicator)indicator));
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
        }
        Convertor getForkPath = user -> (ForkInfo)GithubUtil.computeValueInModal(this.myProject, "Access to GitHub", indicator -> this.findRepositoryByUser((ProgressIndicator)indicator, (String)user));
        GithubSelectForkDialog dialog = new GithubSelectForkDialog(this.myProject, this.myAvailableForks, (Convertor<String, ForkInfo>)getForkPath);
        DialogManager.show((DialogWrapper)dialog);
        if (!dialog.isOK()) {
            return null;
        }
        return dialog.getPath();
    }

    @Nullable
    private List<GithubFullPath> getAvailableForks(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(45);
        }
        try {
            List forks = (List)GithubUtil.runTask(this.myProject, this.myAuthHolder, indicator, connection -> GithubApiUtil.getForks(connection, this.mySource.getUser(), this.mySource.getRepository()));
            List forkPaths = ContainerUtil.map((Collection)forks, GithubRepo::getFullPath);
            if (!forkPaths.contains(this.mySource)) {
                return ContainerUtil.append((List)forkPaths, (Object[])new GithubFullPath[]{this.mySource});
            }
            return forkPaths;
        }
        catch (IOException e) {
            GithubNotifications.showWarning(this.myProject, "Can't load available forks", e);
            return null;
        }
    }

    @Nullable
    private ForkInfo findRepositoryByUser(@NotNull ProgressIndicator indicator, @NotNull String user) {
        if (indicator == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(46);
        }
        if (user == null) {
            GithubCreatePullRequestWorker.$$$reportNull$$$0(47);
        }
        for (ForkInfo fork : this.myForks) {
            if (!StringUtil.equalsIgnoreCase((CharSequence)user, (CharSequence)fork.getPath().getUser())) continue;
            return fork;
        }
        try {
            GithubRepo repo = (GithubRepo)GithubUtil.runTask(this.myProject, this.myAuthHolder, indicator, connection -> {
                if (user == null) {
                    GithubCreatePullRequestWorker.$$$reportNull$$$0(48);
                }
                try {
                    GithubRepoDetailed target = GithubApiUtil.getDetailedRepoInfo(connection, user, this.mySource.getRepository());
                    if (target.getSource() != null && StringUtil.equals((CharSequence)target.getSource().getUserName(), (CharSequence)this.mySource.getUser())) {
                        return target;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return GithubApiUtil.findForkByUser(connection, this.mySource.getUser(), this.mySource.getRepository(), user);
            });
            if (repo == null) {
                return null;
            }
            return this.doAddFork(repo, indicator);
        }
        catch (IOException e) {
            GithubNotifications.showError(this.myProject, "Can't find repository", e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 21: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 21: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitRepository";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authHolder";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteUrl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentBranch";
                break;
            }
            case 8: 
            case 9: 
            case 21: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/github/GithubCreatePullRequestWorker";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 23: 
            case 41: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repo";
                break;
            }
            case 19: 
            case 22: 
            case 24: 
            case 27: 
            case 30: 
            case 31: 
            case 52: 
            case 54: 
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fork";
                break;
            }
            case 25: 
            case 26: 
            case 28: 
            case 32: 
            case 36: 
            case 38: 
            case 42: 
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 39: 
            case 43: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 40: 
            case 44: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "user";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/github/GithubCreatePullRequestWorker";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentBranch";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getForks";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "loadBranches";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "doLoadDiffInfo";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultDescriptionMessage";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleDefaultDescriptionMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 21: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 37: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "initForks";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doAddFork";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doLoadForksFromSettings";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "doLoadForksFromGit";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "doLoadForksFromGithub";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "loadBranches";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "doLoadDefaultBranch";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "launchFetchRemote";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "launchLoadDiffInfo";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getDiffInfo";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "doFetchRemote";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "doLoadDiffInfo";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "doConfigureRemote";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "configureRemote";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultDescriptionMessage";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleDefaultDescriptionMessage";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createPullRequest";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "doCreatePullRequest";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableForks";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "findRepositoryByUser";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findRepositoryByUser$17";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doCreatePullRequest$10";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getDefaultDescriptionMessage$7";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "lambda$configureRemote$6";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "lambda$launchLoadDiffInfo$5";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "lambda$launchFetchRemote$4";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doLoadDefaultBranch$3";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "lambda$loadBranches$2";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "lambda$create$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 21: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MasterFutureTask<T>
    extends FutureTask<T> {
        @NotNull
        private final Object LOCK;
        private boolean myDone;
        @Nullable
        private List<SlaveFutureTask> mySlaves;

        public MasterFutureTask(@NotNull Callable<T> callable) {
            if (callable == null) {
                MasterFutureTask.$$$reportNull$$$0(0);
            }
            super(callable);
            this.LOCK = new Object();
            this.myDone = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean addSlave(@NotNull SlaveFutureTask slave) {
            if (slave == null) {
                MasterFutureTask.$$$reportNull$$$0(1);
            }
            if (this.isDone()) {
                return false;
            }
            Object object = this.LOCK;
            synchronized (object) {
                if (this.myDone) {
                    return false;
                }
                if (this.mySlaves == null) {
                    this.mySlaves = new ArrayList<SlaveFutureTask>();
                }
                this.mySlaves.add(slave);
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            Object object = this.LOCK;
            synchronized (object) {
                this.myDone = true;
                if (this.mySlaves != null) {
                    for (SlaveFutureTask slave : this.mySlaves) {
                        this.runSlave(slave);
                    }
                    this.mySlaves = null;
                }
            }
        }

        protected void runSlave(@NotNull SlaveFutureTask slave) {
            if (slave == null) {
                MasterFutureTask.$$$reportNull$$$0(2);
            }
            ApplicationManager.getApplication().executeOnPooledThread((Runnable)slave);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callable";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "slave";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$MasterFutureTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addSlave";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runSlave";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class SlaveFutureTask<T>
    extends FutureTask<T> {
        @NotNull
        private final MasterFutureTask myMaster;

        public SlaveFutureTask(@NotNull MasterFutureTask master, @NotNull Callable<T> callable) {
            if (master == null) {
                SlaveFutureTask.$$$reportNull$$$0(0);
            }
            if (callable == null) {
                SlaveFutureTask.$$$reportNull$$$0(1);
            }
            super(callable);
            this.myMaster = master;
        }

        @Override
        public void run() {
            if (this.myMaster.isDone()) {
                super.run();
            } else if (!this.myMaster.addSlave(this)) {
                super.run();
            }
        }

        public T safeGet() {
            try {
                return (T)super.get();
            }
            catch (InterruptedException | CancellationException | ExecutionException e) {
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "master";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "callable";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$SlaveFutureTask";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DiffInfo {
        @NotNull
        private final GitCommitCompareInfo myInfo;
        @NotNull
        private final String myFrom;
        @NotNull
        private final String myTo;

        private DiffInfo(@NotNull GitCommitCompareInfo info, @NotNull String from, @NotNull String to) {
            if (info == null) {
                DiffInfo.$$$reportNull$$$0(0);
            }
            if (from == null) {
                DiffInfo.$$$reportNull$$$0(1);
            }
            if (to == null) {
                DiffInfo.$$$reportNull$$$0(2);
            }
            this.myInfo = info;
            this.myFrom = from;
            this.myTo = to;
        }

        @NotNull
        public GitCommitCompareInfo getInfo() {
            GitCommitCompareInfo gitCommitCompareInfo = this.myInfo;
            if (gitCommitCompareInfo == null) {
                DiffInfo.$$$reportNull$$$0(3);
            }
            return gitCommitCompareInfo;
        }

        @NotNull
        public String getFrom() {
            String string = this.myFrom;
            if (string == null) {
                DiffInfo.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public String getTo() {
            String string = this.myTo;
            if (string == null) {
                DiffInfo.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$DiffInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$DiffInfo";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInfo";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFrom";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class BranchInfo {
        @NotNull
        public final Object LOCK;
        @NotNull
        private final ForkInfo myForkInfo;
        @NotNull
        private final String myRemoteName;
        @Nullable
        private SlaveFutureTask<DiffInfo> myDiffInfoTask;
        @Nullable
        private Couple<String> myDefaultMessage;

        public BranchInfo(@NotNull String remoteName, @NotNull ForkInfo fork) {
            if (remoteName == null) {
                BranchInfo.$$$reportNull$$$0(0);
            }
            if (fork == null) {
                BranchInfo.$$$reportNull$$$0(1);
            }
            this.LOCK = new Object();
            this.myRemoteName = remoteName;
            this.myForkInfo = fork;
        }

        @NotNull
        public ForkInfo getForkInfo() {
            ForkInfo forkInfo = this.myForkInfo;
            if (forkInfo == null) {
                BranchInfo.$$$reportNull$$$0(2);
            }
            return forkInfo;
        }

        @NotNull
        public String getRemoteName() {
            String string = this.myRemoteName;
            if (string == null) {
                BranchInfo.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        public SlaveFutureTask<DiffInfo> getDiffInfoTask() {
            return this.myDiffInfoTask;
        }

        public void setDiffInfoTask(@NotNull SlaveFutureTask<DiffInfo> diffInfoTask) {
            if (diffInfoTask == null) {
                BranchInfo.$$$reportNull$$$0(4);
            }
            this.myDiffInfoTask = diffInfoTask;
        }

        @Nullable
        public Couple<String> getDefaultMessage() {
            return this.myDefaultMessage;
        }

        public void setDefaultMessage(@NotNull Couple<String> message) {
            if (message == null) {
                BranchInfo.$$$reportNull$$$0(5);
            }
            this.myDefaultMessage = message;
        }

        public String toString() {
            return this.myRemoteName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "remoteName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fork";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$BranchInfo";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "diffInfoTask";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$BranchInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getForkInfo";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRemoteName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setDiffInfoTask";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setDefaultMessage";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ForkInfo {
        @NotNull
        public final Object LOCK;
        @NotNull
        private final GithubFullPath myPath;
        @NotNull
        private final String myDefaultBranch;
        @NotNull
        private final List<BranchInfo> myBranches;
        @Nullable
        private String myRemoteName;
        private boolean myProposedToCreateRemote;
        @Nullable
        private MasterFutureTask<Void> myFetchTask;

        public ForkInfo(@NotNull GithubFullPath path, @NotNull List<String> branches, @Nullable String defaultBranch) {
            if (path == null) {
                ForkInfo.$$$reportNull$$$0(0);
            }
            if (branches == null) {
                ForkInfo.$$$reportNull$$$0(1);
            }
            this.LOCK = new Object();
            this.myPath = path;
            this.myDefaultBranch = defaultBranch == null ? "master" : defaultBranch;
            this.myBranches = new ArrayList<BranchInfo>();
            for (String branchName : branches) {
                this.myBranches.add(new BranchInfo(branchName, this));
            }
        }

        @NotNull
        public GithubFullPath getPath() {
            GithubFullPath githubFullPath = this.myPath;
            if (githubFullPath == null) {
                ForkInfo.$$$reportNull$$$0(2);
            }
            return githubFullPath;
        }

        @Nullable
        public String getRemoteName() {
            return this.myRemoteName;
        }

        @NotNull
        public String getDefaultBranch() {
            String string = this.myDefaultBranch;
            if (string == null) {
                ForkInfo.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public List<BranchInfo> getBranches() {
            List<BranchInfo> list = this.myBranches;
            if (list == null) {
                ForkInfo.$$$reportNull$$$0(4);
            }
            return list;
        }

        public void setRemoteName(@NotNull String remoteName) {
            if (remoteName == null) {
                ForkInfo.$$$reportNull$$$0(5);
            }
            this.myRemoteName = remoteName;
        }

        public boolean isProposedToCreateRemote() {
            return this.myProposedToCreateRemote;
        }

        public void setProposedToCreateRemote(boolean proposedToCreateRemote) {
            this.myProposedToCreateRemote = proposedToCreateRemote;
        }

        @Nullable
        public MasterFutureTask<Void> getFetchTask() {
            return this.myFetchTask;
        }

        public void setFetchTask(@NotNull MasterFutureTask<Void> fetchTask) {
            if (fetchTask == null) {
                ForkInfo.$$$reportNull$$$0(6);
            }
            this.myFetchTask = fetchTask;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ForkInfo info = (ForkInfo)o;
            return this.myPath.equals(info.myPath);
        }

        public int hashCode() {
            return this.myPath.hashCode();
        }

        public String toString() {
            return this.myPath.getUser() + ":" + this.myPath.getRepository();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branches";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$ForkInfo";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "remoteName";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fetchTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$ForkInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultBranch";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBranches";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setRemoteName";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setFetchTask";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

