/*
 * Decompiled with CFR 0.152.
 */
package org.projectlibre.core.configuration;

import com.projectlibre.core.fields.FieldManager;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import org.projectlibre.core.configuration.ConfigurationFile;
import org.projectlibre.core.dictionary.Dictionary;
import org.projectlibre.core.dictionary.DictionaryCategory;
import org.projectlibre.core.dictionary.HasStringId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration {
    protected static Configuration instance;
    protected List<ConfigurationFile> configurations = new ArrayList<ConfigurationFile>();
    protected Dictionary dictionary = new Dictionary();
    protected FieldManager fieldManager = new FieldManager();

    public static synchronized Configuration getInstance() {
        if (instance == null) {
            instance = new Configuration();
        }
        return instance;
    }

    public Dictionary getDictionary() {
        return this.dictionary;
    }

    public synchronized void register(String string, Class<?> ... classArray) {
        this.configurations.add(new ConfigurationFile(string, classArray));
    }

    public synchronized void load() {
        for (ConfigurationFile configurationFile : this.configurations) {
            if (configurationFile.isBinded()) continue;
            configurationFile.setRoot(this.load(configurationFile.getFile(), configurationFile.getClassesToBeBound()));
            configurationFile.setBinded(true);
        }
    }

    public synchronized Object load(String string, Class<?> ... classArray) {
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])classArray);
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            unmarshaller.setSchema(null);
            unmarshaller.setListener((Unmarshaller.Listener)new DictionaryListener());
            InputStream inputStream = Configuration.class.getClassLoader().getResourceAsStream(string);
            return unmarshaller.unmarshal(inputStream);
        }
        catch (JAXBException jAXBException) {
            jAXBException.printStackTrace();
            return null;
        }
    }

    public synchronized void save(String string, Object object, Class<?> clazz) {
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Marshaller marshaller = jAXBContext.createMarshaller();
            marshaller.marshal(object, new File(string));
        }
        catch (JAXBException jAXBException) {
            jAXBException.printStackTrace();
        }
    }

    public static synchronized void dump(Object object, OutputStream outputStream) {
        Configuration.dump(object.getClass(), object, outputStream);
    }

    public static synchronized void dump(Class<?> clazz, Object object, OutputStream outputStream) {
        if (object == null) {
            System.out.println("null");
        } else {
            try {
                JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
                Marshaller marshaller = jAXBContext.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
                marshaller.marshal(object, outputStream);
            }
            catch (PropertyException propertyException) {
                propertyException.printStackTrace();
            }
            catch (JAXBException jAXBException) {
                jAXBException.printStackTrace();
            }
        }
    }

    public synchronized void dumpDictionary() {
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])this.dictionary.getClassesAsArray());
            Marshaller marshaller = jAXBContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            for (DictionaryCategory dictionaryCategory : this.dictionary.keySet()) {
                System.out.println("============================== " + dictionaryCategory + " ===============================");
                Map<String, HasStringId> map = this.dictionary.get(dictionaryCategory);
                for (String string : map.keySet()) {
                    System.out.println("------------------ " + string + " ------------------");
                    marshaller.marshal((Object)map.get(string), (OutputStream)System.out);
                }
            }
        }
        catch (PropertyException propertyException) {
            propertyException.printStackTrace();
        }
        catch (JAXBException jAXBException) {
            jAXBException.printStackTrace();
        }
    }

    public FieldManager getFieldManager() {
        return this.fieldManager;
    }

    public class DictionaryListener
    extends Unmarshaller.Listener {
        public void beforeUnmarshal(Object object, Object object2) {
        }

        public void afterUnmarshal(Object object, Object object2) {
            if (object instanceof HasStringId) {
                Configuration.this.dictionary.add((HasStringId)object);
            }
        }
    }
}

