/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.RecurrenceType;

public final class RecurringTask {
    private static final String[] ORDINAL = new String[]{null, "every", "every other", "every 3rd", "every 4th", "every 5th", "every 6th", "every 7th", "every 8th", "every 9th", "every 10th", "every 11th", "every 12th"};
    private static final String[] DAY_ORDINAL = new String[]{null, "First", "Second", "Third", "Fourth", "Last"};
    private Date m_startDate;
    private Date m_finishDate;
    private Duration m_duration;
    private Integer m_occurrences;
    private RecurrenceType m_recurrenceType;
    private boolean m_useEndDate;
    private Integer m_dailyFrequency;
    private boolean m_dailyWorkday;
    private Integer m_weeklyFrequency;
    private Integer m_weeklyDays;
    private boolean m_monthlyRelative;
    private Integer m_monthlyRelativeOrdinal;
    private Day m_monthlyRelativeDay;
    private Integer m_monthlyRelativeFrequency;
    private Integer m_monthlyAbsoluteDay;
    private Integer m_monthlyAbsoluteFrequency;
    private boolean m_yearlyAbsolute;
    private Date m_yearlyAbsoluteDate;
    private Integer m_yearlyRelativeOrdinal;
    private Day m_yearlyRelativeDay;
    private Integer m_yearlyRelativeMonth;

    public Date getStartDate() {
        return this.m_startDate;
    }

    public void setStartDate(Date date) {
        this.m_startDate = date;
    }

    public Date getFinishDate() {
        return this.m_finishDate;
    }

    public void setFinishDate(Date date) {
        this.m_finishDate = date;
    }

    public Duration getDuration() {
        return this.m_duration;
    }

    public void setDuration(Duration duration) {
        this.m_duration = duration;
    }

    public Integer getOccurrences() {
        return this.m_occurrences;
    }

    public void setOccurrences(Integer n) {
        this.m_occurrences = n;
    }

    public RecurrenceType getRecurrenceType() {
        return this.m_recurrenceType;
    }

    public void setRecurrenceType(RecurrenceType recurrenceType) {
        this.m_recurrenceType = recurrenceType;
    }

    public boolean getUseEndDate() {
        return this.m_useEndDate;
    }

    public void setUseEndDate(boolean bl) {
        this.m_useEndDate = bl;
    }

    public boolean getDailyWorkday() {
        return this.m_dailyWorkday;
    }

    public void setDailyWorkday(boolean bl) {
        this.m_dailyWorkday = bl;
    }

    public Integer getWeeklyDays() {
        return this.m_weeklyDays;
    }

    public void setWeeklyDays(Integer n) {
        this.m_weeklyDays = n;
    }

    public boolean getMonthlyRelative() {
        return this.m_monthlyRelative;
    }

    public void setMonthlyRelative(boolean bl) {
        this.m_monthlyRelative = bl;
    }

    public boolean getYearlyAbsolute() {
        return this.m_yearlyAbsolute;
    }

    public void setYearlyAbsolute(boolean bl) {
        this.m_yearlyAbsolute = bl;
    }

    public Integer getDailyFrequency() {
        return this.m_dailyFrequency;
    }

    public void setDailyFrequency(Integer n) {
        this.m_dailyFrequency = n;
    }

    public Integer getWeeklyFrequency() {
        return this.m_weeklyFrequency;
    }

    public void setWeeklyFrequency(Integer n) {
        this.m_weeklyFrequency = n;
    }

    public Integer getMonthlyRelativeOrdinal() {
        return this.m_monthlyRelativeOrdinal;
    }

    public void setMonthlyRelativeOrdinal(Integer n) {
        this.m_monthlyRelativeOrdinal = n;
    }

    public Day getMonthlyRelativeDay() {
        return this.m_monthlyRelativeDay;
    }

    public void setMonthlyRelativeDay(Day day) {
        this.m_monthlyRelativeDay = day;
    }

    public Integer getMonthlyRelativeFrequency() {
        return this.m_monthlyRelativeFrequency;
    }

    public void setMonthlyRelativeFrequency(Integer n) {
        this.m_monthlyRelativeFrequency = n;
    }

    public Integer getMonthlyAbsoluteDay() {
        return this.m_monthlyAbsoluteDay;
    }

    public void setMonthlyAbsoluteDay(Integer n) {
        this.m_monthlyAbsoluteDay = n;
    }

    public Integer getMonthlyAbsoluteFrequency() {
        return this.m_monthlyAbsoluteFrequency;
    }

    public void setMonthlyAbsoluteFrequency(Integer n) {
        this.m_monthlyAbsoluteFrequency = n;
    }

    public Integer getYearlyRelativeOrdinal() {
        return this.m_yearlyRelativeOrdinal;
    }

    public void setYearlyRelativeOrdinal(Integer n) {
        this.m_yearlyRelativeOrdinal = n;
    }

    public Day getYearlyRelativeDay() {
        return this.m_yearlyRelativeDay;
    }

    public void setYearlyRelativeDay(Day day) {
        this.m_yearlyRelativeDay = day;
    }

    public Integer getYearlyRelativeMonth() {
        return this.m_yearlyRelativeMonth;
    }

    public void setYearlyRelativeMonth(Integer n) {
        this.m_yearlyRelativeMonth = n;
    }

    public Date getYearlyAbsoluteDate() {
        return this.m_yearlyAbsoluteDate;
    }

    public void setYearlyAbsoluteDate(Date date) {
        this.m_yearlyAbsoluteDate = date;
    }

    public String toString() {
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("d MMM");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        printWriter.print("[RecurringTask");
        if (this.m_duration != null) {
            printWriter.print(" Duration " + this.m_duration);
            printWriter.print(" This Occurs " + this.m_recurrenceType);
            switch (this.m_recurrenceType) {
                case DAILY: {
                    printWriter.print(" " + ORDINAL[this.m_dailyFrequency]);
                    printWriter.print(this.m_dailyWorkday ? " Workday" : " Day");
                    break;
                }
                case WEEKLY: {
                    printWriter.print(" " + ORDINAL[this.m_weeklyFrequency]);
                    printWriter.print(" week on ");
                    if ((this.m_weeklyDays & 0x40) != 0) {
                        printWriter.print("Sunday");
                    }
                    if ((this.m_weeklyDays & 0x20) != 0) {
                        printWriter.print("Monday");
                    }
                    if ((this.m_weeklyDays & 0x10) != 0) {
                        printWriter.print("Tuesday");
                    }
                    if ((this.m_weeklyDays & 8) != 0) {
                        printWriter.print("Wednesday");
                    }
                    if ((this.m_weeklyDays & 4) != 0) {
                        printWriter.print("Thursday");
                    }
                    if ((this.m_weeklyDays & 2) != 0) {
                        printWriter.print("Friday");
                    }
                    if ((this.m_weeklyDays & 1) == 0) break;
                    printWriter.print("Saturday");
                    break;
                }
                case MONTHLY: {
                    if (this.m_monthlyRelative) {
                        printWriter.print(" on The ");
                        printWriter.print(DAY_ORDINAL[this.m_monthlyRelativeOrdinal]);
                        printWriter.print(" ");
                        printWriter.print(dateFormatSymbols.getWeekdays()[this.m_monthlyRelativeDay.getValue()]);
                        printWriter.print(" of ");
                        printWriter.print(ORDINAL[this.m_monthlyRelativeFrequency]);
                    } else {
                        printWriter.print(" on Day ");
                        printWriter.print(this.m_monthlyAbsoluteDay);
                        printWriter.print(" of ");
                        printWriter.print(ORDINAL[this.m_monthlyAbsoluteFrequency]);
                    }
                    printWriter.print(" month");
                    break;
                }
                case YEARLY: {
                    printWriter.print(" on the ");
                    if (this.m_yearlyAbsolute) {
                        printWriter.print(simpleDateFormat.format(this.m_yearlyAbsoluteDate));
                        break;
                    }
                    printWriter.print(DAY_ORDINAL[this.m_yearlyRelativeOrdinal]);
                    printWriter.print(" ");
                    printWriter.print(dateFormatSymbols.getWeekdays()[this.m_yearlyRelativeDay.getValue()]);
                    printWriter.print(" of ");
                    printWriter.print(dateFormatSymbols.getMonths()[this.m_yearlyRelativeMonth - 1]);
                }
            }
            printWriter.print(" From " + this.m_startDate);
            printWriter.print(" For " + this.m_occurrences + " occurrences");
            printWriter.print(" To " + this.m_finishDate);
        }
        printWriter.println("]");
        printWriter.flush();
        return byteArrayOutputStream.toString();
    }
}

