/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.model.cache;

import com.projity.association.AssociationList;
import com.projity.association.InvalidAssociationException;
import com.projity.document.Document;
import com.projity.document.ObjectEvent;
import com.projity.graphic.configuration.GraphicConfiguration;
import com.projity.grouping.core.Node;
import com.projity.grouping.core.event.HierarchyEvent;
import com.projity.grouping.core.event.HierarchyListener;
import com.projity.grouping.core.hierarchy.NodeHierarchy;
import com.projity.grouping.core.model.NodeModel;
import com.projity.pm.assignment.Assignment;
import com.projity.pm.dependency.Dependency;
import com.projity.pm.dependency.DependencyService;
import com.projity.pm.dependency.HasDependencies;
import com.projity.pm.graphic.model.cache.DependencyCache;
import com.projity.pm.graphic.model.cache.GraphicDependency;
import com.projity.pm.graphic.model.cache.GraphicNode;
import com.projity.pm.graphic.model.cache.NodeCache;
import com.projity.pm.graphic.model.cache.VisibleDependencies;
import com.projity.pm.graphic.model.cache.VisibleNodes;
import com.projity.pm.resource.Resource;
import com.projity.pm.scheduling.ScheduleEvent;
import com.projity.pm.scheduling.ScheduleEventListener;
import com.projity.pm.task.Project;
import com.projity.pm.task.Task;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class ReferenceNodeModelCache
implements ObjectEvent.Listener,
HierarchyListener,
ScheduleEventListener {
    private NodeModel model;
    protected NodeCache nodeCache;
    protected DependencyCache edgeCache;
    protected Document document;
    protected int type;
    protected boolean receiveEvents = true;
    protected GraphicNode root = null;

    public ReferenceNodeModelCache(NodeModel nodeModel, Document document, int n) {
        this.document = document;
        this.nodeCache = new NodeCache();
        this.edgeCache = new DependencyCache();
        this.setModel(nodeModel);
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public GraphicNode getGraphicNode(Node node) {
        return (GraphicNode)this.nodeCache.getElement(node);
    }

    public void bindView(VisibleNodes visibleNodes, VisibleDependencies visibleDependencies) {
        this.nodeCache.addVisibleElements(visibleNodes);
        this.edgeCache.addVisibleElements(visibleDependencies);
    }

    public void unbindView(VisibleNodes visibleNodes, VisibleDependencies visibleDependencies) {
        this.nodeCache.addVisibleElements(visibleNodes);
        this.edgeCache.addVisibleElements(visibleDependencies);
    }

    public void close() {
        if (this.model != null) {
            this.removeListeners();
            this.nodeCache.removeAllVisibleElements();
            this.nodeCache.clear();
            this.edgeCache.removeAllVisibleElements();
            this.edgeCache.clear();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    private void removeListeners() {
        this.model.getHierarchy().removeHierarchyListener(this);
        if (this.document != null) {
            this.document.removeObjectListener(this);
        }
        if (this.document != null && this.document instanceof Project) {
            ((Project)this.document).removeScheduleListener(this);
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public GraphicNode getParent(GraphicNode graphicNode) {
        Node node = this.getModel().getHierarchy().getParent(graphicNode.getNode());
        return (GraphicNode)this.nodeCache.getElement(node);
    }

    public List getChildren(GraphicNode graphicNode) {
        List list = this.getModel().getHierarchy().getChildren(graphicNode == null ? null : graphicNode.getNode());
        if (list == null) {
            return null;
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object = this.nodeCache.getElement(iterator.next());
            if (object == null) continue;
            linkedList.add(object);
        }
        return linkedList;
    }

    public List getEdges() {
        return this.edgeCache.getCache();
    }

    public Object getGraphicNode(Object object) {
        return this.nodeCache.getElement(object);
    }

    public Object getGraphicDependency(Object object) {
        return this.edgeCache.getElement(object);
    }

    public void update() {
        this.update(new HashSet(), false);
    }

    public void update(boolean bl) {
        this.update(new HashSet(), bl);
    }

    public void update(Set set, boolean bl) {
        NodeCache nodeCache = new NodeCache();
        this.update(null, nodeCache, set, bl);
        HashSet hashSet = new HashSet();
        this.updateEdges(hashSet);
        this.nodeCache.copyContent(nodeCache);
        this.updateVisibleElements(set, hashSet);
    }

    protected void updateVisibleElements(Set set, Set set2) {
        this.nodeCache.updateVisibleElements(set);
        this.edgeCache.updateVisibleElements(set2);
        this.nodeCache.fireEvents(this);
    }

    protected void updateVisibleElements(VisibleNodes visibleNodes) {
        this.nodeCache.updateVisibleElements(visibleNodes, new HashSet());
        this.edgeCache.updateVisibleElements(visibleNodes.getVisibleDependencies(), new HashSet());
        this.nodeCache.fireEvents(this, visibleNodes);
    }

    public void updateEdges(Set set) {
        ListIterator listIterator = this.edgeCache.getCacheIterator();
        while (listIterator.hasNext()) {
            GraphicDependency graphicDependency = (GraphicDependency)listIterator.next();
            if (!graphicDependency.isDirty()) continue;
            graphicDependency.setDirty(false);
            set.add(graphicDependency);
        }
    }

    public void update(GraphicNode graphicNode, NodeCache nodeCache, Set set, boolean bl) {
        int n = graphicNode == null ? 0 : graphicNode.getLevel();
        int n2 = GraphicConfiguration.getInstance().getCollapseLevel();
        List list = this.model.getHierarchy().getChildren(graphicNode == null ? null : graphicNode.getNode());
        boolean bl2 = false;
        if (list != null) {
            for (Node node : list) {
                GraphicNode graphicNode2;
                Object object = node.getImpl();
                if (!(object instanceof Assignment)) {
                    bl2 = true;
                }
                if ((graphicNode2 = (GraphicNode)this.nodeCache.getElement(node)) == null) {
                    graphicNode2 = this.createNode(node);
                    if (n2 != -1 && n >= n2 - 1) {
                        graphicNode2.setCollapsed(true);
                    }
                }
                nodeCache.insertElement(graphicNode2, graphicNode2.getNode());
                if (graphicNode2.getLevel() != n + 1) {
                    graphicNode2.setLevel(n + 1);
                }
                if (graphicNode2.isVoid() && !graphicNode2.getNode().isVoid()) {
                    graphicNode2.setVoid(false);
                } else if (!graphicNode2.isVoid() && graphicNode2.getNode().isVoid()) {
                    graphicNode2.setVoid(true);
                }
                if (bl && object instanceof Task && ((Task)object).isJustModified()) {
                    graphicNode2.setDirty(true);
                }
                if (graphicNode2.isDirty()) {
                    set.add(graphicNode2);
                    graphicNode2.setDirty(false);
                }
                this.update(graphicNode2, nodeCache, set, bl);
            }
        }
        if (graphicNode != null) {
            boolean bl3;
            boolean bl4 = bl3 = list != null && list.size() != 0;
            if (graphicNode.isComposite() != bl3) {
                graphicNode.setComposite(bl3);
            }
            if (graphicNode.isSummary() != bl2) {
                graphicNode.setSummary(bl2);
            }
            if (graphicNode.isDirty()) {
                set.add(graphicNode);
                graphicNode.setDirty(false);
            }
            graphicNode.updateScheduleCache();
        }
    }

    public NodeModel getModel() {
        return this.model;
    }

    public void setModel(NodeModel nodeModel) {
        if (this.model != null) {
            this.removeListeners();
        }
        this.model = nodeModel;
        nodeModel.getHierarchy().addHierarchyListener(this);
        if (this.document != null) {
            this.document.addObjectListener(this);
        }
        if (this.document != null && this.document instanceof Project) {
            ((Project)this.document).addScheduleListener(this);
        }
        this.buildCache();
    }

    private void buildCache() {
        this.nodeCache.clear();
        this.getModel().getHierarchy().checkEndVoidNodes(0);
        this.update();
        this.buildEdges();
        this.syncEdges();
    }

    public void changeCollapsedState(GraphicNode graphicNode) {
        if (graphicNode.isComposite()) {
            graphicNode.setCollapsed(!graphicNode.isCollapsed());
        }
        this.update();
    }

    public void buildEdges() {
        HashMap<Object, GraphicNode> hashMap = new HashMap<Object, GraphicNode>();
        ArrayList<GraphicNode> arrayList = new ArrayList<GraphicNode>();
        for (GraphicNode graphicNode : this.nodeCache.getCache()) {
            if (graphicNode.isVoid() || graphicNode.isAssignment()) continue;
            if (!(graphicNode.getNode().getImpl() instanceof HasDependencies)) {
                return;
            }
            arrayList.add(graphicNode);
            hashMap.put(graphicNode.getNode().getImpl(), graphicNode);
        }
        for (GraphicNode graphicNode : arrayList) {
            HasDependencies hasDependencies = (HasDependencies)graphicNode.getNode().getImpl();
            AssociationList associationList = hasDependencies.getSuccessorList();
            for (Dependency dependency : associationList) {
                HasDependencies hasDependencies2 = dependency.getPredecessor();
                HasDependencies hasDependencies3 = dependency.getSuccessor();
                GraphicNode graphicNode2 = (GraphicNode)hashMap.get(hasDependencies2);
                GraphicNode graphicNode3 = (GraphicNode)hashMap.get(hasDependencies3);
                if (graphicNode2 != null && graphicNode3 != null) {
                    this.newGraphicDependency(graphicNode2, graphicNode3, dependency);
                    continue;
                }
                System.out.println("no graphic node");
            }
        }
    }

    public GraphicDependency newGraphicDependency(GraphicNode graphicNode, GraphicNode graphicNode2, Dependency dependency) {
        GraphicDependency graphicDependency = new GraphicDependency(graphicNode, graphicNode2, dependency);
        int n = dependency.getDependencyType();
        this.edgeCache.insertElement(graphicDependency, dependency);
        return graphicDependency;
    }

    private void syncEdges() {
        this.edgeCache.updateAllVisibleElements();
    }

    public void createDependency(GraphicNode graphicNode, GraphicNode graphicNode2) throws InvalidAssociationException {
        DependencyService dependencyService = DependencyService.getInstance();
        HasDependencies hasDependencies = (HasDependencies)graphicNode.getNode().getImpl();
        HasDependencies hasDependencies2 = (HasDependencies)graphicNode2.getNode().getImpl();
        Dependency dependency = dependencyService.newDependency(hasDependencies, hasDependencies2, 1, 0L, this);
    }

    public void removeEdge(GraphicDependency graphicDependency) {
        if (graphicDependency == null) {
            return;
        }
        this.edgeCache.deleteElement(graphicDependency);
    }

    public void modifyEdge(GraphicDependency graphicDependency, int n) {
        if (n != -1) {
            // empty if block
        }
    }

    protected int getLevel(Node node) {
        int n = 0;
        NodeHierarchy nodeHierarchy = this.getModel().getHierarchy();
        Node node2 = node;
        while (node2 != null) {
            ++n;
            node2 = nodeHierarchy.getParent(node2);
        }
        return n;
    }

    protected boolean isComposite(Node node) {
        return !this.getModel().getHierarchy().isLeaf(node);
    }

    protected boolean isSummary(Node node) {
        return this.getModel().getHierarchy().isSummary(node);
    }

    public GraphicNode createNode(Node node) {
        return new GraphicNode(node, -1);
    }

    public boolean isReceiveEvents() {
        return this.receiveEvents;
    }

    public void setReceiveEvents(boolean bl) {
        this.receiveEvents = bl;
    }

    public void scheduleChanged(ScheduleEvent scheduleEvent) {
        if (!this.receiveEvents) {
            return;
        }
        this.update(true);
    }

    public void objectChanged(ObjectEvent objectEvent) {
        if (!this.receiveEvents) {
            return;
        }
        Object object = objectEvent.getObject();
        if (object instanceof Dependency) {
            Dependency dependency = (Dependency)object;
            if (dependency.getDocument() == this.document || dependency.getMasterDocument() == this.document) {
                if (objectEvent.isCreate()) {
                    GraphicDependency graphicDependency;
                    Node node = this.model.search(dependency.getPredecessor());
                    Node node2 = this.model.search(dependency.getSuccessor());
                    GraphicNode graphicNode = (GraphicNode)this.nodeCache.getElement(node);
                    GraphicNode graphicNode2 = (GraphicNode)this.nodeCache.getElement(node2);
                    if (graphicNode != null && graphicNode2 != null && (graphicDependency = (GraphicDependency)this.edgeCache.getElement(dependency)) == null) {
                        graphicDependency = this.newGraphicDependency(graphicNode, graphicNode2, dependency);
                        this.update();
                    }
                } else if (objectEvent.isDelete()) {
                    GraphicDependency graphicDependency = (GraphicDependency)this.edgeCache.getElement(dependency);
                    if (graphicDependency != null) {
                        this.removeEdge(graphicDependency);
                        this.update();
                    }
                } else {
                    GraphicDependency graphicDependency = (GraphicDependency)this.edgeCache.getElement(dependency);
                    if (graphicDependency != null) {
                        this.modifyEdge(graphicDependency, dependency.getDependencyType());
                        this.update();
                    }
                }
            }
        } else if (object != null && (object instanceof Task && (this.type & 2) == 2 || object instanceof Resource && (this.type & 4) == 4 || object instanceof Assignment && (this.type & 1) == 1 || object instanceof Project && (this.type & 8) == 8)) {
            Node node;
            if (object != null && !objectEvent.isDelete() && (node = this.model.search(object)) != null) {
                while (!node.isRoot()) {
                    GraphicNode graphicNode = this.getGraphicNode(node);
                    if (graphicNode != null) {
                        graphicNode.setDirty(true);
                    }
                    node = this.model.getParent(node);
                }
            }
            this.update();
        }
    }

    public void nodesChanged(HierarchyEvent hierarchyEvent) {
        if (this.receiveEvents && !hierarchyEvent.isConsumed()) {
            this.update();
        }
    }

    public void nodesInserted(HierarchyEvent hierarchyEvent) {
        if (this.receiveEvents && !hierarchyEvent.isConsumed()) {
            this.update();
        }
    }

    public void nodesRemoved(HierarchyEvent hierarchyEvent) {
        if (this.receiveEvents && !hierarchyEvent.isConsumed()) {
            this.update();
        }
    }

    public void structureChanged(HierarchyEvent hierarchyEvent) {
        if (this.receiveEvents && !hierarchyEvent.isConsumed()) {
            this.update();
        }
    }

    public Object getRoot() {
        if (this.root == null) {
            this.root = new GraphicNode((Node)this.model.getRoot(), 0);
        }
        return this.root;
    }

    public String toString() {
        return this.nodeCache.getVisibleElements().toString();
    }
}

