/*
 * Decompiled with CFR 0.152.
 */
package com.projity.grouping.core.transform;

import com.projity.grouping.core.transform.CommonTransform;
import com.projity.grouping.core.transform.TransformId;
import com.projity.grouping.core.transform.TransformList;
import com.projity.grouping.core.transform.ViewTransformerEvent;
import com.projity.grouping.core.transform.ViewTransformerListener;
import com.projity.grouping.core.transform.filtering.NodeFilter;
import com.projity.grouping.core.transform.grouping.NodeGrouper;
import com.projity.grouping.core.transform.sorting.NodeSorter;
import com.projity.grouping.core.transform.transformer.NodeTransformer;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.event.EventListenerList;
import org.apache.commons.collections.Closure;

public class ViewTransformer {
    public static final String FILTER_NONE_ID = "Filter.None";
    public static final String SORTER_NONE_ID = "Sorter.None";
    public static final String GROUPER_NONE_ID = "Grouper.None";
    protected List filters = null;
    protected List sorters = null;
    protected List groupers = null;
    protected NodeFilter hiddenFilter;
    protected NodeFilter userFilter;
    protected NodeSorter hiddenSorter;
    protected NodeTransformer transformer;
    protected NodeSorter userSorter;
    protected NodeGrouper hiddenGrouper;
    protected NodeGrouper userGrouper;
    protected String hiddenFilterId;
    protected String userFilterId = "Filter.None";
    protected String hiddenSorterId;
    protected String userSorterId = "Sorter.None";
    protected String hiddenGrouperId;
    protected String userGrouperId = "Grouper.None";
    protected String transformerId;
    protected boolean hiddenFilterIdDirty = false;
    protected boolean userFilterIdDirty = false;
    protected boolean hiddenSorterIdDirty = false;
    protected boolean userSorterIdDirty = false;
    protected boolean hiddenGrouperIdDirty = false;
    protected boolean userGrouperIdDirty = false;
    protected boolean transformerIdDirty = false;
    private Closure redefinition = new Closure(){

        public void execute(Object object) {
            ViewTransformer.this.fireTransformerChanged(object);
        }
    };
    protected EventListenerList listenerList = new EventListenerList();

    public List getFilterList() {
        return this.filters;
    }

    public void setFilters(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";, \t");
        this.filters = new ArrayList();
        while (stringTokenizer.hasMoreTokens()) {
            this.filters.add(stringTokenizer.nextToken());
        }
    }

    public List getSorterList() {
        return this.sorters;
    }

    public void setSorters(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";, \t");
        this.sorters = new ArrayList();
        while (stringTokenizer.hasMoreTokens()) {
            this.sorters.add(stringTokenizer.nextToken());
        }
    }

    public List getGrouperList() {
        return this.groupers;
    }

    public void setGroupers(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";, \t");
        this.groupers = new ArrayList();
        while (stringTokenizer.hasMoreTokens()) {
            this.groupers.add(stringTokenizer.nextToken());
        }
    }

    public void setFilterId(TransformId transformId) {
        if (transformId.isHidden()) {
            this.hiddenFilterId = transformId.getId();
            this.hiddenFilterIdDirty = true;
        } else {
            this.userFilterId = transformId.getId();
            this.userFilterIdDirty = true;
        }
    }

    public void setSorterId(TransformId transformId) {
        if (transformId.isHidden()) {
            this.hiddenSorterId = transformId.getId();
            this.hiddenSorterIdDirty = true;
        } else {
            this.userSorterId = transformId.getId();
            this.userSorterIdDirty = true;
        }
    }

    public void setGrouperId(TransformId transformId) {
        if (transformId.isHidden()) {
            this.hiddenGrouperId = transformId.getId();
            this.hiddenGrouperIdDirty = true;
        } else {
            this.userGrouperId = transformId.getId();
            this.userGrouperIdDirty = true;
        }
    }

    public void setTransformerId(TransformId transformId) {
        this.transformerId = transformId.getId();
        this.transformerIdDirty = true;
    }

    public String getHiddenFilterId() {
        return this.hiddenFilterId;
    }

    public void setHiddenFilterId(String string) {
        this.hiddenFilterId = string;
        this.hiddenFilterIdDirty = true;
        this.fireTransformerChanged(this);
    }

    public String getHiddenGrouperId() {
        return this.hiddenGrouperId;
    }

    public void setHiddenGrouperId(String string) {
        this.hiddenGrouperId = string;
        this.hiddenGrouperIdDirty = true;
        this.fireTransformerChanged(this);
    }

    public String getHiddenSorterId() {
        return this.hiddenSorterId;
    }

    public void setHiddenSorterId(String string) {
        this.hiddenSorterId = string;
        this.hiddenSorterIdDirty = true;
        this.fireTransformerChanged(this);
    }

    public String getUserFilterId() {
        return this.userFilterId;
    }

    public void setUserFilterId(String string) {
        this.userFilterId = string;
        this.userFilterIdDirty = true;
        this.fireTransformerChanged(this);
    }

    public String getUserGrouperId() {
        return this.userGrouperId;
    }

    public void setUserGrouperId(String string) {
        this.userGrouperId = string;
        this.userGrouperIdDirty = true;
        this.fireTransformerChanged(this);
    }

    public String getUserSorterId() {
        return this.userSorterId;
    }

    public void setUserSorterId(String string) {
        this.userSorterId = string;
        this.userSorterIdDirty = true;
        this.fireTransformerChanged(this);
    }

    public String getTransformerId() {
        return this.transformerId;
    }

    public void setTransformerId(String string) {
        this.transformerId = string;
        this.transformerIdDirty = true;
        this.fireTransformerChanged(this);
    }

    public void update() {
        this.fireTransformerChanged(this);
    }

    private CommonTransform getTransform(String string, String string2) {
        TransformList transformList = TransformList.getInstance(string);
        if (transformList == null) {
            return null;
        }
        CommonTransform commonTransform = (CommonTransform)transformList.getTransform(string2);
        if (commonTransform != null) {
            commonTransform.askForParameters();
        }
        return commonTransform;
    }

    public NodeFilter getHiddenFilter() {
        if (this.hiddenFilterIdDirty) {
            this.hiddenFilter = (NodeFilter)this.getTransform("hidden_filters", this.hiddenFilterId);
            this.hiddenFilter.setRedefinitionCallBack(this.redefinition);
            this.hiddenFilterIdDirty = false;
        }
        return this.hiddenFilter;
    }

    public void setHiddenFilter(NodeFilter nodeFilter) {
        this.hiddenFilter = nodeFilter;
    }

    public NodeGrouper getHiddenGrouper() {
        if (this.hiddenGrouperIdDirty) {
            this.hiddenGrouper = (NodeGrouper)this.getTransform("hidden_groupers", this.hiddenGrouperId);
            this.hiddenGrouper.setRedefinitionCallBack(this.redefinition);
            this.hiddenGrouperIdDirty = false;
        }
        return this.hiddenGrouper;
    }

    public void setHiddenGrouper(NodeGrouper nodeGrouper) {
        this.hiddenGrouper = nodeGrouper;
    }

    public NodeSorter getHiddenSorter() {
        if (this.hiddenSorterIdDirty) {
            this.hiddenSorter = (NodeSorter)this.getTransform("hidden_sorters", this.hiddenSorterId);
            this.hiddenSorter.setRedefinitionCallBack(this.redefinition);
            this.hiddenSorterIdDirty = false;
        }
        return this.hiddenSorter;
    }

    public void setHiddenSorter(NodeSorter nodeSorter) {
        this.hiddenSorter = nodeSorter;
    }

    public NodeFilter getUserFilter() {
        if (this.userFilterIdDirty) {
            this.userFilter = (NodeFilter)this.getTransform("user_filters", this.userFilterId);
            this.userFilterIdDirty = false;
        }
        return this.userFilter;
    }

    public void setUserFilter(NodeFilter nodeFilter) {
        this.userFilter = nodeFilter;
    }

    public NodeGrouper getUserGrouper() {
        if (this.userGrouperIdDirty) {
            this.userGrouper = (NodeGrouper)this.getTransform("user_groupers", this.userGrouperId);
            this.userGrouperIdDirty = false;
        }
        return this.userGrouper;
    }

    public void setUserGrouper(NodeGrouper nodeGrouper) {
        this.userGrouper = nodeGrouper;
    }

    public NodeSorter getUserSorter() {
        if (this.userSorterIdDirty) {
            this.userSorter = (NodeSorter)this.getTransform("user_sorters", this.userSorterId);
            this.userSorterIdDirty = false;
        }
        return this.userSorter;
    }

    public void setUserSorter(NodeSorter nodeSorter) {
        this.userSorter = nodeSorter;
    }

    public NodeTransformer getTransformer() {
        if (this.transformerIdDirty) {
            this.transformer = (NodeTransformer)this.getTransform("transformers", this.transformerId);
            this.transformerIdDirty = false;
        }
        return this.transformer;
    }

    public void settransformer(NodeTransformer nodeTransformer) {
        this.transformer = nodeTransformer;
    }

    public boolean isShowSummary() {
        if (!this.isShowSummary(this.getHiddenFilter())) {
            return false;
        }
        if (!this.isShowSummary(this.getUserFilter())) {
            return false;
        }
        if (!this.isShowSummary(this.getHiddenSorter())) {
            return false;
        }
        if (!this.isShowSummary(this.getUserSorter())) {
            return false;
        }
        if (!this.isShowSummary(this.getHiddenGrouper())) {
            return false;
        }
        return this.isShowSummary(this.getUserGrouper());
    }

    private boolean isShowSummary(CommonTransform commonTransform) {
        return commonTransform == null ? true : commonTransform.isShowSummary();
    }

    public boolean isPreserveHierarchy() {
        if (!this.isPreserveHierarchy(this.getHiddenFilter())) {
            return false;
        }
        if (!this.isPreserveHierarchy(this.getUserFilter())) {
            return false;
        }
        if (!this.isPreserveHierarchy(this.getHiddenSorter())) {
            return false;
        }
        if (!this.isPreserveHierarchy(this.getUserSorter())) {
            return false;
        }
        if (!this.isPreserveHierarchy(this.getHiddenGrouper())) {
            return false;
        }
        return this.isPreserveHierarchy(this.getUserGrouper());
    }

    private boolean isPreserveHierarchy(CommonTransform commonTransform) {
        return commonTransform == null ? true : commonTransform.isPreserveHierarchy();
    }

    public boolean isShowAssignments() {
        if (!this.isShowAssignments(this.getHiddenFilter())) {
            return false;
        }
        if (!this.isShowAssignments(this.getUserFilter())) {
            return false;
        }
        if (!this.isShowAssignments(this.getHiddenSorter())) {
            return false;
        }
        if (!this.isShowAssignments(this.getUserSorter())) {
            return false;
        }
        if (!this.isShowAssignments(this.getHiddenGrouper())) {
            return false;
        }
        return this.isShowAssignments(this.getUserGrouper());
    }

    private boolean isShowAssignments(CommonTransform commonTransform) {
        return commonTransform == null ? true : commonTransform.isShowAssignments();
    }

    public boolean isShowEmptyLines() {
        if (!this.isNoneSorter()) {
            return false;
        }
        if (!this.isNoneGrouper()) {
            return false;
        }
        if (!this.isShowEmptyLines(this.getHiddenFilter())) {
            return false;
        }
        return this.isShowEmptyLines(this.getUserFilter());
    }

    private boolean isShowEmptyLines(CommonTransform commonTransform) {
        return commonTransform == null ? true : commonTransform.isShowEmptyLines();
    }

    public boolean isShowEndEmptyLines() {
        if (!this.isNoneSorter()) {
            return false;
        }
        if (!this.isNoneGrouper()) {
            return false;
        }
        if (!this.isShowEndEmptyLines(this.getHiddenFilter())) {
            return false;
        }
        return this.isShowEndEmptyLines(this.getUserFilter());
    }

    private boolean isShowEndEmptyLines(CommonTransform commonTransform) {
        return commonTransform == null ? true : commonTransform.isShowEndEmptyLines();
    }

    public boolean isShowEmptySummaries() {
        if (!this.isShowEmptySummaries(this.getHiddenFilter())) {
            return false;
        }
        return this.isShowEmptySummaries(this.getUserFilter());
    }

    private boolean isShowEmptySummaries(CommonTransform commonTransform) {
        return commonTransform == null ? true : commonTransform.isShowEmptySummaries();
    }

    public boolean isTreatAssignmentsAsTasks() {
        return false;
    }

    public boolean isNoneFilter() {
        return this.userFilterId == null || FILTER_NONE_ID.equals(this.userFilterId);
    }

    public boolean isNoneSorter() {
        return this.userSorterId == null || SORTER_NONE_ID.equals(this.userSorterId);
    }

    public boolean isNoneGrouper() {
        return this.userGrouperId == null || GROUPER_NONE_ID.equals(this.userGrouperId);
    }

    public void addViewTransformerListener(ViewTransformerListener viewTransformerListener) {
        this.listenerList.add(ViewTransformerListener.class, viewTransformerListener);
    }

    public void removeViewTransformerListener(ViewTransformerListener viewTransformerListener) {
        this.listenerList.remove(ViewTransformerListener.class, viewTransformerListener);
    }

    public ViewTransformerListener[] getTimeScaleListeners() {
        return (ViewTransformerListener[])this.listenerList.getListeners(ViewTransformerListener.class);
    }

    protected void fireTransformerChanged(Object object) {
        Object[] objectArray = this.listenerList.getListenerList();
        ViewTransformerEvent viewTransformerEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ViewTransformerListener.class) continue;
            if (viewTransformerEvent == null) {
                viewTransformerEvent = new ViewTransformerEvent(object);
            }
            ((ViewTransformerListener)objectArray[i + 1]).transformerChanged(viewTransformerEvent);
        }
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }
}

