/*
 * Decompiled with CFR 0.152.
 */
package com.projity.dialog;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.projity.dialog.AbstractDialog;
import com.projity.exchange.ResourceMappingForm;
import com.projity.help.HelpUtil;
import com.projity.strings.Messages;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.apache.commons.beanutils.BeanUtils;

public final class ResourceMappingDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private ResourceMappingForm form;
    protected AssociationTable associationTable;
    protected JComboBox field1;
    protected JComboBox editorCombo;
    protected JLabel field1Label;
    protected JLabel accessControlLabel;
    protected JCheckBox localProject;
    protected JCheckBox masterProject = null;
    protected JComboBox accessControl;

    public static ResourceMappingDialog getInstance(ResourceMappingForm resourceMappingForm) {
        return new ResourceMappingDialog(resourceMappingForm);
    }

    private ResourceMappingDialog(ResourceMappingForm resourceMappingForm) {
        super(resourceMappingForm.getOwner(), Messages.getString("ResourceMappingDialog.ResourceMerging"), true);
        this.form = resourceMappingForm;
        this.addDocHelp("Merge_Dialog");
    }

    public void setForm(ResourceMappingForm resourceMappingForm) {
        this.form = resourceMappingForm;
    }

    protected void initControls() {
        this.editorCombo = new JComboBox();
        this.associationTable = new AssociationTable();
        this.field1 = new JComboBox();
        this.field1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResourceMappingDialog.this.form.setMergeField((ResourceMappingForm.MergeField)ResourceMappingDialog.this.field1.getSelectedItem());
                ((AssociationTableModel)ResourceMappingDialog.this.associationTable.getModel()).update();
            }
        });
        this.field1Label = new JLabel(Messages.getString("ResourceMappingDialog.MergeResourcesUsingField"));
        this.localProject = new JCheckBox(Messages.getString("ResourceMappingDialog.DontMergeOpenProjectReadOnly"));
        this.accessControlLabel = new JLabel(Messages.getString("ResourceMappingDialog.ProjectTeam"));
        this.accessControl = new JComboBox<Object>(new Object[]{Messages.getString("ResourceMappingDialog.AllResourcesExceptCustomerPartner"), Messages.getString("ResourceMappingDialog.BasedOnProjectRoleInResourcesView")});
        HelpUtil.addDocHelp(this.accessControl, "Project_Team");
        this.localProject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResourceMappingDialog.this.setLocal(ResourceMappingDialog.this.localProject.isSelected());
                if (ResourceMappingDialog.this.masterProject != null && ResourceMappingDialog.this.localProject.isSelected()) {
                    ResourceMappingDialog.this.form.setMaster(false);
                    ResourceMappingDialog.this.masterProject.setSelected(false);
                }
            }
        });
    }

    private void setLocal(boolean bl) {
        this.form.setLocal(bl);
        this.field1Label.setEnabled(!bl);
        this.field1.setEnabled(!bl);
        this.associationTable.setEnabled(!bl);
        this.accessControlLabel.setEnabled(!bl);
        this.accessControl.setEnabled(!bl);
    }

    public boolean bind(boolean bl) {
        if (this.form == null) {
            return false;
        }
        if (bl) {
            this.field1.setModel(new DefaultComboBoxModel(this.form.getMergeFields()));
            this.field1.setSelectedItem(this.form.getMergeField());
            this.editorCombo.setModel(new DefaultComboBoxModel(this.form.getResources()));
            this.editorCombo.setSelectedIndex(0);
            this.accessControl.setSelectedIndex(this.form.getAccessControlType());
            this.localProject.setSelected(this.form.isLocal());
            this.setLocal(this.form.isLocal());
            AssociationTableModel associationTableModel = (AssociationTableModel)this.associationTable.getModel();
            associationTableModel.update();
        } else {
            this.form.setAccessControlType(this.accessControl.getSelectedIndex());
        }
        return true;
    }

    public JComponent createContentPanel() {
        this.initControls();
        FormLayout formLayout = new FormLayout("310dlu:grow", this.masterProject == null ? "p,3dlu,p,3dlu,p,3dlu,p" : "p,3dlu,p,3dlu,p,3dlu,p,3dlu,p");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.append(this.createFieldPanel());
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.add(new JScrollPane(this.associationTable));
        if (this.masterProject != null) {
            defaultFormBuilder.nextLine(2);
            defaultFormBuilder.append(this.masterProject);
        }
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(this.localProject);
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(this.createFooterPanel());
        return defaultFormBuilder.getPanel();
    }

    public JComponent createFieldPanel() {
        FormLayout formLayout = new FormLayout("p,3dlu,p", "p");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.append(this.field1Label);
        defaultFormBuilder.append(this.field1);
        return defaultFormBuilder.getPanel();
    }

    public JComponent createFooterPanel() {
        FormLayout formLayout = new FormLayout("p,3dlu,p", "p");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.append(this.accessControlLabel);
        defaultFormBuilder.add((Component)this.accessControl, cellConstraints.xy(defaultFormBuilder.getColumn(), defaultFormBuilder.getRow(), "left,default"));
        return defaultFormBuilder.getPanel();
    }

    public ResourceMappingForm getForm() {
        return this.form;
    }

    public Object getBean() {
        return this.form;
    }

    private class AssociationTableColumnModel
    extends DefaultTableColumnModel {
        protected int columnIndex = 0;

        public void addColumn(TableColumn tableColumn) {
            if (this.columnIndex == 0) {
                tableColumn.setHeaderValue(Messages.getString("ResourceMappingDialog.ImportedResources"));
                tableColumn.setPreferredWidth(150);
            } else {
                tableColumn.setHeaderValue(Messages.getString("ResourceMappingDialog.ServerResources"));
                tableColumn.setPreferredWidth(150);
                tableColumn.setCellEditor(new DefaultCellEditor(ResourceMappingDialog.this.editorCombo));
            }
            tableColumn.setCellRenderer(new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    this.setEnabled(jTable == null || jTable.isEnabled());
                    super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    return this;
                }
            });
            super.addColumn(tableColumn);
            ++this.columnIndex;
        }

        public void moveColumn(int n, int n2) {
        }
    }

    private class AssociationTableModel
    extends AbstractTableModel {
        private AssociationTableModel() {
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return ResourceMappingDialog.this.form.getImportedResources().size();
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                try {
                    return BeanUtils.getProperty(ResourceMappingDialog.this.form.getImportedResources().get(n), "name");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (n2 == 1) {
                return ResourceMappingDialog.this.form.getSelectedResources().get(n);
            }
            return null;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 1) {
                ResourceMappingDialog.this.form.getSelectedResources().set(n, object);
            }
        }

        public void update() {
            this.fireTableDataChanged();
        }
    }

    private static class HeaderRenderer
    extends DefaultTableCellRenderer
    implements UIResource {
        public HeaderRenderer() {
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JTableHeader jTableHeader;
            this.setEnabled(jTable == null || jTable.isEnabled());
            if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
                this.setForeground(jTableHeader.getForeground());
                this.setBackground(jTableHeader.getBackground());
                this.setFont(jTableHeader.getFont());
            }
            this.setText(object == null ? "" : object.toString());
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }
    }

    private class AssociationTable
    extends JTable {
        public AssociationTable() {
            super(new AssociationTableModel(), new AssociationTableColumnModel());
            this.setCellSelectionEnabled(true);
            this.getTableHeader().setDefaultRenderer(new HeaderRenderer());
            this.registerEditors();
            this.createDefaultColumnsFromModel();
        }

        protected void registerEditors() {
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.getTableHeader().setEnabled(bl);
        }
    }
}

