/*
 * Decompiled with CFR 0.152.
 */
package processing.xml;

import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;
import processing.xml.StdXMLReader;
import processing.xml.XMLParseException;

public class XMLEntityResolver {
    private Hashtable<String, Object> entities = new Hashtable();

    public XMLEntityResolver() {
        this.entities.put("amp", "&#38;");
        this.entities.put("quot", "&#34;");
        this.entities.put("apos", "&#39;");
        this.entities.put("lt", "&#60;");
        this.entities.put("gt", "&#62;");
    }

    protected void finalize() throws Throwable {
        this.entities.clear();
        this.entities = null;
        super.finalize();
    }

    public void addInternalEntity(String string, String string2) {
        if (!this.entities.containsKey(string)) {
            this.entities.put(string, string2);
        }
    }

    public void addExternalEntity(String string, String string2, String string3) {
        if (!this.entities.containsKey(string)) {
            this.entities.put(string, new String[]{string2, string3});
        }
    }

    public Reader getEntity(StdXMLReader stdXMLReader, String string) throws XMLParseException {
        Object object = this.entities.get(string);
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return new StringReader((String)object);
        }
        String[] stringArray = (String[])object;
        return this.openExternalEntity(stdXMLReader, stringArray[0], stringArray[1]);
    }

    public boolean isExternalEntity(String string) {
        Object object = this.entities.get(string);
        return !(object instanceof String);
    }

    protected Reader openExternalEntity(StdXMLReader stdXMLReader, String string, String string2) throws XMLParseException {
        String string3 = stdXMLReader.getSystemID();
        try {
            return stdXMLReader.openStream(string, string2);
        }
        catch (Exception exception) {
            throw new XMLParseException(string3, stdXMLReader.getLineNr(), "Could not open external entity at system ID: " + string2);
        }
    }
}

