/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0u - uvec2(38u, 35u)) => uvec2(4294967258u, 4294967261u)
 * (0u - uvec2(64u, 9u)) => uvec2(4294967232u, 4294967287u)
 * (6u - uvec2(38u, 35u)) => uvec2(4294967264u, 4294967267u)
 * (6u - uvec2(64u, 9u)) => uvec2(4294967238u, 4294967293u)
 * (12u - uvec2(38u, 35u)) => uvec2(4294967270u, 4294967273u)
 * (12u - uvec2(64u, 9u)) => uvec2(4294967244u, 3u)
 * (32u - uvec2(38u, 35u)) => uvec2(4294967290u, 4294967293u)
 * (32u - uvec2(64u, 9u)) => uvec2(4294967264u, 23u)
 * (74u - uvec2(38u, 35u)) => uvec2(36u, 39u)
 * (74u - uvec2(64u, 9u)) => uvec2(10u, 65u)
 */
#version 150

void main()
{
  float[all(equal((0u - uvec2(38u, 35u)), uvec2(4294967258u, 4294967261u))) ? 1 : -1] array0;
  float[all(equal((0u - uvec2(64u, 9u)), uvec2(4294967232u, 4294967287u))) ? 1 : -1] array1;
  float[all(equal((6u - uvec2(38u, 35u)), uvec2(4294967264u, 4294967267u))) ? 1 : -1] array2;
  float[all(equal((6u - uvec2(64u, 9u)), uvec2(4294967238u, 4294967293u))) ? 1 : -1] array3;
  float[all(equal((12u - uvec2(38u, 35u)), uvec2(4294967270u, 4294967273u))) ? 1 : -1] array4;
  float[all(equal((12u - uvec2(64u, 9u)), uvec2(4294967244u, 3u))) ? 1 : -1] array5;
  float[all(equal((32u - uvec2(38u, 35u)), uvec2(4294967290u, 4294967293u))) ? 1 : -1] array6;
  float[all(equal((32u - uvec2(64u, 9u)), uvec2(4294967264u, 23u))) ? 1 : -1] array7;
  float[all(equal((74u - uvec2(38u, 35u)), uvec2(36u, 39u))) ? 1 : -1] array8;
  float[all(equal((74u - uvec2(64u, 9u)), uvec2(10u, 65u))) ? 1 : -1] array9;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length());
}
