/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * trunc(vec3(-2.0, -1.4285715, -0.85714287)) => vec3(-2.0, -1.0, -0.0)
 * trunc(vec3(-0.2857143, 0.2857143, 0.85714287)) => vec3(-0.0, 0.0, 0.0)
 * trunc(vec3(1.4285715, 2.0, 0.0)) => vec3(1.0, 2.0, 0.0)
 * trunc(vec3(45027112.0, -45027112.0, 1.9584199e+10)) => vec3(45027112.0, -45027112.0, 1.9584199e+10)
 * trunc(vec3(-1.9584199e+10, 4.5027112e+19, -4.5027112e+19)) => vec3(-1.9584199e+10, 4.5027112e+19, -4.5027112e+19)
 */
#version 130

void main()
{
  float[distance(trunc(vec3(-2.0, -1.4285715, -0.85714287)), vec3(-2.0, -1.0, -0.0)) <= 2.236068e-05 ? 1 : -1] array0;
  float[distance(trunc(vec3(-0.2857143, 0.2857143, 0.85714287)), vec3(-0.0, 0.0, 0.0)) <= 0.0 ? 1 : -1] array1;
  float[distance(trunc(vec3(1.4285715, 2.0, 0.0)), vec3(1.0, 2.0, 0.0)) <= 2.236068e-05 ? 1 : -1] array2;
  float[distance(trunc(vec3(45027112.0, -45027112.0, 1.9584199e+10)), vec3(45027112.0, -45027112.0, 1.9584199e+10)) <= 195843.02 ? 1 : -1] array3;
  float[distance(trunc(vec3(-1.9584199e+10, 4.5027112e+19, -4.5027112e+19)), vec3(-1.9584199e+10, 4.5027112e+19, -4.5027112e+19)) <= 6.367795e+14 ? 1 : -1] array4;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length());
}
