/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0.0 * vec4(-1.65, 1.33, 1.9299999, 0.75999999)) => vec4(-0.0, 0.0, 0.0, 0.0)
 * (0.0 * vec4(0.80000001, -0.15000001, -0.50999999, 0.0)) => vec4(0.0, -0.0, -0.0, 0.0)
 * (-1.33 * vec4(-1.65, 1.33, 1.9299999, 0.75999999)) => vec4(2.1945, -1.7689002, -2.5669, -1.0108)
 * (-1.33 * vec4(0.80000001, -0.15000001, -0.50999999, 0.0)) => vec4(-1.064, 0.19950001, 0.67830002, -0.0)
 * (0.85000002 * vec4(-1.65, 1.33, 1.9299999, 0.75999999)) => vec4(-1.4025, 1.1305001, 1.6404999, 0.64600003)
 * (0.85000002 * vec4(0.80000001, -0.15000001, -0.50999999, 0.0)) => vec4(0.68000001, -0.12750001, -0.43349999, 0.0)
 */
#version 120

void main()
{
  float[distance((0.0 * vec4(-1.65, 1.33, 1.9299999, 0.75999999)), vec4(-0.0, 0.0, 0.0, 0.0)) <= 0.0 ? 1 : -1] array0;
  float[distance((0.0 * vec4(0.80000001, -0.15000001, -0.50999999, 0.0)), vec4(0.0, -0.0, -0.0, 0.0)) <= 0.0 ? 1 : -1] array1;
  float[distance((-1.33 * vec4(-1.65, 1.33, 1.9299999, 0.75999999)), vec4(2.1945, -1.7689002, -2.5669, -1.0108)) <= 3.94405e-05 ? 1 : -1] array2;
  float[distance((-1.33 * vec4(0.80000001, -0.15000001, -0.50999999, 0.0)), vec4(-1.064, 0.19950001, 0.67830002, -0.0)) <= 1.2774925e-05 ? 1 : -1] array3;
  float[distance((0.85000002 * vec4(-1.65, 1.33, 1.9299999, 0.75999999)), vec4(-1.4025, 1.1305001, 1.6404999, 0.64600003)) <= 2.5206335e-05 ? 1 : -1] array4;
  float[distance((0.85000002 * vec4(0.80000001, -0.15000001, -0.50999999, 0.0)), vec4(0.68000001, -0.12750001, -0.43349999, 0.0)) <= 8.1644257e-06 ? 1 : -1] array5;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
