/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * mix(vec2(-2.0, -2.0), vec2(-3.0, -3.0), vec2(0.0, 0.33333334)) => vec2(-2.0, -2.3333333)
 * mix(vec2(-2.0, -2.0), vec2(-3.0, -3.0), vec2(0.66666669, 1.0)) => vec2(-2.6666667, -3.0)
 * mix(vec2(-2.0, -2.0), vec2(3.0, 3.0), vec2(0.0, 0.33333334)) => vec2(-2.0, -0.33333328)
 * mix(vec2(-2.0, -2.0), vec2(3.0, 3.0), vec2(0.66666669, 1.0)) => vec2(1.3333335, 3.0)
 * mix(vec2(2.0, 2.0), vec2(-3.0, -3.0), vec2(0.0, 0.33333334)) => vec2(2.0, 0.33333328)
 * mix(vec2(2.0, 2.0), vec2(-3.0, -3.0), vec2(0.66666669, 1.0)) => vec2(-1.3333335, -3.0)
 * mix(vec2(2.0, 2.0), vec2(3.0, 3.0), vec2(0.0, 0.33333334)) => vec2(2.0, 2.3333333)
 * mix(vec2(2.0, 2.0), vec2(3.0, 3.0), vec2(0.66666669, 1.0)) => vec2(2.6666667, 3.0)
 */
#version 120

void main()
{
  float[distance(mix(vec2(-2.0, -2.0), vec2(-3.0, -3.0), vec2(0.0, 0.33333334)), vec2(-2.0, -2.3333333)) <= 3.0731815e-05 ? 1 : -1] array0;
  float[distance(mix(vec2(-2.0, -2.0), vec2(-3.0, -3.0), vec2(0.66666669, 1.0)), vec2(-2.6666667, -3.0)) <= 4.0138646e-05 ? 1 : -1] array1;
  float[distance(mix(vec2(-2.0, -2.0), vec2(3.0, 3.0), vec2(0.0, 0.33333334)), vec2(-2.0, -0.33333328)) <= 2.0275875e-05 ? 1 : -1] array2;
  float[distance(mix(vec2(-2.0, -2.0), vec2(3.0, 3.0), vec2(0.66666669, 1.0)), vec2(1.3333335, 3.0)) <= 3.2829525e-05 ? 1 : -1] array3;
  float[distance(mix(vec2(2.0, 2.0), vec2(-3.0, -3.0), vec2(0.0, 0.33333334)), vec2(2.0, 0.33333328)) <= 2.0275875e-05 ? 1 : -1] array4;
  float[distance(mix(vec2(2.0, 2.0), vec2(-3.0, -3.0), vec2(0.66666669, 1.0)), vec2(-1.3333335, -3.0)) <= 3.2829525e-05 ? 1 : -1] array5;
  float[distance(mix(vec2(2.0, 2.0), vec2(3.0, 3.0), vec2(0.0, 0.33333334)), vec2(2.0, 2.3333333)) <= 3.0731815e-05 ? 1 : -1] array6;
  float[distance(mix(vec2(2.0, 2.0), vec2(3.0, 3.0), vec2(0.66666669, 1.0)), vec2(2.6666667, 3.0)) <= 4.0138646e-05 ? 1 : -1] array7;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length());
}
