/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * reflect(dvec2(-0.10000000000000001lf, -1.2lf), dvec2(-0.083045479853739973lf, -0.99654575824487956lf)) => dvec2(0.099999999999999978lf, 1.1999999999999995lf)
 * reflect(dvec2(-0.10000000000000001lf, -1.2lf), dvec2(-0.65850460786851817lf, 0.75257669470687794lf)) => dvec2(-1.2026548672566375lf, 0.060176991150442838lf)
 * reflect(dvec2(-0.41999999999999998lf, 0.47999999999999998lf), dvec2(-0.083045479853739973lf, -0.99654575824487956lf)) => dvec2(-0.49365517241379309lf, -0.40386206896551724lf)
 * reflect(dvec2(-0.41999999999999998lf, 0.47999999999999998lf), dvec2(-0.65850460786851817lf, 0.75257669470687794lf)) => dvec2(0.42000000000000032lf, -0.48000000000000043lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(reflect(dvec2(-0.10000000000000001lf, -1.2lf), dvec2(-0.083045479853739973lf, -0.99654575824487956lf)), dvec2(0.099999999999999978lf, 1.1999999999999995lf)) <= 1.2041594578792292e-05lf ? 1 : -1] array0;
  double[distance(reflect(dvec2(-0.10000000000000001lf, -1.2lf), dvec2(-0.65850460786851817lf, 0.75257669470687794lf)), dvec2(-1.2026548672566375lf, 0.060176991150442838lf)) <= 1.2041594578792299e-05lf ? 1 : -1] array1;
  double[distance(reflect(dvec2(-0.41999999999999998lf, 0.47999999999999998lf), dvec2(-0.083045479853739973lf, -0.99654575824487956lf)), dvec2(-0.49365517241379309lf, -0.40386206896551724lf)) <= 6.3780874876407897e-06lf ? 1 : -1] array2;
  double[distance(reflect(dvec2(-0.41999999999999998lf, 0.47999999999999998lf), dvec2(-0.65850460786851817lf, 0.75257669470687794lf)), dvec2(0.42000000000000032lf, -0.48000000000000043lf)) <= 6.3780874876407965e-06lf ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
