/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0.0lf * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf)) => dmat4(-0.0lf, 0.0lf, 0.0lf, -0.0lf, -0.0lf, 0.0lf, -0.0lf, -0.0lf, -0.0lf, 0.0lf, -0.0lf, -0.0lf, 0.0lf, -0.0lf, -0.0lf, 0.0lf)
 * (0.0lf * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf)) => dmat4(0.0lf, 0.0lf, 0.0lf, -0.0lf, 0.0lf, -0.0lf, 0.0lf, 0.0lf, 0.0lf, 0.0lf, 0.0lf, -0.0lf, -0.0lf, -0.0lf, -0.0lf, 0.0lf)
 * (-1.3333333333333333lf * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf)) => dmat4(1.3333333333333333lf, -2.3599999999999999lf, -0.12lf, 1.2133333333333334lf, 0.73333333333333339lf, -0.82666666666666666lf, 0.94666666666666655lf, 2.4266666666666667lf, 1.4399999999999999lf, -0.6399999999999999lf, 1.8533333333333331lf, 1.9066666666666665lf, -2.3866666666666667lf, 1.8lf, 1.6133333333333333lf, -0.95999999999999996lf)
 * (-1.3333333333333333lf * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf)) => dmat4(-0.079999999999999988lf, -2.1333333333333333lf, -1.6666666666666665lf, 0.21333333333333332lf, -1.7466666666666666lf, 0.42666666666666664lf, -0.59999999999999998lf, -0.59999999999999998lf, -2.0266666666666664lf, -0.67999999999999994lf, -2.5333333333333332lf, 1.1733333333333333lf, 2.6133333333333333lf, 2.4533333333333331lf, 0.95999999999999996lf, -0.52000000000000002lf)
 * (0.84999999999999998lf * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf)) => dmat4(-0.84999999999999998lf, 1.5044999999999999lf, 0.076499999999999999lf, -0.77349999999999997lf, -0.46750000000000003lf, 0.52700000000000002lf, -0.60349999999999993lf, -1.5469999999999999lf, -0.91800000000000004lf, 0.40799999999999997lf, -1.1815lf, -1.2155lf, 1.5215000000000001lf, -1.1475lf, -1.0285lf, 0.61199999999999999lf)
 * (0.84999999999999998lf * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf)) => dmat4(0.050999999999999997lf, 1.3600000000000001lf, 1.0625lf, -0.13600000000000001lf, 1.1134999999999999lf, -0.27200000000000002lf, 0.38250000000000001lf, 0.38250000000000001lf, 1.292lf, 0.4335lf, 1.615lf, -0.748lf, -1.6659999999999999lf, -1.5640000000000001lf, -0.61199999999999999lf, 0.33150000000000002lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[(distance((0.0lf * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[0], dvec4(-0.0lf, 0.0lf, 0.0lf, -0.0lf)) * distance((0.0lf * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[0], dvec4(-0.0lf, 0.0lf, 0.0lf, -0.0lf))) + (distance((0.0lf * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[1], dvec4(-0.0lf, 0.0lf, -0.0lf, -0.0lf)) * distance((0.0lf * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[1], dvec4(-0.0lf, 0.0lf, -0.0lf, -0.0lf))) + (distance((0.0lf * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[2], dvec4(-0.0lf, 0.0lf, -0.0lf, -0.0lf)) * distance((0.0lf * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[2], dvec4(-0.0lf, 0.0lf, -0.0lf, -0.0lf))) + (distance((0.0lf * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[3], dvec4(0.0lf, -0.0lf, -0.0lf, 0.0lf)) * distance((0.0lf * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[3], dvec4(0.0lf, -0.0lf, -0.0lf, 0.0lf))) <= 0.0lf ? 1 : -1] array0;
  double[(distance((0.0lf * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[0], dvec4(0.0lf, 0.0lf, 0.0lf, -0.0lf)) * distance((0.0lf * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[0], dvec4(0.0lf, 0.0lf, 0.0lf, -0.0lf))) + (distance((0.0lf * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[1], dvec4(0.0lf, -0.0lf, 0.0lf, 0.0lf)) * distance((0.0lf * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[1], dvec4(0.0lf, -0.0lf, 0.0lf, 0.0lf))) + (distance((0.0lf * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[2], dvec4(0.0lf, 0.0lf, 0.0lf, -0.0lf)) * distance((0.0lf * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[2], dvec4(0.0lf, 0.0lf, 0.0lf, -0.0lf))) + (distance((0.0lf * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[3], dvec4(-0.0lf, -0.0lf, -0.0lf, 0.0lf)) * distance((0.0lf * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[3], dvec4(-0.0lf, -0.0lf, -0.0lf, 0.0lf))) <= 0.0lf ? 1 : -1] array1;
  double[(distance((-1.3333333333333333lf * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[0], dvec4(1.3333333333333333lf, -2.3599999999999999lf, -0.12lf, 1.2133333333333334lf)) * distance((-1.3333333333333333lf * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[0], dvec4(1.3333333333333333lf, -2.3599999999999999lf, -0.12lf, 1.2133333333333334lf))) + (distance((-1.3333333333333333lf * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[1], dvec4(0.73333333333333339lf, -0.82666666666666666lf, 0.94666666666666655lf, 2.4266666666666667lf)) * distance((-1.3333333333333333lf * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[1], dvec4(0.73333333333333339lf, -0.82666666666666666lf, 0.94666666666666655lf, 2.4266666666666667lf))) + (distance((-1.3333333333333333lf * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[2], dvec4(1.4399999999999999lf, -0.6399999999999999lf, 1.8533333333333331lf, 1.9066666666666665lf)) * distance((-1.3333333333333333lf * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[2], dvec4(1.4399999999999999lf, -0.6399999999999999lf, 1.8533333333333331lf, 1.9066666666666665lf))) + (distance((-1.3333333333333333lf * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[3], dvec4(-2.3866666666666667lf, 1.8lf, 1.6133333333333333lf, -0.95999999999999996lf)) * distance((-1.3333333333333333lf * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[3], dvec4(-2.3866666666666667lf, 1.8lf, 1.6133333333333333lf, -0.95999999999999996lf))) <= 3.8854044444444445e-09lf ? 1 : -1] array2;
  double[(distance((-1.3333333333333333lf * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[0], dvec4(-0.079999999999999988lf, -2.1333333333333333lf, -1.6666666666666665lf, 0.21333333333333332lf)) * distance((-1.3333333333333333lf * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[0], dvec4(-0.079999999999999988lf, -2.1333333333333333lf, -1.6666666666666665lf, 0.21333333333333332lf))) + (distance((-1.3333333333333333lf * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[1], dvec4(-1.7466666666666666lf, 0.42666666666666664lf, -0.59999999999999998lf, -0.59999999999999998lf)) * distance((-1.3333333333333333lf * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[1], dvec4(-1.7466666666666666lf, 0.42666666666666664lf, -0.59999999999999998lf, -0.59999999999999998lf))) + (distance((-1.3333333333333333lf * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[2], dvec4(-2.0266666666666664lf, -0.67999999999999994lf, -2.5333333333333332lf, 1.1733333333333333lf)) * distance((-1.3333333333333333lf * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[2], dvec4(-2.0266666666666664lf, -0.67999999999999994lf, -2.5333333333333332lf, 1.1733333333333333lf))) + (distance((-1.3333333333333333lf * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[3], dvec4(2.6133333333333333lf, 2.4533333333333331lf, 0.95999999999999996lf, -0.52000000000000002lf)) * distance((-1.3333333333333333lf * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[3], dvec4(2.6133333333333333lf, 2.4533333333333331lf, 0.95999999999999996lf, -0.52000000000000002lf))) <= 3.7738311111111122e-09lf ? 1 : -1] array3;
  double[(distance((0.84999999999999998lf * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[0], dvec4(-0.84999999999999998lf, 1.5044999999999999lf, 0.076499999999999999lf, -0.77349999999999997lf)) * distance((0.84999999999999998lf * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[0], dvec4(-0.84999999999999998lf, 1.5044999999999999lf, 0.076499999999999999lf, -0.77349999999999997lf))) + (distance((0.84999999999999998lf * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[1], dvec4(-0.46750000000000003lf, 0.52700000000000002lf, -0.60349999999999993lf, -1.5469999999999999lf)) * distance((0.84999999999999998lf * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[1], dvec4(-0.46750000000000003lf, 0.52700000000000002lf, -0.60349999999999993lf, -1.5469999999999999lf))) + (distance((0.84999999999999998lf * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[2], dvec4(-0.91800000000000004lf, 0.40799999999999997lf, -1.1815lf, -1.2155lf)) * distance((0.84999999999999998lf * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[2], dvec4(-0.91800000000000004lf, 0.40799999999999997lf, -1.1815lf, -1.2155lf))) + (distance((0.84999999999999998lf * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[3], dvec4(1.5215000000000001lf, -1.1475lf, -1.0285lf, 0.61199999999999999lf)) * distance((0.84999999999999998lf * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[3], dvec4(1.5215000000000001lf, -1.1475lf, -1.0285lf, 0.61199999999999999lf))) <= 1.5790526500000007e-09lf ? 1 : -1] array4;
  double[(distance((0.84999999999999998lf * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[0], dvec4(0.050999999999999997lf, 1.3600000000000001lf, 1.0625lf, -0.13600000000000001lf)) * distance((0.84999999999999998lf * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[0], dvec4(0.050999999999999997lf, 1.3600000000000001lf, 1.0625lf, -0.13600000000000001lf))) + (distance((0.84999999999999998lf * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[1], dvec4(1.1134999999999999lf, -0.27200000000000002lf, 0.38250000000000001lf, 0.38250000000000001lf)) * distance((0.84999999999999998lf * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[1], dvec4(1.1134999999999999lf, -0.27200000000000002lf, 0.38250000000000001lf, 0.38250000000000001lf))) + (distance((0.84999999999999998lf * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[2], dvec4(1.292lf, 0.4335lf, 1.615lf, -0.748lf)) * distance((0.84999999999999998lf * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[2], dvec4(1.292lf, 0.4335lf, 1.615lf, -0.748lf))) + (distance((0.84999999999999998lf * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[3], dvec4(-1.6659999999999999lf, -1.5640000000000001lf, -0.61199999999999999lf, 0.33150000000000002lf)) * distance((0.84999999999999998lf * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[3], dvec4(-1.6659999999999999lf, -1.5640000000000001lf, -0.61199999999999999lf, 0.33150000000000002lf))) <= 1.5337085500000004e-09lf ? 1 : -1] array5;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
