/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.DecoratedFigure;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public class AbstractConnector
implements Connector {
    private Figure owner;
    private boolean isConnectToDecorator;
    private boolean isStatePersistent;

    public AbstractConnector() {
        this.owner = null;
    }

    public AbstractConnector(Figure figure) {
        this.owner = figure;
    }

    public void setConnectToDecorator(boolean bl) {
        this.isConnectToDecorator = bl;
    }

    public boolean isConnectToDecorator() {
        return this.isConnectToDecorator;
    }

    protected final Figure getConnectorTarget(Figure figure) {
        return this.isConnectToDecorator && ((DecoratedFigure)figure).getDecorator() != null ? ((DecoratedFigure)figure).getDecorator() : figure;
    }

    @Override
    public boolean contains(Point2D.Double double_) {
        return this.getOwner().contains(double_);
    }

    @Override
    public Point2D.Double findStart(ConnectionFigure connectionFigure) {
        return this.findPoint(connectionFigure);
    }

    @Override
    public Point2D.Double findEnd(ConnectionFigure connectionFigure) {
        return this.findPoint(connectionFigure);
    }

    protected Point2D.Double findPoint(ConnectionFigure connectionFigure) {
        return Geom.center(this.getBounds());
    }

    @Override
    public Figure getOwner() {
        return this.owner;
    }

    protected void setOwner(Figure figure) {
        this.owner = figure;
    }

    @Override
    public Object clone() {
        try {
            AbstractConnector abstractConnector = (AbstractConnector)super.clone();
            return abstractConnector;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            InternalError internalError = new InternalError(cloneNotSupportedException.toString());
            throw internalError;
        }
    }

    public void updateStartLocation(Point2D.Double double_) {
    }

    public void updateEndLocation(Point2D.Double double_) {
    }

    @Override
    public Point2D.Double getAnchor() {
        return Geom.center(this.getBounds());
    }

    @Override
    public void updateAnchor(Point2D.Double double_) {
    }

    @Override
    public Rectangle2D.Double getBounds() {
        return this.isConnectToDecorator() ? ((DecoratedFigure)this.getOwner()).getDecorator().getBounds() : this.getOwner().getBounds();
    }

    @Override
    public void read(DOMInput dOMInput) throws IOException {
        if (this.isStatePersistent) {
            this.isConnectToDecorator = dOMInput.getAttribute("connectToDecorator", false);
        }
        if (dOMInput.getElementCount("Owner") != 0) {
            dOMInput.openElement("Owner");
        } else {
            dOMInput.openElement("owner");
        }
        this.owner = (Figure)dOMInput.readObject(0);
        dOMInput.closeElement();
    }

    @Override
    public void write(DOMOutput dOMOutput) throws IOException {
        if (this.isStatePersistent && this.isConnectToDecorator) {
            dOMOutput.addAttribute("connectToDecorator", true);
        }
        dOMOutput.openElement("Owner");
        dOMOutput.writeObject(this.getOwner());
        dOMOutput.closeElement();
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        Point2D.Double double_ = this.getAnchor();
        return new Rectangle2D.Double(double_.x - 4.0, double_.y - 4.0, 8.0, 8.0);
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        Point2D.Double double_ = this.getAnchor();
        Ellipse2D.Double double_2 = new Ellipse2D.Double(double_.x - 3.0, double_.y - 3.0, 6.0, 6.0);
        graphics2D.setColor(Color.BLUE);
        graphics2D.fill(double_2);
    }
}

