/*
 * Decompiled with CFR 0.152.
 */
package com.jrjackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.jrjackson.JavaHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class JjParse {
    private final JavaHandler _handler;
    protected final HashMap<JsonStreamContext, Object> _objectMap = new HashMap();
    protected JsonStreamContext _deepestContext;

    public JjParse(JavaHandler handler) {
        this._handler = handler;
    }

    public void deserialize(JsonParser jp) throws JsonProcessingException, IOException {
        try {
            while (jp.nextValue() != null) {
                this.handleCurrentToken(jp);
            }
        }
        catch (JsonProcessingException e) {
            this._handler.raiseError(e.getLocalizedMessage());
        }
        catch (IOException e) {
            this._handler.raiseError(e.getLocalizedMessage());
        }
    }

    private void callAddValue(JsonStreamContext x) {
        JsonStreamContext px = x.getParent();
        Object dtarget = this._objectMap.get(this._deepestContext);
        if (px == null) {
            this._handler.addValue(dtarget);
            return;
        }
        Object value = this._objectMap.get(x);
        if (x.inArray()) {
            this._handler.arrayAppend((ArrayList)value, dtarget);
        } else if (x.inObject()) {
            this._handler.hashSet((HashMap)value, (Object)this.callHashKey(x), dtarget);
        } else {
            this._handler.addValue(value);
        }
    }

    private void callAddValue(JsonStreamContext x, Object val) {
        if (x.inArray()) {
            ArrayList a = (ArrayList)this._objectMap.get(x);
            this._handler.arrayAppend(a, val);
        } else if (x.inObject()) {
            HashMap h = (HashMap)this._objectMap.get(x);
            this._handler.hashSet(h, (Object)this.callHashKey(x), val);
        } else {
            this._handler.addValue(val);
        }
    }

    private String callHashKey(JsonStreamContext x) {
        String k = x.getCurrentName();
        if (k == null) {
            return null;
        }
        return (String)this._handler.hashKey(k);
    }

    private void handleCurrentToken(JsonParser jp) throws IOException, JsonProcessingException {
        JsonStreamContext cx = jp.getParsingContext();
        switch (jp.getCurrentToken()) {
            case START_OBJECT: {
                this._deepestContext = cx;
                this._objectMap.put(cx, this._handler.hashStart());
                break;
            }
            case START_ARRAY: {
                this._deepestContext = cx;
                this._objectMap.put(cx, this._handler.arrayStart());
            }
            case FIELD_NAME: {
                break;
            }
            case VALUE_EMBEDDED_OBJECT: {
                System.out.println("-------- VALUE_EMBEDDED_OBJECT ????????? --------");
                System.out.println(jp.getEmbeddedObject());
                break;
            }
            case VALUE_STRING: {
                this.callAddValue(cx, this._handler.treatString(jp));
                break;
            }
            case VALUE_NUMBER_INT: {
                this.callAddValue(cx, this._handler.treatInt(jp));
                break;
            }
            case VALUE_NUMBER_FLOAT: {
                this.callAddValue(cx, this._handler.treatFloat(jp));
                break;
            }
            case VALUE_TRUE: {
                this.callAddValue(cx, this._handler.trueValue());
                break;
            }
            case VALUE_FALSE: {
                this.callAddValue(cx, this._handler.falseValue());
                break;
            }
            case VALUE_NULL: {
                this.callAddValue(cx, this._handler.treatNull());
                break;
            }
            case END_ARRAY: {
                this._handler.arrayEnd();
                this.callAddValue(cx);
                this._deepestContext = cx;
                break;
            }
            case END_OBJECT: {
                this._handler.hashEnd();
                this.callAddValue(cx);
                this._deepestContext = cx;
            }
        }
    }
}

