/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nokogiri.NokogiriService;
import nokogiri.XmlDocument;
import nokogiri.XmlElement;
import nokogiri.XmlNode;
import nokogiri.XmlNodeSet;
import nokogiri.internals.NokogiriHelpers;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;

@JRubyClass(name={"Nokogiri::XML::DocumentFragment"}, parent="Nokogiri::XML::Node")
public class XmlDocumentFragment
extends XmlNode {
    private XmlElement fragmentContext = null;
    private static Pattern qname_pattern = Pattern.compile("[^</:>\\s]+:[^</:>=\\s]+");
    private static Pattern starttag_pattern = Pattern.compile("<[^</>]+>");

    public XmlDocumentFragment(Ruby ruby) {
        this(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::DocumentFragment"));
    }

    public XmlDocumentFragment(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    @JRubyMethod(name={"new"}, meta=true, required=1, optional=2)
    public static IRubyObject rbNew(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray.length < 1) {
            throw threadContext.getRuntime().newArgumentError(iRubyObjectArray.length, 1);
        }
        if (!(iRubyObjectArray[0] instanceof XmlDocument)) {
            throw threadContext.getRuntime().newArgumentError("first parameter must be a Nokogiri::XML::Document instance");
        }
        XmlDocument xmlDocument = (XmlDocument)iRubyObjectArray[0];
        if (iRubyObjectArray.length > 1 && iRubyObjectArray[1] instanceof RubyString && XmlDocumentFragment.isTag((RubyString)iRubyObjectArray[1])) {
            iRubyObjectArray[1] = RubyString.newString((Ruby)threadContext.getRuntime(), (String)XmlDocumentFragment.addNamespaceDeclIfNeeded(xmlDocument, NokogiriHelpers.rubyStringToString(iRubyObjectArray[1])));
        }
        XmlDocumentFragment xmlDocumentFragment = (XmlDocumentFragment)NokogiriService.XML_DOCUMENT_FRAGMENT_ALLOCATOR.allocate(threadContext.getRuntime(), (RubyClass)iRubyObject);
        xmlDocumentFragment.setDocument(threadContext, (IRubyObject)xmlDocument);
        xmlDocumentFragment.setNode(threadContext, xmlDocument.getDocument().createDocumentFragment());
        if (iRubyObjectArray.length == 3 && iRubyObjectArray[2] != null && iRubyObjectArray[2] instanceof XmlElement) {
            xmlDocumentFragment.fragmentContext = (XmlElement)iRubyObjectArray[2];
        }
        RuntimeHelpers.invoke((ThreadContext)threadContext, (IRubyObject)xmlDocumentFragment, (String)"initialize", (IRubyObject[])iRubyObjectArray);
        return xmlDocumentFragment;
    }

    private static boolean isTag(RubyString rubyString) {
        String string = NokogiriHelpers.rubyStringToString(rubyString);
        return string.startsWith("<") && string.endsWith(">");
    }

    private static boolean isNamespaceDefined(String string, NamedNodeMap namedNodeMap) {
        if (NokogiriHelpers.isNamespace(string.intern())) {
            return true;
        }
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (!NokogiriHelpers.isNamespace(attr.getNodeName())) continue;
            String string2 = NokogiriHelpers.getLocalNameForNamespace(attr.getNodeName());
            if (!NokogiriHelpers.getPrefix(string).equals(string2)) continue;
            return true;
        }
        return false;
    }

    private static String addNamespaceDeclIfNeeded(XmlDocument xmlDocument, String string) {
        String string2;
        Object object;
        Object object2;
        if (xmlDocument.getDocument() == null) {
            return string;
        }
        if (xmlDocument.getDocument().getDocumentElement() == null) {
            return string;
        }
        Matcher matcher = starttag_pattern.matcher(string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (matcher.find()) {
            object2 = matcher.group();
            object = qname_pattern.matcher((CharSequence)object2);
            while (((Matcher)object).find()) {
                String string3;
                NamedNodeMap namedNodeMap;
                string2 = ((Matcher)object).group();
                if (!XmlDocumentFragment.isNamespaceDefined(string2, namedNodeMap = xmlDocument.getDocument().getDocumentElement().getAttributes()) || (string3 = XmlDocumentFragment.getNamespceDecl(NokogiriHelpers.getPrefix(string2), namedNodeMap)) == null) continue;
                hashMap.put("<" + string2 + ">", "<" + string2 + " " + string3 + ">");
            }
        }
        object2 = hashMap.keySet();
        object = object2.iterator();
        while (object.hasNext()) {
            string2 = (String)object.next();
            string = string.replace(string2, (CharSequence)hashMap.get(string2));
        }
        return string;
    }

    private static String getNamespceDecl(String string, NamedNodeMap namedNodeMap) {
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (!string.equals(attr.getLocalName())) continue;
            return attr.getName() + "=\"" + attr.getValue() + "\"";
        }
        return null;
    }

    public XmlElement getFragmentContext() {
        return this.fragmentContext;
    }

    public void add_child(ThreadContext threadContext, XmlNode xmlNode) {
        Ruby ruby = threadContext.getRuntime();
        XmlNodeSet xmlNodeSet = (XmlNodeSet)xmlNode.children(threadContext);
        long l = xmlNodeSet.length();
        RubyArray rubyArray = xmlNodeSet.convertToArray();
        if (l != 0L) {
            int n = 0;
            while ((long)n < l) {
                XmlNode xmlNode2 = (XmlNode)((XmlNode)rubyArray.aref((IRubyObject)ruby.newFixnum(n))).dup_implementation(threadContext, true);
                this.add_child(threadContext, xmlNode2);
                ++n;
            }
        }
    }

    @Override
    public void relink_namespace(ThreadContext threadContext) {
        ((XmlNodeSet)this.children(threadContext)).relink_namespace(threadContext);
    }
}

