/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.beats;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.logstash.beats.Ack;
import org.logstash.beats.Batch;
import org.logstash.beats.IMessageListener;
import org.logstash.beats.Message;

@ChannelHandler.Sharable
public class BeatsHandler
extends SimpleChannelInboundHandler<Batch> {
    private static final Logger logger = Logger.getLogger(BeatsHandler.class);
    private final AtomicBoolean processing = new AtomicBoolean(false);
    private final IMessageListener messageListener;
    private ChannelHandlerContext context;

    public BeatsHandler(IMessageListener listener) {
        this.messageListener = listener;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.context = ctx;
        this.messageListener.onNewConnection(ctx);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.messageListener.onConnectionClose(ctx);
    }

    public void channelRead0(ChannelHandlerContext ctx, Batch batch) throws Exception {
        logger.debug((Object)"Received a new payload");
        this.processing.compareAndSet(false, true);
        for (Message message : batch.getMessages()) {
            logger.debug((Object)("Sending a new message for the listener, sequence: " + message.getSequence()));
            this.messageListener.onNewMessage(ctx, message);
            if (!this.needAck(message)) continue;
            this.ack(ctx, message);
        }
        ctx.flush();
        this.processing.compareAndSet(true, false);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.messageListener.onException(ctx, cause);
        logger.error((Object)("Exception: " + cause.getMessage()));
        ctx.close();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object event) {
        if (event instanceof IdleStateEvent) {
            IdleStateEvent e = (IdleStateEvent)event;
            if (e.state() == IdleState.WRITER_IDLE) {
                this.sendKeepAlive();
            } else if (e.state() == IdleState.READER_IDLE) {
                this.clientTimeout();
            }
        }
    }

    private boolean needAck(Message message) {
        return message.getSequence() == message.getBatch().getBatchSize();
    }

    private void ack(ChannelHandlerContext ctx, Message message) {
        this.writeAck(ctx, message.getBatch().getProtocol(), message.getSequence());
    }

    private void writeAck(ChannelHandlerContext ctx, byte protocol, int sequence) {
        ctx.write((Object)new Ack(protocol, sequence));
    }

    private void clientTimeout() {
        logger.debug((Object)"Client Timeout");
        this.context.close();
    }

    private void sendKeepAlive() {
        if (this.processing.get()) {
            this.writeAck(this.context, (byte)50, 0);
        }
    }
}

