/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRLEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509v2CRLBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.joda.time.DateTime;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.ObjectSupport;
import org.jruby.ext.openssl.OpenSSL;
import org.jruby.ext.openssl.PKey;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.StringHelper;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.X509;
import org.jruby.ext.openssl.X509Extension;
import org.jruby.ext.openssl.X509Name;
import org.jruby.ext.openssl.X509Revoked;
import org.jruby.ext.openssl.x509store.PEMInputOutput;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.Variable;
import org.jruby.util.ByteList;

public class X509CRL
extends RubyObject {
    private static final long serialVersionUID = -2463300006179688577L;
    private static ObjectAllocator X509CRL_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new X509CRL(runtime, klass);
        }
    };
    private RubyInteger version;
    private IRubyObject issuer;
    private RubyTime last_update;
    private RubyTime next_update;
    private RubyArray revoked;
    private RubyArray extensions;
    private IRubyObject signature_algorithm;
    private boolean changed = true;
    private java.security.cert.X509CRL crl = null;
    private transient X509CRLHolder crlHolder;
    private transient ASN1Primitive crlValue;
    private static boolean avoidJavaSecurity = false;

    public static void createX509CRL(Ruby runtime, RubyModule _X509) {
        RubyClass _CRL = _X509.defineClassUnder("CRL", runtime.getObject(), X509CRL_ALLOCATOR);
        RubyClass _OpenSSLError = runtime.getModule("OpenSSL").getClass("OpenSSLError");
        _X509.defineClassUnder("CRLError", _OpenSSLError, _OpenSSLError.getAllocator());
        _CRL.defineAnnotatedMethods(X509CRL.class);
    }

    static RubyClass _CRL(Ruby runtime) {
        return X509._X509(runtime).getClass("CRL");
    }

    public X509CRL(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    private X509CRL(Ruby runtime) {
        super(runtime, X509CRL._CRL(runtime));
    }

    java.security.cert.X509CRL getCRL() {
        if (this.crl != null) {
            return this.crl;
        }
        try {
            if (this.crlHolder == null) {
                throw new IllegalStateException("no crl holder");
            }
            byte[] encoded = this.crlHolder.getEncoded();
            this.crl = X509CRL.generateCRL(encoded, 0, encoded.length);
            return this.crl;
        }
        catch (IOException ex) {
            throw X509CRL.newCRLError(this.getRuntime(), ex);
        }
        catch (GeneralSecurityException ex) {
            throw X509CRL.newCRLError(this.getRuntime(), ex);
        }
    }

    private X509CRLHolder getCRLHolder(boolean allowNull) {
        if (this.crlHolder != null) {
            return this.crlHolder;
        }
        try {
            if (this.crl == null) {
                if (allowNull) {
                    return null;
                }
                throw new IllegalStateException("no crl");
            }
            this.crlHolder = new X509CRLHolder(this.crl.getEncoded());
            return this.crlHolder;
        }
        catch (IOException ex) {
            throw X509CRL.newCRLError(this.getRuntime(), ex);
        }
        catch (CRLException ex) {
            throw X509CRL.newCRLError(this.getRuntime(), ex);
        }
    }

    final byte[] getEncoded() throws IOException, CRLException {
        if (this.crlHolder != null) {
            return this.crlHolder.getEncoded();
        }
        return this.getCRL().getEncoded();
    }

    private byte[] getSignature() {
        return this.getCRL().getSignature();
    }

    private static java.security.cert.X509CRL generateCRL(byte[] bytes, int offset, int length) throws GeneralSecurityException {
        CertificateFactory factory = SecurityHelper.getCertificateFactory("X.509");
        return (java.security.cert.X509CRL)factory.generateCRL(new ByteArrayInputStream(bytes, offset, length));
    }

    private static X509CRLHolder parseCRLHolder(byte[] bytes, int offset, int length) throws IOException {
        return new X509CRLHolder((InputStream)new ByteArrayInputStream(bytes, offset, length));
    }

    @JRubyMethod(name={"initialize"}, rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context2, IRubyObject[] args, Block block) {
        Ruby runtime = context2.runtime;
        this.extensions = runtime.newArray(8);
        if (Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)0, (int)1) == 0) {
            return this;
        }
        ByteList strList = args[0].asString().getByteList();
        byte[] bytes = strList.unsafeBytes();
        int offset = strList.getBegin();
        int length = strList.getRealSize();
        try {
            if (avoidJavaSecurity) {
                this.crlHolder = X509CRL.parseCRLHolder(bytes, offset, length);
            } else {
                this.crl = X509CRL.generateCRL(bytes, offset, length);
            }
        }
        catch (IOException e) {
            OpenSSL.debugStackTrace(runtime, e);
            throw X509CRL.newCRLError(runtime, e);
        }
        catch (GeneralSecurityException e) {
            OpenSSL.debugStackTrace(runtime, e);
            throw X509CRL.newCRLError(runtime, e);
        }
        this.set_last_update(context2, (IRubyObject)RubyTime.newTime((Ruby)runtime, (long)this.crl.getThisUpdate().getTime()));
        this.set_next_update(context2, (IRubyObject)RubyTime.newTime((Ruby)runtime, (long)this.crl.getNextUpdate().getTime()));
        this.set_issuer((IRubyObject)X509Name.newName(runtime, this.crl.getIssuerX500Principal()));
        int version2 = this.crl.getVersion();
        this.version = runtime.newFixnum(version2 > 0 ? version2 - 1 : 2);
        this.extractExtensions(context2);
        Set<? extends X509CRLEntry> revokedCRLs = this.crl.getRevokedCertificates();
        if (revokedCRLs != null && !revokedCRLs.isEmpty()) {
            X509CRLEntry[] revokedSorted = revokedCRLs.toArray(new X509CRLEntry[revokedCRLs.size()]);
            Arrays.sort(revokedSorted, 0, revokedSorted.length, new Comparator<X509CRLEntry>(){

                @Override
                public int compare(X509CRLEntry o1, X509CRLEntry o2) {
                    return o1.getRevocationDate().compareTo(o2.getRevocationDate());
                }
            });
            for (X509CRLEntry entry : revokedSorted) {
                this.revoked().append((IRubyObject)X509Revoked.newInstance(context2, entry));
            }
        }
        this.changed = false;
        return this;
    }

    private void extractExtensions(ThreadContext context2) {
        if (this.crlHolder != null) {
            this.extractExtensions(context2, this.crlHolder);
        } else {
            this.extractExtensionsCRL(context2, this.getCRL());
        }
    }

    private void extractExtensions(ThreadContext context2, X509CRLHolder crl2) {
        if (!this.crlHolder.hasExtensions()) {
            return;
        }
        for (ASN1ObjectIdentifier oid2 : crl2.getExtensionOIDs()) {
            this.addExtension(context2, oid2, crl2);
        }
    }

    private void addExtension(ThreadContext context2, ASN1ObjectIdentifier extOID, X509CRLHolder crl2) {
        Extension ext2 = crl2.getExtension(extOID);
        X509Extension extension = X509Extension.newExtension(context2.runtime, extOID, ext2);
        this.extensions.append((IRubyObject)extension);
    }

    private void extractExtensionsCRL(ThreadContext context2, java.security.cert.X509Extension crl2) {
        Set<String> nonCriticalExtOIDs;
        Set<String> criticalExtOIDs = crl2.getCriticalExtensionOIDs();
        if (criticalExtOIDs != null) {
            for (String extOID : criticalExtOIDs) {
                this.addExtensionCRL(context2, extOID, crl2, true);
            }
        }
        if ((nonCriticalExtOIDs = crl2.getNonCriticalExtensionOIDs()) != null) {
            for (String extOID : nonCriticalExtOIDs) {
                this.addExtensionCRL(context2, extOID, crl2, false);
            }
        }
    }

    private void addExtensionCRL(ThreadContext context2, String extOID, java.security.cert.X509Extension crl2, boolean critical) {
        try {
            X509Extension extension = X509Extension.newExtension(context2, extOID, crl2, critical);
            if (extension != null) {
                this.extensions.append((IRubyObject)extension);
            }
        }
        catch (IOException e) {
            throw X509CRL.newCRLError(context2.runtime, e);
        }
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject obj) {
        if (this == obj) {
            return this;
        }
        return super.initialize_copy(obj);
    }

    @JRubyMethod(name={"to_pem", "to_s"})
    public IRubyObject to_pem(ThreadContext context2) {
        StringWriter writer = new StringWriter();
        try {
            PEMInputOutput.writeX509CRL(writer, this.crl);
            return RubyString.newString((Ruby)context2.runtime, (CharSequence)writer.getBuffer());
        }
        catch (IOException e) {
            throw X509CRL.newCRLError(context2.runtime, e);
        }
    }

    @JRubyMethod
    public IRubyObject to_der(ThreadContext context2) {
        try {
            return StringHelper.newString(context2.runtime, this.getEncoded());
        }
        catch (IOException e) {
            throw X509CRL.newCRLError(context2.runtime, e);
        }
        catch (CRLException e) {
            throw X509CRL.newCRLError(context2.runtime, e);
        }
    }

    @JRubyMethod
    public IRubyObject to_text(ThreadContext context2) {
        Ruby runtime = context2.runtime;
        char[] S16 = StringHelper.S20;
        StringBuilder text = new StringBuilder(160);
        text.append("Certificate Revocation List (CRL):\n");
        int version2 = RubyNumeric.fix2int((IRubyObject)this.version);
        text.append(S16, 0, 8).append("Version ").append(version2 + 1).append(" (0x").append(Integer.toString(version2, 16)).append(")\n");
        text.append(S16, 0, 4).append("Signature Algorithm: ").append(this.signature_algorithm()).append('\n');
        text.append(S16, 0, 8).append("Issuer: ").append(this.issuer()).append('\n');
        text.append(S16, 0, 8).append("Last Update: ");
        StringHelper.appendGMTDateTime(text, this.getLastUpdate()).append('\n');
        if (!this.next_update().isNil()) {
            text.append(S16, 0, 8).append("Next Update: ");
            StringHelper.appendGMTDateTime(text, this.getNextUpdate()).append('\n');
        } else {
            text.append(S16, 0, 8).append("Next Update: NONE\n");
        }
        if (this.extensions != null && this.extensions.size() > 0) {
            text.append(S16, 0, 8).append("CRL extensions:\n");
            X509CRL.extensions_to_text(context2, (List<X509Extension>)this.extensions, text, 12);
        }
        if (this.revoked != null && this.revoked.size() > 0) {
            text.append("\nRevoked Certificates:\n");
            for (int i2 = 0; i2 < this.revoked.size(); ++i2) {
                X509Revoked rev = (X509Revoked)this.revoked.entry(i2);
                String serial2 = rev.serial.toString(16);
                text.append(S16, 0, 4).append("Serial Number: ");
                if (serial2.length() % 2 == 0) {
                    text.append(serial2).append('\n');
                } else {
                    text.append('0').append(serial2).append('\n');
                }
                text.append(S16, 0, 8).append("Revocation Date: ");
                StringHelper.appendGMTDateTime(text, rev.getTime()).append('\n');
                if (!rev.hasExtensions()) continue;
                text.append(S16, 0, 8).append("CRL entry extensions:\n");
                X509CRL.extensions_to_text(context2, (List<X509Extension>)this.extensions, text, 12);
            }
        } else {
            text.append("No Revoked Certificates.\n");
        }
        text.append(S16, 0, 4).append("Signature Algorithm: ").append(this.signature_algorithm()).append('\n');
        StringHelper.appendLowerHexValue(text, this.getSignature(), 9, 54);
        return RubyString.newString((Ruby)runtime, (CharSequence)text);
    }

    static void extensions_to_text(ThreadContext context2, List<X509Extension> exts, StringBuilder text, int indent) {
        char[] S20 = StringHelper.S20;
        for (int i2 = 0; i2 < exts.size(); ++i2) {
            X509Extension ext2 = exts.get(i2);
            ASN1ObjectIdentifier oid2 = ext2.getRealObjectID();
            String no = ASN1.o2a(context2.runtime, oid2);
            text.append(S20, 0, indent).append(no).append(": ");
            if (ext2.isRealCritical()) {
                text.append("critical");
            }
            text.append('\n');
            String value2 = ext2.value(context2).toString();
            text.append(S20, 0, 16).append(value2);
            if (value2.charAt(value2.length() - 1) == '\n') continue;
            text.append('\n');
        }
    }

    @JRubyMethod
    public IRubyObject inspect() {
        return ObjectSupport.inspect((RubyBasicObject)this, this.getInstanceVariableList());
    }

    public List<Variable<IRubyObject>> getInstanceVariableList() {
        ArrayList<Variable<IRubyObject>> list = new ArrayList<Variable<IRubyObject>>(6);
        return list;
    }

    @JRubyMethod
    public IRubyObject version() {
        return this.version == null ? (this.version = this.getRuntime().newFixnum(0)) : this.version;
    }

    @JRubyMethod(name={"version="})
    public IRubyObject set_version(IRubyObject version2) {
        if (!version2.equals(this.version)) {
            this.changed = true;
        }
        this.version = version2.convertToInteger("to_i");
        return this.version;
    }

    @JRubyMethod
    public IRubyObject signature_algorithm() {
        return this.signature_algorithm == null ? (this.signature_algorithm = this.signature_algorithm(this.getRuntime())) : this.signature_algorithm;
    }

    private RubyString signature_algorithm(Ruby runtime) {
        return RubyString.newString((Ruby)runtime, (String)this.getSignatureAlgorithm(runtime, "itu-t"));
    }

    private String getSignatureAlgorithm(Ruby runtime, String def) {
        X509CRLHolder crlHolder = this.getCRLHolder(true);
        if (crlHolder == null) {
            return def;
        }
        ASN1ObjectIdentifier algId = crlHolder.toASN1Structure().getSignatureAlgorithm().getAlgorithm();
        String algName = algId != null ? ASN1.o2a(runtime, algId, true) : null;
        return algName == null ? def : algName;
    }

    @JRubyMethod
    public IRubyObject issuer() {
        return this.issuer == null ? (this.issuer = X509Name.newName(this.getRuntime())) : this.issuer;
    }

    @JRubyMethod(name={"issuer="})
    public IRubyObject set_issuer(IRubyObject issuer2) {
        if (!issuer2.equals(this.issuer)) {
            this.changed = true;
        }
        this.issuer = issuer2;
        return this.issuer;
    }

    DateTime getLastUpdate() {
        if (this.last_update == null) {
            return null;
        }
        return this.last_update.getDateTime();
    }

    @JRubyMethod
    public IRubyObject last_update() {
        return this.last_update == null ? this.getRuntime().getNil() : this.last_update;
    }

    @JRubyMethod(name={"last_update="})
    public IRubyObject set_last_update(ThreadContext context2, IRubyObject val) {
        this.changed = true;
        RubyTime value2 = (RubyTime)val.callMethod(context2, "getutc");
        value2.setMicroseconds(0L);
        this.last_update = value2;
        return this.last_update;
    }

    DateTime getNextUpdate() {
        if (this.next_update == null) {
            return null;
        }
        return this.next_update.getDateTime();
    }

    @JRubyMethod
    public IRubyObject next_update() {
        return this.next_update == null ? this.getRuntime().getNil() : this.next_update;
    }

    @JRubyMethod(name={"next_update="})
    public IRubyObject set_next_update(ThreadContext context2, IRubyObject val) {
        this.changed = true;
        RubyTime value2 = (RubyTime)val.callMethod(context2, "getutc");
        value2.setMicroseconds(0L);
        this.next_update = value2;
        return this.next_update;
    }

    @JRubyMethod
    public RubyArray revoked() {
        return this.revoked == null ? (this.revoked = this.getRuntime().newArray(4)) : this.revoked;
    }

    @JRubyMethod(name={"revoked="})
    public IRubyObject set_revoked(IRubyObject revoked2) {
        this.changed = true;
        this.revoked = (RubyArray)revoked2;
        return this.revoked;
    }

    @JRubyMethod
    public IRubyObject add_revoked(ThreadContext context2, IRubyObject val) {
        this.changed = true;
        this.revoked().callMethod(context2, "<<", val);
        return val;
    }

    @JRubyMethod
    public RubyArray extensions() {
        return this.extensions;
    }

    @JRubyMethod(name={"extensions="})
    public IRubyObject set_extensions(IRubyObject extensions2) {
        this.extensions = (RubyArray)extensions2;
        return this.extensions;
    }

    @JRubyMethod
    public IRubyObject add_extension(IRubyObject extension) {
        this.extensions().append(extension);
        return extension;
    }

    @JRubyMethod
    public IRubyObject sign(ThreadContext context2, IRubyObject key, IRubyObject digest2) {
        int i2;
        Ruby runtime = context2.runtime;
        String signatureAlgorithm = this.getSignatureAlgorithm(runtime, (PKey)key, (Digest)digest2);
        X500Name issuerName = ((X509Name)this.issuer).getX500Name();
        Date thisUpdate = this.getLastUpdate().toDate();
        X509v2CRLBuilder generator = new X509v2CRLBuilder(issuerName, thisUpdate);
        Date nextUpdate = this.getNextUpdate().toDate();
        generator.setNextUpdate(nextUpdate);
        if (this.revoked != null) {
            for (i2 = 0; i2 < this.revoked.size(); ++i2) {
                Extensions revExts;
                X509Revoked rev = (X509Revoked)this.revoked.entry(i2);
                BigInteger serial2 = new BigInteger(rev.callMethod(context2, "serial").toString());
                RubyTime t1 = (RubyTime)rev.callMethod(context2, "time").callMethod(context2, "getutc");
                t1.setMicroseconds(0L);
                if (rev.hasExtensions()) {
                    RubyArray exts = rev.extensions();
                    ASN1Encodable[] array = new ASN1Encodable[exts.size()];
                    for (int j = 0; j < exts.size(); ++j) {
                        X509Extension ext2 = (X509Extension)exts.entry(j);
                        try {
                            array[j] = ext2.toASN1Sequence();
                            continue;
                        }
                        catch (IOException e) {
                            throw X509CRL.newCRLError(runtime, e);
                        }
                    }
                    revExts = Extensions.getInstance((Object)new DERSequence(array));
                } else {
                    revExts = null;
                }
                generator.addCRLEntry(serial2, t1.getJavaDate(), revExts);
            }
        }
        try {
            for (i2 = 0; i2 < this.extensions.size(); ++i2) {
                X509Extension ext3 = (X509Extension)this.extensions.entry(i2);
                ASN1Encodable value2 = ext3.getRealValue();
                generator.addExtension(ext3.getRealObjectID(), ext3.isRealCritical(), value2);
            }
        }
        catch (IOException e) {
            throw X509CRL.newCRLError(runtime, e);
        }
        PrivateKey privateKey = ((PKey)key).getPrivateKey();
        try {
            if (avoidJavaSecurity) {
                // empty if block
            }
            ContentSigner signer = new JcaContentSignerBuilder(signatureAlgorithm).build(privateKey);
            this.crlHolder = generator.build(signer);
            this.crl = null;
        }
        catch (IllegalStateException e) {
            OpenSSL.debugStackTrace(e);
            throw X509CRL.newCRLError(runtime, e);
        }
        catch (Exception e) {
            OpenSSL.debugStackTrace(e);
            throw X509CRL.newCRLError(runtime, e.getMessage());
        }
        ASN1Primitive crlVal = this.getCRLValue(runtime);
        ASN1Sequence v1 = (ASN1Sequence)((ASN1Sequence)crlVal).getObjectAt(0);
        ASN1EncodableVector build1 = new ASN1EncodableVector();
        int copyIndex = 0;
        if (v1.getObjectAt(0) instanceof ASN1Integer) {
            ++copyIndex;
        }
        build1.add((ASN1Encodable)new ASN1Integer(new BigInteger(this.version.toString())));
        while (copyIndex < v1.size()) {
            build1.add(v1.getObjectAt(copyIndex++));
        }
        ASN1EncodableVector build2 = new ASN1EncodableVector();
        build2.add((ASN1Encodable)new DLSequence(build1));
        build2.add(((ASN1Sequence)crlVal).getObjectAt(1));
        build2.add(((ASN1Sequence)crlVal).getObjectAt(2));
        this.crlValue = new DLSequence(build2);
        this.changed = false;
        return this;
    }

    private String getSignatureAlgorithm(Ruby runtime, PKey key, Digest digest2) {
        String keyAlg = key.getAlgorithm();
        String digAlg = digest2.getShortAlgorithm();
        if ("DSA".equalsIgnoreCase(keyAlg) ? "MD5".equalsIgnoreCase(digAlg) : "RSA".equalsIgnoreCase(keyAlg) && "DSS1".equals(digest2.name().toString())) {
            throw X509CRL.newCRLError(runtime, "unsupported key / digest algorithm (" + (Object)((Object)key) + " / " + digAlg + ")");
        }
        return digAlg + "WITH" + keyAlg;
    }

    private boolean isDSA(PKey key) {
        return "DSA".equalsIgnoreCase(key.getAlgorithm());
    }

    private ASN1Primitive getCRLValue(Ruby runtime) {
        if (this.crlValue != null) {
            return this.crlValue;
        }
        this.crlValue = this.readCRL(runtime);
        return this.crlValue;
    }

    private ASN1Primitive readCRL(Ruby runtime) {
        try {
            return ASN1.readObject(this.getEncoded());
        }
        catch (CRLException e) {
            throw X509CRL.newCRLError(runtime, e);
        }
        catch (IOException e) {
            throw X509CRL.newCRLError(runtime, e);
        }
    }

    @JRubyMethod
    public IRubyObject verify(ThreadContext context2, IRubyObject key) {
        if (this.changed) {
            return context2.runtime.getFalse();
        }
        PublicKey publicKey = ((PKey)key).getPublicKey();
        try {
            boolean valid = SecurityHelper.verify(this.getCRL(), publicKey, true);
            return context2.runtime.newBoolean(valid);
        }
        catch (GeneralSecurityException e) {
            OpenSSL.debug("CRL#verify() failed:", e);
            return context2.runtime.getFalse();
        }
    }

    private static RubyClass _CRLError(Ruby runtime) {
        return X509._X509(runtime).getClass("CRLError");
    }

    static RaiseException newCRLError(Ruby runtime, Exception e) {
        return Utils.newError(runtime, X509CRL._CRLError(runtime), e);
    }

    private static RaiseException newCRLError(Ruby runtime, String message) {
        return Utils.newError(runtime, X509CRL._CRLError(runtime), message);
    }
}

