/*
 * Decompiled with CFR 0.152.
 */
package com.jrjackson;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.jrjackson.RubyDateFormat;
import com.jrjackson.RubyUtils;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.ext.bigdecimal.RubyBigDecimal;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyAnySerializer
extends JsonSerializer<IRubyObject> {
    public static final RubyAnySerializer instance = new RubyAnySerializer();

    private void serializeUnknownRubyObject(ThreadContext ctx, IRubyObject rubyObject, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        RubyClass meta = rubyObject.getMetaClass();
        DynamicMethod method = meta.searchMethod("to_json_data");
        if (!method.isUndefined()) {
            RubyObject obj = (RubyObject)method.call(ctx, rubyObject, (RubyModule)meta, "to_json_data");
            if (obj instanceof RubyString) {
                RubyUtils.writeBytes((IRubyObject)obj, jgen);
            } else {
                this.serialize((IRubyObject)obj, jgen, provider);
            }
            return;
        }
        method = meta.searchMethod("to_time");
        if (!method.isUndefined()) {
            RubyTime dt = (RubyTime)method.call(ctx, rubyObject, (RubyModule)meta, "to_time");
            this.serializeTime(dt, jgen, provider);
            return;
        }
        method = meta.searchMethod("to_h");
        if (!method.isUndefined()) {
            RubyObject obj = (RubyObject)method.call(ctx, rubyObject, (RubyModule)meta, "to_h");
            this.serializeHash((IRubyObject)obj, jgen, provider);
            return;
        }
        method = meta.searchMethod("to_hash");
        if (!method.isUndefined()) {
            RubyObject obj = (RubyObject)method.call(ctx, rubyObject, (RubyModule)meta, "to_hash");
            this.serializeHash((IRubyObject)obj, jgen, provider);
            return;
        }
        method = meta.searchMethod("to_a");
        if (!method.isUndefined()) {
            RubyObject obj = (RubyObject)method.call(ctx, rubyObject, (RubyModule)meta, "to_a");
            this.serializeArray((IRubyObject)obj, jgen, provider);
            return;
        }
        method = meta.searchMethod("to_json");
        if (!method.isUndefined()) {
            RubyObject obj = (RubyObject)method.call(ctx, rubyObject, (RubyModule)meta, "to_json");
            if (obj instanceof RubyString) {
                jgen.writeRawValue(obj.toString());
            } else {
                this.serialize((IRubyObject)obj, jgen, provider);
            }
            return;
        }
        throw new JsonGenerationException("Cannot serialize instance of: " + meta.getRealClass().getName(), jgen);
    }

    public void serialize(IRubyObject value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (value.isNil()) {
            jgen.writeNull();
        } else if (value instanceof JavaProxy) {
            provider.defaultSerializeValue(((JavaProxy)value).getObject(), jgen);
        } else {
            RUBYCLASS clazz;
            String rubyClassName = value.getMetaClass().getRealClass().getName();
            try {
                clazz = RUBYCLASS.valueOf(rubyClassName);
            }
            catch (IllegalArgumentException e) {
                this.serializeUnknownRubyObject(value.getRuntime().getCurrentContext(), value, jgen, provider);
                return;
            }
            switch (clazz) {
                case Hash: {
                    this.serializeHash(value, jgen, provider);
                    break;
                }
                case Array: {
                    this.serializeArray(value, jgen, provider);
                    break;
                }
                case String: {
                    RubyUtils.writeBytes(value, jgen);
                    break;
                }
                case Symbol: 
                case Date: {
                    RubyString s = value.asString();
                    jgen.writeUTF8String(s.getBytes(), 0, s.size());
                    break;
                }
                case TrueClass: 
                case FalseClass: {
                    jgen.writeBoolean(value.isTrue());
                    break;
                }
                case Float: {
                    jgen.writeNumber(RubyNumeric.num2dbl((IRubyObject)value));
                    break;
                }
                case Fixnum: {
                    jgen.writeNumber(RubyNumeric.num2long((IRubyObject)value));
                    break;
                }
                case Bignum: {
                    jgen.writeNumber(((RubyBignum)value).getBigIntegerValue());
                    break;
                }
                case BigDecimal: {
                    jgen.writeNumber(((RubyBigDecimal)value).getBigDecimalValue());
                    break;
                }
                case Struct: {
                    IRubyObject obj = value.callMethod(value.getRuntime().getCurrentContext(), "to_a");
                    this.serializeArray(obj, jgen, provider);
                    break;
                }
                case Time: {
                    this.serializeTime((RubyTime)value, jgen, provider);
                    break;
                }
                default: {
                    this.serializeUnknownRubyObject(value.getRuntime().getCurrentContext(), value, jgen, provider);
                }
            }
        }
    }

    private void serializeArray(IRubyObject value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        RubyArray arr = (RubyArray)value;
        IRubyObject[] a = arr.toJavaArray();
        jgen.writeStartArray();
        for (IRubyObject val : a) {
            this.serialize(val, jgen, provider);
        }
        jgen.writeEndArray();
    }

    private void serializeHash(IRubyObject value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        RubyHash h = (RubyHash)value;
        jgen.writeStartObject();
        for (Object o : h.directEntrySet()) {
            RubyHash.RubyHashEntry next = (RubyHash.RubyHashEntry)o;
            this.serializeKey((IRubyObject)next.getKey(), jgen, provider);
            this.serialize((IRubyObject)next.getValue(), jgen, provider);
        }
        jgen.writeEndObject();
    }

    private void serializeTime(RubyTime dt, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        DateFormat df = provider.getConfig().getDateFormat();
        if (df == null) {
            provider.defaultSerializeDateValue(dt.getJavaDate(), jgen);
        } else if (df instanceof RubyDateFormat) {
            RubyDateFormat rdf = (RubyDateFormat)df.clone();
            jgen.writeString(rdf.format(dt.getJavaDate()));
        } else {
            SimpleDateFormat sdf = (SimpleDateFormat)df.clone();
            jgen.writeString(df.format(dt.getJavaDate()));
        }
    }

    private void serializeKey(IRubyObject key, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (key instanceof RubyString) {
            jgen.writeFieldName(((RubyString)key).decodeString());
        } else {
            jgen.writeFieldName(key.toString());
        }
    }

    public void serializeWithType(IRubyObject value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
        typeSer.writeTypePrefixForScalar((Object)value, jgen);
        this.serialize(value, jgen, provider);
        typeSer.writeTypeSuffixForScalar((Object)value, jgen);
    }

    static enum RUBYCLASS {
        String,
        Float,
        BigDecimal,
        Time,
        Array,
        Hash,
        Fixnum,
        Bignum,
        Date,
        Symbol,
        Struct,
        TrueClass,
        FalseClass;

    }
}

