/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.representations;

import java.util.ArrayList;
import java.util.List;
import org.jruby.RubyInstanceConfig;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRScope;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.YieldInstr;
import org.jruby.ir.listeners.InstructionsListener;
import org.jruby.ir.listeners.InstructionsListenerDecorator;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.representations.CFG;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.ir.util.ExplicitVertexID;

public class BasicBlock
implements ExplicitVertexID {
    private int id;
    private CFG cfg;
    private Label label;
    private List<Instr> instrs;
    private boolean isRescueEntry;
    private Instr[] instrsArray;

    public BasicBlock(CFG c, Label l) {
        IRManager irManager;
        InstructionsListener listener;
        this.label = l;
        this.cfg = c;
        this.id = c.getNextBBID();
        this.instrs = new ArrayList<Instr>();
        if ((RubyInstanceConfig.IR_COMPILER_DEBUG || RubyInstanceConfig.IR_VISUALIZER) && (listener = (irManager = this.cfg.getScope().getManager()).getInstructionsListener()) != null) {
            this.instrs = new InstructionsListenerDecorator(this.instrs, listener);
        }
        this.instrsArray = null;
        this.isRescueEntry = false;
    }

    @Override
    public int getID() {
        return this.id;
    }

    public Label getLabel() {
        return this.label;
    }

    public void markRescueEntryBB() {
        this.isRescueEntry = true;
    }

    public boolean isRescueEntry() {
        return this.isRescueEntry;
    }

    public void addInstr(Instr i2) {
        this.instrs.add(i2);
    }

    public void insertInstr(Instr i2) {
        this.instrs.add(0, i2);
    }

    public List<Instr> getInstrs() {
        return this.instrs;
    }

    public int instrCount() {
        return this.instrs.size();
    }

    public Instr[] getInstrsArray() {
        if (this.instrsArray == null) {
            this.instrsArray = this.instrs.toArray(new Instr[this.instrs.size()]);
        }
        return this.instrsArray;
    }

    public Instr getLastInstr() {
        int n = this.instrs.size();
        return n == 0 ? null : this.instrs.get(n - 1);
    }

    public boolean removeInstr(Instr i2) {
        return i2 == null ? false : this.instrs.remove(i2);
    }

    public boolean isEmpty() {
        return this.instrs.isEmpty();
    }

    public BasicBlock splitAtInstruction(Instr splitPoint, Label newLabel, boolean includeSplitPointInstr) {
        BasicBlock newBB = new BasicBlock(this.cfg, newLabel);
        int idx = 0;
        int numInstrs = this.instrs.size();
        boolean found = false;
        for (Instr i2 : this.instrs) {
            if (i2 == splitPoint) {
                found = true;
            }
            if (found) {
                if (!includeSplitPointInstr && i2 == splitPoint) continue;
                newBB.addInstr(i2);
                continue;
            }
            ++idx;
        }
        for (int j = 0; j < numInstrs - idx; ++j) {
            this.instrs.remove(idx);
        }
        return newBB;
    }

    public void swallowBB(BasicBlock foodBB) {
        this.instrs.addAll(foodBB.instrs);
    }

    public BasicBlock cloneForInlinedMethod(InlinerInfo ii) {
        IRScope hostScope = ii.getInlineHostScope();
        BasicBlock clonedBB = ii.getOrCreateRenamedBB(this);
        for (Instr i2 : this.getInstrs()) {
            CallBase call2;
            Operand block;
            Instr clonedInstr = i2.cloneForInlinedScope(ii);
            if (clonedInstr == null) continue;
            clonedBB.addInstr(clonedInstr);
            if (clonedInstr instanceof YieldInstr) {
                ii.recordYieldSite(clonedBB, (YieldInstr)clonedInstr);
            }
            if (!(clonedInstr instanceof CallBase) || !((block = (call2 = (CallBase)clonedInstr).getClosureArg(null)) instanceof WrappedIRClosure)) continue;
            hostScope.addClosure(((WrappedIRClosure)block).getClosure());
        }
        return clonedBB;
    }

    public BasicBlock cloneForInlinedClosure(InlinerInfo ii) {
        IRScope hostScope = ii.getInlineHostScope();
        BasicBlock clonedBB = ii.getOrCreateRenamedBB(this);
        for (Instr i2 : this.getInstrs()) {
            CallBase call2;
            Operand block;
            Instr clonedInstr = i2.cloneForInlinedClosure(ii);
            if (clonedInstr == null) continue;
            clonedBB.addInstr(clonedInstr);
            if (!(clonedInstr instanceof CallBase) || !((block = (call2 = (CallBase)clonedInstr).getClosureArg(null)) instanceof WrappedIRClosure)) continue;
            hostScope.addClosure(((WrappedIRClosure)block).getClosure());
        }
        return clonedBB;
    }

    public String toString() {
        return "BB [" + this.id + ":" + this.label + "]";
    }

    public String toStringInstrs() {
        StringBuilder buf = new StringBuilder(this.toString() + "\n");
        for (Instr instr : this.getInstrs()) {
            buf.append('\t').append(instr).append('\n');
        }
        return buf.toString();
    }
}

