/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.dataflow.analyses;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jruby.ir.IREvalScript;
import org.jruby.ir.IRScope;
import org.jruby.ir.dataflow.DataFlowProblem;
import org.jruby.ir.dataflow.DataFlowVar;
import org.jruby.ir.dataflow.FlowGraphNode;
import org.jruby.ir.dataflow.analyses.LiveVariableNode;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.representations.BasicBlock;

public class LiveVariablesProblem
extends DataFlowProblem {
    public static final String NAME = "Live Variables Analysis";
    private static final Set<LocalVariable> EMPTY_SET = new HashSet<LocalVariable>();
    private HashMap<Variable, DataFlowVar> dfVarMap = new HashMap();
    private HashMap<Integer, Variable> varDfVarMap = new HashMap();
    private HashSet<LocalVariable> localVars = new HashSet();
    private List<LocalVariable> alwaysLiveVars;
    private Collection<LocalVariable> varsLiveOnScopeExit;

    public LiveVariablesProblem(IRScope scope) {
        this(scope, EMPTY_SET);
    }

    LiveVariablesProblem(IRScope scope, Set<LocalVariable> nonSelfLocalVars) {
        super(DataFlowProblem.DF_Direction.BACKWARD);
        this.setup(scope, nonSelfLocalVars);
    }

    public DataFlowVar getDFVar(Variable v) {
        return this.dfVarMap.get(v);
    }

    public boolean dfVarExists(Variable v) {
        return this.getDFVar(v) != null;
    }

    public Variable getVariable(int id2) {
        return this.varDfVarMap.get(id2);
    }

    @Override
    public FlowGraphNode buildFlowGraphNode(BasicBlock bb) {
        return new LiveVariableNode(this, bb);
    }

    public void addDFVar(Variable v) {
        DataFlowVar dfv = new DataFlowVar(this);
        this.dfVarMap.put(v, dfv);
        this.varDfVarMap.put(dfv.id, v);
        if (v instanceof LocalVariable && !((LocalVariable)v).isSelf()) {
            int n = ((LocalVariable)v).getScopeDepth();
            for (IRScope s2 = this.getScope(); s2 != null && n >= 0; s2 = s2.getLexicalParent(), --n) {
                if (!(s2 instanceof IREvalScript)) continue;
                this.alwaysLiveVars.add((LocalVariable)v);
                break;
            }
            this.localVars.add((LocalVariable)v);
        }
    }

    public List<Variable> getVarsLiveOnScopeEntry() {
        ArrayList<Variable> liveVars = new ArrayList<Variable>();
        BitSet liveIn = ((LiveVariableNode)this.getFlowGraphNode(this.getScope().cfg().getEntryBB())).getLiveOutBitSet();
        for (int i2 = 0; i2 < liveIn.size(); ++i2) {
            if (!liveIn.get(i2)) continue;
            Variable v = this.getVariable(i2);
            liveVars.add(v);
        }
        return liveVars;
    }

    public final void setup(IRScope scope, Collection<LocalVariable> allVars) {
        this.alwaysLiveVars = new ArrayList<LocalVariable>();
        this.setup(scope);
        this.varsLiveOnScopeExit = new ArrayList<LocalVariable>(this.alwaysLiveVars);
        for (Variable variable : allVars) {
            if (this.getDFVar(variable) != null) continue;
            this.addDFVar(variable);
        }
    }

    @Override
    public String getDataFlowVarsForOutput() {
        StringBuilder buf = new StringBuilder();
        for (Variable v : this.dfVarMap.keySet()) {
            buf.append("DF Var ").append(this.dfVarMap.get(v).getId()).append(" = ").append(v).append("\n");
        }
        return buf.toString();
    }

    public void markDeadInstructions() {
        for (FlowGraphNode n : this.flowGraphNodes) {
            ((LiveVariableNode)n).markDeadInstructions();
        }
    }

    public void setVarsLiveOnScopeExit(Collection<LocalVariable> vars) {
        this.varsLiveOnScopeExit.addAll(vars);
    }

    public Collection<LocalVariable> getVarsLiveOnScopeExit() {
        return this.varsLiveOnScopeExit;
    }

    public Set<Variable> getAllVars() {
        return this.dfVarMap.keySet();
    }

    public Set<LocalVariable> getNonSelfLocalVars() {
        return this.localVars;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

