# KDbConfig.cmake provides information about the installed KDb library.
# It can be used directly from CMake via find_package(KDb NO_MODULE)
#
# Any changes in this ".cmake" file will be overwritten by CMake, the source is the ".cmake.in" file.
#
# The following CMake variables are provided:
#   KDb_VERSION_MAJOR - the major version number of KDb
#   KDb_VERSION_MINOR - the minor version number of KDb
#   KDb_VERSION_PATCH - the patch version number of KDb
#   KDb_INCLUDE_DIRS  - the include directories to use
#
# Additionally, the following imported library targets are created, which may be used directly
# with target_link_libraries():
#   KDb - the KDb library
#
# Provided features are available under KDB_* variables at the end of this file.


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was KDbConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

include(CMakeFindDependencyMacro)

find_dependency(Qt5Core 5.4.0)
find_dependency(Qt5Widgets 5.4.0)
find_dependency(Qt5Xml 5.4.0)
find_dependency(KF5CoreAddons 5.16.0)

include("${CMAKE_CURRENT_LIST_DIR}/KDbTargets.cmake")

# Features
set(KDB_DEBUG_GUI OFF)

# Match COMPONENTS to features (KDB_ prefixes)
#message(status " KDb_FIND_COMPONENTS=${KDb_FIND_COMPONENTS}")
foreach (_COMP ${KDb_FIND_COMPONENTS})
    if(NOT DEFINED KDB_${_COMP} OR NOT ${KDB_${_COMP}})
        message(FATAL_ERROR "KDb does not contain required component ${_COMP}. Update KDb or remove this requirement.")
    endif()
endforeach()

include(FeatureSummary)
set_package_properties(KDb PROPERTIES
                       DESCRIPTION "Database connectivity and creation framework"
                       URL "https://community.kde.org/KDb")
