#!/bin/sh
export PATH='/usr/obj/ports/hs-hackage-security-0.5.2.2/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: hackage-security
version: 0.5.2.2
id: hackage-security-0.5.2.2-2xPvTJk9eMUH8RAihmaWhK
key: hackage-security-0.5.2.2-2xPvTJk9eMUH8RAihmaWhK
license: BSD3
copyright: Copyright 2015-2016 Well-Typed LLP
maintainer: edsko@well-typed.com
homepage: https://github.com/well-typed/hackage-security
synopsis: Hackage security library
description:
    The hackage security library provides both server and
    client utilities for securing the Hackage package server
    (<http://hackage.haskell.org/>).  It is based on The Update
    Framework (<http://theupdateframework.com/>), a set of
    recommendations developed by security researchers at
    various universities in the US as well as developers on the
    Tor project (<https://www.torproject.org/>).
    .
    The current implementation supports only index signing,
    thereby enabling untrusted mirrors. It does not yet provide
    facilities for author package signing.
    .
    The library has two main entry points:
    "Hackage.Security.Client" is the main entry point for
    clients (the typical example being @cabal@), and
    "Hackage.Security.Server" is the main entry point for
    servers (the typical example being @hackage-server@).
category: Distribution
author: Edsko de Vries
exposed: True
indefinite: False
exposed-modules:
    Hackage.Security.Client Hackage.Security.Client.Formats
    Hackage.Security.Client.Repository
    Hackage.Security.Client.Repository.Cache
    Hackage.Security.Client.Repository.HttpLib
    Hackage.Security.Client.Repository.Local
    Hackage.Security.Client.Repository.Remote
    Hackage.Security.Client.Verify Hackage.Security.JSON
    Hackage.Security.Key.Env Hackage.Security.Server
    Hackage.Security.TUF.FileMap Hackage.Security.Trusted
    Hackage.Security.Util.Checked Hackage.Security.Util.IO
    Hackage.Security.Util.Lens Hackage.Security.Util.Path
    Hackage.Security.Util.Pretty Hackage.Security.Util.Some
    Text.JSON.Canonical
hidden-modules: Hackage.Security.Key Hackage.Security.Trusted.TCB
                Hackage.Security.TUF Hackage.Security.TUF.Common
                Hackage.Security.TUF.FileInfo Hackage.Security.TUF.Header
                Hackage.Security.TUF.Layout.Cache Hackage.Security.TUF.Layout.Index
                Hackage.Security.TUF.Layout.Repo Hackage.Security.TUF.Mirrors
                Hackage.Security.TUF.Paths Hackage.Security.TUF.Patterns
                Hackage.Security.TUF.Root Hackage.Security.TUF.Signed
                Hackage.Security.TUF.Snapshot Hackage.Security.TUF.Targets
                Hackage.Security.TUF.Timestamp Hackage.Security.Util.Base64
                Hackage.Security.Util.JSON Hackage.Security.Util.Stack
                Hackage.Security.Util.TypedEmbedded Prelude
abi: 423cacbbb072b84641fe012981e47ed6
trusted: False
import-dirs: /usr/local/lib/ghc/hackage-security-0.5.2.2
library-dirs: /usr/local/lib/ghc/hackage-security-0.5.2.2
              /usr/local/lib/x86_64-openbsd-ghc-8.2.2
data-dir: /usr/local/share/hs-hackage-security-0.5.2.2
hs-libraries: HShackage-security-0.5.2.2-2xPvTJk9eMUH8RAihmaWhK
depends:
    base-4.10.1.0 base16-bytestring-0.1.1.5-6C0w7pcEjtRYQOqmnwyBO
    base64-bytestring-1.0.0.0-1by0UXugZ1QA46cGNBhjge
    bytestring-0.10.8.2 Cabal-2.0.1.0 containers-0.5.10.2
    directory-1.3.0.2 ed25519-0.0.5.0-3Sle7uACwGIJ1UEE9iZB8E
    filepath-1.4.1.2 mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH
    parsec-3.1.9-444fzLM2idQ5vByZuGIOJ pretty-1.1.3.3
    cryptohash-sha256-0.11.101.0-2y5kOPF2abcAQTysw8Z7cK
    tar-0.5.0.3-4RaKOzbHzG1EpSAqFcpBFH time-1.8.0.2
    transformers-0.5.2.0 zlib-0.5.4.2-F6BHJqwkis53HpMy7MLAqK
    template-haskell-2.12.0.0 ghc-prim-0.5.1.1
    network-uri-2.6.0.3-GWiZs2R299yBQO2d6Ohaq0
    network-2.6.2.1-EN7QebdZTnQLy4O4vi1CmV
abi-depends: base-4.10.1.0=3319c96bc0bdd0e7df6bb89e8bc8756b
             base16-bytestring-0.1.1.5-6C0w7pcEjtRYQOqmnwyBO=4a1008421db98ed58268c987f8bffeaa
             base64-bytestring-1.0.0.0-1by0UXugZ1QA46cGNBhjge=1b23c9b40457173f4699350c800a6a19
             bytestring-0.10.8.2=96a37efba3f680a6fd96553c4173d263
             Cabal-2.0.1.0=f7d09c3199e9927fc4e499fea78c1ec2
             containers-0.5.10.2=3a910cd7b137e6ec964a6149559bd205
             directory-1.3.0.2=89a675d415b6f9ef917edd79b87ac775
             ed25519-0.0.5.0-3Sle7uACwGIJ1UEE9iZB8E=fc6c06a28c82c6ae6d1c3be6833727d1
             filepath-1.4.1.2=f49190c9093d895f9f159c40e7d1ff46
             mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH=1e76d6f7019a4b5c8c222b2fbbb06681
             parsec-3.1.9-444fzLM2idQ5vByZuGIOJ=a369a8a10945a0b8aaa4d2c66712ca09
             pretty-1.1.3.3=97ea8e310dd6a2f22cf144bcaba08212
             cryptohash-sha256-0.11.101.0-2y5kOPF2abcAQTysw8Z7cK=a97957d803c4b89c2ae13434da08f9d5
             tar-0.5.0.3-4RaKOzbHzG1EpSAqFcpBFH=b56eec0fce685a555ac2bf4abbceed65
             time-1.8.0.2=1980548222fbca3cc4f4aa5245bbb96e
             transformers-0.5.2.0=e04579c0363c9229351d1a0b394bf2d5
             zlib-0.5.4.2-F6BHJqwkis53HpMy7MLAqK=ad609bc4dc5b05bf485166ea5811da39
             template-haskell-2.12.0.0=23eb77c3fcb7809b7db73842f3d4fcfe
             ghc-prim-0.5.1.1=c8f3d173544d1472727fce7b0518abda
             network-uri-2.6.0.3-GWiZs2R299yBQO2d6Ohaq0=a6b6b8644440f5ddf28d07e319fd9a50
             network-2.6.2.1-EN7QebdZTnQLy4O4vi1CmV=1e391bce62287578e3a86dbbea151616
haddock-interfaces: /usr/local/share/doc/hs-hackage-security-0.5.2.2/html/hackage-security.haddock
haddock-html: /usr/local/share/doc/hs-hackage-security-0.5.2.2/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"

