#
# Copyright 2015 Google Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Generated message classes for fusiontables version v1.

API for working with Fusion Tables data.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages


package = 'fusiontables'


class Column(_messages.Message):

    """Specifies the id, name and type of a column in a table.

    Messages:
      BaseColumnValue: Optional identifier of the base column. If present, this
        column is derived from the specified base column.

    Fields:
      baseColumn: Optional identifier of the base column. If present, this
        column is derived from the specified base column.
      columnId: Identifier for the column.
      description: Optional column description.
      graph_predicate: Optional column predicate. Used to map table to
        graph data model (subject,predicate,object) See
        http://www.w3.org/TR/2014/REC-
        rdf11-concepts-20140225/#data-model
      kind: Type name: a template for an individual column.
      name: Required name of the column.
      type: Required type of the column.

    """

    class BaseColumnValue(_messages.Message):

        """Optional identifier of the base column. If present, this column is
        derived from the specified base column.

        Fields:
          columnId: The id of the column in the base table from which
            this column is derived.
          tableIndex: Offset to the entry in the list of base tables
            in the table definition.

        """

        columnId = _messages.IntegerField(1, variant=_messages.Variant.INT32)
        tableIndex = _messages.IntegerField(2, variant=_messages.Variant.INT32)

    baseColumn = _messages.MessageField('BaseColumnValue', 1)
    columnId = _messages.IntegerField(2, variant=_messages.Variant.INT32)
    description = _messages.StringField(3)
    graph_predicate = _messages.StringField(4)
    kind = _messages.StringField(5, default=u'fusiontables#column')
    name = _messages.StringField(6)
    type = _messages.StringField(7)


class ColumnList(_messages.Message):

    """Represents a list of columns in a table.

    Fields:
      items: List of all requested columns.
      kind: Type name: a list of all columns.
      nextPageToken: Token used to access the next page of this
        result. No token is displayed if there are no more pages left.
      totalItems: Total number of columns for the table.

    """

    items = _messages.MessageField('Column', 1, repeated=True)
    kind = _messages.StringField(2, default=u'fusiontables#columnList')
    nextPageToken = _messages.StringField(3)
    totalItems = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class FusiontablesColumnListRequest(_messages.Message):

    """A FusiontablesColumnListRequest object.

    Fields:
      maxResults: Maximum number of columns to return. Optional. Default is 5.
      pageToken: Continuation token specifying which result page to return.
        Optional.
      tableId: Table whose columns are being listed.
    """

    maxResults = _messages.IntegerField(1, variant=_messages.Variant.UINT32)
    pageToken = _messages.StringField(2)
    tableId = _messages.StringField(3, required=True)


class FusiontablesColumnListAlternateRequest(_messages.Message):

    """A FusiontablesColumnListRequest object.

    Fields:
      pageSize: Maximum number of columns to return. Optional. Default is 5.
      pageToken: Continuation token specifying which result page to return.
        Optional.
      tableId: Table whose columns are being listed.
    """

    pageSize = _messages.IntegerField(1, variant=_messages.Variant.UINT32)
    pageToken = _messages.StringField(2)
    tableId = _messages.StringField(3, required=True)


class ColumnListAlternate(_messages.Message):

    """Represents a list of columns in a table.

    Fields:
      items: List of all requested columns.
      kind: Type name: a list of all columns.
      nextPageToken: Token used to access the next page of this
        result. No token is displayed if there are no more pages left.
      totalItems: Total number of columns for the table.

    """

    columns = _messages.MessageField('Column', 1, repeated=True)
    kind = _messages.StringField(2, default=u'fusiontables#columnList')
    nextPageToken = _messages.StringField(3)
    totalItems = _messages.IntegerField(4, variant=_messages.Variant.INT32)
