"""Generated message classes for cloudtasks version v2beta2.

Cloud Tasks enables developers to manage the execution of large numbers of
distributed requests.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'cloudtasks'


class AcknowledgeTaskRequest(_messages.Message):
  """Request message for acknowledging a task using
  CloudTasks.AcknowledgeTask.

  Fields:
    scheduleTime: Required.  The task schedule time, available in the
      Task.schedule_time returned in PullTasksResponse.tasks or
      CloudTasks.RenewLease.  This restriction is to check that the caller is
      acknowledging the correct task.
  """

  scheduleTime = _messages.StringField(1)


class AppEngineQueueConfig(_messages.Message):
  """App Engine queue config.  The task will be delivered to the App Engine
  application URL specified by its AppEngineQueueConfig and
  AppEngineTaskTarget. The documentation for AppEngineTaskTarget explains how
  the task's host URL is constructed.  When creating or updating this type of
  target, the following scope must be used: `https://www.googleapis.com/auth
  /cloud-platform`.

  Messages:
    HeadersValue: HTTP request headers.  This map contains the header field
      names and values. Repeated headers are not supported but a header value
      can contain commas.  Some headers, such as the ones below, will be
      automatically set by Cloud Tasks:  * Host: The host is constructed from
      many settings in   AppEngineQueueConfig and AppEngineTaskTarget. See the
      documentation for AppEngineTaskTarget for more   information. If set,
      the host header has to exactly match the   resolved hostname, otherwise
      an error will be returned. * Content-Length: This will be computed and
      overwritten by Cloud Tasks. * X-Google-*: For Google internal use only.
      * X-AppEngine-*: For Google internal use only. See
      [here](https://cloud.google.com/appengine/docs/python/taskqueue/push
      /creating-handlers#reading_request_headers).  When a task is attempted,
      AppEngineQueueConfig.headers will be merged with the task's
      AppEngineTaskTarget.headers and the merged headers will be sent with the
      task's overrides. In addition, some App Engine headers, which contain
      task-specific information, will also be sent to the task handler; see
      [here](https://cloud.google.com/appengine/docs/python/taskqueue/push
      /creating-handlers#reading_request_headers).

  Fields:
    appEngineRoutingOverrides: Overrides for the task-level
      app_engine_routing.  If set,
      AppEngineQueueConfig.app_engine_routing_overrides is used for all tasks
      in the queue, no matter what the setting is for the task-level
      app_engine_routing.
    headers: HTTP request headers.  This map contains the header field names
      and values. Repeated headers are not supported but a header value can
      contain commas.  Some headers, such as the ones below, will be
      automatically set by Cloud Tasks:  * Host: The host is constructed from
      many settings in   AppEngineQueueConfig and AppEngineTaskTarget. See the
      documentation for AppEngineTaskTarget for more   information. If set,
      the host header has to exactly match the   resolved hostname, otherwise
      an error will be returned. * Content-Length: This will be computed and
      overwritten by Cloud Tasks. * X-Google-*: For Google internal use only.
      * X-AppEngine-*: For Google internal use only. See
      [here](https://cloud.google.com/appengine/docs/python/taskqueue/push
      /creating-handlers#reading_request_headers).  When a task is attempted,
      AppEngineQueueConfig.headers will be merged with the task's
      AppEngineTaskTarget.headers and the merged headers will be sent with the
      task's overrides. In addition, some App Engine headers, which contain
      task-specific information, will also be sent to the task handler; see
      [here](https://cloud.google.com/appengine/docs/python/taskqueue/push
      /creating-handlers#reading_request_headers).
    retryConfig: Deprecated. Queue.retry_config replaces this field. If both
      this field and Queue.retry_config are specified, Queue.retry_config
      takes precedence.  Settings that determine the retry behavior.  The
      task's retry configuration (AppEngineTaskTarget.retry_config) overrides
      the queue's retry configuration (AppEngineQueueConfig.retry_config).
    throttleConfig: Config for throttling task dispatches.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class HeadersValue(_messages.Message):
    """HTTP request headers.  This map contains the header field names and
    values. Repeated headers are not supported but a header value can contain
    commas.  Some headers, such as the ones below, will be automatically set
    by Cloud Tasks:  * Host: The host is constructed from many settings in
    AppEngineQueueConfig and AppEngineTaskTarget. See the   documentation for
    AppEngineTaskTarget for more   information. If set, the host header has to
    exactly match the   resolved hostname, otherwise an error will be
    returned. * Content-Length: This will be computed and overwritten by Cloud
    Tasks. * X-Google-*: For Google internal use only. * X-AppEngine-*: For
    Google internal use only. See
    [here](https://cloud.google.com/appengine/docs/python/taskqueue/push
    /creating-handlers#reading_request_headers).  When a task is attempted,
    AppEngineQueueConfig.headers will be merged with the task's
    AppEngineTaskTarget.headers and the merged headers will be sent with the
    task's overrides. In addition, some App Engine headers, which contain
    task-specific information, will also be sent to the task handler; see
    [here](https://cloud.google.com/appengine/docs/python/taskqueue/push
    /creating-handlers#reading_request_headers).

    Messages:
      AdditionalProperty: An additional property for a HeadersValue object.

    Fields:
      additionalProperties: Additional properties of type HeadersValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a HeadersValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  appEngineRoutingOverrides = _messages.MessageField('AppEngineRouting', 1)
  headers = _messages.MessageField('HeadersValue', 2)
  retryConfig = _messages.MessageField('RetryConfig', 3)
  throttleConfig = _messages.MessageField('ThrottleConfig', 4)


class AppEngineRouting(_messages.Message):
  """App Engine Routing.  For more information about services, versions, and
  instances see [An Overview of App
  Engine](https://cloud.google.com/appengine/docs/python/an-overview-of-app-
  engine) and [Microservices Architecture on Google App
  Engine](https://cloud.google.com/appengine/docs/python/microservices-on-app-
  engine).  Note: The routing for some queues or tasks which were not created
  using the Cloud Tasks API may not be parsable into AppEngineRouting. For
  example, if numeric version names are used, then urls such as `123.my-
  service.appspot.com` are ambiguous because `123` can be interpreted as a
  version or instance number. See
  [here](https://cloud.google.com/appengine/docs/python/how-requests-are-
  routed#soft_routing) for more information. If the routing is unparsable,
  AppEngineRouting will be empty; the routing information can be viewed in the
  HOST header in AppEngineQueueConfig.headers and AppEngineTaskTarget.headers.

  Fields:
    instance: App instance.  By default, the task will be sent to an instance
      which is available when the task is attempted.  Requests can only be
      sent to a specific instance if basic or manual scaling is used. For more
      information see [here](https://cloud.google.com/appengine/docs/python
      /an-overview-of-app-engine?hl=en_US#scaling_types_and_instance_classes).
    service: App service.  By default, the task will be sent to the service
      which is the default service when the task is attempted ("default").
    version: App version.  Version names should begin with a letter, to
      distinguish them from numeric instances in the app URL; for more
      information see [here](https://cloud.google.com/appengine/docs/python
      /how-requests-are-routed#soft_routing).  By default, the task will be
      sent to the version which is the default version when the task is
      attempted ("default").
  """

  instance = _messages.StringField(1)
  service = _messages.StringField(2)
  version = _messages.StringField(3)


class AppEngineTaskTarget(_messages.Message):
  """App Engine task target.  This proto can only be used for tasks in a queue
  which has Queue.app_engine_queue_config set.  When creating this type of
  task target, the following scope must be used:
  `https://www.googleapis.com/auth/cloud-platform`.  The task will be
  delivered to the URL specified by the AppEngineQueueConfig and
  AppEngineTaskTarget in the App Engine app which belongs to the same project
  as the queue. See [here](https://cloud.google.com/appengine/docs/python/how-
  requests-are-routed) for information on how requests are routed in App
  Engine and how routing is affected by [dispatch
  files](https://cloud.google.com/appengine/docs/python/config/dispatchref).
  The AppEngineRouting used to construct the URL can be set at the queue-level
  or task-level:  *  If set, AppEngineQueueConfig.app_engine_routing_overrides
  is used for    all tasks in the queue, no matter what the setting is for the
  task-level app_engine_routing.   The `url` that the task will be sent to is:
  * `url = host +` AppEngineTaskTarget.relative_url  * `host =
  [application_domain_name]`</br>   `| [service] + '.' +
  [application_domain_name]`</br>   `| [version] + '.' +
  [application_domain_name]`</br>   `| [version_dot_service]+ '.' +
  [application_domain_name]`</br>   `| [instance] + '.' +
  [application_domain_name]`</br>   `| [instance_dot_service] + '.' +
  [application_domain_name]`</br>   `| [instance_dot_version] + '.' +
  [application_domain_name]`</br>   `| [instance_dot_version_dot_service] +
  '.' + [application_domain_name]`  * `application_domain_name` = The domain
  name of the app, for   example <app-id>.appspot.com, which is associated
  with the   queue's project ID.  * `service =` AppEngineRouting.service  *
  `version =` AppEngineRouting.version  * `version_dot_service =`
  AppEngineRouting.version `+ '.' +` AppEngineRouting.service  * `instance =`
  AppEngineRouting.instance  * `instance_dot_service =`
  AppEngineRouting.instance `+ '.' +` AppEngineRouting.service  *
  `instance_dot_version =`   AppEngineRouting.instance `+ '.' +`
  AppEngineRouting.version  * `instance_dot_version_dot_service =`
  AppEngineRouting.instance `+ '.' +`   AppEngineRouting.version `+ '.' +`
  AppEngineRouting.service  If AppEngineRouting.service is empty, then the
  task will be sent to the service which is the default service when the task
  is attempted.  If AppEngineRouting.version is empty, then the task will be
  sent to the version which is the default version when the task is attempted.
  If AppEngineRouting.instance is empty, then the task will be sent to an
  instance which is available when the task is attempted.  If
  AppEngineRouting.service, AppEngineRouting.version, or
  AppEngineRouting.instance is invalid, then the task will be sent to the
  default version of the default service when the task is attempted.  The task
  will be sent to a task handler by an HTTP request using the specified
  AppEngineTaskTarget.http_method (for example POST, HTTP GET, etc). The task
  attempt has succeeded if the task handler returns an HTTP response code in
  the range [200 - 299]. Error 503 is considered an App Engine system error
  instead of an application error. Requests returning error 503 will be
  retried regardless of retry configuration and not counted against retry
  counts. Any other response code or a failure to receive a response before
  the deadline is a failed attempt.

  Enums:
    HttpMethodValueValuesEnum: The HTTP method to use for the request. The
      default is POST.  The app's request handler for the task's target URL
      must be able to handle HTTP requests with this http_method, otherwise
      the task attempt will fail with error code 405 "Method Not Allowed"
      because "the method specified in the Request-Line is not allowed for the
      resource identified by the Request-URI". See [Writing a push task
      request
      handler](https://cloud.google.com/appengine/docs/java/taskqueue/push
      /creating-handlers#writing_a_push_task_request_handler) and the
      documentation for the request handlers in the language your app is
      written in e.g. [python RequestHandler](https://cloud.google.com/appengi
      ne/docs/python/tools/webapp/requesthandlerclass).

  Messages:
    HeadersValue: HTTP request headers.  This map contains the header field
      names and values. Repeated headers are not supported but a header value
      can contain commas.  Some headers, such as the ones below, will be
      automatically set by Cloud Tasks:  * Host: The host is constructed from
      many settings in   AppEngineQueueConfig and AppEngineTaskTarget. See the
      documentation for AppEngineTaskTarget for more   information. If set,
      the host header has to exactly match the   resolved hostname, otherwise
      an error will be returned. * Content-Length: This will be computed and
      overwritten by Cloud Tasks. * X-Google-*: For Google internal use only.
      * X-AppEngine-*: For Google internal use only. See
      [here](https://cloud.google.com/appengine/docs/python/taskqueue/push
      /creating-handlers#reading_request_headers).  When a task is attempted,
      AppEngineQueueConfig.headers will be merged with the task's
      AppEngineTaskTarget.headers and the merged headers will be sent with the
      task's HTTP request. In addition, some App Engine headers will be set
      which contain task-specific information that can be used by the handler;
      see [here](https://cloud.google.com/appengine/docs/python/taskqueue/push
      /creating-handlers#reading_request_headers).

  Fields:
    appEngineRouting: Task-level setting for App Engine routing.  If set,
      AppEngineQueueConfig.app_engine_routing_overrides is used for all tasks
      in the queue, no matter what the setting is for the task-level
      app_engine_routing.
    headers: HTTP request headers.  This map contains the header field names
      and values. Repeated headers are not supported but a header value can
      contain commas.  Some headers, such as the ones below, will be
      automatically set by Cloud Tasks:  * Host: The host is constructed from
      many settings in   AppEngineQueueConfig and AppEngineTaskTarget. See the
      documentation for AppEngineTaskTarget for more   information. If set,
      the host header has to exactly match the   resolved hostname, otherwise
      an error will be returned. * Content-Length: This will be computed and
      overwritten by Cloud Tasks. * X-Google-*: For Google internal use only.
      * X-AppEngine-*: For Google internal use only. See
      [here](https://cloud.google.com/appengine/docs/python/taskqueue/push
      /creating-handlers#reading_request_headers).  When a task is attempted,
      AppEngineQueueConfig.headers will be merged with the task's
      AppEngineTaskTarget.headers and the merged headers will be sent with the
      task's HTTP request. In addition, some App Engine headers will be set
      which contain task-specific information that can be used by the handler;
      see [here](https://cloud.google.com/appengine/docs/python/taskqueue/push
      /creating-handlers#reading_request_headers).
    httpMethod: The HTTP method to use for the request. The default is POST.
      The app's request handler for the task's target URL must be able to
      handle HTTP requests with this http_method, otherwise the task attempt
      will fail with error code 405 "Method Not Allowed" because "the method
      specified in the Request-Line is not allowed for the resource identified
      by the Request-URI". See [Writing a push task request
      handler](https://cloud.google.com/appengine/docs/java/taskqueue/push
      /creating-handlers#writing_a_push_task_request_handler) and the
      documentation for the request handlers in the language your app is
      written in e.g. [python RequestHandler](https://cloud.google.com/appengi
      ne/docs/python/tools/webapp/requesthandlerclass).
    payload: Payload.  The payload will be sent as the HTTP message body. A
      message body, and thus a payload, is allowed only if the HTTP method is
      POST or PUT. It is an error to set a data payload on a task with an
      incompatible HttpMethod.
    relativeUrl: The relative URL.  The relative URL must begin with "/" and
      must be a valid HTTP relative URL. It can contain a path, query string
      arguments, and `#` fragments. If the relative URL is empty, then the
      root path "/" will be used. No spaces are allowed, and the maximum
      length allowed is 2083 characters.
    retryConfig: Deprecated. Task.retry_config replaces this field. If both
      this field and Task.retry_config are specified, Task.retry_config takes
      precedence.  Settings that determine the retry behavior.  The task's
      retry configuration overrides the queue's retry configuration.
  """

  class HttpMethodValueValuesEnum(_messages.Enum):
    """The HTTP method to use for the request. The default is POST.  The app's
    request handler for the task's target URL must be able to handle HTTP
    requests with this http_method, otherwise the task attempt will fail with
    error code 405 "Method Not Allowed" because "the method specified in the
    Request-Line is not allowed for the resource identified by the Request-
    URI". See [Writing a push task request
    handler](https://cloud.google.com/appengine/docs/java/taskqueue/push
    /creating-handlers#writing_a_push_task_request_handler) and the
    documentation for the request handlers in the language your app is written
    in e.g. [python RequestHandler](https://cloud.google.com/appengine/docs/py
    thon/tools/webapp/requesthandlerclass).

    Values:
      HTTP_METHOD_UNSPECIFIED: HTTP method unspecified
      POST: HTTP Post
      GET: HTTP Get
      HEAD: HTTP Head
      PUT: HTTP Put
      DELETE: HTTP Delete
    """
    HTTP_METHOD_UNSPECIFIED = 0
    POST = 1
    GET = 2
    HEAD = 3
    PUT = 4
    DELETE = 5

  @encoding.MapUnrecognizedFields('additionalProperties')
  class HeadersValue(_messages.Message):
    """HTTP request headers.  This map contains the header field names and
    values. Repeated headers are not supported but a header value can contain
    commas.  Some headers, such as the ones below, will be automatically set
    by Cloud Tasks:  * Host: The host is constructed from many settings in
    AppEngineQueueConfig and AppEngineTaskTarget. See the   documentation for
    AppEngineTaskTarget for more   information. If set, the host header has to
    exactly match the   resolved hostname, otherwise an error will be
    returned. * Content-Length: This will be computed and overwritten by Cloud
    Tasks. * X-Google-*: For Google internal use only. * X-AppEngine-*: For
    Google internal use only. See
    [here](https://cloud.google.com/appengine/docs/python/taskqueue/push
    /creating-handlers#reading_request_headers).  When a task is attempted,
    AppEngineQueueConfig.headers will be merged with the task's
    AppEngineTaskTarget.headers and the merged headers will be sent with the
    task's HTTP request. In addition, some App Engine headers will be set
    which contain task-specific information that can be used by the handler;
    see [here](https://cloud.google.com/appengine/docs/python/taskqueue/push
    /creating-handlers#reading_request_headers).

    Messages:
      AdditionalProperty: An additional property for a HeadersValue object.

    Fields:
      additionalProperties: Additional properties of type HeadersValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a HeadersValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  appEngineRouting = _messages.MessageField('AppEngineRouting', 1)
  headers = _messages.MessageField('HeadersValue', 2)
  httpMethod = _messages.EnumField('HttpMethodValueValuesEnum', 3)
  payload = _messages.BytesField(4)
  relativeUrl = _messages.StringField(5)
  retryConfig = _messages.MessageField('RetryConfig', 6)


class AttemptStatus(_messages.Message):
  """The status of a task attempt.

  Fields:
    dispatchTime: Output only.  The time that this attempt was dispatched.
    responseStatus: Output only.  The response from the target for this
      attempt.  If the task has not been attempted or the task is currently
      running then the response status will be google.rpc.Code.UNKNOWN.
    responseTime: Output only.  The time that this attempt response was
      received.
    scheduleTime: Output only.  The time that this attempt was scheduled.
  """

  dispatchTime = _messages.StringField(1)
  responseStatus = _messages.MessageField('Status', 2)
  responseTime = _messages.StringField(3)
  scheduleTime = _messages.StringField(4)


class CancelLeaseRequest(_messages.Message):
  """Request message for canceling a lease using CloudTasks.CancelLease.

  Enums:
    ResponseViewValueValuesEnum: The response_view specifies which subset of
      the Task will be returned.  By default response_view is Task.View.BASIC;
      not all information is retrieved by default because some data, such as
      payloads, might be desirable to return only when needed because of its
      large size or because of the sensitivity of data that it contains.
      Authorization for Task.View.FULL requires `cloudtasks.tasks.fullView`
      [Google IAM](https://cloud.google.com/iam/) permission on the Task.name
      resource.

  Fields:
    responseView: The response_view specifies which subset of the Task will be
      returned.  By default response_view is Task.View.BASIC; not all
      information is retrieved by default because some data, such as payloads,
      might be desirable to return only when needed because of its large size
      or because of the sensitivity of data that it contains.  Authorization
      for Task.View.FULL requires `cloudtasks.tasks.fullView` [Google
      IAM](https://cloud.google.com/iam/) permission on the Task.name
      resource.
    scheduleTime: Required.  The task schedule time, available in the
      Task.schedule_time returned in PullTasksResponse.tasks or
      CloudTasks.RenewLease.  This restriction is to check that the caller is
      canceling the correct task.
  """

  class ResponseViewValueValuesEnum(_messages.Enum):
    """The response_view specifies which subset of the Task will be returned.
    By default response_view is Task.View.BASIC; not all information is
    retrieved by default because some data, such as payloads, might be
    desirable to return only when needed because of its large size or because
    of the sensitivity of data that it contains.  Authorization for
    Task.View.FULL requires `cloudtasks.tasks.fullView` [Google
    IAM](https://cloud.google.com/iam/) permission on the Task.name resource.

    Values:
      VIEW_UNSPECIFIED: Unspecified. Defaults to BASIC.
      BASIC: The basic view omits fields which can be large or can contain
        sensitive data.  This view does not include the payload.
      FULL: All information is returned.  Payloads might be desirable to
        return only when needed, because they can be large and because of the
        sensitivity of the data that you choose to store in it.  Authorization
        for Task.View.FULL requires `cloudtasks.tasks.fullView` [Google
        IAM](https://cloud.google.com/iam/) permission on the Queue.name
        resource.
    """
    VIEW_UNSPECIFIED = 0
    BASIC = 1
    FULL = 2

  responseView = _messages.EnumField('ResponseViewValueValuesEnum', 1)
  scheduleTime = _messages.StringField(2)


class CloudtasksProjectsLocationsQueuesCreateRequest(_messages.Message):
  """A CloudtasksProjectsLocationsQueuesCreateRequest object.

  Fields:
    parent: Required.  The location name in which the queue will be created.
      For example: `projects/PROJECT_ID/locations/LOCATION_ID`  The list of
      allowed locations can be obtained by calling Cloud Tasks' implementation
      of google.cloud.location.Locations.ListLocations.
    queue: A Queue resource to be passed as the request body.
  """

  parent = _messages.StringField(1, required=True)
  queue = _messages.MessageField('Queue', 2)


class CloudtasksProjectsLocationsQueuesDeleteRequest(_messages.Message):
  """A CloudtasksProjectsLocationsQueuesDeleteRequest object.

  Fields:
    name: Required.  The queue name. For example:
      `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
  """

  name = _messages.StringField(1, required=True)


class CloudtasksProjectsLocationsQueuesEnableRequest(_messages.Message):
  """A CloudtasksProjectsLocationsQueuesEnableRequest object.

  Fields:
    enableQueueRequest: A EnableQueueRequest resource to be passed as the
      request body.
    name: Required.  The queue name. For example:
      `projects/PROJECT_ID/location/LOCATION_ID/queues/QUEUE_ID`
  """

  enableQueueRequest = _messages.MessageField('EnableQueueRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudtasksProjectsLocationsQueuesGetRequest(_messages.Message):
  """A CloudtasksProjectsLocationsQueuesGetRequest object.

  Fields:
    name: Required.  The resource name of the queue. For example:
      `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
  """

  name = _messages.StringField(1, required=True)


class CloudtasksProjectsLocationsQueuesListRequest(_messages.Message):
  """A CloudtasksProjectsLocationsQueuesListRequest object.

  Fields:
    filter: `filter` can be used to specify a subset of queues. Any queue
      field can be used as a filter and several operators as supported. For
      example: `<=, <, >=, >, !=, =, :`. The filter syntax is the same as
      described in
      https://cloud.google.com/logging/docs/view/advanced_filters.  Sample
      filter "pull_queue_config: *".  Note that using filters might cause
      fewer queues than the requested_page size to be returned.
    pageSize: Requested page size.  The maximum page size is 9800. If
      unspecified, the max will be returned. Fewer queues than requested might
      be returned.
    pageToken: A token identifying the page of results to return.  To request
      the first page results, page_token must be empty. To request the next
      page of results, page_token must be the value of
      ListQueuesResponse.next_page_token returned from the previous call to
      CloudTasks.ListQueues method. It is an error to switch the value of
      ListQueuesRequest.filter while iterating through pages.
    parent: Required.  The location name. For example:
      `projects/PROJECT_ID/locations/LOCATION_ID`
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.BytesField(3)
  parent = _messages.StringField(4, required=True)


class CloudtasksProjectsLocationsQueuesPatchRequest(_messages.Message):
  """A CloudtasksProjectsLocationsQueuesPatchRequest object.

  Fields:
    name: The queue name.  The queue name must have the following format:
      `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`  *
      `PROJECT_ID` can contain uppercase and lowercase letters,   numbers,
      hyphens, colons, and periods; that is, it must match   the regular
      expression: `[a-zA-Z\\d-:\\.]+`. * `QUEUE_ID` can contain uppercase and
      lowercase letters,   numbers, and hyphens; that is, it must match the
      regular   expression: `[a-zA-Z\\d-]+`. The maximum length is 100
      characters.  Caller-specified and required in CreateQueueRequest, after
      which it becomes output only.
    queue: A Queue resource to be passed as the request body.
    updateMask: A  mask used to specify which fields of the queue are being
      updated.  Queue.name cannot be changed and cannot be specified in the
      update_mask.
  """

  name = _messages.StringField(1, required=True)
  queue = _messages.MessageField('Queue', 2)
  updateMask = _messages.StringField(3)


class CloudtasksProjectsLocationsQueuesPauseRequest(_messages.Message):
  """A CloudtasksProjectsLocationsQueuesPauseRequest object.

  Fields:
    name: Required.  The queue name. For example:
      `projects/PROJECT_ID/location/LOCATION_ID/queues/QUEUE_ID`
    pauseQueueRequest: A PauseQueueRequest resource to be passed as the
      request body.
  """

  name = _messages.StringField(1, required=True)
  pauseQueueRequest = _messages.MessageField('PauseQueueRequest', 2)


class CloudtasksProjectsLocationsQueuesPurgeRequest(_messages.Message):
  """A CloudtasksProjectsLocationsQueuesPurgeRequest object.

  Fields:
    name: Required.  The queue name. For example:
      `projects/PROJECT_ID/location/LOCATION_ID/queues/QUEUE_ID`
    purgeQueueRequest: A PurgeQueueRequest resource to be passed as the
      request body.
  """

  name = _messages.StringField(1, required=True)
  purgeQueueRequest = _messages.MessageField('PurgeQueueRequest', 2)


class CloudtasksProjectsLocationsQueuesTasksAcknowledgeRequest(_messages.Message):
  """A CloudtasksProjectsLocationsQueuesTasksAcknowledgeRequest object.

  Fields:
    acknowledgeTaskRequest: A AcknowledgeTaskRequest resource to be passed as
      the request body.
    name: Required.  The task name. For example:
      `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID
      `
  """

  acknowledgeTaskRequest = _messages.MessageField('AcknowledgeTaskRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudtasksProjectsLocationsQueuesTasksCancelLeaseRequest(_messages.Message):
  """A CloudtasksProjectsLocationsQueuesTasksCancelLeaseRequest object.

  Fields:
    cancelLeaseRequest: A CancelLeaseRequest resource to be passed as the
      request body.
    name: Required.  The task name. For example:
      `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID
      `
  """

  cancelLeaseRequest = _messages.MessageField('CancelLeaseRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudtasksProjectsLocationsQueuesTasksCreateRequest(_messages.Message):
  """A CloudtasksProjectsLocationsQueuesTasksCreateRequest object.

  Fields:
    createTaskRequest: A CreateTaskRequest resource to be passed as the
      request body.
    parent: Required.  The queue name. For example:
      `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`  The queue
      must already exist.
  """

  createTaskRequest = _messages.MessageField('CreateTaskRequest', 1)
  parent = _messages.StringField(2, required=True)


class CloudtasksProjectsLocationsQueuesTasksDeleteRequest(_messages.Message):
  """A CloudtasksProjectsLocationsQueuesTasksDeleteRequest object.

  Fields:
    name: Required.  The task name. For example:
      `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID
      `
  """

  name = _messages.StringField(1, required=True)


class CloudtasksProjectsLocationsQueuesTasksGetRequest(_messages.Message):
  """A CloudtasksProjectsLocationsQueuesTasksGetRequest object.

  Enums:
    ResponseViewValueValuesEnum: The response_view specifies which subset of
      the Task will be returned.  By default response_view is Task.View.BASIC;
      not all information is retrieved by default because some data, such as
      payloads, might be desirable to return only when needed because of its
      large size or because of the sensitivity of data that it contains.
      Authorization for Task.View.FULL requires `cloudtasks.tasks.fullView`
      [Google IAM](https://cloud.google.com/iam/) permission on the Task.name
      resource.

  Fields:
    name: Required.  The task name. For example:
      `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID
      `
    responseView: The response_view specifies which subset of the Task will be
      returned.  By default response_view is Task.View.BASIC; not all
      information is retrieved by default because some data, such as payloads,
      might be desirable to return only when needed because of its large size
      or because of the sensitivity of data that it contains.  Authorization
      for Task.View.FULL requires `cloudtasks.tasks.fullView` [Google
      IAM](https://cloud.google.com/iam/) permission on the Task.name
      resource.
  """

  class ResponseViewValueValuesEnum(_messages.Enum):
    """The response_view specifies which subset of the Task will be returned.
    By default response_view is Task.View.BASIC; not all information is
    retrieved by default because some data, such as payloads, might be
    desirable to return only when needed because of its large size or because
    of the sensitivity of data that it contains.  Authorization for
    Task.View.FULL requires `cloudtasks.tasks.fullView` [Google
    IAM](https://cloud.google.com/iam/) permission on the Task.name resource.

    Values:
      VIEW_UNSPECIFIED: <no description>
      BASIC: <no description>
      FULL: <no description>
    """
    VIEW_UNSPECIFIED = 0
    BASIC = 1
    FULL = 2

  name = _messages.StringField(1, required=True)
  responseView = _messages.EnumField('ResponseViewValueValuesEnum', 2)


class CloudtasksProjectsLocationsQueuesTasksListRequest(_messages.Message):
  """A CloudtasksProjectsLocationsQueuesTasksListRequest object.

  Enums:
    ResponseViewValueValuesEnum: The response_view specifies which subset of
      the Task will be returned.  By default response_view is Task.View.BASIC;
      not all information is retrieved by default because some data, such as
      payloads, might be desirable to return only when needed because of its
      large size or because of the sensitivity of data that it contains.
      Authorization for Task.View.FULL requires `cloudtasks.tasks.fullView`
      [Google IAM](https://cloud.google.com/iam/) permission on the Task.name
      resource.

  Fields:
    orderBy:  Sort order used for the query. The fields supported for sorting
      are Task.schedule_time, Task.name, and PullTaskTarget.tag. All results
      will be returned in ascending order. The default ordering is by
      Task.schedule_time.
    pageSize: Requested page size. Fewer tasks than requested might be
      returned. If unspecified, 1000 tasks will be returned.
    pageToken: A token identifying the page of results to return.  To request
      the first page results, page_token must be empty. To request the next
      page of results, page_token must be the value of
      ListTasksResponse.next_page_token returned from the previous call to
      CloudTasks.ListTasks method.  The page token is valid for only 2 hours.
    parent: Required.  The queue name. For example:
      `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
    responseView: The response_view specifies which subset of the Task will be
      returned.  By default response_view is Task.View.BASIC; not all
      information is retrieved by default because some data, such as payloads,
      might be desirable to return only when needed because of its large size
      or because of the sensitivity of data that it contains.  Authorization
      for Task.View.FULL requires `cloudtasks.tasks.fullView` [Google
      IAM](https://cloud.google.com/iam/) permission on the Task.name
      resource.
  """

  class ResponseViewValueValuesEnum(_messages.Enum):
    """The response_view specifies which subset of the Task will be returned.
    By default response_view is Task.View.BASIC; not all information is
    retrieved by default because some data, such as payloads, might be
    desirable to return only when needed because of its large size or because
    of the sensitivity of data that it contains.  Authorization for
    Task.View.FULL requires `cloudtasks.tasks.fullView` [Google
    IAM](https://cloud.google.com/iam/) permission on the Task.name resource.

    Values:
      VIEW_UNSPECIFIED: <no description>
      BASIC: <no description>
      FULL: <no description>
    """
    VIEW_UNSPECIFIED = 0
    BASIC = 1
    FULL = 2

  orderBy = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.BytesField(3)
  parent = _messages.StringField(4, required=True)
  responseView = _messages.EnumField('ResponseViewValueValuesEnum', 5)


class CloudtasksProjectsLocationsQueuesTasksPullRequest(_messages.Message):
  """A CloudtasksProjectsLocationsQueuesTasksPullRequest object.

  Fields:
    name: Required.  The queue name. For example:
      `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
    pullTasksRequest: A PullTasksRequest resource to be passed as the request
      body.
  """

  name = _messages.StringField(1, required=True)
  pullTasksRequest = _messages.MessageField('PullTasksRequest', 2)


class CloudtasksProjectsLocationsQueuesTasksRenewLeaseRequest(_messages.Message):
  """A CloudtasksProjectsLocationsQueuesTasksRenewLeaseRequest object.

  Fields:
    name: Required.  The task name. For example:
      `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID
      `
    renewLeaseRequest: A RenewLeaseRequest resource to be passed as the
      request body.
  """

  name = _messages.StringField(1, required=True)
  renewLeaseRequest = _messages.MessageField('RenewLeaseRequest', 2)


class CreateTaskRequest(_messages.Message):
  """Request message for CloudTasks.CreateTask.

  Enums:
    ResponseViewValueValuesEnum: The response_view specifies which subset of
      the Task will be returned.  By default response_view is Task.View.BASIC;
      not all information is retrieved by default because some data, such as
      payloads, might be desirable to return only when needed because of its
      large size or because of the sensitivity of data that it contains.
      Authorization for Task.View.FULL requires `cloudtasks.tasks.fullView`
      [Google IAM](https://cloud.google.com/iam/) permission on the Task.name
      resource.

  Fields:
    responseView: The response_view specifies which subset of the Task will be
      returned.  By default response_view is Task.View.BASIC; not all
      information is retrieved by default because some data, such as payloads,
      might be desirable to return only when needed because of its large size
      or because of the sensitivity of data that it contains.  Authorization
      for Task.View.FULL requires `cloudtasks.tasks.fullView` [Google
      IAM](https://cloud.google.com/iam/) permission on the Task.name
      resource.
    task: Required.  The task to add.  Task names have the following format:
      `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID
      `. The user can optionally specify a name for the task in Task.name. If
      a name is not specified then the system will generate a random unique
      task id, which will be returned in the response's Task.name.  Explicitly
      specifying a Task.name enables task de-duplication. If a task's name is
      identical to the name of an existing task or a task that was deleted or
      completed within the last ~10 days then the call to
      CloudTasks.CreateTask will fail. Because there is an extra lookup cost
      to identify duplicate task names, these CloudTasks.CreateTask calls have
      significantly increased latency. Using hashed strings for the task id or
      for the prefix of the task id is recommended. Choosing task ids that are
      sequential or have sequential prefixes, for example using a timestamp,
      causes an increase in latency and error rates in all task commands. The
      infrastructure relies on an approximately uniform distribution of task
      ids to store and serve tasks efficiently.  If Task.schedule_time is not
      set or is in the past then Cloud Tasks will set it to the current time.
  """

  class ResponseViewValueValuesEnum(_messages.Enum):
    """The response_view specifies which subset of the Task will be returned.
    By default response_view is Task.View.BASIC; not all information is
    retrieved by default because some data, such as payloads, might be
    desirable to return only when needed because of its large size or because
    of the sensitivity of data that it contains.  Authorization for
    Task.View.FULL requires `cloudtasks.tasks.fullView` [Google
    IAM](https://cloud.google.com/iam/) permission on the Task.name resource.

    Values:
      VIEW_UNSPECIFIED: Unspecified. Defaults to BASIC.
      BASIC: The basic view omits fields which can be large or can contain
        sensitive data.  This view does not include the payload.
      FULL: All information is returned.  Payloads might be desirable to
        return only when needed, because they can be large and because of the
        sensitivity of the data that you choose to store in it.  Authorization
        for Task.View.FULL requires `cloudtasks.tasks.fullView` [Google
        IAM](https://cloud.google.com/iam/) permission on the Queue.name
        resource.
    """
    VIEW_UNSPECIFIED = 0
    BASIC = 1
    FULL = 2

  responseView = _messages.EnumField('ResponseViewValueValuesEnum', 1)
  task = _messages.MessageField('Task', 2)


class Empty(_messages.Message):
  """A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class EnableQueueRequest(_messages.Message):
  """Request message for CloudTasks.EnableQueue."""


class ListQueuesResponse(_messages.Message):
  """Response message for CloudTasks.ListQueues.

  Fields:
    nextPageToken: A token to retrieve next page of results.  To return the
      next page of results, call CloudTasks.ListQueues with this value as the
      ListQueuesRequest.page_token.  If the next_page_token is empty, there
      are no more results.  The page token is valid for only 2 hours.
    queues: The list of queues.
  """

  nextPageToken = _messages.BytesField(1)
  queues = _messages.MessageField('Queue', 2, repeated=True)


class ListTasksResponse(_messages.Message):
  """Response message for listing tasks using CloudTasks.ListTasks.

  Fields:
    nextPageToken: A token to retrieve next page of results.  To return the
      next page of results, call CloudTasks.ListTasks with this value as the
      ListTasksRequest.page_token.  If the next_page_token is empty, there are
      no more results.
    tasks: The list of tasks.
  """

  nextPageToken = _messages.BytesField(1)
  tasks = _messages.MessageField('Task', 2, repeated=True)


class PauseQueueRequest(_messages.Message):
  """Request message for CloudTasks.PauseQueue."""


class PullQueueConfig(_messages.Message):
  """Pull queue config.

  Fields:
    maxAttempts: The maximum number of attempts for a task.  Cloud Tasks will
      attempt the task `max_attempts` times. If the first attempt fails, then
      there will be `max_attempts - 1` retries. Must be > 0.
    unlimitedAttempts: If true, then the number of attempts is unlimited.
  """

  maxAttempts = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  unlimitedAttempts = _messages.BooleanField(2)


class PullTaskTarget(_messages.Message):
  """Pull task target.  This proto can only be used for tasks in a queue which
  has Queue.pull_queue_config set.

  Fields:
    maxAttempts: The maximum number of attempts for a task.  Cloud Tasks will
      attempt the task `max_attempts` times. If the first attempt fails, then
      there will be `max_attempts - 1` retries). Must be > 0.
    payload: A data payload consumed by the task worker to execute the task.
    tag: A meta-data tag for this task.  This value is used by
      CloudTasks.PullTasks calls when PullTasksRequest.filter is `tag=<tag>`.
      The tag must be less than 500 bytes.
    unlimitedAttempts: If true, then the number of attempts is unlimited. If
      false, then by default Cloud Tasks will retry the task 100 times.
  """

  maxAttempts = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  payload = _messages.BytesField(2)
  tag = _messages.BytesField(3)
  unlimitedAttempts = _messages.BooleanField(4)


class PullTasksRequest(_messages.Message):
  """Request message for pulling tasks using CloudTasks.PullTasks.

  Enums:
    ResponseViewValueValuesEnum: The response_view specifies which subset of
      the Task will be returned.  By default response_view is Task.View.BASIC;
      not all information is retrieved by default because some data, such as
      payloads, might be desirable to return only when needed because of its
      large size or because of the sensitivity of data that it contains.
      Authorization for Task.View.FULL requires `cloudtasks.tasks.fullView`
      [Google IAM](https://cloud.google.com/iam/) permission on the Task.name
      resource.

  Fields:
    filter: `filter` can be used to specify a subset of tasks to lease.  When
      `filter` is set to `tag=<my-tag>` then the PullTasksResponse will
      contain only tasks whose PullTaskTarget.tag is equal to `<my-tag>`.
      `<my-tag>` can be a bytes encoded as a string and must be less than 500
      bytes. If `<my-tag>` includes whitespace or special characters
      (characters which aren't letters, numbers, or underscores), then it must
      be double-quoted. Double quotes and backslashes in quoted strings must
      be escaped by preceding it with a backslash (`\`).  When `filter` is set
      to `tag=oldest_tag()`, only tasks which have the same tag as the task
      with the oldest schedule_time will be returned.  Grammar Syntax:  *
      `filter = "tag=" comparable`  *  `comparable = tag | function`  * `tag =
      string | bytes`  * `function = "oldest_tag()"`    The `oldest_tag()`
      function returns tasks which have the same tag as the oldest task
      (ordered by schedule time).
    leaseDuration: The duration of the lease.  Each task returned in the
      PullTasksResponse will have its Task.schedule_time set to the current
      time plus the `lease_duration`. A task that has been returned in a
      PullTasksResponse is leased -- that task will not be returned in a
      different PullTasksResponse before the Task.schedule_time.  After the
      lease holder has successfully finished the work associated with the
      task, the lease holder must call CloudTasks.AcknowledgeTask. If the task
      is not acknowledged via CloudTasks.AcknowledgeTask before the
      Task.schedule_time then it will be returned in a later PullTasksResponse
      so that another lease holder can process it.  The maximum lease duration
      is 1 week.
    maxTasks: The maximum number of tasks to lease. The maximum that can be
      requested is 1000.
    responseView: The response_view specifies which subset of the Task will be
      returned.  By default response_view is Task.View.BASIC; not all
      information is retrieved by default because some data, such as payloads,
      might be desirable to return only when needed because of its large size
      or because of the sensitivity of data that it contains.  Authorization
      for Task.View.FULL requires `cloudtasks.tasks.fullView` [Google
      IAM](https://cloud.google.com/iam/) permission on the Task.name
      resource.
  """

  class ResponseViewValueValuesEnum(_messages.Enum):
    """The response_view specifies which subset of the Task will be returned.
    By default response_view is Task.View.BASIC; not all information is
    retrieved by default because some data, such as payloads, might be
    desirable to return only when needed because of its large size or because
    of the sensitivity of data that it contains.  Authorization for
    Task.View.FULL requires `cloudtasks.tasks.fullView` [Google
    IAM](https://cloud.google.com/iam/) permission on the Task.name resource.

    Values:
      VIEW_UNSPECIFIED: Unspecified. Defaults to BASIC.
      BASIC: The basic view omits fields which can be large or can contain
        sensitive data.  This view does not include the payload.
      FULL: All information is returned.  Payloads might be desirable to
        return only when needed, because they can be large and because of the
        sensitivity of the data that you choose to store in it.  Authorization
        for Task.View.FULL requires `cloudtasks.tasks.fullView` [Google
        IAM](https://cloud.google.com/iam/) permission on the Queue.name
        resource.
    """
    VIEW_UNSPECIFIED = 0
    BASIC = 1
    FULL = 2

  filter = _messages.StringField(1)
  leaseDuration = _messages.StringField(2)
  maxTasks = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  responseView = _messages.EnumField('ResponseViewValueValuesEnum', 4)


class PullTasksResponse(_messages.Message):
  """Response message for pulling tasks using CloudTasks.PullTasks.

  Fields:
    tasks: The leased tasks.
  """

  tasks = _messages.MessageField('Task', 1, repeated=True)


class PurgeQueueRequest(_messages.Message):
  """Request message for CloudTasks.PurgeQueue."""


class Queue(_messages.Message):
  """A queue is a container of related tasks. Queues are configured to manage
  how those tasks are dispatched. Configurable properties include rate limits,
  retry options, target types, and others.

  Enums:
    QueueStateValueValuesEnum: Output only.  The state of the queue.
      `queue_state` can only be changed by called CloudTasks.PauseQueue,
      CloudTasks.EnableQueue, or uploading [queue.yaml](https://cloud.google.c
      om/appengine/docs/python/config/queueref). CloudTasks.UpdateQueue cannot
      be used to change `queue_state`.

  Fields:
    appEngineQueueConfig: App Engine queue config.
    name: The queue name.  The queue name must have the following format:
      `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`  *
      `PROJECT_ID` can contain uppercase and lowercase letters,   numbers,
      hyphens, colons, and periods; that is, it must match   the regular
      expression: `[a-zA-Z\\d-:\\.]+`. * `QUEUE_ID` can contain uppercase and
      lowercase letters,   numbers, and hyphens; that is, it must match the
      regular   expression: `[a-zA-Z\\d-]+`. The maximum length is 100
      characters.  Caller-specified and required in CreateQueueRequest, after
      which it becomes output only.
    pullQueueConfig: Pull queue config.
    purgeTime: Output only.  The last time this queue was purged. All tasks
      that were created before this time were purged.  A queue can be purged
      using CloudTasks.PurgeQueue, the [App Engine Task Queue SDK, or the
      Cloud Console](https://cloud.google.com/appengine/docs/standard/python/t
      askqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
      Purge time will be truncated to the nearest microsecond. Purge time will
      be zero if the queue has never been purged.
    queueState: Output only.  The state of the queue.  `queue_state` can only
      be changed by called CloudTasks.PauseQueue, CloudTasks.EnableQueue, or
      uploading [queue.yaml](https://cloud.google.com/appengine/docs/python/co
      nfig/queueref). CloudTasks.UpdateQueue cannot be used to change
      `queue_state`.
    retryConfig: Settings that determine the retry behavior.  The task's retry
      configuration (Task.retry_config) overrides the queue's retry
      configuration (Queue.retry_config).
    throttleConfig: Config for throttling task dispatches.
  """

  class QueueStateValueValuesEnum(_messages.Enum):
    """Output only.  The state of the queue.  `queue_state` can only be
    changed by called CloudTasks.PauseQueue, CloudTasks.EnableQueue, or
    uploading [queue.yaml](https://cloud.google.com/appengine/docs/python/conf
    ig/queueref). CloudTasks.UpdateQueue cannot be used to change
    `queue_state`.

    Values:
      QUEUE_STATE_UNSPECIFIED: Unspecified state.
      ENABLED: Queue is enabled. Tasks can be dispatched.
      PAUSED: Tasks are paused by the user. If the queue is paused then Cloud
        Tasks will stop delivering tasks from it, but more tasks can still be
        added to it by the user. When a pull queue is paused, all
        CloudTasks.PullTasks calls will return a `FAILED_PRECONDITION` error.
      DISABLED: Disabled indicates that queue has been removed from
        queue.yaml.  When you remove a queue from [queue.yaml](https://cloud.g
        oogle.com/appengine/docs/python/config/queueref), it is marked as
        `DISABLED`. You cannot directly disable a queue.  When a queue is
        disabled, tasks can still be added to a queue but the tasks are not
        dispatched and CloudTasks.PullTasks calls return a
        `FAILED_PRECONDITION` error.  To permanently delete this queue and all
        of its tasks, call CloudTasks.DeleteQueue.
    """
    QUEUE_STATE_UNSPECIFIED = 0
    ENABLED = 1
    PAUSED = 2
    DISABLED = 3

  appEngineQueueConfig = _messages.MessageField('AppEngineQueueConfig', 1)
  name = _messages.StringField(2)
  pullQueueConfig = _messages.MessageField('PullQueueConfig', 3)
  purgeTime = _messages.StringField(4)
  queueState = _messages.EnumField('QueueStateValueValuesEnum', 5)
  retryConfig = _messages.MessageField('RetryConfig', 6)
  throttleConfig = _messages.MessageField('ThrottleConfig', 7)


class RenewLeaseRequest(_messages.Message):
  """Request message for renewing a lease using CloudTasks.RenewLease.

  Enums:
    ResponseViewValueValuesEnum: The response_view specifies which subset of
      the Task will be returned.  By default response_view is Task.View.BASIC;
      not all information is retrieved by default because some data, such as
      payloads, might be desirable to return only when needed because of its
      large size or because of the sensitivity of data that it contains.
      Authorization for Task.View.FULL requires `cloudtasks.tasks.fullView`
      [Google IAM](https://cloud.google.com/iam/) permission on the Task.name
      resource.

  Fields:
    newLeaseDuration: Required.  The desired new lease duration, starting from
      now.   The maximum lease duration is 1 week.
    responseView: The response_view specifies which subset of the Task will be
      returned.  By default response_view is Task.View.BASIC; not all
      information is retrieved by default because some data, such as payloads,
      might be desirable to return only when needed because of its large size
      or because of the sensitivity of data that it contains.  Authorization
      for Task.View.FULL requires `cloudtasks.tasks.fullView` [Google
      IAM](https://cloud.google.com/iam/) permission on the Task.name
      resource.
    scheduleTime: Required.  The task schedule time, available in the
      Task.schedule_time returned in PullTasksResponse.tasks or
      CloudTasks.RenewLease.  This restriction is to check that the caller is
      renewing the correct task.
  """

  class ResponseViewValueValuesEnum(_messages.Enum):
    """The response_view specifies which subset of the Task will be returned.
    By default response_view is Task.View.BASIC; not all information is
    retrieved by default because some data, such as payloads, might be
    desirable to return only when needed because of its large size or because
    of the sensitivity of data that it contains.  Authorization for
    Task.View.FULL requires `cloudtasks.tasks.fullView` [Google
    IAM](https://cloud.google.com/iam/) permission on the Task.name resource.

    Values:
      VIEW_UNSPECIFIED: Unspecified. Defaults to BASIC.
      BASIC: The basic view omits fields which can be large or can contain
        sensitive data.  This view does not include the payload.
      FULL: All information is returned.  Payloads might be desirable to
        return only when needed, because they can be large and because of the
        sensitivity of the data that you choose to store in it.  Authorization
        for Task.View.FULL requires `cloudtasks.tasks.fullView` [Google
        IAM](https://cloud.google.com/iam/) permission on the Queue.name
        resource.
    """
    VIEW_UNSPECIFIED = 0
    BASIC = 1
    FULL = 2

  newLeaseDuration = _messages.StringField(1)
  responseView = _messages.EnumField('ResponseViewValueValuesEnum', 2)
  scheduleTime = _messages.StringField(3)


class RetryConfig(_messages.Message):
  """Retry config.  These settings determine retry behavior.  If a task does
  not complete successfully, meaning that an acknowledgement is not received
  from the handler before the [deadline](https://cloud.google.com/appengine/do
  cs/python/taskqueue/push/#the_task_deadline), then it will be retried with
  exponential backoff according to the settings in RetryConfig.

  Fields:
    maxAttempts: The maximum number of attempts for a task.  Cloud Tasks will
      attempt the task `max_attempts` times (that is, if the first attempt
      fails, then there will be `max_attempts - 1` retries).  Must be > 0.
    maxBackoff: The maximum amount of time to wait before retrying a task
      after it fails. The default is 1 hour.  * For App Engine queues and
      tasks, this field is 1 hour by default. * For pull queues and tasks,
      this field is output only and always 0.
    maxDoublings: The maximum number of times that the interval between failed
      task retries will be doubled before the increase becomes constant. The
      constant is: 2**(max_doublings - 1) * RetryConfig.min_backoff.  * For
      App Engine queues and tasks, this field is 16 by default. * For pull
      queues and tasks, this field is output only and always 0.
    minBackoff: The minimum amount of time to wait before retrying a task
      after it fails.  * For App Engine queues and tasks, this field is 0.1
      seconds by default. * For pull queues and tasks, this field is output
      only and always 0.
    taskAgeLimit: If positive, task_age_limit specifies the time limit for
      retrying a failed task, measured from when the task was first run. If
      specified with RetryConfig.max_attempts, the task will be retried until
      both limits are reached.  If zero, then the task age is unlimited. This
      field is zero by default.
    unlimitedAttempts: If true, then the number of attempts is unlimited.
  """

  maxAttempts = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  maxBackoff = _messages.StringField(2)
  maxDoublings = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  minBackoff = _messages.StringField(4)
  taskAgeLimit = _messages.StringField(5)
  unlimitedAttempts = _messages.BooleanField(6)


class StandardQueryParameters(_messages.Message):
  """Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    bearer_token: OAuth bearer token.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    pp: Pretty-print response.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    """Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    """V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  bearer_token = _messages.StringField(4)
  callback = _messages.StringField(5)
  fields = _messages.StringField(6)
  key = _messages.StringField(7)
  oauth_token = _messages.StringField(8)
  pp = _messages.BooleanField(9, default=True)
  prettyPrint = _messages.BooleanField(10, default=True)
  quotaUser = _messages.StringField(11)
  trace = _messages.StringField(12)
  uploadType = _messages.StringField(13)
  upload_protocol = _messages.StringField(14)


class Status(_messages.Message):
  """The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). The error model is designed to be:
  - Simple to use and understand for most users - Flexible enough to meet
  unexpected needs  # Overview  The `Status` message contains three pieces of
  data: error code, error message, and error details. The error code should be
  an enum value of google.rpc.Code, but it may accept additional error codes
  if needed.  The error message should be a developer-facing English message
  that helps developers *understand* and *resolve* the error. If a localized
  user-facing error message is needed, put the localized message in the error
  details or localize it in the client. The optional error details may contain
  arbitrary information about the error. There is a predefined set of error
  detail types in the package `google.rpc` that can be used for common error
  conditions.  # Language mapping  The `Status` message is the logical
  representation of the error model, but it is not necessarily the actual wire
  format. When the `Status` message is exposed in different client libraries
  and different wire protocols, it can be mapped differently. For example, it
  will likely be mapped to some exceptions in Java, but more likely mapped to
  some error codes in C.  # Other uses  The error model and the `Status`
  message can be used in a variety of environments, either with or without
  APIs, to provide a consistent developer experience across different
  environments.  Example uses of this error model include:  - Partial errors.
  If a service needs to return partial errors to the client,     it may embed
  the `Status` in the normal response to indicate the partial     errors.  -
  Workflow errors. A typical workflow has multiple steps. Each step may
  have a `Status` message for error reporting.  - Batch operations. If a
  client uses batch request and batch response, the     `Status` message
  should be used directly inside batch response, one for     each error sub-
  response.  - Asynchronous operations. If an API call embeds asynchronous
  operation     results in its response, the status of those operations should
  be     represented directly using the `Status` message.  - Logging. If some
  API errors are stored in logs, the message `Status` could     be used
  directly after any stripping needed for security/privacy reasons.

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    """A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class Task(_messages.Message):
  """A unit of scheduled work.

  Enums:
    ViewValueValuesEnum: Output only.  The view specifies which subset of the
      Task has been returned.

  Fields:
    appEngineTaskTarget: App Engine task target. Can be used only if
      Queue.app_engine_queue_config is set.
    createTime: Output only.  The time that the task was created.  create_time
      will be truncated to the nearest second.
    name: The task name.  The task name must have the following format:
      `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID
      `  * `PROJECT_ID` can contain uppercase and lowercase letters,
      numbers, hyphens, colons, and periods; that is, it must match   the
      regular expression: `[a-zA-Z\\d-:\\.]+`. * `QUEUE_ID` can contain
      uppercase and lowercase letters,   numbers, and hyphens; that is, it
      must match the regular   expression: `[a-zA-Z\\d-]+`. The maximum length
      is 100   characters. * `TASK_ID` contain uppercase and lowercase
      letters, numbers,   underscores, and hyphens; that is, it must match the
      regular   expression: `[a-zA-Z\\d_-]+`. The maximum length is 500
      characters.  Optionally caller-specified in CreateTaskRequest, after
      which it becomes output only.
    pullTaskTarget: Pull task target. Can be used only if
      Queue.pull_queue_config is set.
    retryConfig: Settings that determine the retry behavior.  The task's retry
      configuration overrides the queue's retry configuration.
    scheduleTime: The time when the task is scheduled to be attempted.  For
      pull queues, this is the time when the task is available to be leased;
      if a task is currently leased, this is the time when the current lease
      expires, that is, the time that the task was leased plus the
      PullTasksRequest.lease_duration.  For App Engine queues, this is when
      the task will be attempted or retried.  schedule_time will be truncated
      to the nearest microsecond.
    taskStatus: Output only.  Task status.
    view: Output only.  The view specifies which subset of the Task has been
      returned.
  """

  class ViewValueValuesEnum(_messages.Enum):
    """Output only.  The view specifies which subset of the Task has been
    returned.

    Values:
      VIEW_UNSPECIFIED: Unspecified. Defaults to BASIC.
      BASIC: The basic view omits fields which can be large or can contain
        sensitive data.  This view does not include the payload.
      FULL: All information is returned.  Payloads might be desirable to
        return only when needed, because they can be large and because of the
        sensitivity of the data that you choose to store in it.  Authorization
        for Task.View.FULL requires `cloudtasks.tasks.fullView` [Google
        IAM](https://cloud.google.com/iam/) permission on the Queue.name
        resource.
    """
    VIEW_UNSPECIFIED = 0
    BASIC = 1
    FULL = 2

  appEngineTaskTarget = _messages.MessageField('AppEngineTaskTarget', 1)
  createTime = _messages.StringField(2)
  name = _messages.StringField(3)
  pullTaskTarget = _messages.MessageField('PullTaskTarget', 4)
  retryConfig = _messages.MessageField('RetryConfig', 5)
  scheduleTime = _messages.StringField(6)
  taskStatus = _messages.MessageField('TaskStatus', 7)
  view = _messages.EnumField('ViewValueValuesEnum', 8)


class TaskStatus(_messages.Message):
  """Status of the task.

  Fields:
    attemptDispatchCount: Output only.  The number of attempts dispatched.
      This count includes tasks which have been dispatched but haven't
      received a response.
    attemptResponseCount: Output only.  The number of attempts which have
      received a response.
    firstAttemptStatus: Output only.  The status of the task's first attempt.
      Only AttemptStatus.dispatch_time will be set. The other AttemptStatus
      information is not retained by Cloud Tasks.
    lastAttemptStatus: Output only.  The status of the task's last attempt.
  """

  attemptDispatchCount = _messages.IntegerField(1)
  attemptResponseCount = _messages.IntegerField(2)
  firstAttemptStatus = _messages.MessageField('AttemptStatus', 3)
  lastAttemptStatus = _messages.MessageField('AttemptStatus', 4)


class ThrottleConfig(_messages.Message):
  """Throttle config.  These settings determine the throttling behavior.

  Fields:
    bucketSize: Deprecated: This field is replaced by `max_burst_size`.
      Output only.  The max burst size limits how fast the queue is processed
      when many tasks are in the queue and the rate is high. This field allows
      the queue to have a high rate so processing starts shortly after a task
      is enqueued, but still limits resource usage when many tasks are
      enqueued in a short period of time.  This field has the same meaning as
      [bucket_size in queue.yaml](https://cloud.google.com/appengine/docs/stan
      dard/python/config/queueref#bucket_size).
    maxBurstSize: Output only.  The max burst size limits how fast the queue
      is processed when many tasks are in the queue and the rate is high. This
      field allows the queue to have a high rate so processing starts shortly
      after a task is enqueued, but still limits resource usage when many
      tasks are enqueued in a short period of time.  * For App Engine queues,
      if   ThrottleConfig.max_tasks_dispatched_per_second is 1, this   field
      is 10; otherwise this field is
      ThrottleConfig.max_tasks_dispatched_per_second / 5. * For pull queues,
      this field is output only and always 10,000.  Note: For App Engine
      queues that were created through `queue.yaml/xml`, `max_burst_size`
      might not have the same settings as specified above;
      CloudTasks.UpdateQueue can be used to set `max_burst_size` only to the
      values specified above.  This field has the same meaning as [bucket_size
      in queue.yaml](https://cloud.google.com/appengine/docs/standard/python/c
      onfig/queueref#bucket_size).
    maxOutstandingRequests: Deprecated: This field is replaced by
      `max_outstanding_tasks`.  The maximum number of outstanding tasks that
      Cloud Tasks allows to be dispatched for this queue. After this threshold
      has been reached, Cloud Tasks stops dispatching tasks until the number
      of outstanding requests decreases.  This field is 10 by default. The
      maximum allowed value is 15,000.  This field has the same meaning as
      [max_concurrent_requests in queue.yaml](https://cloud.google.com/appengi
      ne/docs/standard/python/config/queueref#max_concurrent_requests).  This
      field is output only for pull queues.
    maxOutstandingTasks: * For App Engine queues, this field is 10 by default.
      * For pull queues, this field is output only and always -1, which
      indicates no limit.  This field has the same meaning as
      [max_concurrent_requests in queue.yaml](https://cloud.google.com/appengi
      ne/docs/standard/python/config/queueref#max_concurrent_requests).
    maxRequestsPerSecond: Deprecated: This field is replaced by
      `max_tasks_dispatched_per_second`.  The maximum rate at which tasks are
      dispatched from this queue.  This field has the same meaning as [rate in
      queue.yaml](https://cloud.google.com/appengine/docs/standard/python/conf
      ig/queueref#rate).  This field is 1 by default. The maximum allowed
      value is 500.  This field is output only for pull queues.
    maxTasksDispatchedPerSecond: The maximum rate at which tasks are
      dispatched from this queue.  The maximum allowed value is 500.  * For
      App Engine queues, this field is 1 by default. * For pull queues, this
      field is output only and always 10,000.  This field has the same meaning
      as [rate in queue.yaml](https://cloud.google.com/appengine/docs/standard
      /python/config/queueref#rate).
  """

  bucketSize = _messages.FloatField(1)
  maxBurstSize = _messages.FloatField(2)
  maxOutstandingRequests = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  maxOutstandingTasks = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  maxRequestsPerSecond = _messages.FloatField(5)
  maxTasksDispatchedPerSecond = _messages.FloatField(6)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv',
    package=u'cloudtasks')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1',
    package=u'cloudtasks')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2',
    package=u'cloudtasks')
