/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.RecordNumberBinding;
import com.sleepycat.collections.CurrentTransaction;
import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.PrimaryKeyAssigner;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.db.CursorConfig;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseConfig;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.Environment;
import com.sleepycat.db.JoinConfig;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.SecondaryConfig;
import com.sleepycat.db.SecondaryDatabase;
import com.sleepycat.db.SecondaryKeyCreator;
import com.sleepycat.db.Transaction;
import com.sleepycat.util.RuntimeExceptionWrapper;
import com.sleepycat.util.keyrange.KeyRange;
import com.sleepycat.util.keyrange.KeyRangeException;

final class DataView
implements Cloneable {
    Database db;
    SecondaryDatabase secDb;
    CurrentTransaction currentTxn;
    KeyRange range;
    EntryBinding keyBinding;
    EntryBinding valueBinding;
    EntityBinding entityBinding;
    PrimaryKeyAssigner keyAssigner;
    SecondaryKeyCreator secKeyCreator;
    CursorConfig cursorConfig;
    boolean writeAllowed;
    boolean ordered;
    boolean recNumAllowed;
    boolean recNumAccess;
    boolean btreeRecNumDb;
    boolean btreeRecNumAccess;
    boolean recNumRenumber;
    boolean keysRenumbered;
    boolean dupsAllowed;
    boolean dupsOrdered;
    boolean transactional;
    boolean readUncommittedAllowed;
    DatabaseEntry dupsKey;
    boolean dupsView;
    KeyRange dupsRange;

    DataView(Database database, EntryBinding entryBinding, EntryBinding entryBinding2, EntityBinding entityBinding, boolean bl, PrimaryKeyAssigner primaryKeyAssigner) throws IllegalArgumentException {
        if (database == null) {
            throw new IllegalArgumentException("database is null");
        }
        this.db = database;
        try {
            DatabaseConfig databaseConfig;
            this.currentTxn = CurrentTransaction.getInstanceInternal(this.db.getEnvironment());
            if (this.db instanceof SecondaryDatabase) {
                this.secDb = (SecondaryDatabase)database;
                SecondaryConfig secondaryConfig = this.secDb.getSecondaryConfig();
                this.secKeyCreator = secondaryConfig.getKeyCreator();
                databaseConfig = secondaryConfig;
            } else {
                databaseConfig = this.db.getConfig();
            }
            this.ordered = !DbCompat.isTypeHash(databaseConfig);
            this.recNumAllowed = DbCompat.isTypeQueue(databaseConfig) || DbCompat.isTypeRecno(databaseConfig) || DbCompat.getBtreeRecordNumbers(databaseConfig);
            this.recNumRenumber = DbCompat.getRenumbering(databaseConfig);
            this.dupsAllowed = DbCompat.getSortedDuplicates(databaseConfig) || DbCompat.getUnsortedDuplicates(databaseConfig);
            this.dupsOrdered = DbCompat.getSortedDuplicates(databaseConfig);
            this.transactional = this.currentTxn.isTxnMode() && databaseConfig.getTransactional();
            this.readUncommittedAllowed = DbCompat.getReadUncommitted(databaseConfig);
            this.btreeRecNumDb = this.recNumAllowed && DbCompat.isTypeBtree(databaseConfig);
            this.range = new KeyRange(databaseConfig.getBtreeComparator());
        }
        catch (DatabaseException databaseException) {
            throw new RuntimeExceptionWrapper(databaseException);
        }
        this.writeAllowed = bl;
        this.keyBinding = entryBinding;
        this.valueBinding = entryBinding2;
        this.entityBinding = entityBinding;
        this.keyAssigner = primaryKeyAssigner;
        this.cursorConfig = CursorConfig.DEFAULT;
        if (entryBinding2 != null && entityBinding != null) {
            throw new IllegalArgumentException("both valueBinding and entityBinding are non-null");
        }
        if (entryBinding instanceof RecordNumberBinding) {
            if (!this.recNumAllowed) {
                throw new IllegalArgumentException("RecordNumberBinding requires DB_BTREE/DB_RECNUM, DB_RECNO, or DB_QUEUE");
            }
            this.recNumAccess = true;
            if (this.btreeRecNumDb) {
                this.btreeRecNumAccess = true;
            }
        }
        this.keysRenumbered = this.recNumRenumber || this.btreeRecNumAccess;
    }

    private DataView cloneView() {
        try {
            return (DataView)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException();
        }
    }

    DataView keySetView() {
        if (this.keyBinding == null) {
            throw new UnsupportedOperationException("must have keyBinding");
        }
        DataView dataView = this.cloneView();
        dataView.valueBinding = null;
        dataView.entityBinding = null;
        return dataView;
    }

    DataView valueSetView() {
        if (this.valueBinding == null && this.entityBinding == null) {
            throw new UnsupportedOperationException("must have valueBinding or entityBinding");
        }
        DataView dataView = this.cloneView();
        dataView.keyBinding = null;
        return dataView;
    }

    DataView valueSetView(Object object) throws DatabaseException, KeyRangeException {
        KeyRange keyRange = this.subRange(this.range, object);
        DataView dataView = this.valueSetView();
        dataView.range = keyRange;
        return dataView;
    }

    DataView subView(Object object, boolean bl, Object object2, boolean bl2, EntryBinding entryBinding) throws DatabaseException, KeyRangeException {
        DataView dataView = this.cloneView();
        dataView.setRange(object, bl, object2, bl2);
        if (entryBinding != null) {
            dataView.keyBinding = entryBinding;
        }
        return dataView;
    }

    DataView duplicatesView(Object object, EntryBinding entryBinding) throws DatabaseException, KeyRangeException {
        if (!this.isSecondary()) {
            throw new UnsupportedOperationException("Only allowed for maps on secondary databases");
        }
        if (this.dupsView) {
            throw new IllegalStateException();
        }
        DataView dataView = this.cloneView();
        dataView.range = this.subRange(dataView.range, object);
        dataView.dupsKey = dataView.range.getSingleKey();
        dataView.dupsView = true;
        dataView.keyBinding = entryBinding;
        return dataView;
    }

    DataView configuredView(CursorConfig cursorConfig) {
        DataView dataView = this.cloneView();
        dataView.cursorConfig = cursorConfig != null ? DbCompat.cloneCursorConfig(cursorConfig) : CursorConfig.DEFAULT;
        return dataView;
    }

    CurrentTransaction getCurrentTxn() {
        return this.transactional ? this.currentTxn : null;
    }

    private void setRange(Object object, boolean bl, Object object2, boolean bl2) throws DatabaseException, KeyRangeException {
        KeyRange keyRange = this.useSubRange();
        keyRange = this.subRange(keyRange, object, bl, object2, bl2);
        if (this.dupsView) {
            this.dupsRange = keyRange;
        } else {
            this.range = keyRange;
        }
    }

    DatabaseEntry getSingleKeyThang() {
        return this.range.getSingleKey();
    }

    final Environment getEnv() {
        return this.currentTxn.getEnvironment();
    }

    final boolean isSecondary() {
        return this.secDb != null;
    }

    boolean isEmpty() throws DatabaseException {
        DataCursor dataCursor = new DataCursor(this, false);
        try {
            boolean bl = dataCursor.getFirst(false) != OperationStatus.SUCCESS;
            return bl;
        }
        finally {
            dataCursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationStatus append(Object object, Object[] objectArray, Object[] objectArray2) throws DatabaseException {
        OperationStatus operationStatus;
        DatabaseEntry databaseEntry = new DatabaseEntry();
        DatabaseEntry databaseEntry2 = new DatabaseEntry();
        this.useValue(object, databaseEntry2, null);
        if (this.keyAssigner != null) {
            this.keyAssigner.assignKey(databaseEntry);
            if (!this.range.check(databaseEntry)) {
                throw new IllegalArgumentException("assigned key out of range");
            }
            DataCursor dataCursor = new DataCursor(this, true);
            try {
                operationStatus = dataCursor.getCursor().putNoOverwrite(databaseEntry, databaseEntry2);
            }
            finally {
                dataCursor.close();
            }
        } else {
            if (this.currentTxn.isCDBCursorOpen(this.db)) {
                throw new IllegalStateException("cannot open CDB write cursor when read cursor is open");
            }
            operationStatus = DbCompat.append(this.db, this.useTransaction(), databaseEntry, databaseEntry2);
            if (operationStatus == OperationStatus.SUCCESS && !this.range.check(databaseEntry)) {
                this.db.delete(this.useTransaction(), databaseEntry);
                throw new IllegalArgumentException("appended record number out of range");
            }
        }
        if (operationStatus == OperationStatus.SUCCESS) {
            this.returnPrimaryKeyAndValue(databaseEntry, databaseEntry2, objectArray, objectArray2);
        }
        return operationStatus;
    }

    Transaction useTransaction() {
        return this.transactional ? this.currentTxn.getTransaction() : null;
    }

    void clear() throws DatabaseException {
        DataCursor dataCursor = new DataCursor(this, true);
        try {
            OperationStatus operationStatus = OperationStatus.SUCCESS;
            while (operationStatus == OperationStatus.SUCCESS) {
                operationStatus = this.keysRenumbered ? dataCursor.getFirst(true) : dataCursor.getNext(true);
                if (operationStatus != OperationStatus.SUCCESS) continue;
                dataCursor.delete();
            }
        }
        finally {
            dataCursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataCursor join(DataView[] dataViewArray, Object[] objectArray, JoinConfig joinConfig) throws DatabaseException {
        DataCursor dataCursor = null;
        DataCursor[] dataCursorArray = new DataCursor[dataViewArray.length];
        try {
            for (int i = 0; i < dataViewArray.length; ++i) {
                dataCursorArray[i] = new DataCursor(dataViewArray[i], false);
                dataCursorArray[i].getSearchKey(objectArray[i], null, false);
            }
            DataCursor dataCursor2 = dataCursor = new DataCursor(this, dataCursorArray, joinConfig, true);
            return dataCursor2;
        }
        finally {
            if (dataCursor == null) {
                for (int i = 0; i < dataCursorArray.length; ++i) {
                    if (dataCursorArray[i] == null) continue;
                    try {
                        dataCursorArray[i].close();
                        continue;
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    DataCursor join(DataCursor[] dataCursorArray, JoinConfig joinConfig) throws DatabaseException {
        return new DataCursor(this, dataCursorArray, joinConfig, false);
    }

    private void returnPrimaryKeyAndValue(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, Object[] objectArray, Object[] objectArray2) throws DatabaseException {
        if (objectArray != null) {
            if (this.keyBinding == null) {
                throw new IllegalArgumentException("returning key requires primary key binding");
            }
            if (this.isSecondary()) {
                throw new IllegalArgumentException("returning key requires unindexed view");
            }
            objectArray[0] = this.keyBinding.entryToObject(databaseEntry);
        }
        if (objectArray2 != null) {
            objectArray2[0] = this.makeValue(databaseEntry, databaseEntry2);
        }
    }

    boolean useKey(Object object, Object object2, DatabaseEntry databaseEntry, KeyRange keyRange) throws DatabaseException {
        if (object != null) {
            if (this.keyBinding == null) {
                throw new IllegalArgumentException("non-null key with null key binding");
            }
            this.keyBinding.objectToEntry(object, databaseEntry);
        } else {
            if (object2 == null) {
                throw new IllegalArgumentException("null key and null value");
            }
            if (this.entityBinding == null) {
                throw new IllegalStateException("EntityBinding required to derive key from value");
            }
            if (!this.dupsView && this.isSecondary()) {
                DatabaseEntry databaseEntry2 = new DatabaseEntry();
                this.entityBinding.objectToKey(object2, databaseEntry2);
                DatabaseEntry databaseEntry3 = new DatabaseEntry();
                this.entityBinding.objectToData(object2, databaseEntry3);
                this.secKeyCreator.createSecondaryKey(this.secDb, databaseEntry2, databaseEntry3, databaseEntry);
            } else {
                this.entityBinding.objectToKey(object2, databaseEntry);
            }
        }
        if (this.recNumAccess && DbCompat.getRecordNumber(databaseEntry) <= 0) {
            return false;
        }
        return keyRange == null || keyRange.check(databaseEntry);
    }

    final boolean canDeriveKeyFromValue() {
        return this.entityBinding != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    void useValue(Object object, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        if (object == null) {
            databaseEntry.setData(KeyRange.ZERO_LENGTH_BYTE_ARRAY);
            databaseEntry.setOffset(0);
            databaseEntry.setSize(0);
            return;
        }
        if (this.valueBinding != null) {
            this.valueBinding.objectToEntry(object, databaseEntry);
            return;
        }
        if (this.entityBinding == null) throw new IllegalArgumentException("non-null value with null value/entity binding");
        this.entityBinding.objectToData(object, databaseEntry);
        if (databaseEntry2 == null) return;
        DatabaseEntry databaseEntry3 = new DatabaseEntry();
        this.entityBinding.objectToKey(object, databaseEntry3);
        if (KeyRange.equalBytes(databaseEntry3, databaseEntry2)) return;
        throw new IllegalArgumentException("cannot change primary key");
    }

    Object makeKey(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) {
        DatabaseEntry databaseEntry3;
        if (this.keyBinding == null) {
            throw new UnsupportedOperationException();
        }
        DatabaseEntry databaseEntry4 = databaseEntry3 = this.dupsView ? databaseEntry2 : databaseEntry;
        if (databaseEntry3.getSize() == 0) {
            return null;
        }
        return this.keyBinding.entryToObject(databaseEntry3);
    }

    Object makeValue(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) {
        Object object;
        if (this.valueBinding != null) {
            object = this.valueBinding.entryToObject(databaseEntry2);
        } else if (this.entityBinding != null) {
            object = this.entityBinding.entryToObject(databaseEntry, databaseEntry2);
        } else {
            throw new UnsupportedOperationException("requires valueBinding or entityBinding");
        }
        return object;
    }

    KeyRange subRange(KeyRange keyRange, Object object) throws DatabaseException, KeyRangeException {
        return keyRange.subRange(this.makeRangeKey(object));
    }

    KeyRange subRange(KeyRange keyRange, Object object, boolean bl, Object object2, boolean bl2) throws DatabaseException, KeyRangeException {
        if (object == object2 && bl && bl2) {
            return this.subRange(keyRange, object);
        }
        if (!this.ordered) {
            throw new UnsupportedOperationException("Cannot use key ranges on an unsorted database");
        }
        DatabaseEntry databaseEntry = object != null ? this.makeRangeKey(object) : null;
        DatabaseEntry databaseEntry2 = object2 != null ? this.makeRangeKey(object2) : null;
        return keyRange.subRange(databaseEntry, bl, databaseEntry2, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KeyRange useSubRange() throws DatabaseException {
        if (this.dupsView) {
            DataView dataView = this;
            synchronized (dataView) {
                if (this.dupsRange == null) {
                    DatabaseConfig databaseConfig = this.secDb.getPrimaryDatabase().getConfig();
                    this.dupsRange = new KeyRange(databaseConfig.getBtreeComparator());
                }
            }
            return this.dupsRange;
        }
        return this.range;
    }

    private DatabaseEntry makeRangeKey(Object object) throws DatabaseException {
        DatabaseEntry databaseEntry = new DatabaseEntry();
        if (this.keyBinding != null) {
            this.useKey(object, null, databaseEntry, null);
        } else {
            this.useKey(null, object, databaseEntry, null);
        }
        return databaseEntry;
    }
}

