/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.broker;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.broker.AbstractSubscriptionRegistry;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.PathMatcher;

public class DefaultSubscriptionRegistry
extends AbstractSubscriptionRegistry {
    public static final int DEFAULT_CACHE_LIMIT = 1024;
    private volatile int cacheLimit = 1024;
    private PathMatcher pathMatcher = new AntPathMatcher();
    private final DestinationCache destinationCache = new DestinationCache();
    private final SessionSubscriptionRegistry subscriptionRegistry = new SessionSubscriptionRegistry();

    public void setCacheLimit(int cacheLimit) {
        this.cacheLimit = cacheLimit;
    }

    public int getCacheLimit() {
        return this.cacheLimit;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    @Override
    protected void addSubscriptionInternal(String sessionId, String subsId, String destination, Message<?> message) {
        this.subscriptionRegistry.addSubscription(sessionId, subsId, destination);
        this.destinationCache.updateAfterNewSubscription(destination, sessionId, subsId);
    }

    @Override
    protected void removeSubscriptionInternal(String sessionId, String subsId, Message<?> message) {
        String destination;
        SessionSubscriptionInfo info = this.subscriptionRegistry.getSubscriptions(sessionId);
        if (info != null && (destination = info.removeSubscription(subsId)) != null) {
            this.destinationCache.updateAfterRemovedSubscription(sessionId, subsId);
        }
    }

    @Override
    public void unregisterAllSubscriptions(String sessionId) {
        SessionSubscriptionInfo info = this.subscriptionRegistry.removeSubscriptions(sessionId);
        if (info != null) {
            this.destinationCache.updateAfterRemovedSession(info);
        }
    }

    @Override
    protected MultiValueMap<String, String> findSubscriptionsInternal(String destination, Message<?> message) {
        return this.destinationCache.getSubscriptions(destination, message);
    }

    public String toString() {
        return "DefaultSubscriptionRegistry[" + this.destinationCache + ", " + this.subscriptionRegistry + "]";
    }

    private static class SessionSubscriptionInfo {
        private final String sessionId;
        private final Map<String, Set<String>> subscriptions = new ConcurrentHashMap<String, Set<String>>(4);

        public SessionSubscriptionInfo(String sessionId) {
            Assert.notNull(sessionId, "sessionId must not be null");
            this.sessionId = sessionId;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public Set<String> getDestinations() {
            return this.subscriptions.keySet();
        }

        public Set<String> getSubscriptions(String destination) {
            return this.subscriptions.get(destination);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSubscription(String destination, String subscriptionId) {
            Set<String> subs = this.subscriptions.get(destination);
            if (subs == null) {
                Map<String, Set<String>> map = this.subscriptions;
                synchronized (map) {
                    subs = this.subscriptions.get(destination);
                    if (subs == null) {
                        subs = new CopyOnWriteArraySet<String>();
                        this.subscriptions.put(destination, subs);
                    }
                }
            }
            subs.add(subscriptionId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String removeSubscription(String subscriptionId) {
            for (String destination : this.subscriptions.keySet()) {
                Set<String> subscriptionIds = this.subscriptions.get(destination);
                if (subscriptionIds == null || !subscriptionIds.remove(subscriptionId)) continue;
                Map<String, Set<String>> map = this.subscriptions;
                synchronized (map) {
                    if (subscriptionIds.isEmpty()) {
                        this.subscriptions.remove(destination);
                    }
                }
                return destination;
            }
            return null;
        }

        public String toString() {
            return "[sessionId=" + this.sessionId + ", subscriptions=" + this.subscriptions + "]";
        }
    }

    private static class SessionSubscriptionRegistry {
        private final ConcurrentMap<String, SessionSubscriptionInfo> sessions = new ConcurrentHashMap<String, SessionSubscriptionInfo>();

        private SessionSubscriptionRegistry() {
        }

        public SessionSubscriptionInfo getSubscriptions(String sessionId) {
            return (SessionSubscriptionInfo)this.sessions.get(sessionId);
        }

        public Collection<SessionSubscriptionInfo> getAllSubscriptions() {
            return this.sessions.values();
        }

        public SessionSubscriptionInfo addSubscription(String sessionId, String subscriptionId, String destination) {
            SessionSubscriptionInfo value;
            SessionSubscriptionInfo info = (SessionSubscriptionInfo)this.sessions.get(sessionId);
            if (info == null && (value = this.sessions.putIfAbsent(sessionId, info = new SessionSubscriptionInfo(sessionId))) != null) {
                info = value;
            }
            info.addSubscription(destination, subscriptionId);
            return info;
        }

        public SessionSubscriptionInfo removeSubscriptions(String sessionId) {
            return (SessionSubscriptionInfo)this.sessions.remove(sessionId);
        }

        public String toString() {
            return "registry[" + this.sessions.size() + " sessions]";
        }
    }

    private class DestinationCache {
        private final Map<String, MultiValueMap<String, String>> accessCache = new ConcurrentHashMap<String, MultiValueMap<String, String>>(1024);
        private final Map<String, MultiValueMap<String, String>> updateCache = new LinkedHashMap<String, MultiValueMap<String, String>>(1024, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, MultiValueMap<String, String>> eldest) {
                if (this.size() > DefaultSubscriptionRegistry.this.getCacheLimit()) {
                    DestinationCache.this.accessCache.remove(eldest.getKey());
                    return true;
                }
                return false;
            }
        };

        private DestinationCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MultiValueMap<String, String> getSubscriptions(String destination, Message<?> message) {
            MultiValueMap<String, String> result = this.accessCache.get(destination);
            if (result == null) {
                Map<String, MultiValueMap<String, String>> map = this.updateCache;
                synchronized (map) {
                    result = new LinkedMultiValueMap<String, String>();
                    for (SessionSubscriptionInfo info : DefaultSubscriptionRegistry.this.subscriptionRegistry.getAllSubscriptions()) {
                        for (String destinationPattern : info.getDestinations()) {
                            if (!DefaultSubscriptionRegistry.this.getPathMatcher().match(destinationPattern, destination)) continue;
                            for (String subscriptionId : info.getSubscriptions(destinationPattern)) {
                                result.add(info.sessionId, subscriptionId);
                            }
                        }
                    }
                    if (!result.isEmpty()) {
                        this.updateCache.put(destination, this.deepCopy(result));
                        this.accessCache.put(destination, result);
                    }
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateAfterNewSubscription(String destination, String sessionId, String subsId) {
            Map<String, MultiValueMap<String, String>> map = this.updateCache;
            synchronized (map) {
                for (Map.Entry<String, MultiValueMap<String, String>> entry : this.updateCache.entrySet()) {
                    String cachedDestination = entry.getKey();
                    if (!DefaultSubscriptionRegistry.this.getPathMatcher().match(destination, cachedDestination)) continue;
                    MultiValueMap<String, String> subs = entry.getValue();
                    subs.add(sessionId, subsId);
                    this.accessCache.put(cachedDestination, this.deepCopy(subs));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateAfterRemovedSubscription(String sessionId, String subsId) {
            Map<String, MultiValueMap<String, String>> map = this.updateCache;
            synchronized (map) {
                HashSet<String> destinationsToRemove = new HashSet<String>();
                for (Map.Entry<String, MultiValueMap<String, String>> entry : this.updateCache.entrySet()) {
                    String destination = entry.getKey();
                    MultiValueMap<String, String> sessionMap = entry.getValue();
                    List subscriptions = (List)sessionMap.get(sessionId);
                    if (subscriptions == null) continue;
                    subscriptions.remove(subsId);
                    if (subscriptions.isEmpty()) {
                        sessionMap.remove(sessionId);
                    }
                    if (sessionMap.isEmpty()) {
                        destinationsToRemove.add(destination);
                        continue;
                    }
                    this.accessCache.put(destination, this.deepCopy(sessionMap));
                }
                for (String destination : destinationsToRemove) {
                    this.updateCache.remove(destination);
                    this.accessCache.remove(destination);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateAfterRemovedSession(SessionSubscriptionInfo info) {
            Map<String, MultiValueMap<String, String>> map = this.updateCache;
            synchronized (map) {
                HashSet<String> destinationsToRemove = new HashSet<String>();
                for (Map.Entry<String, MultiValueMap<String, String>> entry : this.updateCache.entrySet()) {
                    String destination = entry.getKey();
                    MultiValueMap<String, String> sessionMap = entry.getValue();
                    if (sessionMap.remove(info.getSessionId()) == null) continue;
                    if (sessionMap.isEmpty()) {
                        destinationsToRemove.add(destination);
                        continue;
                    }
                    this.accessCache.put(destination, this.deepCopy(sessionMap));
                }
                for (String destination : destinationsToRemove) {
                    this.updateCache.remove(destination);
                    this.accessCache.remove(destination);
                }
            }
        }

        private <K, V> LinkedMultiValueMap<K, V> deepCopy(Map<K, List<V>> map) {
            LinkedMultiValueMap copy = new LinkedMultiValueMap();
            for (Map.Entry<K, List<V>> entry : map.entrySet()) {
                copy.put(entry.getKey(), new LinkedList(entry.getValue()));
            }
            return copy;
        }

        public String toString() {
            return "cache[" + this.accessCache.size() + " destination(s)]";
        }
    }
}

