untrusted comment: verify with openbsd-71-base.pub
RWR2eHwZTOEiTZA9HmHtIjH4Sp6N/zgeleYD+WVnnHFNQSsLRitnJEYYqa38eUjaPc/Bf9SbKWS3N50vsoO7hTPmUQbCZ9Un4QU=

OpenBSD 7.1 errata 024, February 7, 2023:

smtpd(8) could abort due to a connection from a local, scoped ipv6 address.

Apply by doing:
    signify -Vep /etc/signify/openbsd-71-base.pub -x 024_smtpd.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install smtpd:
    cd /usr/src/usr.sbin/smtpd
    make obj
    make
    make install

Index: usr.sbin/smtpd/envelope.c
===================================================================
RCS file: /cvs/src/usr.sbin/smtpd/envelope.c,v
diff -u -p -u -r1.49 envelope.c
--- usr.sbin/smtpd/envelope.c	14 Jun 2021 17:58:15 -0000	1.49
+++ usr.sbin/smtpd/envelope.c	31 Jan 2023 17:10:21 -0000
@@ -270,32 +270,28 @@ ascii_load_string(char *dest, char *buf,
 static int
 ascii_load_sockaddr(struct sockaddr_storage *ss, char *buf)
 {
-	struct sockaddr_in6 ssin6;
-	struct sockaddr_in  ssin;
-
-	memset(&ssin, 0, sizeof ssin);
-	memset(&ssin6, 0, sizeof ssin6);
-
 	if (!strcmp("local", buf)) {
 		ss->ss_family = AF_LOCAL;
 	}
-	else if (strncasecmp("IPv6:", buf, 5) == 0) {
-		/* XXX - remove this after 6.6 release */
-		if (inet_pton(AF_INET6, buf + 5, &ssin6.sin6_addr) != 1)
-			return 0;
-		ssin6.sin6_family = AF_INET6;
-		memcpy(ss, &ssin6, sizeof(ssin6));
-		ss->ss_len = sizeof(struct sockaddr_in6);
-	}
 	else if (buf[0] == '[' && buf[strlen(buf)-1] == ']') {
+		struct addrinfo hints, *res0;
+		
 		buf[strlen(buf)-1] = '\0';
-		if (inet_pton(AF_INET6, buf+1, &ssin6.sin6_addr) != 1)
+
+		/* getaddrinfo() is used to support scoped addresses. */
+		memset(&hints, 0, sizeof(hints));
+		hints.ai_family = AF_INET6;
+		hints.ai_flags = AI_NUMERICHOST;
+		if (getaddrinfo(buf+1, NULL, &hints, &res0) != 0)
 			return 0;
-		ssin6.sin6_family = AF_INET6;
-		memcpy(ss, &ssin6, sizeof(ssin6));
-		ss->ss_len = sizeof(struct sockaddr_in6);
+		memcpy(ss, res0->ai_addr, res0->ai_addrlen);
+		ss->ss_len = res0->ai_addrlen;
+		freeaddrinfo(res0);
 	}
 	else {
+		struct sockaddr_in ssin;
+
+		memset(&ssin, 0, sizeof ssin);
 		if (inet_pton(AF_INET, buf, &ssin.sin_addr) != 1)
 			return 0;
 		ssin.sin_family = AF_INET;
