/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.instance.command;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.felix.utils.properties.Properties;
import org.apache.karaf.features.command.completers.AllFeatureCompleter;
import org.apache.karaf.features.command.completers.InstalledRepoUriCompleter;
import org.apache.karaf.instance.command.InstanceCommandSupport;
import org.apache.karaf.instance.core.InstanceSettings;
import org.apache.karaf.profile.command.completers.ProfileCompleter;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="instance", name="create", description="Creates a new container instance.")
@Service
public class CreateCommand
extends InstanceCommandSupport {
    public static final String FEATURES_SERVICE_CONFIG_FILE = "org.apache.karaf.features.cfg";
    @Option(name="-b", aliases={"--bare"}, description="Do not use add default features")
    boolean bare;
    @Option(name="-s", aliases={"--ssh-port"}, description="Port number for remote secure shell connection", required=false, multiValued=false)
    int sshPort = 0;
    @Option(name="-r", aliases={"-rr", "--rmi-port", "--rmi-registry-port"}, description="Port number for RMI registry connection", required=false, multiValued=false)
    int rmiRegistryPort = 0;
    @Option(name="-rs", aliases={"--rmi-server-port"}, description="Port number for RMI server connection", required=false, multiValued=false)
    int rmiServerPort = 0;
    @Option(name="-l", aliases={"--location"}, description="Location of the new container instance in the file system", required=false, multiValued=false)
    String location;
    @Option(name="-o", aliases={"--java-opts"}, description="JVM options to use when launching the instance", required=false, multiValued=false)
    String javaOpts;
    @Option(name="-f", aliases={"--feature"}, description="Initial features. This option can be specified multiple times to enable multiple initial features", required=false, multiValued=true)
    @Completion(value=AllFeatureCompleter.class)
    List<String> features;
    @Option(name="-furl", aliases={"--featureURL"}, description="Additional feature descriptor URLs. This option can be specified multiple times to add multiple URLs", required=false, multiValued=true)
    @Completion(value=InstalledRepoUriCompleter.class)
    List<String> featureURLs;
    @Option(name="-p", aliases={"--profiles"}, description="Profiles to install on the instance", required=false, multiValued=true)
    @Completion(value=ProfileCompleter.class)
    List<String> profiles;
    @Option(name="-v", aliases={"--verbose"}, description="Display actions performed by the command (disabled by default)", required=false, multiValued=false)
    boolean verbose = false;
    @Option(name="-a", aliases={"--address"}, description="IP address of the new container instance running on (when virtual IP is used)", required=false, multiValued=false)
    String address = "0.0.0.0";
    @Option(name="-tr", aliases={"--text-resource"}, description="Add a text resource to the instance", required=false, multiValued=true)
    List<String> textResourceLocation;
    @Option(name="-br", aliases={"--binary-resource"}, description="Add a text resource to the instance", required=false, multiValued=true)
    List<String> binaryResourceLocations;
    @Argument(index=0, name="name", description="The name of the new container instance", required=true, multiValued=false)
    String instance = null;

    @Override
    protected Object doExecute() throws Exception {
        if (!this.bare) {
            Properties configuration = new Properties();
            File configFile = new File(System.getProperty("karaf.etc"), FEATURES_SERVICE_CONFIG_FILE);
            configuration.load(configFile);
            String featuresRepositories = configuration.getProperty("featuresRepositories", "");
            String featuresBoot = configuration.getProperty("featuresBoot", "");
            if (this.featureURLs == null) {
                this.featureURLs = new ArrayList<String>();
            }
            for (String repo : featuresRepositories.split(",")) {
                if ((repo = repo.trim()).isEmpty()) continue;
                this.featureURLs.add(repo);
            }
            if (this.features == null) {
                this.features = new ArrayList<String>();
            }
            for (String feature : featuresBoot.split(",")) {
                if ((feature = feature.trim()).isEmpty()) continue;
                this.features.add(feature);
            }
        }
        Map<String, URL> textResources = CreateCommand.getResources(this.textResourceLocation);
        Map<String, URL> binaryResources = CreateCommand.getResources(this.binaryResourceLocations);
        InstanceSettings settings = new InstanceSettings(this.sshPort, this.rmiRegistryPort, this.rmiServerPort, this.location, this.javaOpts, this.featureURLs, this.features, this.address, textResources, binaryResources, this.profiles);
        this.getInstanceService().createInstance(this.instance, settings, this.verbose);
        return null;
    }
}

