/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.spi;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.hibernate.models.Incubating;
import org.hibernate.models.UnknownClassException;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsBuilder;

public interface ClassDetailsRegistry {
    public boolean isTrackingImplementors();

    public ClassDetails resolveClassDetails(String var1);

    public ClassDetails findClassDetails(String var1);

    default public ClassDetails getClassDetails(String name) {
        ClassDetails named = this.findClassDetails(name);
        if (named == null) {
            if ("void".equals(name)) {
                return null;
            }
            throw new UnknownClassException("Unknown managed class - " + name);
        }
        return named;
    }

    public void forEachClassDetails(ClassDetailsConsumer var1);

    @Deprecated
    public List<ClassDetails> getDirectSubTypes(String var1);

    public Set<ClassDetails> getDirectSubtypes(String var1);

    @Deprecated
    default public void forEachDirectSubType(String typeName, ClassDetailsConsumer consumer) {
        this.forEachDirectSubtype(typeName, consumer);
    }

    public void forEachDirectSubtype(String var1, ClassDetailsConsumer var2);

    @Incubating
    public Set<ClassDetails> getDirectImplementors(String var1);

    @Incubating
    public void forEachDirectImplementor(String var1, ClassDetailsConsumer var2);

    @Incubating
    default public Set<ClassDetails> findConcreteTypes(String base) {
        return this.findConcreteTypes(base, true);
    }

    @Incubating
    default public Set<ClassDetails> findConcreteTypes(String base, boolean includeBase) {
        LinkedHashSet<ClassDetails> result = new LinkedHashSet<ClassDetails>();
        this.walkConcreteTypes(base, includeBase, result::add);
        return result;
    }

    @Incubating
    public void walkConcreteTypes(String var1, boolean var2, ClassDetailsConsumer var3);

    @Incubating
    public void walkImplementors(String var1, boolean var2, ClassDetailsConsumer var3);

    @Incubating
    default public Set<ClassDetails> collectImplementors(String base, boolean includeBase) {
        return this.collectImplementors(base, includeBase, null);
    }

    @Incubating
    default public Set<ClassDetails> collectImplementors(String base, boolean includeBase, Predicate<ClassDetails> exclusions) {
        LinkedHashSet<ClassDetails> result = new LinkedHashSet<ClassDetails>();
        this.walkImplementors(base, includeBase, classDetails -> {
            if (exclusions == null || !exclusions.test(classDetails)) {
                result.add(classDetails);
            }
        });
        return result;
    }

    public ClassDetailsBuilder getClassDetailsBuilder();

    default public <S> S as(Class<S> type) {
        if (type.isInstance(this)) {
            return (S)this;
        }
        throw new UnsupportedOperationException("Unsure how to cast " + String.valueOf(this) + " to " + type.getName());
    }

    @FunctionalInterface
    public static interface ClassDetailsConsumer {
        public void consume(ClassDetails var1);
    }
}

