/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.log.drop;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogCommitSelection;
import com.intellij.vcs.log.ui.table.VcsLogCommitSelectionUtils;
import git4idea.GitLocalBranch;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.i18n.GitBundle;
import git4idea.rebase.log.GitCommitEditingActionBase;
import git4idea.rebase.log.GitCommitEditingNotificationsKt;
import git4idea.rebase.log.GitCommitEditingOperationResult;
import git4idea.rebase.log.GitLogCommitDetailsLoaderKt;
import git4idea.rebase.log.GitMultipleCommitEditingAction;
import git4idea.rebase.log.drop.GitDropOperation;
import git4idea.ui.branch.GitBranchPopupActions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0014\u00a8\u0006\u0013"}, d2={"Lgit4idea/rebase/log/drop/GitDropLogAction;", "Lgit4idea/rebase/log/GitMultipleCommitEditingAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "commitEditingData", "Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;", "actionPerformedAfterChecks", "askForConfirmation", "", "project", "Lcom/intellij/openapi/project/Project;", "data", "getFailureTitle", "", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitDropLogAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitDropLogAction.kt\ngit4idea/rebase/log/drop/GitDropLogAction\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,88:1\n40#2,3:89\n*S KotlinDebug\n*F\n+ 1 GitDropLogAction.kt\ngit4idea/rebase/log/drop/GitDropLogAction\n*L\n31#1:89,3\n*E\n"})
public final class GitDropLogAction
extends GitMultipleCommitEditingAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int MAX_COMMITS_IN_NOTIFICATION = 10;
    @NotNull
    public static final String DROP_COMMIT_HELP_ID = "reference.VersionControl.Git.DropCommit";

    @Override
    protected void update(@NotNull AnActionEvent e, @NotNull GitCommitEditingActionBase.MultipleCommitEditingData commitEditingData) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)commitEditingData, (String)"commitEditingData");
        Object[] objectArray = new Object[]{VcsLogCommitSelectionUtils.getSize((VcsLogCommitSelection)commitEditingData.getSelection())};
        e.getPresentation().setText(GitBundle.message((String)"rebase.log.drop.action.custom.text", (Object[])objectArray));
    }

    @Override
    protected void actionPerformedAfterChecks(@NotNull GitCommitEditingActionBase.MultipleCommitEditingData commitEditingData) {
        boolean canDrop;
        Intrinsics.checkNotNullParameter((Object)commitEditingData, (String)"commitEditingData");
        Project project = commitEditingData.getProject();
        boolean $i$f$service = false;
        Class<GitVcsApplicationSettings> serviceClass$iv = GitVcsApplicationSettings.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        boolean bl = canDrop = !((GitVcsApplicationSettings)object).isShowDropCommitDialog() || this.askForConfirmation(project, commitEditingData);
        if (!canDrop) {
            return;
        }
        List<VcsCommitMetadata> commitDetails = GitLogCommitDetailsLoaderKt.getOrLoadDetails(project, commitEditingData.getLogData(), commitEditingData.getSelection());
        Object[] objectArray = new Object[]{commitDetails.size()};
        String string = GitBundle.message((String)"rebase.log.drop.progress.indicator.title", (Object[])objectArray);
        new Task.Backgroundable(project, commitEditingData, commitDetails, string){
            final /* synthetic */ GitCommitEditingActionBase.MultipleCommitEditingData $commitEditingData;
            final /* synthetic */ List<VcsCommitMetadata> $commitDetails;
            {
                this.$commitEditingData = $commitEditingData;
                this.$commitDetails = $commitDetails;
                super($project, $super_call_param$1);
            }

            /*
             * WARNING - void declaration
             */
            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                GitCommitEditingOperationResult operationResult = new GitDropOperation(this.$commitEditingData.getRepository()).execute(this.$commitDetails);
                if (operationResult instanceof GitCommitEditingOperationResult.Complete) {
                    HtmlBuilder htmlBuilder;
                    Collection<HtmlChunk> collection;
                    void $this$mapTo$iv$iv;
                    HtmlBuilder $this$map$iv;
                    Object[] objectArray = new Object[]{this.$commitDetails.size()};
                    String string = GitBundle.message((String)"rebase.log.drop.success.notification.title", (Object[])objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    String notificationTitle = string;
                    Iterable iterable = CollectionsKt.take((Iterable)this.$commitDetails, (int)10);
                    HtmlChunk htmlChunk = (HtmlChunk)HtmlChunk.br();
                    HtmlBuilder htmlBuilder2 = new HtmlBuilder();
                    boolean $i$f$map = false;
                    void var8_9 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        VcsCommitMetadata vcsCommitMetadata = (VcsCommitMetadata)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(HtmlChunk.text((String)("\"" + StringUtil.shortenTextWithEllipsis((String)it.getSubject(), (int)40, (int)0) + "\"")));
                    }
                    collection = (List)destination$iv$iv;
                    $this$map$iv = htmlBuilder2.appendWithSeparators(htmlChunk, (Iterable)collection);
                    boolean condition$iv = this.$commitDetails.size() > 10;
                    boolean $i$f$applyIf = false;
                    if (condition$iv) {
                        void $this$run_u24lambda_u241 = $this$applyIf$iv;
                        boolean bl = false;
                        htmlBuilder = $this$run_u24lambda_u241.br().append("...");
                    } else {
                        htmlBuilder = $this$applyIf$iv;
                    }
                    String string2 = htmlBuilder.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                    String notificationContent = string2;
                    GitCommitEditingOperationResult.Complete complete = (GitCommitEditingOperationResult.Complete)operationResult;
                    String string3 = GitBundle.message((String)"rebase.log.drop.undo.progress.title", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                    String string4 = GitBundle.message((String)"rebase.log.drop.undo.impossible.title", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
                    String string5 = GitBundle.message((String)"rebase.log.drop.undo.failed.title", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
                    GitCommitEditingNotificationsKt.notifySuccess(complete, notificationTitle, notificationContent, string3, string4, string5);
                }
            }
        }.queue();
    }

    private final boolean askForConfirmation(Project project, GitCommitEditingActionBase.MultipleCommitEditingData data2) {
        Object[] objectArray;
        String string;
        int commitsCount = VcsLogCommitSelectionUtils.getSize((VcsLogCommitSelection)data2.getSelection());
        GitLocalBranch branch = data2.getRepository().getCurrentBranch();
        if (branch != null) {
            String string2 = GitBranchPopupActions.getSelectedBranchFullPresentation(branch.getName());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSelectedBranchFullPresentation(...)");
            String branchPresentation = string2;
            Object[] objectArray2 = new Object[]{commitsCount, branchPresentation};
            string = GitBundle.message((String)"rebase.log.drop.action.confirmation.message", (Object[])objectArray2);
        } else {
            objectArray = new Object[]{commitsCount};
            string = GitBundle.message((String)"rebase.log.drop.action.confirmation.message.detached.head", (Object[])objectArray);
        }
        String string3 = string;
        Intrinsics.checkNotNull((Object)string3);
        String confirmationMessage = string3;
        objectArray = new Object[]{commitsCount};
        String string4 = GitBundle.message((String)"rebase.log.drop.action.confirmation.title", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        return ((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)MessageDialogBuilder.Companion.okCancel(string4, confirmationMessage).asWarning()).doNotAsk((DoNotAskOption)new DoNotAskOption.Adapter(){

            public void rememberChoice(boolean isSelected, int exitCode) {
                boolean $i$f$service = false;
                Class<GitVcsApplicationSettings> serviceClass$iv = GitVcsApplicationSettings.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                ((GitVcsApplicationSettings)object).setShowDropCommitDialog(!isSelected);
            }
        })).help(DROP_COMMIT_HELP_ID)).ask(project);
    }

    @Override
    @NotNull
    protected String getFailureTitle() {
        String string = GitBundle.message((String)"rebase.log.drop.action.failure.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lgit4idea/rebase/log/drop/GitDropLogAction$Companion;", "", "<init>", "()V", "MAX_COMMITS_IN_NOTIFICATION", "", "DROP_COMMIT_HELP_ID", "", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

