/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.local.generation.generation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.completion.full.line.local.generation.generation.SearchState;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0018B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u0016\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0004H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/completion/full/line/local/generation/generation/HypothesesStasher;", "", "stashIds", "", "", "lenNormBase", "", "lenNormPow", "<init>", "(Ljava/util/Set;DD)V", "_stashedHypotheses", "Ljava/util/TreeSet;", "Lorg/jetbrains/completion/full/line/local/generation/generation/HypothesesStasher$Hypothesis;", "stash", "", "searchState", "Lorg/jetbrains/completion/full/line/local/generation/generation/SearchState;", "hypotheses", "", "getHypotheses", "()Ljava/util/List;", "collectHypotheses", "normalize", "length", "Hypothesis", "intellij.fullLine.local"})
@SourceDebugExtension(value={"SMAP\nHypothesesStasher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HypothesesStasher.kt\norg/jetbrains/completion/full/line/local/generation/generation/HypothesesStasher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n1583#2,11:45\n1878#2,2:56\n1880#2:59\n1594#2:60\n1563#2:61\n1634#2,3:62\n1563#2:65\n1634#2,3:66\n1#3:58\n*S KotlinDebug\n*F\n+ 1 HypothesesStasher.kt\norg/jetbrains/completion/full/line/local/generation/generation/HypothesesStasher\n*L\n12#1:45,11\n12#1:56,2\n12#1:59\n12#1:60\n13#1:61\n13#1:62,3\n20#1:65\n20#1:66,3\n12#1:58\n*E\n"})
public final class HypothesesStasher {
    @NotNull
    private final Set<Integer> stashIds;
    private final double lenNormBase;
    private final double lenNormPow;
    @NotNull
    private final TreeSet<Hypothesis> _stashedHypotheses;

    public HypothesesStasher(@NotNull Set<Integer> stashIds, double lenNormBase, double lenNormPow) {
        Intrinsics.checkNotNullParameter(stashIds, (String)"stashIds");
        this.stashIds = stashIds;
        this.lenNormBase = lenNormBase;
        this.lenNormPow = lenNormPow;
        this._stashedHypotheses = SetsKt.sortedSetOf((Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Hypothesis it = (Hypothesis)b;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.getScore());
                it = (Hypothesis)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getScore()));
            }
        }, (Object[])new Hypothesis[0]);
    }

    public /* synthetic */ HypothesesStasher(Set set, double d, double d2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = 0.0;
        }
        if ((n & 4) != 0) {
            d2 = 0.0;
        }
        this(set, d, d2);
    }

    /*
     * WARNING - void declaration
     */
    public final void stash(@NotNull SearchState searchState) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapIndexedNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)searchState, (String)"searchState");
        List<Hypothesis> currentHypotheses = this.collectHypotheses(searchState);
        Iterable $this$mapIndexedNotNull$iv = currentHypotheses;
        boolean $i$f$mapIndexedNotNull = false;
        Iterable iterable = $this$mapIndexedNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            Integer it$iv$iv;
            void it;
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            Hypothesis hypothesis = (Hypothesis)element$iv$iv;
            int i = index$iv$iv;
            boolean bl2 = false;
            if ((this.stashIds.contains(ArraysKt.last((int[])it.getIds())) ? Integer.valueOf(i) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List stashedIndices = (List)destination$iv$iv;
        $this$mapIndexedNotNull$iv = stashedIndices;
        TreeSet<Hypothesis> treeSet = this._stashedHypotheses;
        boolean $i$f$map = false;
        $this$mapIndexedNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            index$iv$iv$iv = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(currentHypotheses.get((int)it));
        }
        treeSet.addAll((List)destination$iv$iv);
    }

    @NotNull
    public final List<Hypothesis> getHypotheses() {
        return CollectionsKt.toList((Iterable)this._stashedHypotheses);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Hypothesis> collectHypotheses(@NotNull SearchState searchState) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)searchState, (String)"searchState");
        Iterable $this$map$iv = (Iterable)ArraysKt.getIndices((int[])searchState.getLastPredictions());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Hypothesis(CollectionsKt.toIntArray((Collection)searchState.getHypothesesTokens().get((int)it)), CollectionsKt.toDoubleArray((Collection)searchState.getHypothesesProbabilities().get((int)it)), Math.exp(this.normalize(((Number)searchState.getHypothesesScores().get((int)it)).doubleValue(), searchState.getLength())), CollectionsKt.toDoubleArray((Collection)searchState.getHypothesesNormalizedProbabilities().get((int)it)), CollectionsKt.toDoubleArray((Collection)searchState.getHypothesesTokenScores().get((int)it)), CollectionsKt.toDoubleArray((Collection)searchState.getHypothesesNormalizedTokenScores().get((int)it)), CollectionsKt.toDoubleArray((Collection)searchState.getTokenEntropies().get((int)it))));
        }
        return (List)destination$iv$iv;
    }

    private final double normalize(double $this$normalize, int length) {
        double normFactor = Math.pow((this.lenNormBase + (double)length) / (this.lenNormBase + 1.0), this.lenNormPow);
        return $this$normalize / normFactor;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0019\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003JO\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020&H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011\u00a8\u0006'"}, d2={"Lorg/jetbrains/completion/full/line/local/generation/generation/HypothesesStasher$Hypothesis;", "", "ids", "", "probabilities", "", "score", "", "normalizedProbabilities", "hypothesesTokenScores", "hypothesesNormalizedTokenScores", "tokenEntropies", "<init>", "([I[DD[D[D[D[D)V", "getIds", "()[I", "getProbabilities", "()[D", "getScore", "()D", "getNormalizedProbabilities", "getHypothesesTokenScores", "getHypothesesNormalizedTokenScores", "getTokenEntropies", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.fullLine.local"})
    public static final class Hypothesis {
        @NotNull
        private final int[] ids;
        @NotNull
        private final double[] probabilities;
        private final double score;
        @NotNull
        private final double[] normalizedProbabilities;
        @NotNull
        private final double[] hypothesesTokenScores;
        @NotNull
        private final double[] hypothesesNormalizedTokenScores;
        @NotNull
        private final double[] tokenEntropies;

        public Hypothesis(@NotNull int[] ids, @NotNull double[] probabilities, double score, @NotNull double[] normalizedProbabilities, @NotNull double[] hypothesesTokenScores, @NotNull double[] hypothesesNormalizedTokenScores, @NotNull double[] tokenEntropies) {
            Intrinsics.checkNotNullParameter((Object)ids, (String)"ids");
            Intrinsics.checkNotNullParameter((Object)probabilities, (String)"probabilities");
            Intrinsics.checkNotNullParameter((Object)normalizedProbabilities, (String)"normalizedProbabilities");
            Intrinsics.checkNotNullParameter((Object)hypothesesTokenScores, (String)"hypothesesTokenScores");
            Intrinsics.checkNotNullParameter((Object)hypothesesNormalizedTokenScores, (String)"hypothesesNormalizedTokenScores");
            Intrinsics.checkNotNullParameter((Object)tokenEntropies, (String)"tokenEntropies");
            this.ids = ids;
            this.probabilities = probabilities;
            this.score = score;
            this.normalizedProbabilities = normalizedProbabilities;
            this.hypothesesTokenScores = hypothesesTokenScores;
            this.hypothesesNormalizedTokenScores = hypothesesNormalizedTokenScores;
            this.tokenEntropies = tokenEntropies;
        }

        @NotNull
        public final int[] getIds() {
            return this.ids;
        }

        @NotNull
        public final double[] getProbabilities() {
            return this.probabilities;
        }

        public final double getScore() {
            return this.score;
        }

        @NotNull
        public final double[] getNormalizedProbabilities() {
            return this.normalizedProbabilities;
        }

        @NotNull
        public final double[] getHypothesesTokenScores() {
            return this.hypothesesTokenScores;
        }

        @NotNull
        public final double[] getHypothesesNormalizedTokenScores() {
            return this.hypothesesNormalizedTokenScores;
        }

        @NotNull
        public final double[] getTokenEntropies() {
            return this.tokenEntropies;
        }

        @NotNull
        public final int[] component1() {
            return this.ids;
        }

        @NotNull
        public final double[] component2() {
            return this.probabilities;
        }

        public final double component3() {
            return this.score;
        }

        @NotNull
        public final double[] component4() {
            return this.normalizedProbabilities;
        }

        @NotNull
        public final double[] component5() {
            return this.hypothesesTokenScores;
        }

        @NotNull
        public final double[] component6() {
            return this.hypothesesNormalizedTokenScores;
        }

        @NotNull
        public final double[] component7() {
            return this.tokenEntropies;
        }

        @NotNull
        public final Hypothesis copy(@NotNull int[] ids, @NotNull double[] probabilities, double score, @NotNull double[] normalizedProbabilities, @NotNull double[] hypothesesTokenScores, @NotNull double[] hypothesesNormalizedTokenScores, @NotNull double[] tokenEntropies) {
            Intrinsics.checkNotNullParameter((Object)ids, (String)"ids");
            Intrinsics.checkNotNullParameter((Object)probabilities, (String)"probabilities");
            Intrinsics.checkNotNullParameter((Object)normalizedProbabilities, (String)"normalizedProbabilities");
            Intrinsics.checkNotNullParameter((Object)hypothesesTokenScores, (String)"hypothesesTokenScores");
            Intrinsics.checkNotNullParameter((Object)hypothesesNormalizedTokenScores, (String)"hypothesesNormalizedTokenScores");
            Intrinsics.checkNotNullParameter((Object)tokenEntropies, (String)"tokenEntropies");
            return new Hypothesis(ids, probabilities, score, normalizedProbabilities, hypothesesTokenScores, hypothesesNormalizedTokenScores, tokenEntropies);
        }

        public static /* synthetic */ Hypothesis copy$default(Hypothesis hypothesis, int[] nArray, double[] dArray, double d, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, int n, Object object) {
            if ((n & 1) != 0) {
                nArray = hypothesis.ids;
            }
            if ((n & 2) != 0) {
                dArray = hypothesis.probabilities;
            }
            if ((n & 4) != 0) {
                d = hypothesis.score;
            }
            if ((n & 8) != 0) {
                dArray2 = hypothesis.normalizedProbabilities;
            }
            if ((n & 0x10) != 0) {
                dArray3 = hypothesis.hypothesesTokenScores;
            }
            if ((n & 0x20) != 0) {
                dArray4 = hypothesis.hypothesesNormalizedTokenScores;
            }
            if ((n & 0x40) != 0) {
                dArray5 = hypothesis.tokenEntropies;
            }
            return hypothesis.copy(nArray, dArray, d, dArray2, dArray3, dArray4, dArray5);
        }

        @NotNull
        public String toString() {
            return "Hypothesis(ids=" + Arrays.toString(this.ids) + ", probabilities=" + Arrays.toString(this.probabilities) + ", score=" + this.score + ", normalizedProbabilities=" + Arrays.toString(this.normalizedProbabilities) + ", hypothesesTokenScores=" + Arrays.toString(this.hypothesesTokenScores) + ", hypothesesNormalizedTokenScores=" + Arrays.toString(this.hypothesesNormalizedTokenScores) + ", tokenEntropies=" + Arrays.toString(this.tokenEntropies) + ")";
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.ids);
            result = result * 31 + Arrays.hashCode(this.probabilities);
            result = result * 31 + Double.hashCode(this.score);
            result = result * 31 + Arrays.hashCode(this.normalizedProbabilities);
            result = result * 31 + Arrays.hashCode(this.hypothesesTokenScores);
            result = result * 31 + Arrays.hashCode(this.hypothesesNormalizedTokenScores);
            result = result * 31 + Arrays.hashCode(this.tokenEntropies);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Hypothesis)) {
                return false;
            }
            Hypothesis hypothesis = (Hypothesis)other;
            if (!Intrinsics.areEqual((Object)this.ids, (Object)hypothesis.ids)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.probabilities, (Object)hypothesis.probabilities)) {
                return false;
            }
            if (Double.compare(this.score, hypothesis.score) != 0) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.normalizedProbabilities, (Object)hypothesis.normalizedProbabilities)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.hypothesesTokenScores, (Object)hypothesis.hypothesesTokenScores)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.hypothesesNormalizedTokenScores, (Object)hypothesis.hypothesesNormalizedTokenScores)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.tokenEntropies, (Object)hypothesis.tokenEntropies);
        }
    }
}

