/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.publisher;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Writer;
import org.gradle.api.NonNullApi;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceResolver;
import org.gradle.api.internal.artifacts.repositories.transport.NetworkOperationBackOffAndRetry;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.internal.publisher.MavenNormalizedPublication;
import org.gradle.api.publish.maven.internal.publisher.MavenPublisher;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.HashFunction;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ExternalResourceReadResult;
import org.gradle.internal.resource.ExternalResourceRepository;
import org.gradle.internal.resource.ReadableContent;
import org.gradle.internal.resource.local.ByteArrayReadableContent;
import org.gradle.internal.resource.local.FileReadableContent;
import org.gradle.internal.xml.XmlTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullApi
abstract class AbstractMavenPublisher
implements MavenPublisher {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenPublisher.class);
    private final NetworkOperationBackOffAndRetry<ExternalResourceReadResult<Metadata>> metadataRetryCaller = new NetworkOperationBackOffAndRetry();
    private static final String POM_FILE_ENCODING = "UTF-8";
    private static final String SNAPSHOT_VERSION = "SNAPSHOT";
    private static final Pattern VERSION_FILE_PATTERN = Pattern.compile("^(.*)-([0-9]{8}.[0-9]{6})-([0-9]+)$");
    private final Factory<File> temporaryDirFactory;
    private final XmlTransformer xmlTransformer = new XmlTransformer();

    AbstractMavenPublisher(Factory<File> temporaryDirFactory) {
        this.temporaryDirFactory = temporaryDirFactory;
    }

    protected void publish(MavenNormalizedPublication publication, ExternalResourceRepository repository, URI rootUri, boolean localRepo) {
        ModuleArtifactPublisher artifactPublisher;
        String groupId = publication.getGroupId();
        String artifactId = publication.getArtifactId();
        String version = publication.getVersion();
        SnapshotMetadataResult snapshotMetadataResult = this.computeSnapshotMetadata(publication, repository, version, artifactPublisher = new ModuleArtifactPublisher(repository, localRepo, rootUri, groupId, artifactId, version), groupId, artifactId);
        if (snapshotMetadataResult != null && !localRepo) {
            artifactPublisher.artifactVersion = snapshotMetadataResult.getVersion();
        }
        AbstractMavenPublisher.publishArtifactsAndMetadata(publication, artifactPublisher);
        this.publishPublicationMetadata(repository, version, artifactPublisher, groupId, artifactId, snapshotMetadataResult);
    }

    @Nullable
    private SnapshotMetadataResult computeSnapshotMetadata(MavenNormalizedPublication publication, ExternalResourceRepository repository, String version, ModuleArtifactPublisher artifactPublisher, String groupId, String artifactId) {
        if (this.isSnapshot(version)) {
            ExternalResourceName snapshotMetadataPath = artifactPublisher.getSnapshotMetadataLocation();
            Metadata snapshotMetadata = this.createSnapshotMetadata(publication, groupId, artifactId, version, repository, snapshotMetadataPath);
            return new SnapshotMetadataResult(snapshotMetadataPath, snapshotMetadata);
        }
        return null;
    }

    private void publishPublicationMetadata(ExternalResourceRepository repository, String version, ModuleArtifactPublisher artifactPublisher, String groupId, String artifactId, @Nullable SnapshotMetadataResult snapshotMetadataResult) {
        if (snapshotMetadataResult != null) {
            artifactPublisher.publish(snapshotMetadataResult.snapshotMetadataPath, this.writeMetadataToTmpFile(snapshotMetadataResult.snapshotMetadata, "snapshot-maven-metadata.xml"));
        }
        ExternalResourceName externalResource = artifactPublisher.getMetadataLocation();
        Metadata metadata = this.createMetadata(groupId, artifactId, version, repository, externalResource);
        artifactPublisher.publish(externalResource, this.writeMetadataToTmpFile(metadata, "module-maven-metadata.xml"));
    }

    private static void publishArtifactsAndMetadata(MavenNormalizedPublication publication, ModuleArtifactPublisher artifactPublisher) {
        if (publication.getMainArtifact() != null) {
            artifactPublisher.publish(null, publication.getMainArtifact().getExtension(), publication.getMainArtifact().getFile());
        }
        artifactPublisher.publish(null, "pom", publication.getPomArtifact().getFile());
        for (MavenArtifact artifact : publication.getAdditionalArtifacts()) {
            artifactPublisher.publish(artifact.getClassifier(), artifact.getExtension(), artifact.getFile());
        }
    }

    private Metadata createMetadata(String groupId, String artifactId, String version, ExternalResourceRepository repository, ExternalResourceName metadataResource) {
        Versioning versioning = this.getExistingVersioning(repository, metadataResource);
        if (!versioning.getVersions().contains(version)) {
            versioning.addVersion(version);
        }
        versioning.setLatest(version);
        if (!this.isSnapshot(version)) {
            versioning.setRelease(version);
        }
        versioning.updateTimestamp();
        Metadata metadata = new Metadata();
        metadata.setGroupId(groupId);
        metadata.setArtifactId(artifactId);
        metadata.setVersioning(versioning);
        return metadata;
    }

    private Versioning getExistingVersioning(ExternalResourceRepository repository, ExternalResourceName metadataResource) {
        Metadata recessive;
        ExternalResourceReadResult<Metadata> existing = this.readExistingMetadata(repository, metadataResource);
        if (existing != null && (recessive = (Metadata)existing.getResult()) != null && recessive.getVersioning() != null) {
            return recessive.getVersioning();
        }
        return new Versioning();
    }

    private File writeMetadataToTmpFile(Metadata metadata, String fileName) {
        File metadataFile = new File((File)this.temporaryDirFactory.create(), fileName);
        this.xmlTransformer.transform(metadataFile, POM_FILE_ENCODING, writer -> {
            try {
                new MetadataXpp3Writer().write(writer, metadata);
            }
            catch (IOException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        });
        return metadataFile;
    }

    private boolean isSnapshot(@Nullable String version) {
        if (version != null) {
            if (version.regionMatches(true, version.length() - SNAPSHOT_VERSION.length(), SNAPSHOT_VERSION, 0, SNAPSHOT_VERSION.length())) {
                return true;
            }
            return VERSION_FILE_PATTERN.matcher(version).matches();
        }
        return false;
    }

    @Nullable
    ExternalResourceReadResult<Metadata> readExistingMetadata(final ExternalResourceRepository repository, final ExternalResourceName metadataResource) {
        return (ExternalResourceReadResult)this.metadataRetryCaller.withBackoffAndRetry((Callable)new Callable<ExternalResourceReadResult<Metadata>>(){

            @Override
            @Nullable
            public ExternalResourceReadResult<Metadata> call() {
                return repository.resource(metadataResource).withContentIfPresent(inputStream -> {
                    try {
                        return new MetadataXpp3Reader().read(inputStream, false);
                    }
                    catch (Exception e) {
                        throw UncheckedException.throwAsUncheckedException((Throwable)e);
                    }
                });
            }

            public String toString() {
                return "GET " + metadataResource.getDisplayName();
            }
        });
    }

    protected abstract Metadata createSnapshotMetadata(MavenNormalizedPublication var1, String var2, String var3, String var4, ExternalResourceRepository var5, ExternalResourceName var6);

    private static class ModuleArtifactPublisher {
        private final NetworkOperationBackOffAndRetry<Void> networkOperationCaller = new NetworkOperationBackOffAndRetry();
        private final ExternalResourceRepository repository;
        private final boolean localRepo;
        private final URI rootUri;
        private final String groupPath;
        private final String artifactId;
        private final String moduleVersion;
        private String artifactVersion;

        ModuleArtifactPublisher(ExternalResourceRepository repository, boolean localRepo, URI rootUri, String groupId, String artifactId, String moduleVersion) {
            this.repository = repository.withProgressLogging();
            this.localRepo = localRepo;
            this.rootUri = rootUri;
            this.groupPath = groupId.replace('.', '/');
            this.artifactId = artifactId;
            this.moduleVersion = moduleVersion;
            this.artifactVersion = moduleVersion;
        }

        ExternalResourceName getMetadataLocation() {
            String path = this.groupPath + '/' + this.artifactId + '/' + this.getMetadataFileName();
            return new ExternalResourceName(this.rootUri, path);
        }

        ExternalResourceName getSnapshotMetadataLocation() {
            String path = this.groupPath + '/' + this.artifactId + '/' + this.moduleVersion + '/' + this.getMetadataFileName();
            return new ExternalResourceName(this.rootUri, path);
        }

        private String getMetadataFileName() {
            if (this.localRepo) {
                return "maven-metadata-local.xml";
            }
            return "maven-metadata.xml";
        }

        void publish(@Nullable String classifier, String extension, File content) {
            StringBuilder path = new StringBuilder(128);
            path.append(this.groupPath).append('/');
            path.append(this.artifactId).append('/');
            path.append(this.moduleVersion).append('/');
            path.append(this.artifactId).append('-').append(this.artifactVersion);
            if (classifier != null) {
                path.append('-').append(classifier);
            }
            if (extension.length() > 0) {
                path.append('.').append(extension);
            }
            ExternalResourceName externalResource = new ExternalResourceName(this.rootUri, path.toString());
            this.publish(externalResource, content);
        }

        void publish(ExternalResourceName externalResource, File content) {
            if (!this.localRepo) {
                LOGGER.info("Uploading {} to {}", (Object)externalResource.getShortDisplayName(), (Object)externalResource.getPath());
            }
            this.putResource(externalResource, (ReadableContent)new FileReadableContent(content));
            if (!this.localRepo) {
                this.publishChecksums(externalResource, content);
            }
        }

        private void publishChecksums(ExternalResourceName destination, File content) {
            this.publishChecksum(destination, content, Hashing.sha1());
            this.publishChecksum(destination, content, Hashing.md5());
            if (!ExternalResourceResolver.disableExtraChecksums()) {
                this.publishPossiblyUnsupportedChecksum(destination, content, Hashing.sha256());
                this.publishPossiblyUnsupportedChecksum(destination, content, Hashing.sha512());
            }
        }

        private void publishPossiblyUnsupportedChecksum(ExternalResourceName destination, File content, HashFunction hashFunction) {
            try {
                this.publishChecksum(destination, content, hashFunction);
            }
            catch (Exception ex) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.warn("Cannot upload checksum for " + content.getName() + " because the remote repository doesn't support " + hashFunction + ". This will not fail the build.", (Throwable)ex);
                }
                LOGGER.warn("Cannot upload checksum for " + content.getName() + " because the remote repository doesn't support " + hashFunction + ". This will not fail the build.");
            }
        }

        private void publishChecksum(ExternalResourceName destination, File content, HashFunction hashFunction) {
            byte[] checksum = this.createChecksumFile(content, hashFunction);
            this.putResource(destination.append("." + hashFunction.getAlgorithm().toLowerCase(Locale.ROOT).replaceAll("-", "")), (ReadableContent)new ByteArrayReadableContent(checksum));
        }

        private byte[] createChecksumFile(File src, HashFunction hashFunction) {
            HashCode hash;
            try {
                hash = hashFunction.hashFile(src);
            }
            catch (IOException e) {
                throw new UncheckedIOException((Throwable)e);
            }
            String formattedHashString = hash.toZeroPaddedString(hashFunction.getHexDigits());
            return formattedHashString.getBytes(StandardCharsets.US_ASCII);
        }

        private void putResource(final ExternalResourceName externalResource, final ReadableContent readableContent) {
            this.networkOperationCaller.withBackoffAndRetry((Callable)new Callable<Void>(){

                @Override
                public Void call() {
                    repository.resource(externalResource).put(readableContent);
                    return null;
                }

                public String toString() {
                    return "PUT " + externalResource.getDisplayName();
                }
            });
        }
    }

    @NonNullApi
    private static class SnapshotMetadataResult {
        public final ExternalResourceName snapshotMetadataPath;
        public final Metadata snapshotMetadata;

        public SnapshotMetadataResult(ExternalResourceName snapshotMetadataPath, Metadata snapshotMetadata) {
            this.snapshotMetadataPath = snapshotMetadataPath;
            this.snapshotMetadata = snapshotMetadata;
        }

        public String getVersion() {
            return ((SnapshotVersion)this.snapshotMetadata.getVersioning().getSnapshotVersions().get(0)).getVersion();
        }
    }
}

