/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot;

import com.jogamp.math.geom.AABBox;
import jogamp.graph.font.typecast.cff.CharstringType2;
import jogamp.graph.font.typecast.cff.T2Interpreter;
import jogamp.graph.font.typecast.ot.Glyph;
import jogamp.graph.font.typecast.ot.Point;

public class T2Glyph
extends Glyph {
    private final short _leftSideBearing;
    private final int _advanceWidth;
    private Point[] _points;
    private Integer[] _hstems;
    private Integer[] _vstems;

    public T2Glyph(int n, CharstringType2 charstringType2, short s, int n2) {
        super(n);
        this._leftSideBearing = s;
        this._advanceWidth = n2;
        T2Interpreter t2Interpreter = new T2Interpreter();
        this._points = t2Interpreter.execute(charstringType2);
        this._hstems = t2Interpreter.getHStems();
        this._vstems = t2Interpreter.getVStems();
        AABBox aABBox = new AABBox();
        for (Point point : this._points) {
            aABBox.resize(point.x, point.y, 0.0f);
        }
        this._bbox = aABBox;
    }

    @Override
    public final void clearPointData() {
        this._points = null;
        this._hstems = null;
        this._vstems = null;
    }

    @Override
    public int getAdvanceWidth() {
        return this._advanceWidth;
    }

    @Override
    public short getLeftSideBearing() {
        return this._leftSideBearing;
    }

    @Override
    public Point getPoint(int n) {
        return this._points[n];
    }

    @Override
    public int getPointCount() {
        return this._points.length;
    }

    public Integer[] getHStems() {
        return this._hstems;
    }

    public Integer[] getVStems() {
        return this._vstems;
    }

    @Override
    public String toString() {
        return "T2Glyph id " + this._glyph_id + ", points " + this._points.length + ", advance " + this.getAdvanceWidth() + ", " + this._bbox;
    }
}

